/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.process;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.Platform;
import jdk.test.lib.Utils;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.StreamPumper;

public final class ProcessTools {
    public static final String OLD_MAIN_THREAD_NAME = "old-m-a-i-n";

    private ProcessTools() {
    }

    public static Process startProcess(String name, ProcessBuilder processBuilder) throws IOException {
        return ProcessTools.startProcess(name, processBuilder, (Consumer<String>)null);
    }

    public static Process startProcess(String name, ProcessBuilder processBuilder, Consumer<String> consumer) throws IOException {
        try {
            return ProcessTools.startProcess(name, processBuilder, consumer, null, -1L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException | CancellationException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static Process startProcess(String name, ProcessBuilder processBuilder, Predicate<String> linePredicate, long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        return ProcessTools.startProcess(name, processBuilder, null, linePredicate, timeout, unit);
    }

    public static Process startProcess(String name, ProcessBuilder processBuilder, final Consumer<String> lineConsumer, final Predicate<String> linePredicate, long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        Future<Void> stderrTask;
        Future<Void> stdoutTask;
        BufferInputStream stdErr;
        BufferInputStream stdOut;
        Process p;
        block9: {
            System.out.println("[" + name + "]:" + String.join((CharSequence)" ", processBuilder.command()));
            p = ProcessTools.privilegedStart(processBuilder);
            StreamPumper stdout = new StreamPumper(p.getInputStream());
            StreamPumper stderr = new StreamPumper(p.getErrorStream());
            stdout.addPump(new LineForwarder(name, System.out));
            stderr.addPump(new LineForwarder(name, System.err));
            stdOut = new BufferInputStream(p);
            stdErr = new BufferInputStream(p);
            stdout.addOutputStream(stdOut.getOutputStream());
            stderr.addOutputStream(stdErr.getOutputStream());
            if (lineConsumer != null) {
                StreamPumper.LinePump pump = new StreamPumper.LinePump(){

                    @Override
                    protected void processLine(String line) {
                        lineConsumer.accept(line);
                    }
                };
                stdout.addPump(pump);
                stderr.addPump(pump);
            }
            final CountDownLatch latch = new CountDownLatch(1);
            if (linePredicate != null) {
                StreamPumper.LinePump pump = new StreamPumper.LinePump(){
                    private final Object sync = new Object();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void processLine(String line) {
                        Object object = this.sync;
                        synchronized (object) {
                            if (latch.getCount() > 0L && linePredicate.test(line)) {
                                latch.countDown();
                            }
                        }
                    }
                };
                stdout.addPump(pump);
                stderr.addPump(pump);
            } else {
                latch.countDown();
            }
            stdoutTask = stdout.process();
            stderrTask = stderr.process();
            stdOut.getOutputStream().setTask(stdoutTask);
            stdErr.getOutputStream().setTask(stderrTask);
            try {
                if (timeout <= -1L) break block9;
                long timeoutMs = timeout == 0L ? -1L : unit.toMillis(Utils.adjustTimeout(timeout));
                Utils.waitForCondition(() -> latch.getCount() == 0L || !p.isAlive(), timeoutMs, 1000L);
                if (latch.getCount() <= 0L) break block9;
                if (!p.isAlive()) {
                    Thread.sleep(1000L);
                    if (latch.getCount() > 0L) {
                        throw new RuntimeException("Started process " + name + " terminated before producing the expected output.");
                    }
                    break block9;
                }
                throw new TimeoutException();
            }
            catch (InterruptedException | RuntimeException | TimeoutException e) {
                System.err.println("Failed to start a process (thread dump follows)");
                for (Map.Entry<Thread, StackTraceElement[]> s : Thread.getAllStackTraces().entrySet()) {
                    ProcessTools.printStack(s.getKey(), s.getValue());
                }
                if (p.isAlive()) {
                    p.destroyForcibly();
                }
                stdoutTask.cancel(true);
                stderrTask.cancel(true);
                throw e;
            }
        }
        return new ProcessImpl(p, stdoutTask, stderrTask, stdOut, stdErr);
    }

    public static Process startProcess(String name, ProcessBuilder processBuilder, Predicate<String> linePredicate) throws IOException, InterruptedException, TimeoutException {
        return ProcessTools.startProcess(name, processBuilder, linePredicate, 0L, TimeUnit.SECONDS);
    }

    public static long getProcessId() throws Exception {
        return ProcessHandle.current().pid();
    }

    private static List<String> addTestThreadFactoryArgs(String testThreadFactoryName, List<String> command) {
        List<String> unsupportedArgs = List.of("-jar", "-cp", "-classpath", "--class-path", "--describe-module", "-d", "--dry-run", "--list-modules", "--validate-modules", "-m", "--module", "-version");
        List<String> doubleWordArgs = List.of("--add-opens", "--upgrade-module-path", "--add-modules", "--add-exports", "--limit-modules", "--add-reads", "--patch-module", "--module-path", "-p");
        ArrayList<String> args = new ArrayList<String>();
        boolean expectSecondArg = false;
        boolean isTestThreadFactoryAdded = false;
        for (String cmd : command) {
            if (isTestThreadFactoryAdded) {
                args.add(cmd);
                continue;
            }
            if (expectSecondArg) {
                expectSecondArg = false;
                args.add(cmd);
                continue;
            }
            if (unsupportedArgs.contains(cmd)) {
                return command;
            }
            if (doubleWordArgs.contains(cmd)) {
                expectSecondArg = true;
                args.add(cmd);
                continue;
            }
            if (expectSecondArg) continue;
            if (cmd.startsWith("-") || cmd.startsWith("@")) {
                args.add(cmd);
                continue;
            }
            if (cmd.endsWith(".java")) {
                return command;
            }
            args.add("-Dtest.thread.factory=" + testThreadFactoryName);
            args.add("jdk.test.lib.process.ProcessTools");
            args.add(testThreadFactoryName);
            isTestThreadFactoryAdded = true;
            args.add(cmd);
        }
        return args;
    }

    private static ProcessBuilder createJavaProcessBuilder(String ... command) {
        String testThreadFactoryName;
        String javapath = JDKToolFinder.getJDKTool("java");
        ArrayList<String> args = new ArrayList<String>();
        args.add(javapath);
        String noCPString = System.getProperty("test.noclasspath", "false");
        boolean noCP = Boolean.valueOf(noCPString);
        if (!noCP) {
            args.add("-cp");
            args.add(System.getProperty("java.class.path"));
        }
        if ((testThreadFactoryName = System.getProperty("test.thread.factory")) != null) {
            args.addAll(ProcessTools.addTestThreadFactoryArgs(testThreadFactoryName, Arrays.asList(command)));
        } else {
            Collections.addAll(args, command);
        }
        StringBuilder cmdLine = new StringBuilder();
        for (String cmd : args) {
            cmdLine.append(cmd).append(' ');
        }
        System.out.println("Command line: [" + cmdLine.toString() + "]");
        ProcessBuilder pb = new ProcessBuilder(args);
        if (noCP) {
            pb.environment().remove("CLASSPATH");
        }
        return pb;
    }

    private static void printStack(Thread t, StackTraceElement[] stack) {
        System.out.println("\t" + String.valueOf(t) + " stack: (length = " + stack.length + ")");
        if (t != null) {
            for (StackTraceElement stack1 : stack) {
                System.out.println("\t" + String.valueOf(stack1));
            }
            System.out.println();
        }
    }

    public static ProcessBuilder createTestJavaProcessBuilder(List<String> command) {
        return ProcessTools.createTestJavaProcessBuilder((String[])command.toArray(String[]::new));
    }

    public static ProcessBuilder createTestJavaProcessBuilder(String ... command) {
        return ProcessTools.createJavaProcessBuilder(Utils.prependTestJavaOpts(command));
    }

    public static ProcessBuilder createLimitedTestJavaProcessBuilder(List<String> command) {
        return ProcessTools.createLimitedTestJavaProcessBuilder((String[])command.toArray(String[]::new));
    }

    public static ProcessBuilder createLimitedTestJavaProcessBuilder(String ... command) {
        return ProcessTools.createJavaProcessBuilder(command);
    }

    public static OutputAnalyzer executeTestJava(List<String> command) throws Exception {
        return ProcessTools.executeTestJava((String[])command.toArray(String[]::new));
    }

    public static OutputAnalyzer executeTestJava(String ... command) throws Exception {
        ProcessBuilder pb = ProcessTools.createTestJavaProcessBuilder(command);
        return ProcessTools.executeProcess(pb);
    }

    public static OutputAnalyzer executeLimitedTestJava(List<String> command) throws Exception {
        return ProcessTools.executeLimitedTestJava((String[])command.toArray(String[]::new));
    }

    public static OutputAnalyzer executeLimitedTestJava(String ... command) throws Exception {
        ProcessBuilder pb = ProcessTools.createLimitedTestJavaProcessBuilder(command);
        return ProcessTools.executeProcess(pb);
    }

    public static OutputAnalyzer executeProcess(ProcessBuilder pb) throws Exception {
        return ProcessTools.executeProcess(pb, null);
    }

    public static OutputAnalyzer executeProcess(ProcessBuilder pb, String input) throws Exception {
        return ProcessTools.executeProcess(pb, input, null);
    }

    public static OutputAnalyzer executeProcess(ProcessBuilder pb, String input, Charset cs) throws Exception {
        OutputAnalyzer output = null;
        Process p = null;
        boolean failed = false;
        try {
            p = ProcessTools.privilegedStart(pb);
            if (input != null) {
                try (PrintStream ps = new PrintStream(p.getOutputStream());){
                    ps.print(input);
                }
            }
            output = new OutputAnalyzer(p, cs);
            output.waitFor();
            Object fileName = String.format("pid-%d-output.log", p.pid());
            String processOutput = ProcessTools.getProcessLog(pb, output);
            AccessController.doPrivileged(() -> ProcessTools.lambda$executeProcess$5((String)fileName, processOutput));
            System.out.printf("Output and diagnostic info for process %d was saved into '%s'%n", p.pid(), fileName);
            fileName = output;
            if (failed) {
                System.err.println(ProcessTools.getProcessLog(pb, output));
            }
            return fileName;
        }
        catch (Throwable t) {
            try {
                if (p != null) {
                    p.destroyForcibly().waitFor();
                }
                failed = true;
                System.out.println("executeProcess() failed: " + String.valueOf(t));
                throw t;
            }
            catch (Throwable throwable) {
                if (failed) {
                    System.err.println(ProcessTools.getProcessLog(pb, output));
                }
                throw throwable;
            }
        }
    }

    public static OutputAnalyzer executeProcess(String ... cmds) throws Exception {
        return ProcessTools.executeProcess(new ProcessBuilder(cmds));
    }

    public static String getProcessLog(ProcessBuilder pb, OutputAnalyzer output) {
        String stderr = output == null ? "null" : output.getStderr();
        String stdout = output == null ? "null" : output.getStdout();
        String exitValue = output == null ? "null" : Integer.toString(output.getExitValue());
        return String.format("--- ProcessLog ---%ncmd: %s%nexitvalue: %s%nstderr: %s%nstdout: %s%n", ProcessTools.getCommandLine(pb), exitValue, stderr, stdout);
    }

    public static String getCommandLine(ProcessBuilder pb) {
        if (pb == null) {
            return "null";
        }
        StringBuilder cmd = new StringBuilder();
        for (String s : pb.command()) {
            cmd.append(s).append(" ");
        }
        return cmd.toString().trim();
    }

    public static OutputAnalyzer executeCommand(String ... cmds) throws Exception {
        String cmdLine = String.join((CharSequence)" ", cmds);
        System.out.println("Command line: [" + cmdLine + "]");
        OutputAnalyzer analyzer = ProcessTools.executeProcess(cmds);
        System.out.println(analyzer.getOutput());
        return analyzer;
    }

    public static OutputAnalyzer executeCommand(ProcessBuilder pb) throws Exception {
        String cmdLine = pb.command().stream().map(x -> x.contains(" ") || x.contains("$") ? "'" + x + "'" : x).collect(Collectors.joining(" "));
        System.out.println("Command line: [" + cmdLine + "]");
        OutputAnalyzer analyzer = ProcessTools.executeProcess(pb);
        System.out.println(analyzer.getOutput());
        return analyzer;
    }

    public static ProcessBuilder createNativeTestProcessBuilder(String executableName, String ... args) throws Exception {
        executableName = Platform.isWindows() ? (String)executableName + ".exe" : executableName;
        String executable = Paths.get(Utils.TEST_NATIVE_PATH, new String[]{executableName}).toAbsolutePath().toString();
        ProcessBuilder pb = new ProcessBuilder(executable);
        pb.command().addAll(Arrays.asList(args));
        return ProcessTools.addJvmLib(pb);
    }

    public static ProcessBuilder addJvmLib(ProcessBuilder pb) throws Exception {
        String jvmLibDir = Platform.jvmLibDir().toString();
        String libPathVar = Platform.sharedLibraryPathVariableName();
        String currentLibPath = pb.environment().get(libPathVar);
        Object newLibPath = jvmLibDir;
        if (Platform.isWindows()) {
            String libDir = Platform.libDir().toString();
            newLibPath = (String)newLibPath + File.pathSeparator + libDir;
        }
        if (currentLibPath != null && !currentLibPath.isEmpty()) {
            newLibPath = (String)newLibPath + File.pathSeparator + currentLibPath;
        }
        pb.environment().put(libPathVar, (String)newLibPath);
        return pb;
    }

    private static Process privilegedStart(ProcessBuilder pb) throws IOException {
        try {
            return AccessController.doPrivileged(pb::start);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static void main(String[] args) throws Throwable {
        String testThreadFactoryName = args[0];
        String className = args[1];
        String[] classArgs = new String[args.length - 2];
        System.arraycopy(args, 2, classArgs, 0, args.length - 2);
        Class<?> c = Class.forName(className);
        Method mainMethod = c.getMethod("main", String[].class);
        mainMethod.setAccessible(true);
        if (testThreadFactoryName.equals("Virtual")) {
            MainThreadGroup tg = new MainThreadGroup();
            Thread vthread = Thread.ofVirtual().unstarted(() -> {
                try {
                    mainMethod.invoke(null, new Object[]{classArgs});
                }
                catch (InvocationTargetException e) {
                    tg.uncaughtThrowable = e.getCause();
                }
                catch (Throwable error) {
                    tg.uncaughtThrowable = error;
                }
            });
            Thread.currentThread().setName(OLD_MAIN_THREAD_NAME);
            vthread.setName("main");
            vthread.start();
            vthread.join();
            if (tg.uncaughtThrowable != null) {
                throw tg.uncaughtThrowable;
            }
        } else if (testThreadFactoryName.equals("Kernel")) {
            MainThreadGroup tg = new MainThreadGroup();
            Thread t = new Thread((ThreadGroup)tg, () -> {
                try {
                    mainMethod.invoke(null, new Object[]{classArgs});
                }
                catch (InvocationTargetException e) {
                    tg.uncaughtThrowable = e.getCause();
                }
                catch (Throwable error) {
                    tg.uncaughtThrowable = error;
                }
            });
            t.start();
            t.join();
            if (tg.uncaughtThrowable != null) {
                throw tg.uncaughtThrowable;
            }
        } else {
            mainMethod.invoke(null, new Object[]{classArgs});
        }
    }

    private static /* synthetic */ Void lambda$executeProcess$5(String fileName, String processOutput) throws Exception {
        Files.writeString(Path.of(fileName, new String[0]), (CharSequence)processOutput, new OpenOption[0]);
        return null;
    }

    private static final class LineForwarder
    extends StreamPumper.LinePump {
        private final PrintStream ps;
        private final String prefix;

        LineForwarder(String prefix, PrintStream os) {
            this.ps = os;
            this.prefix = prefix;
        }

        @Override
        protected void processLine(String line) {
            this.ps.println("[" + this.prefix + "] " + line);
        }
    }

    private static class BufferInputStream
    extends InputStream {
        private final BufferOutputStream buffer;

        public BufferInputStream(Process p) {
            this.buffer = new BufferOutputStream(p);
        }

        BufferOutputStream getOutputStream() {
            return this.buffer;
        }

        @Override
        public int read() throws IOException {
            return this.buffer.readNext();
        }
    }

    private static class BufferOutputStream
    extends ByteArrayOutputStream {
        private int current = 0;
        private final Process p;
        private Future<Void> task;

        public BufferOutputStream(Process p) {
            this.p = p;
        }

        synchronized void setTask(Future<Void> task) {
            this.task = task;
        }

        synchronized int readNext() {
            if (this.current > this.count) {
                throw new RuntimeException("Shouldn't ever happen.  start: " + this.current + " count: " + this.count + " buffer: " + String.valueOf(this));
            }
            while (this.current == this.count) {
                if (!this.p.isAlive() && this.task != null) {
                    try {
                        this.task.get(10L, TimeUnit.MILLISECONDS);
                        if (this.current == this.count) {
                            return -1;
                        }
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (InterruptedException | ExecutionException e) {
                        return -1;
                    }
                }
                try {
                    this.wait(1L);
                }
                catch (InterruptedException ie) {
                    return -1;
                }
            }
            return this.buf[this.current++];
        }
    }

    private static class ProcessImpl
    extends Process {
        private final InputStream stdOut;
        private final InputStream stdErr;
        private final Process p;
        private final Future<Void> stdoutTask;
        private final Future<Void> stderrTask;

        public ProcessImpl(Process p, Future<Void> stdoutTask, Future<Void> stderrTask, InputStream stdOut, InputStream etdErr) {
            this.p = p;
            this.stdoutTask = stdoutTask;
            this.stderrTask = stderrTask;
            this.stdOut = stdOut;
            this.stdErr = etdErr;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.p.getOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.stdOut;
        }

        @Override
        public InputStream getErrorStream() {
            return this.stdErr;
        }

        @Override
        public int waitFor() throws InterruptedException {
            int rslt = this.p.waitFor();
            this.waitForStreams();
            return rslt;
        }

        @Override
        public int exitValue() {
            return this.p.exitValue();
        }

        @Override
        public void destroy() {
            this.p.destroy();
        }

        @Override
        public long pid() {
            return this.p.pid();
        }

        @Override
        public boolean isAlive() {
            return this.p.isAlive();
        }

        @Override
        public Process destroyForcibly() {
            return this.p.destroyForcibly();
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            boolean rslt = this.p.waitFor(timeout, unit);
            if (rslt) {
                this.waitForStreams();
            }
            return rslt;
        }

        private void waitForStreams() throws InterruptedException {
            try {
                this.stdoutTask.get();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            try {
                this.stderrTask.get();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    static class MainThreadGroup
    extends ThreadGroup {
        Throwable uncaughtThrowable = null;

        MainThreadGroup() {
            super("MainThreadGroup");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace(System.err);
            this.uncaughtThrowable = e;
        }
    }
}

