/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.test.lib.compiler.CompilerUtils;
import jdk.test.lib.process.OutputAnalyzer;

public class Proc {
    private Process p;
    private BufferedReader br;
    private String launcher;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private Map<String, String> prop = new HashMap<String, String>();
    private Map<String, String> secprop = new HashMap<String, String>();
    private boolean inheritIO = false;
    private boolean noDump = false;
    private boolean addcp;
    private List<String> cp;
    private boolean compile;
    private String clazz;
    private String debug;
    private final StringBuilder stdout = new StringBuilder();
    private static final String PREFIX = "PROCISFUN:";
    private final StringBuilder perms = new StringBuilder();
    private final StringBuilder grant = new StringBuilder();

    public static Proc create(String clazz, String ... launcher) {
        Proc pc = new Proc();
        pc.clazz = clazz;
        if (launcher.length > 0) {
            pc.launcher = launcher[0];
        }
        return pc;
    }

    public Proc inheritIO() {
        this.inheritIO = true;
        return this;
    }

    public Proc nodump() {
        this.noDump = true;
        return this;
    }

    public Proc args(String ... args) {
        for (String c : args) {
            this.args.add(c);
        }
        return this;
    }

    public String debug() {
        return this.debug;
    }

    public Proc debug(String title) {
        this.debug = title;
        return this;
    }

    public Proc env(String a, String b) {
        this.env.put(a, b);
        return this;
    }

    public Proc prop(String a, String b) {
        this.prop.put(a, b);
        return this;
    }

    public Proc secprop(String a, String b) {
        this.secprop.put(a, b);
        return this;
    }

    public Proc inheritProp(String k) {
        String v = System.getProperty(k);
        if (v != null) {
            this.prop.put(k, v);
        }
        return this;
    }

    public Proc cp(String ... s) {
        if (this.cp == null) {
            this.cp = new ArrayList<String>();
        }
        this.cp.addAll(Arrays.asList(s));
        return this;
    }

    public Proc addcp(String ... s) {
        this.addcp = true;
        return this.cp(s);
    }

    public Proc perm(Permission p) {
        if (this.grant.length() != 0) {
            if (this.perms.length() != 0) {
                this.perms.append("};\n");
            }
            this.perms.append("grant ").append((CharSequence)this.grant).append(" {\n");
            this.grant.setLength(0);
        } else if (this.perms.length() == 0) {
            this.perms.append("grant {\n");
        }
        if (p.getActions().isEmpty()) {
            String s = String.format("%s \"%s\"", p.getClass().getCanonicalName(), p.getName().replace("\\", "\\\\").replace("\"", "\\\""));
            this.perms.append("    permission ").append(s).append(";\n");
        } else {
            String s = String.format("%s \"%s\", \"%s\"", p.getClass().getCanonicalName(), p.getName().replace("\\", "\\\\").replace("\"", "\\\""), p.getActions());
            this.perms.append("    permission ").append(s).append(";\n");
        }
        return this;
    }

    public Proc grant(Principal p) {
        this.grant.append("principal ").append(p.getClass().getName()).append(" \"").append(p.getName()).append("\", ");
        return this;
    }

    public Proc grant(File f) {
        this.grant.append("codebase \"").append(f.toURI()).append("\", ");
        return this;
    }

    public Proc grant(String v) {
        this.grant.append(v).append(", ");
        return this;
    }

    public Proc compile() {
        this.compile = true;
        return this;
    }

    String fullcp() {
        if (this.cp == null) {
            return System.getProperty("test.class.path") + File.pathSeparator + System.getProperty("test.src.path");
        }
        ArrayList<String> newcp = new ArrayList<String>(this.cp);
        if (this.addcp) {
            newcp.add(System.getProperty("test.class.path"));
            newcp.add(System.getProperty("test.src.path"));
        }
        if (!newcp.isEmpty()) {
            return newcp.stream().collect(Collectors.joining(File.pathSeparator));
        }
        return null;
    }

    public Proc start() throws IOException {
        boolean comp;
        String lcp;
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.launcher != null) {
            cmd.add(this.launcher);
            File file = new File(this.launcher).getParentFile().getParentFile();
        } else {
            cmd.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getPath());
        }
        String testModules = System.getProperty("test.modules");
        if (testModules != null) {
            for (String module : testModules.split("\\s+")) {
                if (module.endsWith(":+open")) {
                    String realModule = module.substring(0, module.length() - 6);
                    cmd.add("--add-opens=" + realModule + "=ALL-UNNAMED");
                    continue;
                }
                if (!module.contains("/")) continue;
                cmd.add("--add-exports=" + module + "=ALL-UNNAMED");
            }
        }
        if ((lcp = this.fullcp()) != null) {
            cmd.add("-cp");
            cmd.add(lcp);
        }
        if (this.compile && !(comp = CompilerUtils.compile(Path.of(System.getProperty("test.src"), this.clazz + ".java"), Path.of(System.getProperty("test.classes"), new String[0]), cmd.subList(1, cmd.size()).toArray(new String[0])))) {
            throw new RuntimeException("Compilation error");
        }
        Collections.addAll(cmd, Proc.splitProperty("test.vm.opts"));
        Collections.addAll(cmd, Proc.splitProperty("test.java.opts"));
        if (!this.secprop.isEmpty()) {
            Path p = Path.of(this.getId("security"), new String[0]);
            try (OutputStream fos = Files.newOutputStream(p, new OpenOption[0]);
                 PrintStream ps = new PrintStream(fos);){
                this.secprop.forEach((k, v) -> ps.println(k + "=" + v));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.prop.put("java.security.properties", p.toString());
        }
        for (Map.Entry<String, String> e : this.prop.entrySet()) {
            cmd.add("-D" + e.getKey() + "=" + e.getValue());
        }
        if (this.perms.length() > 0) {
            Iterator<String> p = Paths.get(this.getId("policy"), new String[0]).toAbsolutePath();
            this.perms.append("};\n");
            Files.write(p, this.perms.toString().getBytes(), new OpenOption[0]);
            cmd.add("-Djava.security.policy=" + p.toString());
        }
        cmd.add(this.clazz);
        for (String s : this.args) {
            cmd.add(s);
        }
        if (this.debug != null) {
            System.out.println("PROC: " + this.debug + " cmdline: " + String.valueOf(cmd));
            for (String e : this.env.keySet()) {
                System.out.print(e + "=" + this.env.get(e) + " ");
            }
            for (String c : cmd) {
                if (c.indexOf(92) >= 0 || c.indexOf(32) > 0) {
                    System.out.print("'" + c + "'");
                } else {
                    System.out.print(c);
                }
                System.out.print(' ');
            }
            System.out.println();
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        for (Map.Entry<String, String> e : this.env.entrySet()) {
            pb.environment().put(e.getKey(), e.getValue());
        }
        if (this.inheritIO) {
            pb.inheritIO();
        } else if (this.noDump) {
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        } else {
            pb.redirectError(ProcessBuilder.Redirect.appendTo(new File(this.getId("stderr"))));
        }
        this.p = pb.start();
        this.br = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        return this;
    }

    String getId(String suffix) {
        if (this.debug != null) {
            return this.debug + "." + suffix;
        }
        return System.identityHashCode(this) + "." + suffix;
    }

    public String readLine() throws IOException {
        String s = this.br.readLine();
        if (s != null) {
            this.stdout.append(s).append('\n');
        }
        if (this.debug != null) {
            System.out.println("PROC: " + this.debug + " readline: " + (s == null ? "<EOF>" : s));
        }
        return s;
    }

    public String readData() throws Exception {
        String s;
        do {
            if ((s = this.readLine()) != null) continue;
            if (this.p.waitFor() != 0) {
                throw new Exception("Proc abnormal end");
            }
            return s;
        } while (!s.startsWith(PREFIX));
        return s.substring(PREFIX.length());
    }

    public void println(String s) throws IOException {
        if (this.debug != null) {
            System.out.println("PROC: " + this.debug + " println: " + s);
        }
        this.write((s + "\n").getBytes());
    }

    public void write(byte[] b) throws IOException {
        this.p.getOutputStream().write(b);
        this.p.getOutputStream().flush();
    }

    public int waitFor() throws Exception {
        String s;
        while ((s = this.readLine()) != null) {
        }
        return this.p.waitFor();
    }

    public OutputAnalyzer output() throws Exception {
        int exitCode = this.waitFor();
        Path stderr = Path.of(this.getId("stderr"), new String[0]);
        return new OutputAnalyzer(this.stdout.toString(), Files.exists(stderr, new LinkOption[0]) ? Files.readString(stderr) : "", exitCode);
    }

    public void waitFor(int expected) throws Exception {
        if (this.p.waitFor() != expected) {
            throw new RuntimeException("Exit code not " + expected);
        }
    }

    public static void binOut(byte[] data) {
        System.out.println(PREFIX + Base64.getEncoder().encodeToString(data));
    }

    public static byte[] binIn() throws Exception {
        return Base64.getDecoder().decode(Proc.textIn());
    }

    public static void textOut(String data) {
        System.out.println(PREFIX + data);
    }

    public static String textIn() throws Exception {
        int i;
        StringBuilder sb = new StringBuilder();
        boolean isEmpty = true;
        while ((i = System.in.read()) != -1) {
            isEmpty = false;
            if (i == 10) break;
            if (i == 13) continue;
            sb.append((char)i);
        }
        return isEmpty ? null : sb.toString();
    }

    public static void d(String s) throws IOException {
        System.err.println(s);
    }

    public static void d(Throwable e) throws IOException {
        e.printStackTrace();
    }

    private static String[] splitProperty(String prop) {
        String s = System.getProperty(prop);
        if (s == null || s.trim().isEmpty()) {
            return new String[0];
        }
        return s.trim().split("\\s+");
    }
}

