/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sd extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CA = "\u06aa\u064a\u0646\u064a\u068a\u0627";
        final String metaValue_FJ = "\u0641\u062c\u064a";
        final String metaValue_HU = "\u0647\u0646\u06af\u0631\u064a";
        final String metaValue_LU = "\u0644\u06af\u0632\u0645\u0628\u0631\u06af";
        final String metaValue_NU = "\u0646\u0648\u0648\u064a";
        final String metaValue_TV = "\u062a\u0648\u0627\u0644\u0648";
        final String metaValue_ar = "\u0639\u0631\u0628\u064a";
        final String metaValue_bn = "\u0628\u0646\u06af\u0644\u0627";
        final String metaValue_el = "\u064a\u0648\u0646\u0627\u0646\u064a";
        final String metaValue_gu = "\u06af\u062c\u0631\u0627\u062a\u064a";
        final String metaValue_he = "\u0639\u0628\u0631\u0627\u0646\u064a";
        final String metaValue_ja = "\u062c\u0627\u067e\u0627\u0646\u064a";
        final String metaValue_km = "\u062e\u0645\u0631";
        final String metaValue_kn = "\u06aa\u0646\u0627\u068a\u0627";
        final String metaValue_ko = "\u06aa\u0648\u0631\u064a\u0627\u0626\u064a";
        final String metaValue_lo = "\u0644\u0627\u0626\u0648";
        final String metaValue_la = "\u0644\u0627\u0637\u064a\u0646\u064a";
        final String metaValue_mn = "\u0645\u0646\u06af\u0648\u0644\u064a";
        final String metaValue_nqo = "\u0646\u06aa\u0648";
        final String metaValue_or = "\u0627\u0648\u068a\u064a\u0627";
        final String metaValue_si = "\u0633\u0646\u0647\u0627\u0644\u0627";
        final String metaValue_su = "\u0633\u0648\u068a\u0627\u0646\u064a";
        final String metaValue_syr = "\u0634\u0627\u0645\u064a";
        final String metaValue_ta = "\u062a\u0627\u0645\u0644";
        final String metaValue_te = "\u062a\u0644\u06af\u0648";
        final String metaValue_th = "\u067f\u0627\u0626\u064a";
        final Object[][] data = new Object[][] {
            { "001", "\u062f\u0646\u064a\u0627" },
            { "002", "\u0622\u0641\u0631\u064a\u06aa\u0627" },
            { "003", "\u0627\u062a\u0631 \u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "005", "\u068f\u06a9\u06bb \u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "009", "\u0627\u0648\u0634\u0646\u064a\u0627" },
            { "011", "\u0627\u0648\u0644\u0647\u0647 \u0622\u0641\u0631\u064a\u0642\u0627" },
            { "013", "\u0648\u0686 \u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "014", "\u0627\u0648\u0680\u0631 \u0622\u0641\u0631\u064a\u06aa\u0627" },
            { "015", "\u0627\u062a\u0631 \u0622\u0641\u0631\u064a\u06aa\u0627" },
            { "017", "\u0648\u0686 \u0622\u0641\u0631\u064a\u06aa\u0627" },
            { "018", "\u068f\u0627\u06a9\u06bb\u064a \u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "019", "\u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "021", "\u0627\u062a\u0631\u064a\u0646 \u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "029", "\u06aa\u064a\u0631\u064a\u0628\u064a\u0646" },
            { "030", "\u0627\u0648\u0680\u0631 \u0627\u064a\u0634\u064a\u0627" },
            { "034", "\u068f\u06a9\u06bb \u0627\u064a\u0634\u064a\u0627" },
            { "035", "\u068f\u06a9\u06bb \u0627\u0648\u0680\u0631 \u0627\u064a\u0634\u064a\u0627" },
            { "039", "\u068f\u06a9\u06bb \u064a\u0648\u0631\u067e" },
            { "053", "\u0622\u0633\u067d\u0631\u06cc\u0644\u06cc\u0634\u06cc\u0627" },
            { "054", "\u0645\u06cc\u0644\u0627\u0646\u06cc\u0634\u06cc\u0627" },
            { "057", "\u0645\u0627\u0626\u06aa\u0631\u0648\u0646\u064a\u0634\u0627\u0626\u064a \u062e\u0637\u0648" },
            { "061", "\u067e\u0648\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "142", "\u0627\u064a\u0634\u064a\u0627" },
            { "143", "\u0648\u0686 \u0627\u064a\u0634\u064a\u0627" },
            { "145", "\u0627\u0648\u0644\u0647\u0647 \u0627\u064a\u0634\u064a\u0627" },
            { "150", "\u064a\u0648\u0631\u067e" },
            { "151", "\u0627\u0648\u0680\u0631 \u064a\u0648\u0631\u067e" },
            { "154", "\u0627\u062a\u0631\u064a\u0646 \u064a\u0648\u0631\u067e" },
            { "155", "\u0627\u0648\u0644\u0647\u0647 \u064a\u0648\u0631\u067e" },
            { "202", "\u0633\u0628-\u0633\u0647\u0627\u0631\u0627 \u0622\u0641\u0631\u064a\u06aa\u0627" },
            { "419", "\u0644\u0627\u0637\u064a\u0646\u064a \u0622\u0645\u0631\u064a\u06aa\u0627" },
            { "AC", "\u0637\u0644\u0648\u0639 \u067b\u064a\u067d" },
            { "AD", "\u0627\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0627\u0646\u067d\u064a\u06af\u0627 \u06fd \u0628\u0627\u0631\u0628\u062f" },
            { "AI", "\u0627\u0646\u06af\u0648\u064a\u0644\u0627" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u064a\u0627" },
            { "AM", "\u0627\u0631\u0645\u06cc\u0646\u06cc\u0627" },
            { "AO", "\u0627\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u0627\u0646\u067d\u0627\u0631\u06aa\u067d\u064a\u06aa\u0627" },
            { "AR", "\u0627\u0631\u062c\u0646\u067d\u064a\u0646\u0627" },
            { "AS", "\u0622\u0645\u0631\u064a\u06aa\u064a \u0633\u0627\u0645\u0648\u0627" },
            { "AT", "\u0622\u0633\u067d\u0631\u064a\u0627" },
            { "AU", "\u0622\u0633\u067d\u0631\u064a\u0644\u064a\u0627" },
            { "AW", "\u0639\u0631\u0648\u0628\u0627" },
            { "AX", "\u0627\u0644\u0646\u062f \u067b\u064a\u067d" },
            { "AZ", "\u0622\u0630\u0631\u0628\u0627\u0626\u064a\u062c\u0627\u0646" },
            { "BA", "\u0628\u0648\u0633\u0646\u064a\u0627 \u06fd \u0647\u0631\u0632\u0648\u06af\u0648\u0648\u064a\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u068a\u0648\u0633" },
            { "BD", "\u0628\u0646\u06af\u0644\u0627\u062f\u064a\u0634" },
            { "BE", "\u0628\u064a\u0644\u062c\u064a\u0645" },
            { "BF", "\u0628\u0631\u06aa\u064a\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u064a\u0627" },
            { "BH", "\u0628\u062d\u0631\u064a\u0646" },
            { "BI", "\u0628\u0631\u0648\u0646\u068a\u064a" },
            { "BJ", "\u0628\u064a\u0646\u0646" },
            { "BL", "\u0633\u06cc\u0646\u067d \u0628\u0631\u067f\u0644\u06cc\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u0626\u064a" },
            { "BO", "\u0628\u0648\u0644\u064a\u0648\u064a\u0627" },
            { "BQ", "\u06aa\u064a\u0631\u064a\u0628\u064a\u0646 \u0646\u064a\u062f\u0631\u0644\u064a\u0646\u068a" },
            { "BR", "\u0628\u0631\u0627\u0632\u064a\u0644" },
            { "BS", "\u0628\u0627\u0647\u0627\u0645\u0627\u0633" },
            { "BT", "\u0680\u0648\u067d\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u067d \u067b\u064a\u067d" },
            { "BW", "\u0628\u0648\u067d\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0633" },
            { "BZ", "\u0628\u064a\u0644\u064a\u0632" },
            { "CA", metaValue_CA },
            { "CC", "\u06aa\u0648\u06aa\u0648\u0633 \u067b\u064a\u067d" },
            { "CD", "\u06aa\u0627\u0646\u06af\u0648 -\u06aa\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0648\u0686 \u0622\u0641\u0631\u064a\u0642\u064a \u062c\u0645\u0647\u0648\u0631\u064a\u0647" },
            { "CG", "\u06aa\u0627\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644" },
            { "CH", "\u0633\u0648\u0626\u0632\u0631\u0644\u064a\u0646\u068a" },
            { "CI", "\u06aa\u0648\u067d\u064a \u0648\u064a\u0631\u0627" },
            { "CK", "\u06aa\u0648\u06aa \u067b\u064a\u067d" },
            { "CL", "\u0686\u0644\u064a" },
            { "CM", "\u06aa\u064a\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u064a\u0646" },
            { "CO", "\u06aa\u0648\u0644\u0645\u0628\u064a\u0627" },
            { "CP", "\u06aa\u0644\u067e\u0631\u067d\u0646 \u067b\u064a\u067d" },
            { "CR", "\u06aa\u0648\u0633\u067d\u0627 \u0631\u064a\u06aa\u0627" },
            { "CU", "\u06aa\u064a\u0648\u0628\u0627" },
            { "CV", "\u06aa\u064a\u067e \u0648\u0631\u062f\u064a" },
            { "CW", "\u06aa\u064a\u0648\u0631\u0627\u0633\u0627\u0626\u0648" },
            { "CX", "\u06aa\u0631\u0633\u0645\u0633 \u067b\u064a\u067d" },
            { "CY", "\u0633\u0627\u0626\u067e\u0631\u0633" },
            { "CZ", "\u0686\u064a\u06aa\u064a\u0627" },
            { "DE", "\u062c\u0631\u0645\u0646\u064a" },
            { "DG", "\u068a\u0626\u064a\u06af\u0648 \u06af\u0627\u0631\u0633\u064a\u0627" },
            { "DJ", "\u068a\u062c\u0628\u064a\u0648\u062a\u064a" },
            { "DK", "\u068a\u064a\u0646\u0645\u0627\u0631\u06aa" },
            { "DM", "\u068a\u0648\u0645\u064a\u0646\u064a\u06aa\u0627" },
            { "DO", "\u068a\u0648\u0645\u064a\u0646\u064a\u06aa\u0646 \u062c\u0645\u0647\u0648\u0631\u064a\u0647" },
            { "DZ", "\u0627\u0644\u062c\u064a\u0631\u064a\u0627" },
            { "EA", "\u0633\u06cc\u0648\u067d\u0627 \u06fd \u0645\u06cc\u0644\u06cc\u0644\u0627" },
            { "EC", "\u0627\u064a\u06aa\u0648\u0627\u068a\u0648\u0631" },
            { "EE", "\u0627\u064a\u0633\u067d\u0648\u0646\u064a\u0627" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0627\u0648\u0644\u0647\u0647 \u0635\u062d\u0627\u0631\u0627" },
            { "ER", "\u0627\u064a\u0631\u064a\u067d\u064a\u0631\u064a\u0627" },
            { "ES", "\u0627\u0633\u067e\u064a\u0646" },
            { "ET", "\u0627\u064a\u067f\u0648\u067e\u064a\u0627" },
            { "EU", "\u064a\u0648\u0631\u067e\u064a\u0646 \u064a\u0648\u0646\u064a\u0646" },
            { "EZ", "\u064a\u0648\u0631\u0648 \u0632\u0648\u0646" },
            { "FI", "\u0641\u0646 \u0644\u064a\u0646\u068a" },
            { "FJ", metaValue_FJ },
            { "FK", "\u0641\u0627\u06aa \u0644\u064a\u0646\u068a \u067b\u064a\u067d" },
            { "FM", "\u0645\u0627\u0626\u06aa\u0631\u0648\u0646\u064a\u0634\u064a\u0627" },
            { "FO", "\u0641\u0627\u0631\u0648 \u067b\u064a\u067d" },
            { "FR", "\u0641\u0631\u0627\u0646\u0633" },
            { "GA", "\u06af\u0628\u0648\u0646" },
            { "GB", "\u0628\u0631\u0637\u0627\u0646\u064a\u06c1" },
            { "GD", "\u06af\u0631\u064a\u0646\u068a\u0627" },
            { "GE", "\u062c\u0627\u0631\u062c\u064a\u0627" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a \u06af\u064a\u0627\u0646\u0627" },
            { "GG", "\u06af\u0648\u0631\u0646\u0633\u064a" },
            { "GH", "\u06af\u0647\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0631\u0627\u0644\u067d\u0631" },
            { "GL", "\u06af\u0631\u064a\u0646 \u0644\u064a\u0646\u068a" },
            { "GM", "\u06af\u064a\u0645\u0628\u064a\u0627" },
            { "GN", "\u06af\u0646\u064a" },
            { "GP", "\u06af\u0648\u0627\u068a\u06cc\u0644\u0648\u067e" },
            { "GQ", "\u0627\u064a\u06aa\u0648\u067d\u0648\u0631\u064a\u0644 \u06af\u0627\u0626\u064a\u0646\u0627" },
            { "GR", "\u064a\u0648\u0646\u0627\u0646" },
            { "GS", "\u068f\u06a9\u06bb \u062c\u0627\u0631\u062c\u064a\u0627 \u06fd \u068f\u06a9\u06bb \u0633\u064a\u0646\u068a\u0648\u0686 \u067b\u064a\u067d" },
            { "GT", "\u06af\u0648\u0626\u067d\u064a \u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0627\u0645" },
            { "GW", "\u06af\u0646\u064a \u0628\u0633\u0627\u0626\u0648" },
            { "GY", "\u06af\u064a\u0627\u0646\u0627" },
            { "HK", "\u0647\u0627\u0646\u06af \u06aa\u0627\u0646\u06af SAR" },
            { "HM", "\u0647\u0631\u068a \u06fd \u0645\u06aa\u068a\u0648\u0646\u0644\u068a \u067b\u064a\u067d" },
            { "HN", "\u0647\u0646\u068a\u0648\u0631\u0633" },
            { "HR", "\u06aa\u0631\u0648\u0626\u064a\u0634\u064a\u0627" },
            { "HT", "\u0647\u064a\u067d\u064a" },
            { "HU", metaValue_HU },
            { "IC", "\u06aa\u064a\u0646\u0631\u064a \u067b\u064a\u067d" },
            { "ID", "\u0627\u0646\u068a\u0648\u0646\u064a\u0634\u064a\u0627" },
            { "IE", "\u0622\u0626\u0631\u0644\u064a\u0646\u068a" },
            { "IL", "\u0627\u0633\u0631\u0627\u0626\u064a\u0644" },
            { "IM", "\u0627\u0646\u0633\u0627\u0646\u0646 \u062c\u0648 \u067b\u064a\u067d" },
            { "IN", "\u0680\u0627\u0631\u062a" },
            { "IO", "\u0628\u0631\u0637\u0627\u0646\u0648\u064a \u0647\u0646\u062f\u064a \u0633\u0645\u0646\u068a \u062e\u0637\u0648" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u064a\u0631\u0627\u0646" },
            { "IS", "\u0622\u0626\u0633 \u0644\u064a\u0646\u068a" },
            { "IT", "\u0627\u067d\u0644\u064a" },
            { "JE", "\u062c\u0631\u0633\u064a" },
            { "JM", "\u062c\u0645\u064a\u06aa\u0627" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "KE", "\u06aa\u064a\u0646\u064a\u0627" },
            { "KG", "\u06aa\u0631\u063a\u0633\u062a\u0627\u0646" },
            { "KH", "\u06aa\u0645\u0628\u0648\u068a\u064a\u0627" },
            { "KI", "\u06aa\u0631\u0628\u0627\u062a\u064a" },
            { "KM", "\u06aa\u0648\u0645\u0648\u0631\u0648\u0633" },
            { "KN", "\u0633\u064a\u0646\u067d \u06aa\u067d\u0633 \u0648 \u0646\u064a\u0648\u0633" },
            { "KP", "\u0627\u062a\u0631 \u06aa\u0648\u0631\u064a\u0627" },
            { "KR", "\u068f\u06a9\u06bb \u06aa\u0648\u0631\u064a\u0627" },
            { "KW", "\u06aa\u0648\u064a\u062a" },
            { "KY", "\u06aa\u064a \u0645\u064a\u0646 \u067b\u064a\u067d" },
            { "KZ", "\u0642\u0627\u0632\u0642\u0633\u062a\u0627\u0646" },
            { "LA", "\u0644\u0627\u0626\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u064a\u0646\u067d \u0644\u0648\u0633\u064a\u0627" },
            { "LI", "\u0644\u0686\u064a \u067d\u064a\u0646\u0633\u067d\u064a\u0646" },
            { "LK", "\u0633\u0631\u064a \u0644\u0646\u06aa\u0627" },
            { "LR", "\u0644\u0627\u0626\u0628\u06cc\u0631\u06cc\u0627" },
            { "LS", "\u0644\u064a\u0633\u0648\u067f\u0648" },
            { "LT", "\u0644\u067f\u0648\u0646\u064a\u0627" },
            { "LU", metaValue_LU },
            { "LV", "\u0644\u0627\u062a\u0648\u064a\u0627" },
            { "LY", "\u0644\u0628\u064a\u0627" },
            { "MA", "\u0645\u0631\u0627\u06aa\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06aa\u0648" },
            { "MD", "\u0645\u0627\u0644\u062f\u0648\u0648\u0627" },
            { "ME", "\u0645\u0648\u0646\u067d\u064a \u0646\u064a\u06af\u0631\u0648" },
            { "MF", "\u0633\u064a\u0646\u067d \u0645\u0627\u0631\u067d\u0646" },
            { "MG", "\u0645\u062f\u06af\u0627\u0633\u06aa\u0631" },
            { "MH", "\u0645\u0627\u0631\u0634\u0644 \u067b\u064a\u067d" },
            { "MK", "\u0627\u062a\u0631 \u0645\u0642\u062f\u0648\u0646\u064a\u0627" },
            { "ML", "\u0645\u0627\u0644\u064a" },
            { "MM", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u0646\u06af\u0648\u0644\u064a\u0627" },
            { "MO", "\u0645\u06aa\u0627\u0626\u0648 SAR \u0686\u064a\u0646" },
            { "MP", "\u0627\u062a\u0631\u064a\u0627\u0646 \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u067b\u064a\u067d" },
            { "MQ", "\u0645\u0627\u0631\u062a\u064a\u0646\u06aa" },
            { "MR", "\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627" },
            { "MS", "\u0645\u0648\u0646\u067d\u0633\u0631\u0627\u067d" },
            { "MT", "\u0645\u0627\u0644\u067d\u0627" },
            { "MU", "\u0645\u0648\u0631\u064a\u0634\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u064a\u067e" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u064a" },
            { "MX", "\u0645\u064a\u06aa\u0633\u064a\u06aa\u0648" },
            { "MY", "\u0645\u0644\u0627\u0626\u064a\u0634\u064a\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u06cc\u0642" },
            { "NA", "\u0646\u064a\u0645\u064a\u0628\u064a\u0627" },
            { "NC", "\u0646\u06cc\u0648 \u06aa\u0627\u0644\u06cc\u068a\u0648\u0646\u06cc\u0627" },
            { "NE", "\u0646\u0627\u0626\u064a\u062c\u0631" },
            { "NF", "\u0646\u0648\u0631\u0641\u0648\u06aa \u067b\u064a\u067d" },
            { "NG", "\u0646\u0627\u0626\u064a\u062c\u064a\u0631\u064a\u0627" },
            { "NI", "\u0646\u06aa\u0631\u0627\u06af\u0648\u0627" },
            { "NL", "\u0646\u064a\u062f\u0631\u0644\u064a\u0646\u068a" },
            { "NO", "\u0646\u0627\u0631\u0648\u064a" },
            { "NP", "\u0646\u064a\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0626\u0648\u0631\u0648" },
            { "NU", metaValue_NU },
            { "NZ", "\u0646\u064a\u0648 \u0632\u064a\u0644\u064a\u0646\u068a" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "PA", "\u067e\u0646\u0627\u0645\u0627" },
            { "PE", "\u067e\u064a\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a \u067e\u0648\u0644\u064a\u0646\u064a\u0634\u064a\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u0646\u06cc\u0648 \u06af\u0646\u064a" },
            { "PH", "\u0641\u0644\u067e\u0627\u0626\u0646" },
            { "PK", "\u067e\u0627\u06aa\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u064a\u0646\u068a" },
            { "PM", "\u0633\u06cc\u0646\u067d \u067e\u06cc\u0626\u0631 \u0648 \u0645\u06cc\u06aa\u0648\u0626\u06cc\u0644\u0648\u0646" },
            { "PN", "\u067e\u067d\u06aa\u0626\u0631\u0646 \u067b\u064a\u067d" },
            { "PR", "\u067e\u064a\u0648\u0626\u0631\u067d\u0648 \u0631\u064a\u06aa\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u064a\u0646\u064a \u0639\u0644\u0627\u0626\u0642\u0627" },
            { "PT", "\u067e\u0631\u062a\u06af\u0627\u0644" },
            { "PW", "\u067e\u0644\u0627\u0626\u0648" },
            { "PY", "\u067e\u064a\u0631\u0627\u06af\u0648\u0621\u0650" },
            { "QA", "\u0642\u0637\u0631" },
            { "QO", "\u0628\u064a\u0631\u0648\u0646\u064a \u0633\u0627\u0645\u0648\u0646\u068a\u064a" },
            { "RE", "\u0631\u064a \u064a\u0648\u0646\u064a\u0646" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u064a\u0627" },
            { "RS", "\u0633\u0631\u0628\u064a\u0627" },
            { "RU", "\u0631\u0648\u0633" },
            { "RW", "\u0631\u0648\u0627\u0646\u068a\u0627" },
            { "SA", "\u0633\u0639\u0648\u062f\u064a \u0639\u0631\u0628" },
            { "SB", "\u0633\u0648\u0644\u0648\u0645\u0648\u0646 \u067b\u064a\u067d\u064e" },
            { "SC", "\u0634\u064a \u0634\u0644\u0632" },
            { "SD", "\u0633\u0648\u068a\u0627\u0646" },
            { "SE", "\u0633\u0648\u0626\u064a\u068a\u0646" },
            { "SG", "\u0633\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u064a\u0646\u067d \u06be\u064a\u0644\u064a\u0646\u0627" },
            { "SI", "\u0633\u0644\u0648\u06cc\u0646\u06cc\u0627" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u068a \u06fd \u062c\u0627\u0646 \u0645\u0627\u06cc\u0646" },
            { "SK", "\u0633\u0644\u0648\u0648\u0627\u06aa\u064a\u0627" },
            { "SL", "\u0633\u064a\u0631\u0627 \u0644\u064a\u0648\u0646" },
            { "SM", "\u0633\u06cc\u0646 \u0645\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u064a\u0646\u064a\u06af\u0627\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u064a\u0627" },
            { "SR", "\u0633\u0648\u0631\u064a\u0646\u0627\u0645" },
            { "SS", "\u068f\u06a9\u06bb \u0633\u0648\u068a\u0627\u0646" },
            { "ST", "\u0633\u0627\u0626\u0648 \u067d\u0648\u0645 \u06fd \u067e\u0631\u0646\u0633\u067e\u06cc\u064a" },
            { "SV", "\u0627\u0644 \u0633\u0644\u0648\u0627\u068a\u0648\u0631" },
            { "SX", "\u0633\u0646\u067d \u0645\u0627\u0631\u067d\u0646" },
            { "SY", "\u0634\u0627\u0645" },
            { "SZ", "\u0627\u064a\u0633\u0648\u0627\u067d\u0646\u064a" },
            { "TA", "\u067d\u0631\u0633\u067d\u0646 \u062f\u0627 \u06aa\u0648\u0647\u0627" },
            { "TC", "\u062a\u0631\u06aa \u06fd \u06aa\u064a\u06aa\u0648\u0633 \u067b\u064a\u067d" },
            { "TD", "\u0686\u0627\u068a" },
            { "TF", "\u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a \u068f\u0627\u06a9\u06bb\u064a \u0639\u0644\u0627\u0626\u0642\u0627" },
            { "TG", "\u067d\u0648\u06af\u0648" },
            { "TH", "\u067f\u0627\u0626\u064a\u0644\u064a\u0646\u062f" },
            { "TJ", "\u062a\u0627\u062c\u06aa\u0633\u062a\u0627\u0646" },
            { "TK", "\u067d\u0648\u06aa\u0644\u0627\u0626\u0648" },
            { "TL", "\u062a\u064a\u0645\u0648\u0631 \u0644\u064a\u0633\u062a\u064a" },
            { "TM", "\u062a\u0631\u06aa\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u064a\u0648\u0646\u064a\u0633\u064a\u0627" },
            { "TO", "\u067d\u0648\u0646\u06af\u0627" },
            { "TR", "\u062a\u0631\u06aa\u064a\u064a\u064a" },
            { "TT", "\u067d\u0631\u064a\u0646\u064a \u068a\u064a\u068a \u06fd \u067d\u0648\u0628\u0627\u06af\u0648 \u067b\u064a\u067d" },
            { "TV", metaValue_TV },
            { "TW", "\u062a\u0627\u0626\u06cc\u0648\u0627\u0646" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u064a\u0627" },
            { "UA", "\u064a\u0648\u06aa\u0631\u064a\u0646" },
            { "UG", "\u064a\u0648\u06af\u0646\u068a\u0627" },
            { "UM", "\u0622\u0645\u0631\u064a\u06aa\u064a \u062e\u0627\u0631\u062c\u064a \u067b\u064a\u067d" },
            { "UN", "\u06af\u068f\u064a\u0644 \u0642\u0648\u0645\u0648\u0646" },
            { "US", "\u0622\u0645\u0631\u064a\u06aa\u0627 \u062c\u0648\u0646 \u06af\u068f\u064a\u0644 \u0631\u064a\u0627\u0633\u062a\u0648\u0646" },
            { "UY", "\u064a\u0648\u0631\u0648\u06af\u0648\u0621\u0650" },
            { "UZ", "\u0627\u0632\u0628\u06aa\u0633\u062a\u0627\u0646" },
            { "VA", "\u0648\u064a\u067d\u06aa\u064a\u0646 \u0633\u067d\u064a" },
            { "VC", "\u0633\u06cc\u0646\u067d \u0648\u0646\u0633\u0646\u062a \u06fd \u06af\u0631\u06cc\u0646\u0627\u068a\u06cc\u0646\u0632" },
            { "VE", "\u0648\u064a\u0646\u0632\u0648\u064a\u0644\u0627" },
            { "VG", "\u0628\u0631\u0637\u0627\u0646\u0648\u064a \u0648\u0631\u062c\u0646 \u067b\u064a\u067d" },
            { "VI", "\u0622\u0645\u0631\u064a\u06aa\u064a \u0648\u0631\u062c\u0646 \u067b\u064a\u067d" },
            { "VN", "\u0648\u064a\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u064a\u0646\u064a\u067d\u064a\u0648" },
            { "WF", "\u0648\u0627\u0644\u0633 \u06fd \u0641\u062a\u0648\u0646\u0627" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "XA", "\u0633\u0648\u068a\u0648-\u0644\u0647\u062c\u0627" },
            { "XB", "\u0633\u0648\u068a\u0648-\u0628\u064a \u068a\u064a" },
            { "XK", "\u06aa\u0648\u0633\u0648\u0648\u0648" },
            { "YE", "\u064a\u0645\u0646" },
            { "YT", "\u0645\u064a\u0627\u062a\u064a" },
            { "ZA", "\u068f\u06a9\u06bb \u0622\u0641\u0631\u064a\u0642\u0627" },
            { "ZM", "\u0632\u064a\u0645\u0628\u064a\u0627" },
            { "ZW", "\u0632\u0645\u0628\u0627\u0628\u0648\u064a" },
            { "ZZ", "\u0627\u06bb\u0684\u0627\u062a\u0644 \u062e\u0637\u0648" },
            { "aa", "\u0627\u0641\u0627\u0631" },
            { "ab", "\u0627\u0628\u0642\u0627\u0632\u06cc\u0627\u0646" },
            { "af", "\u0622\u0641\u0631\u064a\u06aa\u064a" },
            { "ak", "\u0627\u06aa\u0627\u0646" },
            { "am", "\u0627\u0645\u0647\u0627\u0631\u064a" },
            { "an", "\u0627\u0631\u06af\u0646\u064a" },
            { "ar", metaValue_ar },
            { "as", "\u0622\u0633\u0627\u0645\u064a" },
            { "av", "\u0627\u0648\u064a\u0631\u0633" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "az", "\u0622\u0632\u0631\u0628\u0627\u0626\u064a\u062c\u0627\u0646\u064a" },
            { "ba", metaValue_CA },
            { "be", "\u0628\u064a\u0644\u0627\u0631\u0648\u0633\u064a" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u064a\u0627\u0626\u064a" },
            { "bi", "\u0628\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u0645\u0628\u0627\u0631\u0627" },
            { "bn", metaValue_bn },
            { "bo", "\u062a\u0628\u064a\u062a\u0627\u0626\u064a" },
            { "br", "\u0628\u0631\u064a\u067d\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u064a\u0627\u0626\u064a" },
            { "ca", "\u06aa\u064a\u067d\u0627\u0644\u0627\u0646" },
            { "ce", "\u0686\u06cc\u0686\u0646" },
            { "ch", "\u0686\u0645\u0648\u0631\u0648" },
            { "co", "\u06aa\u0627\u0631\u0633\u064a\u06aa\u0627\u0626\u064a" },
            { "cs", "\u0686\u064a\u06aa" },
            { "cu", "\u0686\u0631\u0686 \u0633\u0644\u0627\u0648\u06cc" },
            { "cv", "\u0686\u0648 \u0648\u0627\u0634" },
            { "cy", "\u0648\u064a\u0644\u0634" },
            { "da", "\u068a\u064a\u0646\u0634" },
            { "de", "\u062c\u0631\u0645\u0646" },
            { "dv", "\u062f\u0648\u064a\u0647\u064a" },
            { "dz", "\u0632\u0648\u0646\u062e\u0627" },
            { "ee", "\u0627\u064a\u0648" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06af\u0631\u064a\u0632\u064a" },
            { "eo", "\u0627\u064a\u0633\u067e\u0631\u0627\u0646\u067d\u0648" },
            { "es", "\u0647\u0633\u067e\u0627\u0646\u0648\u064a" },
            { "et", "\u0627\u064a\u0633\u062a\u0648\u0646\u0627\u0626\u064a" },
            { "eu", "\u0628\u0627\u0633\u0642" },
            { "fa", "\u0641\u0627\u0631\u0633\u064a" },
            { "ff", "\u0641\u0644\u0627\u0647\u0647" },
            { "fi", "\u0641\u0646\u0634" },
            { "fj", metaValue_FJ },
            { "fo", "\u0641\u064a\u0631\u0648\u0627\u064a\u0633" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a" },
            { "fy", "\u0645\u063a\u0631\u0628\u064a \u0641\u0631\u064a\u0634\u0646" },
            { "ga", "\u0622\u0626\u0631\u0634" },
            { "gd", "\u0627\u0633\u06aa\u0627\u067d\u0634 \u06af\u064a\u0644\u06aa" },
            { "gl", "\u06af\u0644\u064a\u0634\u0626\u064a\u0646" },
            { "gn", "\u06af\u0648\u0627\u0631\u0627\u0646\u064a" },
            { "gu", metaValue_gu },
            { "gv", "\u0645\u064a\u0646\u06aa\u0633" },
            { "ha", "\u0647\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0647\u0646\u062f\u064a" },
            { "hr", "\u06aa\u0631\u0648\u0634\u064a\u0627\u0626\u064a" },
            { "ht", "\u0647\u064a\u067d\u064a \u06aa\u0631\u0648\u0644\u064a" },
            { "hu", metaValue_HU },
            { "hy", "\u0627\u0631\u0645\u0627\u0646\u064a" },
            { "hz", "\u0647\u0631\u064a\u0631\u0648" },
            { "ia", "\u0627\u0646\u067d\u0631\u0644\u0646\u06af\u0626\u0627" },
            { "id", "\u0627\u0646\u068a\u0648\u0646\u064a\u0634\u064a" },
            { "ig", "\u0627\u06af\u0628\u0648" },
            { "ii", "\u0633\u0686\u0648\u0627\u0646 \u064a\u064a" },
            { "io", "\u0627\u062f\u0648" },
            { "is", "\u0622\u0626\u064a\u0633 \u0644\u064a\u0646\u068a\u06aa" },
            { "it", "\u0627\u0637\u0627\u0644\u0648\u064a" },
            { "iu", "\u0627\u0646\u0648 \u06aa\u062a\u0648\u062a" },
            { "ja", metaValue_ja },
            { "jv", "\u062c\u0627\u0648\u0646\u064a\u0632" },
            { "ka", "\u062c\u0627\u0631\u062c\u064a\u0627\u0626\u064a" },
            { "ki", "\u0627\u06aa\u0648\u064a\u0648" },
            { "kj", "\u06aa\u0646\u064a\u0627\u0645\u0627" },
            { "kk", "\u0642\u0627\u0632\u0642" },
            { "kl", "\u06aa\u0627\u0644\u0627 \u0644\u064a\u0633\u067d" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u06aa\u0646\u0648\u0631\u064a" },
            { "ks", "\u06aa\u0634\u0645\u064a\u0631\u064a" },
            { "ku", "\u06aa\u0631\u062f\u064a" },
            { "kv", "\u06aa\u0648\u0645\u064a" },
            { "kw", "\u06aa\u0648\u0631\u0646\u0634" },
            { "ky", "\u06aa\u0631\u063a\u064a\u0632" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "li", "\u0644\u0645\u0628\u0631\u06af\u0634" },
            { "ln", "\u0644\u0646\u06af\u0627\u0644\u0627" },
            { "lo", metaValue_lo },
            { "lt", "\u0644\u064a\u067f\u0648\u0646\u064a\u0627\u0626\u064a" },
            { "lu", "\u0644\u0648\u0628\u0627-\u06aa\u062a\u0627\u0646\u06af\u0627" },
            { "lv", "\u0644\u0627\u062a\u0648\u064a\u0646" },
            { "mg", "\u0645\u0644\u0627\u06af\u0627\u0633\u064a" },
            { "mh", "\u0645\u0627\u0631\u0634\u0644\u064a\u0632" },
            { "mi", "\u0645\u0627\u0626\u0648\u0631\u064a" },
            { "mk", "\u0645\u064a\u0633\u064a \u068a\u0648\u0646\u064a\u0627\u0626\u064a" },
            { "ml", "\u0645\u0644\u064a\u0627\u0644\u0645" },
            { "mn", metaValue_mn },
            { "mr", "\u0645\u0631\u0627\u067a\u064a" },
            { "ms", "\u0645\u0644\u064a" },
            { "mt", "\u0645\u0627\u0644\u067d\u064a" },
            { "my", "\u0628\u0631\u0645\u064a" },
            { "na", "\u0646\u0627\u0626\u0648" },
            { "nb", "\u0646\u0627\u0631\u0648\u064a\u0627\u0626\u064a \u0628\u0648\u06aa\u0645\u0627\u0644" },
            { "nd", "\u0627\u062a\u0631 \u062f\u0628\u064a\u0644\u064a" },
            { "ne", "\u0646\u064a\u067e\u0627\u0644\u064a" },
            { "ng", "\u068a\u0648\u0646\u06af\u0627" },
            { "nl", "\u068a\u0686" },
            { "nn", "\u0646\u0627\u0631\u0648\u064a\u0627\u0626\u064a \u0646\u064a\u0648\u0646\u0627\u0633\u06aa" },
            { "no", "\u0646\u0627\u0631\u0648\u064a\u062c\u064a\u0627\u0626\u064a" },
            { "nr", "\u068f\u06a9\u06bb \u062f\u0628\u064a\u0644\u064a" },
            { "nv", "\u0646\u0648\u0627\u062c\u0648" },
            { "ny", "\u0646\u064a\u0627\u0646\u062c\u0627" },
            { "oc", "\u0622\u06aa\u0633\u064a\u067d\u0646" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", metaValue_or },
            { "os", "\u0627\u0648\u0633\u064a\u067d\u06aa" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u064a" },
            { "pl", "\u067e\u0648\u0644\u0634" },
            { "ps", "\u067e\u0634\u062a\u0648" },
            { "pt", "\u067e\u0648\u0631\u067d\u06af\u0644\u064a\u0632" },
            { "qu", "\u06aa\u064a\u0686\u0648\u0627" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0648\u0646\u068a\u064a" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u064a" },
            { "ru", "\u0631\u0648\u0633\u064a" },
            { "rw", "\u06aa\u0646\u064a\u0627\u0631 \u0648\u0627\u0646\u068a\u0627" },
            { "sa", "\u0633\u0646\u0633\u06aa\u0631\u062a" },
            { "sc", "\u0633\u0627\u0631\u068a\u064a\u0646\u064a" },
            { "sd", "\u0633\u0646\u068c\u064a" },
            { "se", "\u0627\u062a\u0631 \u0633\u0627\u0645\u064a" },
            { "sg", "\u0633\u0627\u0646\u06af\u0648" },
            { "si", metaValue_si },
            { "sk", "\u0633\u0644\u0648\u0627\u06aa\u064a" },
            { "sl", "\u0633\u0644\u0648\u0648\u064a\u0646\u064a" },
            { "sm", "\u0633\u0645\u0648\u0626\u0627" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u064a" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u064a" },
            { "sr", "\u0633\u0631\u0628\u064a\u0627\u0626\u064a" },
            { "ss", "\u0633\u0648\u0627\u062a\u064a" },
            { "st", "\u068f\u06a9\u06bb \u0633\u0648\u067f\u064a" },
            { "su", metaValue_su },
            { "sv", "\u0633\u0648\u064a\u068a\u0634" },
            { "sw", "\u0633\u0648\u0627\u062d\u064a\u0644\u064a" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u062a\u0627\u062c\u06aa" },
            { "th", metaValue_th },
            { "ti", "\u062a\u06af\u0631\u064a\u0646\u064a\u0627\u0626\u064a" },
            { "tk", "\u062a\u0631\u06aa\u0645\u064a\u0646" },
            { "tn", "\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "to", "\u062a\u0648\u0646\u06af\u0646" },
            { "tr", "\u062a\u0631\u06aa\u0634" },
            { "ts", "\u0633\u0648\u0646\u06af\u0627" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "ty", "\u062a\u0627\u0647\u064a\u062a\u064a" },
            { "ug", "\u064a\u0648\u063a\u0648\u0631" },
            { "uk", "\u064a\u0648\u06aa\u0631\u0627\u0646\u064a" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "uz", "\u0627\u0632\u0628\u06aa" },
            { "ve", "\u0648\u064a\u0646\u068a\u0627" },
            { "vi", "\u0648\u064a\u062a\u0646\u0627\u0645\u064a" },
            { "vo", "\u0648\u0627\u0644\u067e\u06aa" },
            { "wa", "\u0648\u0644\u0648\u0646" },
            { "wo", "\u0648\u0648\u0644\u0648\u0641" },
            { "xh", "\u0632\u06be\u0648\u0633\u0627" },
            { "yi", "\u064a\u062f\u0634" },
            { "yo", "\u064a\u0648\u0631\u0648\u0628\u0627" },
            { "zh", "\u0686\u064a\u0646\u064a" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "ace", "\u0627\u0686\u0627\u0626\u064a\u0646\u064a\u0632" },
            { "ada", "\u0627\u062f\u0646\u06af\u0645\u064a" },
            { "ady", "\u0627\u062f\u064a\u06af\u0647\u064a" },
            { "agq", "\u0627\u06af\u0647\u064a\u0645" },
            { "ain", "\u0622\u0626\u064a\u0646\u0648" },
            { "ale", "\u0627\u0644\u064a\u0648\u067d" },
            { "alt", "\u068f\u06a9\u06bb \u0627\u0644\u062a\u0627\u0626\u064a" },
            { "ann", "\u0627\u0648\u0628\u0648\u0644\u0648" },
            { "anp", "\u0627\u0646\u062c\u064a\u06aa\u0627" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u064a" },
            { "arp", "\u0627\u0631\u0627\u067e\u0627\u0626\u0648" },
            { "ars", "\u0646\u062c\u062f\u064a \u0639\u0631\u0628\u064a" },
            { "asa", "\u0627\u0633\u0648" },
            { "ast", "\u0627\u0633\u067d\u0648\u0631\u064a\u0646" },
            { "atj", "\u0627\u067d\u064a\u06aa\u0627\u0645\u064a\u06aa\u0648" },
            { "awa", "\u0627\u0648\u0627\u068c\u064a" },
            { "ban", "\u0628\u0627\u0644\u064a\u0646\u064a\u0633" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "bem", "\u0628\u064a\u0645\u0628\u0627" },
            { "bez", "\u0628\u064a\u0646\u0627" },
            { "bgc", "\u06be\u0631\u064a\u0627\u0646\u0648\u064a" },
            { "bho", "\u0680\u0648\u062c\u067e\u0648\u0631\u064a" },
            { "bin", "\u0628\u0646\u064a" },
            { "bla", "\u0633\u06aa\u0633\u06aa\u0627" },
            { "brx", "\u0628\u0648\u062f\u0648" },
            { "bug", "\u0628\u06af\u0646\u064a\u0632" },
            { "byn", "\u0628\u0644\u0646" },
            { "cay", "\u06aa\u0627\u064a\u0648\u06af\u0627" },
            { "ccp", "\u0686\u0645\u06aa\u0627" },
            { "ceb", "\u0633\u0628\u0648\u0627\u0646\u0648" },
            { "cgg", "\u0686\u06af\u0627" },
            { "chk", "\u0686\u06aa\u064a\u0632" },
            { "chm", "\u0645\u0627\u0631\u064a" },
            { "cho", "\u0686\u0648\u06aa \u062a\u0648" },
            { "chp", "\u0686\u0627\u0626\u067e\u0627\u0626\u0646" },
            { "chr", "\u0686\u0631\u0648\u06aa\u064a" },
            { "chy", "\u0686\u0627\u064a\u0627\u0646" },
            { "ckb", "\u0645\u0631\u06aa\u0632\u064a \u06aa\u0631\u062f\u0634" },
            { "clc", "\u0686\u0644\u06aa\u0648\u067d\u0646" },
            { "crg", "\u0645\u064a\u0686\u064a\u0641" },
            { "crj", "\u068f\u06a9\u06bb \u0627\u0680\u0631\u0646\u062f\u0648 \u06aa\u0631\u064a" },
            { "crk", "\u067e\u0644\u064a\u0646\u0632 \u06aa\u0631\u064a" },
            { "crl", "\u0627\u062a\u0631\u064a\u0646 \u0627\u0648\u0680\u0631 \u06aa\u0631\u064a" },
            { "crm", "\u0645\u0648\u0633 \u06aa\u0631\u064a" },
            { "crr", "\u06aa\u064a\u0631\u0648\u0644\u064a\u0646\u0627 \u0627\u0644\u06af\u0627\u0646\u06aa\u0648\u064a\u0626\u0646" },
            { "crs", "\u0633\u064a\u0633\u0644\u0648\u0627 \u06aa\u0631\u064a\u0626\u0648\u0644 \u0641\u0631\u0627\u0646\u0633\u064a" },
            { "csw", "\u0633\u0648\u0627\u0645\u067e\u064a \u06aa\u0631\u064a" },
            { "dak", "\u068a\u06aa\u0648\u067d\u0627" },
            { "dar", "\u068a\u0627\u0631\u06af\u0648\u0627" },
            { "dav", "\u062a\u0627\u0626\u064a\u062a\u0627" },
            { "dgr", "\u062f\u0627\u06af\u0631\u0628" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627" },
            { "doi", "\u068a\u0648\u06af\u0631\u064a" },
            { "dsb", "\u0644\u0648\u0626\u0631 \u0633\u0648\u0631\u0628\u064a\u0646" },
            { "dua", "\u068a\u064a\u0648\u0644\u0627" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a" },
            { "dzg", "\u062f\u0632\u0627\u06af\u0627" },
            { "ebu", "\u0627\u064a\u0645\u0628\u064a\u0648" },
            { "efi", "\u0627\u064a\u0641\u06aa" },
            { "eka", "\u0627\u064a\u06aa\u0627\u062c\u06aa" },
            { "ewo", "\u0627\u0648\u0627\u0646\u068a\u0648" },
            { "fil", "\u0641\u0644\u067e\u0627\u0626\u0646\u064a" },
            { "fon", "\u0641\u0648\u0646" },
            { "frc", "\u06aa\u064a\u062c\u0646 \u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a" },
            { "frr", "\u0627\u062a\u0631\u064a\u0646 \u0641\u0631\u064a\u0633\u064a\u0646" },
            { "fur", "\u0641\u0631\u0627\u0626\u064a \u0644\u0626\u064a\u0646" },
            { "gaa", "\u06af\u0627" },
            { "gez", "\u062c\u064a\u0632" },
            { "gil", "\u06af\u0644\u0628\u0631\u067d\u064a\u0632" },
            { "gor", "\u06af\u0648\u0631\u0646\u067d\u0644\u0648" },
            { "gsw", "\u0633\u0648\u0626\u0633 \u062c\u0631\u0645\u0646" },
            { "guz", "\u06af\u0634\u064a" },
            { "gwi", "\u06af\u0648\u0686\u0646" },
            { "hai", "\u06be\u0627\u0626\u064a\u068a\u0627" },
            { "haw", "\u0647\u0648\u0627\u0626\u064a" },
            { "hax", "\u068f\u0627\u06a9\u06bb\u064a \u06be\u0627\u0626\u068a\u0627" },
            { "hil", "\u0647\u0644\u064a \u06af\u064a\u0627\u0646\u0627\u0646" },
            { "hmn", "\u0645\u0648\u0646\u06af" },
            { "hsb", "\u0627\u067e\u0631 \u0633\u0631\u0628\u064a\u0627\u0626\u064a" },
            { "hup", "\u0647\u0648\u067e\u0627" },
            { "hur", "\u06be\u0627\u06aa\u0645\u0644\u0645" },
            { "iba", "\u0627\u064a\u0628\u0646" },
            { "ibb", "\u0627\u0628\u064a\u0628\u064a\u0648" },
            { "ikt", "\u0645\u063a\u0631\u0628\u064a \u06aa\u064a\u0646\u064a\u068a\u064a\u0646 \u0627\u0646\u0648\u06aa\u067d\u064a\u067d" },
            { "ilo", "\u0627\u0644\u0648\u06aa\u0648" },
            { "inh", "\u0627\u0646\u06af\u0634" },
            { "jbo", "\u0644\u0648\u062c\u0628\u064a\u0646" },
            { "jgo", "\u0646\u063a\u0648\u0645\u0628\u0627" },
            { "jmc", "\u0645\u064a\u06aa\u0645" },
            { "kab", "\u06aa\u0628\u0627\u0626\u0644" },
            { "kac", "\u06aa\u0686\u0646" },
            { "kaj", "\u067e\u0648\u06aa\u064a\u067e\u0633\u064a" },
            { "kam", "\u06aa\u0626\u0645\u0628\u0627" },
            { "kbd", "\u06aa\u0628\u0627\u0631\u068a\u064a\u0626\u0646" },
            { "kcg", "\u062a\u064a\u0627\u067e" },
            { "kde", "\u0645\u06aa\u0648\u0646\u062f\u064a" },
            { "kea", "\u06aa\u064a\u0628\u064a\u0648 \u0648\u064a\u0631\u068a\u064a\u0627\u0646\u0648" },
            { "kfo", "\u06aa\u0648\u0631\u0648" },
            { "kgp", "\u06aa\u0626\u064a\u0646\u06af\u064a\u0646\u06af" },
            { "kha", "\u062e\u0627\u0633\u064a" },
            { "khq", "\u06aa\u064a\u0648\u0631\u0627 \u0686\u0646\u064a" },
            { "kkj", "\u06aa\u06aa\u0648" },
            { "kln", "\u06aa\u064a\u0644\u064a\u0646 \u062c\u0646" },
            { "kmb", "\u06aa\u0646\u0645\u0628\u0648\u0646\u068a\u0648" },
            { "kok", "\u06aa\u0648\u0646\u06aa\u064a" },
            { "kpe", "\u06aa\u067e\u064a\u0644" },
            { "krc", "\u06aa\u0631\u0627\u0686\u064a \u0628\u0627\u0644\u06aa\u0631" },
            { "krl", "\u06aa\u0631\u064a\u0644\u0626\u064a\u0646" },
            { "kru", "\u06aa\u0648\u0631\u062e" },
            { "ksb", "\u0634\u0645\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0628\u0627\u0641\u064a\u0627" },
            { "ksh", "\u06aa\u0644\u0648\u0646\u0626\u064a\u0646" },
            { "kum", "\u06aa\u0648\u0645\u06aa" },
            { "kwk", "\u06aa\u0626\u0627\u06aa \u0648\u0644\u0627" },
            { "lad", "\u0644\u068a\u064a\u0646\u0648" },
            { "lag", "\u0644\u0627\u0646\u06af\u064a" },
            { "lez", "\u0644\u064a\u0632\u06af\u0647\u064a\u0646" },
            { "lil", "\u0644\u064a\u0644\u0648\u0626\u064a\u067d" },
            { "lkt", "\u0644\u06aa\u0648\u067d\u0627" },
            { "lou", "\u0644\u0648\u0626\u064a\u0632\u064a\u0627\u0646\u0627 \u06aa\u0631\u064a\u0626\u0648\u0644" },
            { "loz", "\u0644\u0648\u0632\u064a" },
            { "lrc", "\u0627\u062a\u0631 \u0644\u0648\u0631\u064a" },
            { "lsm", "\u0633\u0627\u0645\u064a\u0627" },
            { "lua", "\u0644\u0648\u0628\u0627-\u0644\u0648\u0644\u0648\u0627" },
            { "lun", "\u0644\u0646\u068a\u0627" },
            { "luo", "\u0644\u0648" },
            { "lus", "\u0645\u064a\u0632\u0648" },
            { "luy", "\u0644\u0648\u0647\u064a\u0627" },
            { "mad", "\u0645\u062f\u0648\u0631\u0627\u0626\u064a" },
            { "mag", "\u0645\u06af\u0627\u0647\u064a" },
            { "mai", "\u0645\u064a\u067f\u0644\u064a" },
            { "mak", "\u0645\u06aa\u0627\u0633\u0631" },
            { "mas", "\u0645\u0633\u0627\u0626\u064a" },
            { "mdf", "\u0645\u0648\u06aa\u0634\u0627" },
            { "men", "\u0645\u064a\u0646\u068a\u064a" },
            { "mer", "\u0645\u064a\u0631\u0648" },
            { "mfe", "\u0645\u0648\u0631\u06cc\u0633\u06cc\u06cc\u0646" },
            { "mgh", "\u0645\u062e\u0648\u0648\u0627 \u0645\u064a\u062a\u0648" },
            { "mgo", "\u0645\u064a\u062a\u0627" },
            { "mic", "\u0645\u064a\u06aa \u0645\u06aa" },
            { "min", "\u0645\u0646\u0627\u06aa\u0627\u0628\u0648\u0627" },
            { "mni", "\u0645\u0627\u0646\u064a \u067e\u0648\u0631\u064a" },
            { "moe", "\u0627\u0646\u0648 \u0622\u0626\u064a\u0645\u0646" },
            { "moh", "\u0645\u0648\u0647\u0627\u06aa" },
            { "mos", "\u0645\u0648\u0633\u064a" },
            { "mua", "\u0645\u0646 \u062f\u0627\u0646\u06af" },
            { "mul", "\u0647\u06aa \u06a9\u0627\u0646 \u0648\u068c\u064a\u06aa \u067b\u0648\u0644\u064a\u0648\u0646" },
            { "mus", "\u06aa\u0631\u064a\u06aa" },
            { "mwl", "\u0645\u0631\u0627\u0646\u068a\u064a\u0632" },
            { "myv", "\u0627\u064a\u0631\u064a\u0632\u064a\u0627" },
            { "mzn", "\u0645\u0632\u064a\u0646\u062f\u0631\u0627\u0646\u064a" },
            { "nap", "\u0646\u064a\u067e\u0648\u0644\u067d\u0646" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "nds", "\u0644\u0648 \u062c\u0631\u0645\u0646" },
            { "new", "\u0646\u064a\u0648\u0627\u0631\u064a" },
            { "nia", "\u0646\u064a\u0627\u0633" },
            { "niu", metaValue_NU },
            { "nmg", "\u06aa\u0648\u064a\u0633\u064a\u0648" },
            { "nnh", "\u0646\u063a\u064a\u0645\u0628\u0648\u0646" },
            { "nog", "\u0646\u0648\u06af\u0627\u0626\u064a" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0627\u062a\u0631 \u0633\u0648\u067f\u0648" },
            { "nus", "\u0646\u064a\u0648\u0631" },
            { "nyn", "\u0646\u0627\u064a\u0627\u0646\u06aa\u0648\u0644" },
            { "ojb", "\u0627\u062a\u0631 \u0627\u0644\u06be\u0646\u062f\u064a \u0627\u0648\u062c\u064a\u0628\u0648\u0627" },
            { "ojc", "\u0648\u0686\u0648\u0644\u064a \u0627\u0648\u062c\u064a\u0628\u0648\u064a" },
            { "ojs", "\u0627\u0648\u062c\u064a \u06aa\u0631\u064a" },
            { "ojw", "\u0645\u063a\u0631\u0628\u064a \u0627\u0648\u062c\u064a\u0628\u0648" },
            { "oka", "\u0627\u0648\u06aa\u0627\u0646\u0627\u06af\u0646" },
            { "pag", "\u067e\u0627\u0646\u06af\u0627 \u0633\u064a\u0646\u0627\u0646" },
            { "pam", "\u067e\u064a\u0645 \u067e\u064a\u0646\u06af\u0627" },
            { "pap", "\u067e\u0627\u067e\u064a \u0627\u0645\u064a\u0646\u067d\u0648" },
            { "pau", "\u067e\u0644\u0648\u0646" },
            { "pcm", "\u0646\u0627\u0626\u064a\u062c\u0631\u064a\u0646 \u067e\u062c\u0646" },
            { "pis", "\u067e\u0627\u0626\u062c\u0646" },
            { "pqm", "\u0645\u0627\u0644\u064a\u0633\u064a\u067d \u067e\u0627\u0633\u0645\u0627\u06aa\u0626\u0648\u068a\u064a" },
            { "prg", "\u067e\u0631\u0634\u0646" },
            { "quc", "\u06aa\u0686\u064a" },
            { "raj", "\u0631\u0627\u062c\u0633\u062a\u0627\u0646\u064a" },
            { "rap", "\u0631\u064a\u067e\u0646\u0648\u0626\u064a" },
            { "rar", "\u0631\u064a\u0631\u0648 \u067d\u064a\u0646\u06af\u0648" },
            { "rhg", "\u0631\u0648\u06be\u0646\u06af\u064a\u0627" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "rup", "\u0627\u0631\u0648\u0645\u064a\u0646\u064a\u0646" },
            { "rwk", "\u0631\u0648\u0627" },
            { "sad", "\u0633\u0646\u062f\u0627\u0648\u064a" },
            { "sah", "\u0633\u0627\u062e\u0627" },
            { "saq", "\u0633\u064a\u0645\u0628\u0648\u0631\u0648" },
            { "sat", "\u0633\u0646\u062a\u0627\u0644\u064a" },
            { "sba", "\u0646\u063a\u0645\u0628\u064a" },
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u0648" },
            { "scn", "\u0633\u0633\u0644\u064a" },
            { "sco", "\u0627\u0633\u06aa\u0627\u067d\u0633" },
            { "seh", "\u0633\u064a\u0646\u0627" },
            { "ses", "\u06aa\u064a\u0648\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u064a\u0646\u064a" },
            { "shi", "\u062a\u064a\u0686\u0644 \u0647\u0627\u062a\u064a" },
            { "shn", "\u0634\u0627\u0646" },
            { "slh", "\u068f\u0627\u06a9\u06bb\u064a \u0644\u0634\u0648\u067d\u0633\u064a\u068a" },
            { "sma", "\u068f\u06a9\u06bb \u0633\u0627\u0645\u064a" },
            { "smj", "\u0644\u0648\u0644\u064a \u0633\u0627\u0645\u064a" },
            { "smn", "\u0627\u0646\u0627\u0631\u064a \u0633\u0627\u0645\u064a" },
            { "sms", "\u0627\u0633\u06aa\u0627\u067d \u0633\u0627\u0645\u064a" },
            { "snk", "\u0633\u0648\u0646\u064a\u0646\u06aa\u064a" },
            { "srn", "\u0633\u0631\u0627\u0646\u0646 \u062a\u0627\u0646\u06af\u0648" },
            { "ssy", "\u0633\u0647\u0648" },
            { "str", "\u0627\u0633\u067d\u0631\u064a\u067d \u0633\u0644\u064a\u0634" },
            { "suk", "\u0633\u06aa\u0648\u0645\u0627" },
            { "swb", "\u06aa\u0645\u0648\u0631\u064a\u0646" },
            { "syr", metaValue_syr },
            { "tce", "\u068f\u0627\u06a9\u06bb\u064a \u067d\u0686\u0648\u0646" },
            { "tem", "\u062a\u0645\u0646\u064a" },
            { "teo", "\u062a\u064a\u0633\u0648" },
            { "tet", "\u062a\u064a\u062a\u0645" },
            { "tgx", "\u067d\u0626\u06af\u0650\u0634" },
            { "tht", "\u067d\u0647\u0644\u067d\u0646" },
            { "tig", "\u062a\u06af\u0631\u064a" },
            { "tlh", "\u06aa\u0644\u0648\u0646" },
            { "tli", "\u067d\u0650\u0644\u0646\u06af\u067d" },
            { "tok", "\u062a\u0648\u06aa\u064a \u067e\u0648\u0646\u0627" },
            { "tpi", "\u062a\u0627\u06aa \u067e\u0633\u0646" },
            { "trv", "\u062a\u0627\u0631\u0648\u06aa\u0648" },
            { "ttm", "\u0627\u062a\u0631\u064a\u0646 \u067d\u0686\u0648\u0646" },
            { "tum", "\u062a\u0645\u0628\u0648\u06aa\u0627" },
            { "tvl", metaValue_TV },
            { "twq", "\u062a\u0633\u0627\u0648\u06aa\u064a" },
            { "tyv", "\u062a\u0648\u0648\u064a\u0646\u064a\u0627\u0626\u064a" },
            { "tzm", "\u0648\u0686 \u0627\u067d\u0644\u0633 \u062a\u0645\u0627\u0632\u0627\u0626\u064a\u067d" },
            { "udm", "\u0627\u062f\u0645\u0631\u062a" },
            { "umb", "\u0627\u0648\u0645\u0628\u0646\u068a\u0648" },
            { "und", "\u0627\u06bb\u0684\u0627\u062a\u0644 \u067b\u0648\u0644\u064a" },
            { "vai", "\u064a\u0627" },
            { "vun", "\u0648\u0646\u062c\u0648" },
            { "wae", "\u0648\u0627\u0644\u0633\u0631" },
            { "wal", "\u0648\u0648\u0644\u0627\u064a\u067d\u0627" },
            { "war", "\u0648\u0627\u0631\u064a" },
            { "wuu", "\u0648\u0648 \u0686\u064a\u0646\u064a" },
            { "xal", "\u06aa\u064a\u0644\u0645\u06aa" },
            { "xog", "\u0633\u0648\u06af\u0627" },
            { "yav", "\u064a\u0627\u0646\u06af \u0628\u064a\u0646" },
            { "ybb", "\u064a\u064a\u0645\u0628\u0627" },
            { "yrl", "\u0646\u06be\u064a\u0646 \u06af\u0627\u067d\u0648" },
            { "yue", "\u06aa\u064a\u0646\u067d\u0648\u0646\u064a\u0632" },
            { "zgh", "\u0645\u0639\u064a\u0627\u0631\u064a \u0645\u0631\u0627\u06aa\u0634\u064a \u062a\u0627\u0645\u0627\u0632\u0627\u0626\u064a\u067d" },
            { "zun", "\u0632\u0648\u0646\u064a" },
            { "zxx", "\u06aa\u0648\u0626\u064a \u067b\u0648\u0644\u064a \u062c\u0648 \u0645\u0648\u0627\u062f \u06aa\u0648\u0646\u0647\u064a" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "Adlm", "\u0627\u064a\u068a\u0644\u0627\u0645" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0646\u0633\u062a\u0639\u0644\u06cc\u0642" },
            { "Armn", "\u0639\u0631\u0645\u0627\u0646\u064a" },
            { "Beng", metaValue_bn },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "Brai", "\u0628\u0631\u064a\u0644\u064a" },
            { "Cakm", "\u0686\u06aa\u0645\u0627" },
            { "Cans", "\u064a\u0648\u0646\u064a\u0641\u0627\u0626\u064a\u068a \u06aa\u064a\u0646\u064a\u068a\u064a\u0626\u0646 \u0627\u0628\u0627\u0631\u062c\u064a\u0646\u064a \u0633\u0644\u064a\u0628\u06aa\u0633" },
            { "Cher", "\u0686\u064a\u0631\u0648\u06aa\u064a" },
            { "Cyrl", "\u0633\u064a\u0631\u064a\u0644\u064a" },
            { "Deva", "\u062f\u064a\u0648\u0646\u0627\u06af\u0631\u064a" },
            { "Ethi", "\u0627\u064a\u067f\u0648\u067e\u064a\u0627\u0626\u064a" },
            { "Geor", "\u062c\u064a\u0648\u0631\u062c\u064a\u0627\u0626\u064a" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u06af\u0631\u0645\u06a9\u064a" },
            { "Hanb", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648 \u0633\u0627\u0646 \u0647\u064a\u0646" },
            { "Hang", "\u0647\u0646\u06af\u0648\u0644" },
            { "Hani", "\u0647\u064a\u0646" },
            { "Hans", "\u0633\u0627\u062f\u064a" },
            { "Hant", "\u0631\u0648\u0627\u064a\u062a\u064a" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0647\u0631\u0627\u06af\u0646\u0627" },
            { "Hrkt", "\u062c\u0627\u067e\u0627\u0646\u064a \u0644\u06a9\u062a" },
            { "Ital", "\u0642\u062f\u064a\u0645 \u0627\u0637\u0627\u0644\u0648\u064a" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "Java", "\u062c\u0627\u0648\u0627\u0646\u064a\u0632" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u06aa\u067d\u0627\u06aa\u0627\u0646\u0627" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "\u0645\u0644\u0627\u064a\u0627\u0644\u0645" },
            { "Mong", metaValue_mn },
            { "Mtei", "\u0645\u064a\u0626\u064a\u067d\u064a \u0645\u0627\u0626\u064a\u06aa" },
            { "Mult", "\u0645\u0644\u062a\u0627\u0646\u064a" },
            { "Mymr", "\u0645\u064a\u0627\u0646\u0645\u0631" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "\u0627\u0648\u0644 \u0686\u06aa\u064a" },
            { "Orya", metaValue_or },
            { "Rohg", "\u06be\u0646\u064a\u0641\u064a" },
            { "Sarb", "\u0642\u062f\u064a\u0645 \u068f\u0627\u06a9\u06bb\u064a \u0639\u0631\u0628\u064a" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "\u067d\u0641\u064a\u0646\u0627\u06af" },
            { "Thaa", "\u067f\u0627\u0646\u0627" },
            { "Thai", metaValue_th },
            { "Tibt", "\u062a\u0628\u064a\u062a\u0646" },
            { "Vaii", "\u0648\u0627\u0626\u064a" },
            { "Xpeo", "\u0642\u062f\u064a\u0645 \u0641\u0627\u0631\u0633\u064a" },
            { "Yiii", "\u064a\u064a" },
            { "Zmth", "\u0631\u064a\u0627\u0636\u064a \u062c\u0648\u0646 \u0646\u0634\u0627\u0646\u064a\u0648\u0646" },
            { "Zsye", "\u0627\u064a\u0645\u0648\u062c\u064a" },
            { "Zsym", "\u0646\u0634\u0627\u0646\u064a\u0648\u0646" },
            { "Zxxx", "\u0627\u06bb \u0644\u06a9\u064a\u0644" },
            { "Zyyy", "\u06aa\u0627\u0645\u0646" },
            { "Zzzz", "\u0627\u06bb\u0684\u0627\u062a\u0644 \u0644\u06a9\u062a" },
            { "de_AT", "\u0622\u0633\u067d\u0631\u064a\u0627\u0626\u064a \u062c\u0631\u0645\u0646" },
            { "de_CH", "\u0633\u0648\u0626\u0633 \u0647\u0627\u0626\u064a \u062c\u0631\u0645\u0646" },
            { "en_AU", "\u0622\u0633\u067d\u0631\u064a\u0644\u064a\u0627\u0626\u064a \u0627\u0646\u06af\u0631\u064a\u0632\u064a" },
            { "en_CA", "\u06aa\u064a\u0646\u064a\u068a\u064a\u0627\u0626\u064a \u0627\u0646\u06af\u0631\u064a\u0632\u064a" },
            { "en_GB", "\u0628\u0631\u0637\u0627\u0646\u0648\u064a \u0627\u0646\u06af\u0631\u064a\u0632\u064a" },
            { "en_US", "\u0622\u0645\u0631\u064a\u06aa\u064a \u0627\u0646\u06af\u0631\u064a\u0632\u064a" },
            { "es_ES", "\u064a\u0648\u0631\u067e\u064a \u0627\u0633\u067e\u064a\u0646\u064a" },
            { "es_MX", "\u0645\u064a\u06aa\u0633\u064a\u06aa\u064a\u0646 \u0627\u0633\u067e\u064a\u0646\u064a" },
            { "fa_AF", "\u062f\u0631\u064a" },
            { "fr_CA", "\u06aa\u064a\u0646\u064a\u068a\u064a\u0627\u0626\u064a \u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a" },
            { "fr_CH", "\u0633\u0648\u0626\u0633 \u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a" },
            { "nl_BE", "\u0641\u0644\u064a\u0645\u0634" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u064a\u0644\u064a \u067e\u0631\u062a\u06af\u0627\u0644\u064a" },
            { "pt_PT", "\u064a\u0648\u0631\u067e\u064a \u067e\u0631\u062a\u06af\u0627\u0644\u064a" },
            { "ro_MD", "\u0645\u0627\u0644\u062f\u064a\u0648\u064a" },
            { "sw_CD", "\u06aa\u0648\u0646\u06af\u0648 \u0633\u0648\u0627\u062d\u064a\u0644\u064a" },
            { "ar_001", "\u062c\u062f\u064a\u062f \u0645\u0639\u064a\u0627\u0631\u064a \u0639\u0631\u0628\u064a" },
            { "es_419", "\u0644\u0627\u0637\u064a\u0646\u064a \u0622\u0645\u0631\u064a\u06aa\u064a \u0627\u0633\u067e\u064a\u0646\u0634" },
            { "key.ca", "\u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "key.cf", "\u0633\u06aa\u064a \u062c\u0648 \u0641\u0627\u0631\u0645\u064a\u067d" },
            { "key.co", "\u062a\u0631\u062a\u064a\u0628 \u0687\u0627\u0646\u067d\u064a" },
            { "key.cu", "\u0633\u06aa\u0648" },
            { "key.hc", "\u06aa\u0644\u0627\u06aa \u0633\u0627\u0626\u064a\u06aa\u0644" },
            { "key.lb", "\u0644\u0627\u0626\u0646 \u067d\u0648\u0699\u06bb \u0627\u0646\u062f\u0627\u0632" },
            { "key.ms", "\u0645\u0627\u067e\u06bb \u062c\u0648 \u0646\u0638\u0627\u0645" },
            { "key.nu", "\u0627\u0646\u06af" },
            { "%%POSIX", "\u06aa\u0645\u067e\u064a\u0648\u067d\u0631" },
            { "zh_Hant", "\u0631\u0648\u0627\u064a\u062a\u064a \u0686\u064a\u0646\u064a" },
            { "type.ca.roc", "\u0645\u0646\u06af\u0648\u0648 \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.hc.h11", "12 \u06aa\u0644\u0627\u06aa \u062c\u0648 \u0633\u0633\u067d\u0645 (0\u201311)" },
            { "type.hc.h12", "12 \u06aa\u0644\u0627\u06aa \u062c\u0648 \u0633\u0633\u067d\u0645 (1\u201312)" },
            { "type.hc.h23", "24 \u06aa\u0644\u0627\u06aa \u062c\u0648 \u0633\u0633\u067d\u0645 (0\u201323)" },
            { "type.hc.h24", "24 \u06aa\u0644\u0627\u06aa \u062c\u0648 \u0633\u0633\u067d\u0645 (1\u201324)" },
            { "type.nu.arab", "\u0639\u0631\u0628\u064a-\u0647\u0646\u062f\u064a \u0639\u062f\u062f" },
            { "type.nu.armn", "\u0627\u0631\u0645\u064a\u0646\u064a\u0627\u0626\u064a \u0627\u0646\u06af" },
            { "type.nu.beng", "\u0628\u0646\u06af\u0644\u0627 \u0639\u062f\u062f" },
            { "type.nu.cakm", "\u0686\u06aa\u0645\u0627 \u0627\u0646\u06af \u0627\u06a9\u0631" },
            { "type.nu.deva", "\u062f\u064a\u0648\u0646\u0627\u06af\u0631\u064a \u0639\u062f\u062f" },
            { "type.nu.ethi", "\u0627\u064a\u067f\u0648\u067e\u064a\u0627\u0626\u064a \u0627\u0646\u06af" },
            { "type.nu.geor", "\u062c\u064a\u0627\u0631\u062c\u064a\u0627\u0626\u064a \u0627\u0646\u06af" },
            { "type.nu.grek", "\u064a\u0648\u0646\u0627\u0646\u064a \u0627\u0646\u06af" },
            { "type.nu.gujr", "\u06af\u062c\u0631\u0627\u062a\u064a \u0639\u062f\u062f" },
            { "type.nu.guru", "\u06af\u0631\u0645\u06a9\u064a \u0639\u062f\u062f" },
            { "type.nu.hans", "\u0622\u0633\u0627\u0646 \u0686\u064a\u0646\u064a \u0627\u0646\u06af" },
            { "type.nu.hant", "\u0631\u0648\u0627\u064a\u062a\u064a \u0686\u064a\u0646\u064a \u0627\u0646\u06af" },
            { "type.nu.hebr", "\u0639\u0628\u0631\u0627\u0646\u064a \u0627\u0646\u06af" },
            { "type.nu.java", "\u062c\u0627\u0648\u0627\u0646\u064a \u0627\u0646\u06af \u0627\u06a9\u0631" },
            { "type.nu.jpan", "\u062c\u0627\u067e\u0627\u0646\u064a \u0627\u0646\u06af" },
            { "type.nu.khmr", "\u062e\u0645\u0631 \u0639\u062f\u062f" },
            { "type.nu.knda", "\u06aa\u0646\u0627\u068a\u0627 \u0639\u062f\u062f" },
            { "type.nu.laoo", "\u0644\u0627\u0626\u0648 \u0639\u062f\u062f" },
            { "type.nu.latn", "\u0645\u063a\u0631\u0628\u064a \u0639\u062f\u062f" },
            { "type.nu.mlym", "\u0645\u0644\u064a\u0627\u0644\u0645 \u0639\u062f\u062f" },
            { "type.nu.mtei", "\u0645\u064a\u067d\u064a \u0645\u0626\u064a\u06aa \u0627\u0646\u06af \u0627\u06a9\u0631" },
            { "type.nu.mymr", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 \u0639\u062f\u062f" },
            { "type.nu.olck", "\u0627\u0648\u0644 \u0686\u06aa\u064a \u0627\u0646\u06af \u0627\u06a9\u0631" },
            { "type.nu.orya", "\u0627\u0648\u068a\u064a\u0627 \u0639\u062f\u062f" },
            { "type.nu.taml", "\u0631\u0648\u0627\u064a\u062a\u064a \u062a\u0627\u0645\u0644 \u0627\u0646\u06af" },
            { "type.nu.telu", "\u062a\u064a\u0644\u06af\u0648 \u0639\u062f\u062f" },
            { "type.nu.thai", "\u067f\u0627\u0626\u064a \u0639\u062f\u062f" },
            { "type.nu.tibt", "\u062a\u0628\u062a\u064a \u0639\u062f\u062f" },
            { "type.nu.vaii", "\u0648\u0627\u0626\u064a \u0627\u0646\u06af \u0627\u06a9\u0631" },
            { "type.ca.dangi", "\u062f\u0627\u0646\u06af\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.co.ducet", "\u068a\u0641\u0627\u0644\u067d \u064a\u0648\u0646\u064a \u06aa\u0648\u068a \u062a\u0631\u062a\u064a\u0628 \u0687\u0627\u0646\u067d\u064a" },
            { "type.lb.loose", "\u0644\u0648\u0632 \u0644\u0627\u0626\u0646 \u067d\u0648\u0699 \u0627\u0646\u062f\u0627\u0632" },
            { "type.nu.roman", "\u0631\u0648\u0645\u064a \u0627\u0646\u06af" },
            { "type.ca.coptic", "\u06aa\u0627\u067e\u067d\u06aa \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.hebrew", "\u0639\u0628\u0631\u0627\u0646\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.indian", "\u0647\u0646\u062f\u0648\u0633\u062a\u0627\u0646\u064a \u0642\u0648\u0645\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.co.search", "\u0639\u0627\u0645 \u0645\u0642\u0635\u062f \u062c\u064a \u06b3\u0648\u0644\u0627" },
            { "type.lb.normal", "\u0639\u0627\u0645 \u0644\u0627\u0626\u0646 \u067d\u0648\u0699 \u0627\u0646\u062f\u0627\u0632" },
            { "type.lb.strict", "\u0633\u062e\u062a \u0644\u0627\u0626\u0646 \u067d\u0648\u0699 \u0627\u0646\u062f\u0627\u0632" },
            { "type.ms.metric", "\u0645\u064a\u067d\u0631\u06aa \u0646\u0638\u0627\u0645" },
            { "type.ca.chinese", "\u0686\u064a\u0646\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.islamic", "\u0627\u0633\u0644\u0627\u0645\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.iso8601", "ISO-8601 \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.persian", "\u0641\u0627\u0631\u0633\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.cf.account", "\u0627\u06aa\u0627\u0626\u0648\u0646\u067d\u0646\u06af \u0633\u06aa\u0648 \u0641\u0627\u0631\u0645\u064a\u067d" },
            { "type.nu.arabext", "\u0648\u068c\u0627\u064a\u0644 \u0639\u0631\u0628\u064a-\u0647\u0646\u062f\u064a \u0639\u062f\u062f" },
            { "type.nu.armnlow", "\u0627\u0631\u0645\u064a\u0646\u064a\u0627\u0626\u064a \u0646\u0646\u068d\u0627 \u0627\u0646\u06af" },
            { "type.nu.greklow", "\u064a\u0648\u0646\u0627\u0646\u064a \u0646\u0646\u068d\u0627 \u0627\u0646\u06af" },
            { "type.nu.hanidec", "\u0686\u064a\u0646\u064a \u0627\u0639\u0634\u0627\u0631\u064a \u0627\u0646\u06af" },
            { "type.nu.hansfin", "\u0622\u0633\u0627\u0646 \u0686\u064a\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0646\u06af" },
            { "type.nu.hantfin", "\u0631\u0648\u0627\u064a\u062a\u064a \u0686\u064a\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0646\u06af" },
            { "type.nu.jpanfin", "\u062c\u0627\u067e\u0627\u0646\u064a \u0645\u0627\u0644\u064a \u0627\u0646\u06af" },
            { "type.nu.tamldec", "\u062a\u0627\u0645\u0644 \u0639\u062f\u062f" },
            { "type.ca.buddhist", "\u067b\u068c \u068c\u0631\u0645 \u062c\u0648 \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.ethiopic", "\u0627\u064a\u067f\u0648\u067e\u064a\u0627\u0626\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0627\u0646\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.cf.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u0633\u06aa\u0648 \u0641\u0627\u0631\u0645\u064a\u067d" },
            { "type.co.standard", "\u0645\u0639\u064a\u0627\u0631\u064a \u062a\u0631\u062a\u064a\u0628 \u0687\u0627\u0646\u067d\u064a" },
            { "type.ms.uksystem", "\u0627\u0645\u067e\u064a\u0631\u064a\u0644 \u0645\u0627\u067e\u06bb \u062c\u0648 \u0646\u0638\u0627\u0645" },
            { "type.ms.ussystem", "\u0622\u0645\u0631\u064a\u06aa\u0627 \u062c\u0648 \u0645\u0627\u067e\u06bb \u062c\u0648 \u0646\u0638\u0627\u0645" },
            { "type.nu.fullwide", "\u067e\u0648\u0631\u064a-\u0648\u064a\u06aa\u0631 \u0627\u0646\u06af\u0646" },
            { "type.nu.romanlow", "\u0631\u0648\u0645\u064a \u0646\u0646\u068d\u0627 \u0627\u0646\u06af" },
            { "type.ca.gregorian", "\u062c\u0627\u0631\u062c\u064a\u0627\u0626\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
            { "type.ca.islamic-tbla", "\u0627\u0633\u0644\u0627\u0645\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631 (\u067d\u064a\u0628\u0644\u0631\u060c \u0641\u0644\u06aa\u064a\u0627\u062a\u064a \u062f\u0648\u0631)" },
            { "type.ca.islamic-civil", "\u0627\u0633\u0644\u0627\u0645\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631 (\u067d\u064a\u0628\u0644\u0631\u060c \u0645\u062f\u0646\u064a \u062f\u0648\u0631)" },
            { "type.ca.islamic-umalqura", "\u0627\u0633\u0644\u0627\u0645\u064a \u06aa\u0626\u0644\u064a\u0646\u068a\u0631 (\u0627\u064f\u0645 \u0627\u0644\u0642\u0631\u0627)" },
            { "type.ca.ethiopic-amete-alem", "\u0627\u064a\u067f\u0648\u067e\u06aa \u0627\u0645\u064a\u067d\u064a \u0639\u0644\u064a\u0645 \u06aa\u0626\u0644\u064a\u0646\u068a\u0631" },
        };
        return data;
    }
}
