/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lrc extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "\u0623\u0631\u0645\u0623\u0646\u06cc";
        final String metaValue_bn = "\u0628\u0623\u0646\u06af\u0627\u0644\u06cc";
        final String metaValue_ka = "\u06af\u0648\u0631\u062c\u06cc";
        final String metaValue_el = "\u06cc\u0648\u0659\u0646\u0627\u0646\u06cc";
        final String metaValue_gu = "\u06af\u0648\u062c\u0623\u0631\u0627\u062a\u06cc";
        final String metaValue_he = "\u0639\u0626\u0628\u0631\u06cc";
        final String metaValue_ja = "\u062c\u0627\u067e\u0648\u0659\u0646\u06cc";
        final String metaValue_km = "\u062e\u0626\u0645\u0626\u0631";
        final String metaValue_ko = "\u06a9\u0648\u0631\u0626 \u06cc\u06cc";
        final String metaValue_la = "\u0644\u0627\u062a\u06cc\u0646";
        final String metaValue_ml = "\u0645\u0627\u0644\u0627\u06cc\u0627\u0645";
        final String metaValue_mn = "\u0645\u0648\u063a\u0648\u0644\u06cc";
        final String metaValue_or = "\u0626\u0648\u0631\u06cc\u0627";
        final String metaValue_ta = "\u062a\u0627\u0645\u06cc\u0644";
        final String metaValue_te = "\u062a\u0626\u0644\u0626\u06af\u0648";
        final String metaValue_th = "\u062a\u0627\u06cc\u0644\u0623\u0646\u062f\u06cc";
        final String metaValue_bo = "\u062a\u0623\u0628\u0623\u062a\u06cc";
        final Object[][] data = new Object[][] {
            { "001", "\u062f\u0648\u0646\u06cc\u0627" },
            { "002", "\u0626\u0641\u0631\u06cc\u0642\u0627" },
            { "003", "\u0626\u0645\u0631\u06cc\u06a9\u0627 \u0634\u0648\u0645\u0627\u0644\u06cc" },
            { "005", "\u0626\u0645\u0631\u06cc\u06a9\u0627 \u06be\u0627\u0631\u06af\u06d5" },
            { "009", "\u06be\u0648\u0645 \u067e\u0626\u06a4\u0623\u0646\u062f \u062c\u0623\u06be\u0648\u0659\u0646 \u0622\u06a4" },
            { "013", "\u0645\u06cc\u0646\u062c\u0627 \u0626\u0645\u0631\u06cc\u06a9\u0627" },
            { "019", "\u0626\u0645\u0631\u06cc\u06a9\u0627" },
            { "021", "\u0626\u0645\u0631\u06cc\u06a9\u0627 \u06a4\u0627\u0631\u0648" },
            { "029", "\u06a9\u0627\u0631\u0627\u0626\u06cc\u0628" },
            { "142", "\u0622\u0633\u06cc\u0627" },
            { "150", "\u0626\u0648\u0631\u0648\u0659\u067e\u0627" },
            { "419", "\u0626\u0645\u0631\u06cc\u06a9\u0627 \u0644\u0627\u062a\u06cc\u0646" },
            { "BR", "\u0628\u0626\u0631\u0626\u0632\u06cc\u0644" },
            { "CN", "\u0686\u06cc\u0646" },
            { "DE", "\u0622\u0644\u0645\u0627\u0646" },
            { "FR", "\u0641\u0623\u0631\u0627\u0646\u0633\u06d5" },
            { "GB", "\u0628\u06cc\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627 \u06af\u0623\u067e" },
            { "IN", "\u06be\u0626\u0646" },
            { "IT", "\u0626\u06cc\u062a\u0627\u0644\u06cc\u0627" },
            { "JP", "\u062c\u0627\u067e\u0648\u0659\u0646" },
            { "RU", "\u0631\u0648\u0659\u0633\u06cc\u06d5" },
            { "US", "\u06a4\u0648\u0644\u0627\u062a\u06cc\u0627 \u06cc\u0623\u06a9\u0627\u06af\u0626\u0631\u062a\u06d5" },
            { "ZZ", "\u0631\u0627\u0633\u0627\u06af\u06d5 \u0646\u0627\u062f\u06cc\u0627\u0631" },
            { "ab", "\u0622\u0630\u0623\u0631\u0628\u0627\u06cc\u0626\u062c\u0627\u0646\u06cc" },
            { "af", "\u0622\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633" },
            { "ak", "\u0622\u06a9\u0627\u0646" },
            { "am", "\u0623\u0645\u06be\u0623\u0631\u06cc" },
            { "ar", "\u0623\u0631\u0623\u06a4\u06cc" },
            { "as", "\u0622\u0633\u0627\u0645\u06cc" },
            { "az", "\u0622\u0630\u0623\u0631\u0628\u0627\u06cc\u0626\u062c\u0627\u0646\u06cc \u06be\u0627\u0631\u06af\u06d5" },
            { "ba", "\u0628\u0627\u0634\u06a9\u06cc\u0631\u06cc" },
            { "be", "\u0628\u0626\u0644\u0627\u0631\u0648\u0659\u0633\u06cc" },
            { "bg", "\u0628\u0648\u0644\u063a\u0627\u0631\u06cc" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u0628\u0626\u0631\u0626\u062a\u0648\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u06cc\u0627\u06cc\u06cc" },
            { "ca", "\u06a9\u0627\u062a\u0627\u0644\u0627\u0646" },
            { "ce", "\u0686\u0626\u0686\u0626\u0646\u06cc" },
            { "co", "\u06a9\u0648\u0631\u06cc\u0633\u06a9\u0627\u0646" },
            { "cv", "\u0686\u0648\u0627\u0634\u06cc" },
            { "cy", "\u06a4\u0626\u0644\u0632\u06cc" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9\u06cc" },
            { "de", "\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "dz", "\u0632\u0648\u0659\u0646\u06af\u062e\u0627" },
            { "ee", "\u0626\u06a4\u0626" },
            { "el", metaValue_el },
            { "en", "\u0626\u06cc\u0646\u06af\u06cc\u0644\u06cc\u0633\u06cc" },
            { "eo", "\u0626\u0633\u067e\u0626\u0631\u0627\u0646\u062a\u0648" },
            { "es", "\u0626\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "et", "\u0626\u0633\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "fi", "\u0641\u0623\u0646\u0644\u0627\u0646\u062f\u06cc" },
            { "fj", "\u0641\u06cc\u062c\u06cc" },
            { "fo", "\u0641\u0627\u0631\u0648\u0659\u0633\u06cc" },
            { "fr", "\u0641\u0622\u0631\u0627\u0646\u0633\u0626 \u0626\u06cc" },
            { "fy", "\u0641\u0626\u0631\u06cc\u0633\u06cc \u0623\u0641\u062a\u0648\u0646\u0626\u0634\u06cc\u0646" },
            { "ga", "\u0626\u06cc\u0631\u0644\u0623\u0646\u062f\u06cc" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0633\u06cc" },
            { "gn", "\u06af\u0648\u0659\u0622\u0631\u0627\u0646\u06cc" },
            { "gu", metaValue_gu },
            { "gv", "\u0645\u0627\u0646\u06a9\u0633" },
            { "ha", "\u06be\u0627\u0626\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u06be\u0626\u0646\u06cc" },
            { "hr", "\u06a9\u0648\u0631\u0648\u06a4\u0627\u062a\u06cc" },
            { "ht", "\u06be\u0627\u06cc\u06cc\u062a\u06cc" },
            { "hu", "\u0645\u0623\u062c\u0627\u0631\u06cc" },
            { "hy", metaValue_hy },
            { "id", "\u0623\u0646\u062f\u0648\u0646\u0626\u0632\u06cc\u0627\u06cc\u06cc" },
            { "ig", "\u0626\u06cc\u06af\u0628\u0648" },
            { "ii", "\u0633\u06cc \u0686\u0648\u0627\u0646 \u06cc\u06cc" },
            { "is", "\u0626\u06cc\u0633\u0644\u0623\u0646\u062f\u06cc" },
            { "it", "\u0626\u06cc\u062a\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "iu", "\u0626\u06cc\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u0659\u062a" },
            { "ja", metaValue_ja },
            { "jv", "\u062c\u0627\u06a4\u0626 \u06cc\u06cc" },
            { "ka", metaValue_ka },
            { "ki", "\u06a9\u06cc\u06a9\u06cc\u0648\u0659" },
            { "kk", "\u0642\u0623\u0632\u0627\u0642" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0644\u06cc\u0633\u0648\u0659\u062a" },
            { "km", metaValue_km },
            { "kn", "\u06a9\u0627\u0646\u0627\u062f" },
            { "ko", metaValue_ko },
            { "ks", "\u06a9\u0623\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0648\u0631\u062f\u06cc \u06a9\u0648\u0631\u0645\u0627\u0646\u062c\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u06cc\u0634" },
            { "ky", "\u0642\u0626\u0631\u0642\u06cc\u0632\u06cc" },
            { "la", metaValue_la },
            { "lb", "\u0644\u0648\u0659\u06a9\u0632\u0627\u0645\u0628\u0648\u0659\u0631\u06af\u06cc" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "ln", "\u0644\u06cc\u0646\u06af\u0627\u0644\u0627" },
            { "lo", "\u0644\u0627\u0648" },
            { "lt", "\u0644\u06cc\u062a\u0648\u06a4\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "lu", "\u0644\u0648\u0659\u0628\u0627 \u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "lv", "\u0644\u0627\u062a\u0648\u06a4\u06cc\u0627\u06cc\u06cc" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0634\u06cc" },
            { "mi", "\u0645\u0627\u0626\u0648\u0631\u06cc" },
            { "mk", "\u0645\u0623\u0642\u062f\u0648\u0659\u0646\u06cc" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0645\u0623\u0631\u0627\u062a\u06cc" },
            { "ms", "\u0645\u0627\u0644\u0627\u06cc\u06cc" },
            { "mt", "\u0645\u0627\u0644\u062a\u06cc" },
            { "my", "\u0628\u0626\u0631\u0645\u0626 \u06cc\u06cc" },
            { "nb", "\u0646\u0648\u0631\u06a4\u0626\u062c\u06cc \u0628\u0648\u0659\u06a9\u0645\u0627\u0644" },
            { "nd", "\u0646\u0626\u062f\u0626\u0628\u0626\u0644\u0626 \u0634\u0648\u0645\u0627\u0644\u06cc" },
            { "ne", "\u0646\u0626\u067e\u0627\u0644\u06cc" },
            { "nl", "\u06be\u0648\u0644\u0623\u0646\u062f\u06cc" },
            { "nn", "\u0646\u0648\u0631\u06a4\u0626\u062c\u06cc \u0646\u06cc\u0646\u0648\u0631\u0633\u06a9" },
            { "om", "\u0626\u0648\u0631\u0648\u0645\u0648\u0659" },
            { "or", metaValue_or },
            { "pa", "\u067e\u0623\u0646\u062c\u0627\u0628\u06cc" },
            { "pl", "\u0644\u0623\u06be\u0626\u0633\u062a\u0627\u0646\u06cc" },
            { "ps", "\u067e\u0623\u0634\u062a\u0648\u0659" },
            { "pt", "\u067e\u0648\u0631\u062a\u0626\u063a\u0627\u0644\u06cc" },
            { "qu", "\u06a9\u0648\u0686\u0648\u0659\u0627" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0627\u0646\u062f\u06cc" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "ru", "\u0631\u0648\u0659\u0633\u06cc" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0622\u0646\u062f\u0627" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0626\u0631\u06cc\u062a" },
            { "sd", "\u0633\u0626\u0646\u062f\u06cc" },
            { "se", "\u0633\u0627\u0645\u06cc \u0634\u0648\u0645\u0627\u0644\u06cc" },
            { "sg", "\u0633\u0627\u0646\u06af\u0648" },
            { "si", "\u0633\u06cc\u0646\u06be\u0627\u0644\u0627" },
            { "sk", "\u0626\u0633\u0644\u0648\u06a4\u0627\u06a9\u06cc" },
            { "sl", "\u0626\u0633\u0644\u0648\u06a4\u0626\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0659\u0645\u0627\u0644\u06cc" },
            { "sq", "\u0622\u0644\u0628\u0627\u0646\u06cc" },
            { "sr", "\u0633\u0626\u0631\u0628\u06cc" },
            { "su", "\u0633\u0648\u0659\u062f\u0627\u0646\u06cc" },
            { "sv", "\u0633\u0648\u0659\u0626\u062f\u06cc" },
            { "sw", "\u0633\u0623\u06a4\u0627\u062d\u06cc\u0644\u06cc" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "th", metaValue_th },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627" },
            { "tk", "\u062a\u0648\u0631\u06a9\u0623\u0645\u0623\u0646\u06cc" },
            { "to", "\u062a\u0648\u0659\u0646\u06af\u0627\u0646" },
            { "tr", "\u062a\u0648\u0631\u06a9\u06cc" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "ug", "\u0626\u0648\u06cc\u063a\u0648\u0659\u0631" },
            { "uk", "\u0626\u0648\u06a9\u0631\u0627\u06cc\u0646\u06cc" },
            { "ur", "\u0626\u0648\u0631\u062f\u0648\u0659" },
            { "uz", "\u0626\u0648\u0632\u0628\u0623\u06a9\u06cc" },
            { "vi", "\u06a4\u06cc\u06cc\u0626\u062a\u0646\u0627\u0645\u06cc" },
            { "wo", "\u06a4\u0648\u0644\u0648\u0641" },
            { "xh", "\u062e\u0648\u0659\u0633\u0627" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "agq", "\u0622\u0642\u0626\u0645" },
            { "arn", "\u0645\u0627\u067e\u0648\u0659\u0686\u0626" },
            { "asa", "\u0622\u0633\u0648\u0659" },
            { "bem", "\u0628\u06cc\u0645\u0627" },
            { "bez", "\u0628\u0626\u0646\u0627" },
            { "bgn", "\u0628\u0623\u0644\u0648\u0659\u0686\u06cc \u0623\u0642\u062a\u0648\u0659\u0646\u0626\u0634\u06cc\u0646" },
            { "brx", "\u0628\u0648\u062f\u0648" },
            { "cgg", "\u0686\u06cc\u06af\u0627" },
            { "chr", "\u0686\u0648\u0631\u0648\u0659\u06a9\u06cc" },
            { "ckb", "\u06a9\u0648\u0631\u062f\u06cc \u0633\u0648\u0659\u0631\u0627\u0646\u06cc" },
            { "dav", "\u062a\u0627\u06cc\u062a\u0627" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627" },
            { "dsb", "\u0633\u0648\u0631\u0628\u06cc \u06be\u0627\u0631\u06cc" },
            { "dua", "\u062f\u0648\u0659\u0627\u0644\u0627" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0659\u0646\u06cc\u06cc" },
            { "ebu", "\u0626\u0645\u0628\u0648" },
            { "fil", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646\u06cc" },
            { "gag", "\u06af\u0627\u06af\u0627\u0626\u0648\u0632" },
            { "gsw", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0633\u0648\u0659\u0626\u06cc\u0633\u06cc" },
            { "guz", "\u06af\u0648\u0659\u0633\u06cc" },
            { "haw", "\u06be\u0627\u06a4\u0627\u06cc\u06cc" },
            { "hsb", "\u0633\u0648\u0631\u0628\u06cc \u06a4\u0627\u0631\u0648" },
            { "jgo", "\u0646\u0626\u06af\u0648\u0659\u0645\u0628\u0627" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u0626" },
            { "kab", "\u06a9\u0627\u0628\u06cc\u0644\u0626" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "kde", "\u0645\u0627\u06a9\u0648\u0659\u0646\u062f\u0626" },
            { "kea", "\u06a9\u0627\u0628\u0627\u0631\u062f\u06cc\u0646\u0648" },
            { "khq", "\u06a9\u06cc \u06cc\u0648\u0631\u0627 \u0686\u06cc\u0646\u06cc" },
            { "kln", "\u06a9\u0627\u0644\u0626\u062c\u06cc\u0646" },
            { "koi", "\u06a9\u0648\u0645\u06cc \u067e\u0626\u0631\u0645\u06cc\u0627\u06a9" },
            { "kok", "\u06a9\u0648\u0659\u0646\u06a9\u0627\u0646\u06cc" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0628\u0627\u0641\u06cc\u0627" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "lkt", "\u0644\u0627\u06a9\u0648\u0659\u062a\u0627" },
            { "lrc", "\u0644\u06ca\u0631\u06cc \u0634\u0648\u0645\u0627\u0644\u06cc" },
            { "luo", "\u0644\u0648\u0659" },
            { "luy", "\u0644\u0648\u0659\u0626\u06cc\u0627" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc\u06cc" },
            { "mer", "\u0645\u0626\u0631\u0648" },
            { "mfe", "\u0645\u0648\u0659\u0631\u06cc\u0633\u06cc" },
            { "mgh", "\u0645\u0627\u062e\u0648\u06a4\u0627 \u0645\u06cc\u062a\u0648" },
            { "mgo", "\u0645\u0626\u062a\u0627\u065b" },
            { "moh", "\u0645\u0648\u0659\u06be\u0627\u06a4\u06a9" },
            { "mua", "\u0645\u0648\u0659\u0646\u062f\u0627\u0646\u06af" },
            { "mzn", "\u0645\u0627\u0632\u0623\u0646\u062f\u0623\u0631\u0627\u0646\u06cc" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "nds", "\u0622\u0644\u0645\u0627\u0646\u06cc \u06be\u0627\u0631\u06cc" },
            { "nmg", "\u06a9\u0626\u06a4\u0627\u0633\u06cc\u0648\u0659" },
            { "nqo", "\u0646\u0626\u06a9\u0648\u0659" },
            { "nus", "\u0646\u06cc\u0648\u0659\u0626\u0631" },
            { "nyn", "\u0646\u06cc\u0627\u0646 \u06a9\u0648\u0659\u0644\u0626" },
            { "quc", "\u06a9\u06cc\u0686\u06cc" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "rwk", "\u0631\u0626\u06a4\u0627" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0659\u0631\u0648\u0659" },
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u0659" },
            { "sdh", "\u06a9\u0648\u0631\u062f\u06cc \u06be\u0627\u0631\u06af\u06d5" },
            { "seh", "\u0633\u0626\u0646\u0627" },
            { "ses", "\u06a9\u06cc\u0627\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u0626\u0646\u06cc" },
            { "shi", "\u062a\u0627\u0686\u0626\u0644\u06be\u06cc\u062a" },
            { "sma", "\u0633\u0627\u0645\u06cc \u06be\u0627\u0631\u06af\u06d5" },
            { "smj", "\u0644\u06c9\u0644\u0626 \u0633\u0627\u0645\u06cc" },
            { "smn", "\u0626\u06cc\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "sms", "\u0626\u0633\u06a9\u0648\u0644\u062a \u0633\u0627\u0645\u06cc" },
            { "teo", "\u062a\u0626\u0633\u0648" },
            { "twq", "\u062a\u0627\u0633\u0627\u06a4\u0627\u0642" },
            { "tzm", "\u062a\u0627\u0645\u0627\u0632\u06cc\u063a \u0645\u06cc\u0646\u062c\u0627\u06cc\u06cc" },
            { "und", "\u0632\u0648\u0659\u0646 \u0646\u0627\u062f\u06cc\u0627\u0631" },
            { "vai", "\u06a4\u0627\u06cc" },
            { "vun", "\u06a4\u0648\u0659\u0646\u062c\u0648\u0659" },
            { "wbp", "\u06a4\u0627\u0631\u0644\u067e\u06cc\u0631\u06cc" },
            { "xog", "\u0633\u0648\u0659\u06af\u0627" },
            { "zgh", "\u062a\u0627\u0645\u0627\u0632\u06cc\u063a \u0645\u0623\u0631\u0627\u06a9\u0626\u0634\u06cc" },
            { "zxx", "\u0628\u06cc \u0646\u0626\u0634\u0648\u0659" },
            { "Arab", "\u0639\u0623\u0631\u0623\u06a4\u06cc" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "\u0628\u0648\u0659\u067e\u0648\u0659" },
            { "Brai", "\u0628\u0626\u0631\u0626\u06cc\u0644" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "Deva", "\u062f\u06cc\u06a4\u0627\u0646\u06af\u0623\u0631\u06cc" },
            { "Ethi", "\u0626\u062a\u0648\u0659\u06cc\u0648\u0659\u067e\u06cc\u0627\u06cc\u06cc" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u06af\u0648\u0659\u0631\u0648\u0659\u0645\u062e\u06cc" },
            { "Hang", "\u06be\u0627\u0646\u06af\u0648\u0659\u0644" },
            { "Hani", "\u06be\u0627\u0646\u06cc" },
            { "Hans", "\u0633\u0627\u062f\u06d5 \u0628\u06cc\u06d5" },
            { "Hant", "\u0633\u0648\u0646\u0623\u062a\u06cc" },
            { "Hebr", metaValue_he },
            { "Hira", "\u06be\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "Khmr", metaValue_km },
            { "Knda", "\u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "Kore", metaValue_ko },
            { "Laoo", "\u0644\u0627\u0626\u0648" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "Orya", metaValue_or },
            { "Sinh", "\u0633\u06cc\u0646\u0627\u06be\u0627\u0644\u0627" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "\u062a\u0627\u0646\u0627" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zsym", "\u0646\u0626\u0634\u0648\u0659\u0646\u06d5 \u06cc\u0627" },
            { "Zxxx", "\u0646\u06cc\u0633\u0626\u0633\u06d5 \u0646\u0623\u0628\u06cc\u06d5" },
            { "Zyyy", "\u062c\u0627\u0626\u0648\u0641\u062a\u0627\u0623" },
            { "Zzzz", "\u0646\u06cc\u0633\u0626\u0633\u06d5 \u0646\u0627\u062f\u06cc\u0627\u0631" },
            { "de_AT", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0626\u0648\u062a\u0631\u06cc\u0634\u06cc" },
            { "de_CH", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0633\u0648\u0659\u06cc\u06cc\u0633\u06cc" },
            { "en_AU", "\u0626\u06cc\u0646\u06af\u06cc\u0644\u06cc\u0633\u06cc \u0626\u0648\u0633\u062a\u0627\u0631\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "en_CA", "\u0626\u06cc\u0646\u06af\u06cc\u0644\u06cc\u0633\u06cc \u06a9\u0627\u0646\u0627\u062f\u0627\u06cc\u06cc" },
            { "en_GB", "\u0626\u06cc\u0646\u06af\u06cc\u0644\u06cc\u0633\u06cc \u0628\u0626\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "en_US", "\u0626\u06cc\u0646\u06af\u06cc\u0644\u06cc\u0633\u06cc \u0626\u0645\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "es_ES", "\u0626\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0626\u0648\u0631\u0648\u0659\u067e\u0627" },
            { "es_MX", "\u0626\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0645\u0626\u06a9\u0632\u06cc\u06a9" },
            { "fr_CA", "\u0641\u0622\u0631\u0627\u0646\u0633\u0626 \u0626\u06cc \u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "fr_CH", "\u0641\u0622\u0631\u0627\u0646\u0633\u0626 \u0626\u06cc \u0633\u0648\u0659\u06cc\u06cc\u0633" },
            { "nl_BE", "\u0641\u0626\u0644\u0627\u0645\u0627\u0646\u062f\u06cc" },
            { "pt_BR", "\u067e\u0648\u0631\u062a\u0626\u063a\u0627\u0644\u06cc \u0628\u0626\u0631\u0626\u0632\u06cc\u0644" },
            { "pt_PT", "\u067e\u0648\u0631\u062a\u0626\u063a\u0627\u0644\u06cc \u0626\u0648\u0631\u0648\u0659\u067e\u0627\u06cc\u06cc" },
            { "ro_MD", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0645\u0648\u0644\u062f\u0627\u06a4\u06cc" },
            { "sw_CD", "\u0633\u0623\u06a4\u0627\u062d\u06cc\u0644\u06cc \u06a9\u0648\u0646\u06af\u0648" },
            { "ar_001", "\u0639\u0631\u0648\u06cc \u0645\u062f\u0631\u0646" },
            { "es_419", "\u0626\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0626\u0645\u0631\u06cc\u06a9\u0627 \u0644\u0627\u062a\u06cc\u0646" },
            { "nds_NL", "\u0622\u0644\u0645\u0627\u0646\u06cc \u06be\u0627\u0631\u06af\u06d5 \u062c\u0627" },
            { "az_Arab", "\u0622\u0630\u0623\u0631\u06cc \u06be\u0627\u0631\u06af\u06d5" },
            { "zh_Hans", "\u0686\u06cc\u0646\u06cc \u0633\u0627\u062f\u06d5 \u0628\u06cc\u06d5" },
            { "zh_Hant", "\u0686\u06cc\u0646\u06cc \u0633\u0648\u0646\u0623\u062a\u06cc" },
            { "type.nu.arab", "\u0623\u062f\u0623\u062f\u06cc\u0627 \u0639\u0623\u0631\u0623\u06a4\u06cc" },
            { "type.nu.latn", "\u0639\u0623\u062f\u0623\u062f\u06cc\u0627 \u0644\u0627\u062a\u06cc\u0646" },
            { "type.co.standard", "\u06a9\u0648\u0659\u0644\u0627\u062a\u06cc \u0626\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f" },
            { "type.ca.gregorian", "\u062a\u0623\u0642\u06a4\u06cc\u0645 \u06af\u0623\u0631\u0626\u06af\u0648\u0659\u0631\u06cc" },
        };
        return data;
    }
}
