/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.errors.SearchForReuseTimeout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(PackDirectory.class);
    private static final int MAX_PACKLIST_RESCAN_ATTEMPTS = 5;
    private static final PackList NO_PACKS = new PackList(FileSnapshot.DIRTY, new Pack[0]);
    private final Config config;
    private final File directory;
    private final AtomicReference<PackList> packList;
    private final CoreConfig.TrustStat trustPackStat;

    PackDirectory(Config config, File directory) {
        this.config = config;
        this.directory = directory;
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.trustPackStat = config.get(CoreConfig.KEY).getTrustPackStat();
    }

    File getDirectory() {
        return this.directory;
    }

    void create() throws IOException {
        FileUtils.mkdir(this.directory);
    }

    void close() {
        PackList packs = this.packList.get();
        if (packs != NO_PACKS && this.packList.compareAndSet(packs, NO_PACKS)) {
            Pack.close(Set.of(packs.packs));
        }
    }

    Collection<Pack> getPacks() {
        PackList list;
        do {
            if ((list = this.packList.get()) != NO_PACKS) continue;
            list = this.scanPacks(list);
        } while (this.searchPacksAgain(list));
        Pack[] packs = list.packs;
        return Collections.unmodifiableCollection(Arrays.asList(packs));
    }

    public String toString() {
        return "PackDirectory[" + String.valueOf(this.getDirectory()) + "]";
    }

    boolean has(AnyObjectId objectId) {
        return this.getPack(objectId) != null;
    }

    @Nullable
    Pack getPack(AnyObjectId objectId) {
        PackList pList;
        do {
            pList = this.packList.get();
            Pack[] packArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                Pack p = packArray[n2];
                try {
                    if (p.hasObject(objectId)) {
                        return p;
                    }
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(JGitText.get().unableToReadPackfile, p.getPackFile().getAbsolutePath()), (Throwable)e);
                    this.remove(p);
                }
                ++n2;
            }
        } while (this.searchPacksAgain(pList));
        return null;
    }

    boolean resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) {
        PackList pList;
        int oldSize = matches.size();
        do {
            pList = this.packList.get();
            Pack[] packArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                Pack p = packArray[n2];
                try {
                    p.resolve(matches, id, matchLimit);
                    p.resetTransientErrorCount();
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                if (matches.size() > matchLimit) {
                    return false;
                }
                ++n2;
            }
        } while (matches.size() == oldSize && this.searchPacksAgain(pList));
        return true;
    }

    ObjectLoader open(WindowCursor curs, AnyObjectId objectId) throws PackMismatchException {
        PackList pList;
        do {
            int retries = 0;
            block4: while (true) {
                pList = this.packList.get();
                Pack[] packArray = pList.packs;
                int n = pList.packs.length;
                int n2 = 0;
                while (n2 < n) {
                    Pack p = packArray[n2];
                    try {
                        ObjectLoader ldr = p.get(curs, objectId);
                        p.resetTransientErrorCount();
                        if (ldr != null) {
                            return ldr;
                        }
                    }
                    catch (PackMismatchException e) {
                        if (this.searchPacksAgain(pList)) {
                            retries = this.checkRescanPackThreshold(retries, e);
                            continue block4;
                        }
                    }
                    catch (IOException e) {
                        this.handlePackError(e, p);
                    }
                    ++n2;
                }
                break;
            }
        } while (this.searchPacksAgain(pList));
        return null;
    }

    long getSize(WindowCursor curs, AnyObjectId id) throws PackMismatchException {
        PackList pList;
        do {
            int retries = 0;
            block4: while (true) {
                pList = this.packList.get();
                Pack[] packArray = pList.packs;
                int n = pList.packs.length;
                int n2 = 0;
                while (n2 < n) {
                    Pack p = packArray[n2];
                    try {
                        long len = p.getObjectSize(curs, id);
                        p.resetTransientErrorCount();
                        if (0L <= len) {
                            return len;
                        }
                    }
                    catch (PackMismatchException e) {
                        if (this.searchPacksAgain(pList)) {
                            retries = this.checkRescanPackThreshold(retries, e);
                            continue block4;
                        }
                    }
                    catch (IOException e) {
                        this.handlePackError(e, p);
                    }
                    ++n2;
                }
                break;
            }
        } while (this.searchPacksAgain(pList));
        return -1L;
    }

    void selectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws PackMismatchException {
        PackList pList = this.packList.get();
        int retries = 0;
        block4: while (true) {
            for (Pack p : pList.inReverse()) {
                try {
                    LocalObjectRepresentation rep = p.representation(curs, otp);
                    p.resetTransientErrorCount();
                    if (rep == null) continue;
                    if (!packer.select(otp, rep)) {
                        return;
                    }
                    packer.checkSearchForReuseTimeout();
                }
                catch (SearchForReuseTimeout e) {
                    break block4;
                }
                catch (PackMismatchException e) {
                    retries = this.checkRescanPackThreshold(retries, e);
                    pList = this.scanPacks(pList);
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
            }
            break;
        }
    }

    private int checkRescanPackThreshold(int retries, PackMismatchException e) throws PackMismatchException {
        if (retries++ > 5) {
            e.setPermanent(true);
            throw e;
        }
        return retries;
    }

    private void handlePackError(IOException e, Pack p) {
        Throwable cause = e.getCause();
        if (e instanceof FileNotFoundException || cause instanceof FileNotFoundException) {
            this.handleFileNotFound(e, p);
        } else if (e instanceof CorruptObjectException || e instanceof PackInvalidException) {
            this.handleCorruptPack(e, p);
        } else if (FileUtils.isStaleFileHandleInCausalChain(e)) {
            this.handleStaleFileHandle(e, p);
        } else {
            this.handleTransientError(e, p, JGitText.get().exceptionWhileReadingPack);
        }
    }

    private void handleFileNotFound(IOException e, Pack p) {
        if (p.getPackFile().exists()) {
            this.handleTransientError(e, p, JGitText.get().packInaccessible);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format(JGitText.get().packWasDeleted, p.getPackFile().getAbsolutePath()), (Throwable)e);
            }
            this.remove(p);
        }
    }

    private void handleCorruptPack(IOException e, Pack p) {
        LOG.warn(MessageFormat.format(JGitText.get().corruptPack, p.getPackFile().getAbsolutePath()), (Throwable)e);
        this.remove(p);
    }

    private void handleStaleFileHandle(IOException e, Pack p) {
        LOG.warn(MessageFormat.format(JGitText.get().packHandleIsStale, p.getPackFile().getAbsolutePath()), (Throwable)e);
        this.remove(p);
    }

    private void handleTransientError(IOException e, Pack p, String errorTemplate) {
        int transientErrorCount = p.incrementTransientErrorCount();
        if (this.doLogExponentialBackoff(transientErrorCount)) {
            LOG.error(MessageFormat.format(errorTemplate, p.getPackFile().getAbsolutePath(), transientErrorCount), (Throwable)e);
        }
    }

    private boolean doLogExponentialBackoff(int n) {
        return (n & n - 1) == 0;
    }

    boolean searchPacksAgain(PackList old) {
        switch (this.trustPackStat) {
            case NEVER: {
                break;
            }
            case AFTER_OPEN: {
                try {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try {
                        InputStream stream = Files.newInputStream(this.directory.toPath(), new OpenOption[0]);
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            case ALWAYS: {
                if (old.snapshot.isModified(this.directory)) break;
                return false;
            }
        }
        return old != this.scanPacks(old);
    }

    void insert(Pack pack) {
        Pack[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            Pack[] oldList = o.packs;
            String name = pack.getPackFile().getName();
            Pack[] packArray = oldList;
            int n2 = oldList.length;
            int n3 = 0;
            while (n3 < n2) {
                Pack p = packArray[n3];
                if (name.equals(p.getPackFile().getName())) {
                    return;
                }
                ++n3;
            }
            newList = new Pack[1 + oldList.length];
            newList[0] = pack;
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
    }

    private void remove(Pack deadPack) {
        Pack[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            Pack[] oldList = o.packs;
            int j = PackDirectory.indexOf(oldList, deadPack);
            if (j < 0) break;
            newList = new Pack[oldList.length - 1];
            System.arraycopy(oldList, 0, newList, 0, j);
            System.arraycopy(oldList, j + 1, newList, j, newList.length - j);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
        deadPack.close();
    }

    private static int indexOf(Pack[] list, Pack pack) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == pack) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) {
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList n;
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
            return n;
        }
    }

    private PackList scanPacksImpl(PackList old) {
        Map<String, Pack> forReuse = PackDirectory.reuseMap(old);
        FileSnapshot snapshot = FileSnapshot.save(this.directory);
        Map<String, Map<PackExt, PackFile>> packFilesByExtById = this.getPackFilesByExtById();
        ArrayList<Pack> list = new ArrayList<Pack>(packFilesByExtById.size());
        boolean foundNew = false;
        for (Map<PackExt, PackFile> packFilesByExt : packFilesByExtById.values()) {
            PackFile packFile = packFilesByExt.get((Object)PackExt.PACK);
            if (packFile == null || !packFilesByExt.containsKey((Object)PackExt.INDEX)) continue;
            Pack oldPack = forReuse.get(packFile.getName());
            if (oldPack != null && !oldPack.getFileSnapshot().isModified(packFile)) {
                forReuse.remove(packFile.getName());
                list.add(oldPack);
                PackFile bitMaps = packFilesByExt.get((Object)PackExt.BITMAP_INDEX);
                if (bitMaps == null) continue;
                oldPack.setBitmapIndexFile(bitMaps);
                continue;
            }
            list.add(new Pack(this.config, packFile, packFilesByExt.get((Object)PackExt.BITMAP_INDEX)));
            foundNew = true;
        }
        if (!foundNew && forReuse.isEmpty() && snapshot.equals(old.snapshot)) {
            old.snapshot.setClean(snapshot);
            return old;
        }
        Pack.close(new HashSet<Pack>(forReuse.values()));
        if (list.isEmpty()) {
            return new PackList(snapshot, PackDirectory.NO_PACKS.packs);
        }
        Pack[] r = list.toArray(new Pack[0]);
        Arrays.sort(r, Pack.SORT);
        return new PackList(snapshot, r);
    }

    private static Map<String, Pack> reuseMap(PackList old) {
        HashMap<String, Pack> forReuse = new HashMap<String, Pack>();
        Pack[] packArray = old.packs;
        int n = old.packs.length;
        int n2 = 0;
        while (n2 < n) {
            Pack p = packArray[n2];
            if (p.invalid()) {
                p.close();
            } else {
                Pack prior = forReuse.put(p.getPackFile().getName(), p);
                if (prior != null) {
                    forReuse.put(prior.getPackFile().getName(), prior);
                    p.close();
                }
            }
            ++n2;
        }
        return forReuse;
    }

    private Map<String, Map<PackExt, PackFile>> getPackFilesByExtById() {
        String[] nameList = this.directory.list();
        if (nameList == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<PackExt, PackFile>> packFilesByExtById = new HashMap<String, Map<PackExt, PackFile>>(nameList.length / 2);
        String[] stringArray = nameList;
        int n = nameList.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                PackFile pack = new PackFile(this.directory, name);
                if (pack.getPackExt() != null && !pack.isTmpGCFile()) {
                    EnumMap<PackExt, PackFile> packByExt = (EnumMap<PackExt, PackFile>)packFilesByExtById.get(pack.getId());
                    if (packByExt == null) {
                        packByExt = new EnumMap<PackExt, PackFile>(PackExt.class);
                        packFilesByExtById.put(pack.getId(), packByExt);
                    }
                    packByExt.put(pack.getPackExt(), pack);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
        return packFilesByExtById;
    }

    static final class PackList {
        final FileSnapshot snapshot;
        final Pack[] packs;

        PackList(FileSnapshot monitor, Pack[] packs) {
            this.snapshot = monitor;
            this.packs = packs;
        }

        Iterable<Pack> inReverse() {
            return Iterators.iterable(this.reverseIterator());
        }

        Iterator<Pack> reverseIterator() {
            return Iterators.reverseIterator(this.packs);
        }
    }
}

