/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.util.Util;

public class SaveIndex
extends IndexRequest {
    public SaveIndex(IPath containerPath, IndexManager manager) {
        super(containerPath, manager);
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterWrite();
                this.manager.saveIndex(index);
            }
            catch (IOException e) {
                Util.log((IStatus)Status.warning((String)("Failed to save index " + String.valueOf(this.containerPath) + ". The index will not be persisted into disk but it is still available in memory and it is usable: " + e.getMessage()), (Throwable)e));
                monitor.exitWrite();
                return false;
            }
        }
        finally {
            monitor.exitWrite();
        }
        return true;
    }

    public String toString() {
        return "saving index for " + String.valueOf(this.containerPath);
    }
}

