/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.core.ui.internal.views.RepositoryViewContentProvider;
import org.eclipse.m2e.core.ui.internal.views.RepositoryViewLabelProvider;
import org.eclipse.m2e.core.ui.internal.views.nodes.IArtifactNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class MavenRepositoryView
extends ViewPart {
    private static final String MENU_OPEN_GRP = "open";
    private static final String MENU_UPDATE_GRP = "update";
    private static final String MENU_ID = ".repositoryViewMenu";
    private IAction collapseAllAction;
    private IAction reloadSettings;
    BaseSelectionListenerAction openPomAction;
    private BaseSelectionListenerAction copyUrlAction;
    TreeViewer viewer;
    private RepositoryViewContentProvider contentProvider;
    private DrillDownAdapter drillDownAdapter;

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.contentProvider = new RepositoryViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        RepositoryViewLabelProvider labelProvider = new RepositoryViewLabelProvider(this.viewer.getTree().getFont());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.viewer.addDoubleClickListener(event -> {});
        this.viewer.setInput((Object)this.getViewSite());
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.viewer.addDoubleClickListener(event -> this.openPomAction.run());
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu-.repositoryViewMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            this.fillContextMenu(manager);
            manager.update();
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.m2e.core.ui.repositoryViewMenu", menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add(this.collapseAllAction);
        manager.add(this.reloadSettings);
    }

    protected List<IMavenRepositoryNode> getSelectedRepositoryNodes(List<?> elements) {
        ArrayList<IMavenRepositoryNode> list = new ArrayList<IMavenRepositoryNode>();
        if (elements != null) {
            for (Object elem : elements) {
                if (!(elem instanceof IMavenRepositoryNode)) continue;
                IMavenRepositoryNode repoNode = (IMavenRepositoryNode)elem;
                list.add(repoNode);
            }
        }
        return list;
    }

    protected List<IArtifactNode> getArtifactNodes(List<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        ArrayList<IArtifactNode> list = new ArrayList<IArtifactNode>();
        for (Object elem : elements) {
            if (!(elem instanceof IArtifactNode)) continue;
            IArtifactNode node = (IArtifactNode)elem;
            list.add(node);
        }
        return list;
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(MENU_OPEN_GRP));
        manager.add((IContributionItem)new Separator(MENU_UPDATE_GRP));
        manager.add((IContributionItem)new Separator("import"));
        manager.prependToGroup(MENU_OPEN_GRP, (IAction)this.copyUrlAction);
        manager.prependToGroup(MENU_OPEN_GRP, (IAction)this.openPomAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add(this.collapseAllAction);
        manager.add(this.reloadSettings);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.collapseAllAction = new Action(Messages.MavenRepositoryView_btnCollapse){

            public void run() {
                MavenRepositoryView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Messages.MavenRepositoryView_btnCollapse_tooltip);
        this.collapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        this.reloadSettings = new Action(Messages.MavenRepositoryView_action_reload){

            public void run() {
                String msg = Messages.MavenRepositoryView_reload_msg;
                boolean res = MessageDialog.openConfirm((Shell)MavenRepositoryView.this.getViewSite().getShell(), (String)Messages.MavenRepositoryView_reload_title, (String)msg);
                if (res) {
                    WorkspaceJob job = new WorkspaceJob(Messages.MavenRepositoryView_job_reloading){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            try {
                                MavenPlugin.getMaven().reloadSettings();
                            }
                            catch (CoreException ex) {
                                return ex.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        };
        this.reloadSettings.setImageDescriptor(MavenImages.REFRESH);
        this.openPomAction = new BaseSelectionListenerAction(Messages.MavenRepositoryView_action_open){

            public void run() {
                ISelection selection = MavenRepositoryView.this.viewer.getSelection();
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof IArtifactNode) {
                    IArtifactNode node = (IArtifactNode)element;
                    Artifact f = node.getArtifact();
                    OpenPomAction.openEditor(f.getGroupId(), f.getArtifactId(), f.getVersion(), null);
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return selection.getFirstElement() instanceof IArtifactNode;
            }
        };
        this.openPomAction.setToolTipText(Messages.MavenRepositoryView_action_open_tooltip);
        this.openPomAction.setImageDescriptor(MavenImages.POM);
        this.copyUrlAction = new BaseSelectionListenerAction(Messages.MavenRepositoryView_action_copy){

            public void run() {
                Object element = this.getStructuredSelection().getFirstElement();
                String url = null;
                if (element instanceof RepositoryNode) {
                    RepositoryNode repoNode = (RepositoryNode)element;
                    url = repoNode.getRepositoryUrl();
                } else if (!(element instanceof IndexedArtifact)) {
                    boolean cfr_ignored_0 = element instanceof IndexedArtifactFile;
                }
                if (url != null) {
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    clipboard.setContents((Object[])new String[]{url}, new Transfer[]{TextTransfer.getInstance()});
                    clipboard.dispose();
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                Object element = selection.getFirstElement();
                return element instanceof RepositoryNode;
            }
        };
        this.copyUrlAction.setToolTipText(Messages.MavenRepositoryView_action_copy_tooltip);
        this.copyUrlAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.openPomAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.copyUrlAction);
    }

    protected RepositoryNode getSelectedRepositoryNode(IStructuredSelection selection) {
        RepositoryNode repoNode;
        List elements = selection.toList();
        if (elements.size() != 1) {
            return null;
        }
        Object e = elements.get(0);
        return e instanceof RepositoryNode ? (repoNode = (RepositoryNode)e) : null;
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.copyUrlAction);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.openPomAction);
        super.dispose();
    }

    void refreshView() {
        Display.getDefault().asyncExec(() -> {
            Object[] expandedElems = this.viewer.getExpandedElements();
            if (!this.viewer.getControl().isDisposed()) {
                this.viewer.setInput((Object)this.getViewSite());
                if (expandedElems != null && expandedElems.length > 0) {
                    this.viewer.setExpandedElements(expandedElems);
                }
            }
        });
    }
}

