/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import com.google.gson.annotations.JsonAdapter;
import java.util.List;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.adapters.WorkspaceSymbolLocationTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.JsonElementTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class WorkspaceSymbol {
    @NonNull
    private String name;
    @NonNull
    private SymbolKind kind;
    private List<SymbolTag> tags;
    @NonNull
    @JsonAdapter(value=WorkspaceSymbolLocationTypeAdapter.class)
    private Either<Location, WorkspaceSymbolLocation> location;
    private String containerName;
    @JsonAdapter(value=JsonElementTypeAdapter.Factory.class)
    private Object data;

    public WorkspaceSymbol() {
    }

    public WorkspaceSymbol(@NonNull String name, @NonNull SymbolKind kind, @NonNull Either<Location, WorkspaceSymbolLocation> location) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.kind = Preconditions.checkNotNull(kind, "kind");
        this.location = Preconditions.checkNotNull(location, "location");
    }

    public WorkspaceSymbol(@NonNull String name, @NonNull SymbolKind kind, @NonNull Either<Location, WorkspaceSymbolLocation> location, String containerName) {
        this(name, kind, location);
        this.containerName = containerName;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = Preconditions.checkNotNull(name, "name");
    }

    @NonNull
    public SymbolKind getKind() {
        return this.kind;
    }

    public void setKind(@NonNull SymbolKind kind) {
        this.kind = Preconditions.checkNotNull(kind, "kind");
    }

    public List<SymbolTag> getTags() {
        return this.tags;
    }

    public void setTags(List<SymbolTag> tags) {
        this.tags = tags;
    }

    @NonNull
    public Either<Location, WorkspaceSymbolLocation> getLocation() {
        return this.location;
    }

    public void setLocation(@NonNull Either<Location, WorkspaceSymbolLocation> location) {
        this.location = Preconditions.checkNotNull(location, "location");
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("name", this.name);
        b.add("kind", (Object)this.kind);
        b.add("tags", this.tags);
        b.add("location", this.location);
        b.add("containerName", this.containerName);
        b.add("data", this.data);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceSymbol other = (WorkspaceSymbol)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.containerName == null ? other.containerName != null : !this.containerName.equals(other.containerName)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.containerName == null ? 0 : this.containerName.hashCode());
        return 31 * result + (this.data == null ? 0 : this.data.hashCode());
    }
}

