/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.remote.core.IProcessFactory;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.RemoteProcess;

public class LocalProcessBuilder
extends AbstractRemoteProcessBuilder {
    private static final String EXTENSION_POINT_ID = "processFactory";
    private static final String ATTR_CLASS = "class";
    private final IProcessFactory fProcessFactory;
    private final Map<String, String> fRemoteEnv = new HashMap<String, String>();
    private Process localProcess;
    private PTY pty;

    public LocalProcessBuilder(IRemoteConnection connection, List<String> command) {
        super(connection, command);
        this.fRemoteEnv.putAll(System.getenv());
        this.fProcessFactory = this.getProcessFactory();
    }

    public LocalProcessBuilder(IRemoteConnection connection, String ... command) {
        this(connection, Arrays.asList(command));
    }

    @Override
    public IFileStore directory() {
        String userDir;
        IFileStore dir = super.directory();
        if (dir == null && (userDir = System.getProperty("user.dir")) != null) {
            dir = EFS.getLocalFileSystem().getStore(Path.fromOSString((String)userDir));
            this.directory(dir);
        }
        return dir;
    }

    @Override
    public Map<String, String> environment() {
        return this.fRemoteEnv;
    }

    @Override
    public int getSupportedFlags() {
        return 0;
    }

    @Override
    public IRemoteProcess start(int flags) throws IOException {
        String[] commandArray = this.command().toArray(new String[0]);
        if ((flags & 1) != 0) {
            this.environment().put("TERM", "vt100");
        }
        String[] environmentArray = new String[this.environment().size()];
        int index = 0;
        for (Map.Entry<String, String> entry : this.environment().entrySet()) {
            environmentArray[index++] = entry.getKey() + "=" + entry.getValue();
        }
        try {
            if ((flags & 1) != 0) {
                this.pty = new PTY(PTY.Mode.TERMINAL);
                File dir = this.directory() != null ? this.directory().toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()) : null;
                this.localProcess = ProcessFactory.getFactory().exec(commandArray, environmentArray, dir, this.pty);
            } else {
                this.localProcess = this.directory() != null ? this.fProcessFactory.exec(commandArray, environmentArray, this.directory().toLocalFile(0, (IProgressMonitor)new NullProgressMonitor())) : this.fProcessFactory.exec(commandArray, environmentArray);
            }
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
        return new RemoteProcess(this.getRemoteConnection(), this);
    }

    public Process getProcess() {
        return this.localProcess;
    }

    public PTY getPty() {
        return this.pty;
    }

    private IProcessFactory getProcessFactory() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(RemoteCorePlugin.getUniqueIdentifier(), EXTENSION_POINT_ID);
        IProcessFactory processFactory = null;
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    processFactory = (IProcessFactory)ce.createExecutableExtension(ATTR_CLASS);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        if (processFactory == null) {
            processFactory = new IProcessFactory(){

                @Override
                public Process exec(String cmd) throws IOException {
                    return Runtime.getRuntime().exec(cmd);
                }

                @Override
                public Process exec(String[] cmdarray) throws IOException {
                    return Runtime.getRuntime().exec(cmdarray);
                }

                @Override
                public Process exec(String[] cmdarray, String[] envp) throws IOException {
                    return Runtime.getRuntime().exec(cmdarray, envp);
                }

                @Override
                public Process exec(String cmd, String[] envp) throws IOException {
                    return Runtime.getRuntime().exec(cmd, envp);
                }

                @Override
                public Process exec(String cmd, String[] envp, File dir) throws IOException {
                    return Runtime.getRuntime().exec(cmd, envp, dir);
                }

                @Override
                public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
                    return Runtime.getRuntime().exec(cmdarray, envp, dir);
                }
            };
        }
        return processFactory;
    }
}

