/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ISettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SettingsProcessor
implements ISettingsProcessor {
    protected static final String NONE = "";
    protected static final String CDATA = "CDATA";
    protected static final String ID_ATTRIBUTE = "id";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String LANGUAGE_ELEMENT = "language";

    protected abstract int getSettingsType();

    protected abstract void writeSettings(ContentHandler var1, ICLanguageSettingEntry var2) throws SettingsImportExportException;

    protected abstract void readSettings(ICLanguageSetting var1, Element var2) throws SettingsImportExportException;

    @Override
    public void writeSectionXML(ICFolderDescription projectRoot, ContentHandler content) throws SettingsImportExportException {
        ICLanguageSetting[] languages = projectRoot.getLanguageSettings();
        AttributesImpl attributes = new AttributesImpl();
        try {
            ICLanguageSetting[] iCLanguageSettingArray = languages;
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSettingEntry[] settings;
                ICLanguageSetting language = iCLanguageSettingArray[n2];
                String languageId = language.getLanguageId();
                String languageName = language.getName();
                attributes.clear();
                if (languageId != null) {
                    attributes.addAttribute(NONE, NONE, ID_ATTRIBUTE, CDATA, languageId);
                }
                attributes.addAttribute(NONE, NONE, NAME_ATTRIBUTE, CDATA, languageName);
                content.startElement(NONE, NONE, LANGUAGE_ELEMENT, attributes);
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray = settings = language.getSettingEntries(this.getSettingsType());
                int n3 = settings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSettingEntry setting = iCLanguageSettingEntryArray[n4];
                    if (!setting.isBuiltIn()) {
                        this.writeSettings(content, setting);
                    }
                    ++n4;
                }
                content.endElement(NONE, NONE, LANGUAGE_ELEMENT);
                ++n2;
            }
        }
        catch (SAXException e) {
            throw new SettingsImportExportException(e);
        }
    }

    @Override
    public void readSectionXML(ICFolderDescription projectRoot, Element section) throws SettingsImportExportException {
        ICLanguageSetting[] languageSettings = projectRoot.getLanguageSettings();
        HashMap<String, ICLanguageSetting> languageIdMap = new HashMap<String, ICLanguageSetting>();
        HashMap<String, ICLanguageSetting> languageMap = new HashMap<String, ICLanguageSetting>();
        ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
        int n = languageSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting language = iCLanguageSettingArray[n2];
            languageIdMap.put(language.getLanguageId(), language);
            languageMap.put(language.getName(), language);
            ++n2;
        }
        List<Element> elements = XMLUtils.extractChildElements(section, LANGUAGE_ELEMENT);
        for (Element languageElement : elements) {
            String languageId = languageElement.getAttribute(ID_ATTRIBUTE);
            ICLanguageSetting setting = (ICLanguageSetting)languageIdMap.get(languageId);
            if (setting == null) {
                String languageName = languageElement.getAttribute(NAME_ATTRIBUTE);
                setting = (ICLanguageSetting)languageMap.get(languageName);
            }
            if (setting == null) continue;
            this.readSettings(setting, languageElement);
        }
    }
}

