/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.StringUtils;

public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private ConflictStyle conflictStyle;
    private List<Ref> commits = new ArrayList<Ref>();
    private Boolean squash;
    private FastForwardMode fastForwardMode;
    private String message;
    private boolean insertChangeId;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private Boolean commit;

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    @Override
    public MergeResult call() throws GitAPIException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException {
        this.checkCallable();
        this.fallBackToConfiguration();
        this.checkParameters();
        DirCacheCheckout dco = null;
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                boolean noProblems;
                Ref head = this.repo.exactRef("HEAD");
                if (head == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                StringBuilder refLogMessage = new StringBuilder("merge ");
                Ref ref = this.commits.get(0);
                refLogMessage.append(ref.getName());
                ref = this.repo.getRefDatabase().peel(ref);
                ObjectId objectId = ref.getPeeledObjectId();
                if (objectId == null) {
                    objectId = ref.getObjectId();
                }
                RevCommit srcCommit = revWalk.lookupCommit(objectId);
                ObjectId headId = head.getObjectId();
                if (headId == null) {
                    revWalk.parseHeaders(srcCommit);
                    dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                    dco.setFailOnConflict(true);
                    dco.setProgressMonitor(this.monitor);
                    dco.checkout();
                    RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                    refUpdate.setNewObjectId(objectId);
                    refUpdate.setExpectedOldObjectId(null);
                    refUpdate.setRefLogMessage("initial pull", false);
                    if (refUpdate.update() != RefUpdate.Result.NEW) {
                        throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                    }
                    this.setCallable(false);
                    ObjectId[] objectIdArray = new ObjectId[2];
                    objectIdArray[1] = srcCommit;
                    return new MergeResult(srcCommit, srcCommit, objectIdArray, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                }
                RevCommit headCommit = revWalk.lookupCommit(headId);
                if (revWalk.isMergedInto(srcCommit, headCommit)) {
                    this.setCallable(false);
                    return new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                }
                if (revWalk.isMergedInto(headCommit, srcCommit) && this.fastForwardMode != FastForwardMode.NO_FF) {
                    ObjectId newHead;
                    refLogMessage.append(": " + String.valueOf((Object)MergeResult.MergeStatus.FAST_FORWARD));
                    dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), srcCommit.getTree());
                    dco.setProgressMonitor(this.monitor);
                    dco.setFailOnConflict(true);
                    dco.checkout();
                    String msg = null;
                    ObjectId base = null;
                    MergeResult.MergeStatus mergeStatus = null;
                    if (!this.squash.booleanValue()) {
                        this.updateHead(refLogMessage, srcCommit, headId);
                        newHead = base = srcCommit;
                        mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                    } else {
                        msg = JGitText.get().squashCommitNotUpdatingHEAD;
                        newHead = base = headId;
                        mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                        List<RevCommit> squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                        String squashMessage = new SquashMessageFormatter().format(squashedCommits, head);
                        this.repo.writeSquashCommitMsg(squashMessage);
                    }
                    this.setCallable(false);
                    return new MergeResult(newHead, base, new ObjectId[]{headCommit, srcCommit}, mergeStatus, this.mergeStrategy, null, msg);
                }
                if (this.fastForwardMode == FastForwardMode.FF_ONLY) {
                    return new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ABORTED, this.mergeStrategy, null, null);
                }
                String mergeMessage = "";
                if (!this.squash.booleanValue()) {
                    mergeMessage = this.message != null ? this.message : new MergeMessageFormatter().format(this.commits, head);
                    this.repo.writeMergeCommitMsg(mergeMessage);
                    this.repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
                } else {
                    List<RevCommit> squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                    String squashMessage = new SquashMessageFormatter().format(squashedCommits, head);
                    this.repo.writeSquashCommitMsg(squashMessage);
                }
                Merger merger = this.mergeStrategy.newMerger(this.repo);
                merger.setProgressMonitor(this.monitor);
                Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults = null;
                Map<String, ResolveMerger.MergeFailureReason> failingPaths = null;
                List<String> unmergedPaths = null;
                if (merger instanceof ResolveMerger) {
                    ResolveMerger resolveMerger = (ResolveMerger)merger;
                    resolveMerger.setContentMergeStrategy(this.contentStrategy);
                    resolveMerger.setConflictStyle(this.conflictStyle);
                    resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                    resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    noProblems = merger.merge(headCommit, srcCommit);
                    lowLevelResults = resolveMerger.getMergeResults();
                    failingPaths = resolveMerger.getFailingPaths();
                    unmergedPaths = resolveMerger.getUnmergedPaths();
                    if (!resolveMerger.getModifiedFiles().isEmpty()) {
                        this.repo.fireEvent(new WorkingTreeModifiedEvent(resolveMerger.getModifiedFiles(), null));
                    }
                } else {
                    noProblems = merger.merge(headCommit, srcCommit);
                }
                refLogMessage.append(": Merge made by ");
                if (!revWalk.isMergedInto(headCommit, srcCommit)) {
                    refLogMessage.append(this.mergeStrategy.getName());
                } else {
                    refLogMessage.append("recursive");
                }
                refLogMessage.append('.');
                if (noProblems) {
                    dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.setProgressMonitor(this.monitor);
                    dco.checkout();
                    String msg = null;
                    ObjectId newHeadId = null;
                    MergeResult.MergeStatus mergeStatus = null;
                    if (!this.commit.booleanValue() && this.squash.booleanValue()) {
                        mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                    }
                    if (!this.commit.booleanValue() && !this.squash.booleanValue()) {
                        mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                    }
                    if (this.commit.booleanValue() && !this.squash.booleanValue()) {
                        Throwable throwable2 = null;
                        Object var23_40 = null;
                        try (Git git = new Git(this.getRepository());){
                            newHeadId = git.commit().setReflogComment(refLogMessage.toString()).setInsertChangeId(this.insertChangeId).call().getId();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        mergeStatus = MergeResult.MergeStatus.MERGED;
                        this.getRepository().autoGC(this.monitor);
                    }
                    if (this.commit.booleanValue() && this.squash.booleanValue()) {
                        msg = JGitText.get().squashCommitNotUpdatingHEAD;
                        newHeadId = headCommit.getId();
                        mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                    }
                    return new MergeResult(newHeadId, null, new ObjectId[]{headCommit.getId(), srcCommit.getId()}, mergeStatus, this.mergeStrategy, null, msg);
                }
                if (failingPaths != null) {
                    this.repo.writeMergeCommitMsg(null);
                    this.repo.writeMergeHeads(null);
                    return new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.FAILED, this.mergeStrategy, lowLevelResults, failingPaths, null);
                }
                CommitConfig cfg = this.repo.getConfig().get(CommitConfig.KEY);
                char commentChar = cfg.getCommentChar(this.message);
                String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths, commentChar);
                this.repo.writeMergeCommitMsg(mergeMessageWithConflicts);
                return new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, this.mergeStrategy, lowLevelResults, null);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (org.eclipse.jgit.errors.CheckoutConflictException e) {
            List<String> conflicts = dco == null ? Collections.emptyList() : dco.getConflicts();
            throw new CheckoutConflictException(conflicts, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), e);
        }
    }

    private void checkParameters() throws InvalidMergeHeadsException {
        if (this.squash.booleanValue() && this.fastForwardMode == FastForwardMode.NO_FF) {
            throw new JGitInternalException(JGitText.get().cannotCombineSquashWithNoff);
        }
        if (this.commits.size() != 1) {
            throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
        }
    }

    private void fallBackToConfiguration() {
        MergeConfig config = MergeConfig.getConfigForCurrentBranch(this.repo);
        if (this.squash == null) {
            this.squash = config.isSquash();
        }
        if (this.commit == null) {
            this.commit = config.isCommit();
        }
        if (this.fastForwardMode == null) {
            this.fastForwardMode = config.getFastForwardMode();
        }
        if (this.conflictStyle == null) {
            this.conflictStyle = config.getConflictStyle();
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case LOCK_FAILURE: 
            case REJECTED: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.checkCallable();
        this.contentStrategy = strategy;
        return this;
    }

    public MergeCommand setConflictStyle(ConflictStyle conflictStyle) {
        this.conflictStyle = conflictStyle;
        return this;
    }

    public MergeCommand include(Ref aCommit) {
        this.checkCallable();
        this.commits.add(aCommit);
        return this;
    }

    public MergeCommand include(AnyObjectId aCommit) {
        return this.include(aCommit.getName(), aCommit);
    }

    public MergeCommand include(String name, AnyObjectId aCommit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, aCommit.copy()));
    }

    public MergeCommand setSquash(boolean squash) {
        this.checkCallable();
        this.squash = squash;
        return this;
    }

    public MergeCommand setFastForward(@Nullable FastForwardMode fastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = fastForwardMode;
        return this;
    }

    public MergeCommand setCommit(boolean commit) {
        this.commit = commit;
        return this;
    }

    public MergeCommand setMessage(String message) {
        this.message = message;
        return this;
    }

    public MergeCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public MergeCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public static enum ConflictStyle {
        MERGE,
        DIFF3;

    }

    public static enum FastForwardMode implements Config.ConfigEnum
    {
        FF,
        NO_FF,
        FF_ONLY;


        @Override
        public String toConfigValue() {
            return "--" + this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        }

        @Override
        public boolean matchConfigValue(String in) {
            if (StringUtils.isEmptyOrNull(in)) {
                return false;
            }
            if (!in.startsWith("--")) {
                return false;
            }
            return this.name().equalsIgnoreCase(in.substring(2).replace('-', '_'));
        }

        public static FastForwardMode valueOf(String string) {
            return Enum.valueOf(FastForwardMode.class, string);
        }

        public static enum Merge {
            TRUE,
            FALSE,
            ONLY;


            public static Merge valueOf(String string) {
                return Enum.valueOf(Merge.class, string);
            }
        }
    }
}

