/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public abstract class BinaryFile
extends PlatformObject
implements IBinaryParser.IBinaryFile {
    private final IPath path;
    private final IBinaryParser parser;
    private final int type;
    private long timestamp;

    public BinaryFile(IBinaryParser parser, IPath path, int type) {
        this.path = path;
        this.parser = parser;
        this.type = type;
    }

    @Override
    public final IBinaryParser getBinaryParser() {
        return this.parser;
    }

    @Override
    public final IPath getPath() {
        return this.path;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public InputStream getContents() throws IOException {
        InputStream stream = null;
        if (this.path != null) {
            stream = new FileInputStream(this.path.toFile());
        }
        if (stream == null) {
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return stream;
    }

    protected boolean hasChanged() {
        boolean changed;
        long modification = this.getPath().toFile().lastModified();
        boolean bl = changed = modification != this.timestamp;
        if (changed) {
            this.timestamp = modification;
        }
        return changed;
    }
}

