/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.lang.reflect.Field;
import java.util.Deque;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.zest.layouts.LayoutItem;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class DirectedGraphLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    private int orientation = 512;

    public DirectedGraphLayoutAlgorithm() {
    }

    public DirectedGraphLayoutAlgorithm(int orientation) {
        if (orientation == 512) {
            this.orientation = orientation;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation == 256 || orientation == 512) {
            this.orientation = orientation;
        }
    }

    @Override
    public void applyLayout(boolean clean) {
        Node connections;
        Node node;
        EntityLayout[] entities;
        if (!clean) {
            return;
        }
        HashMap<EntityLayout, Node> mapping = new HashMap<EntityLayout, Node>();
        DirectedGraph graph = new DirectedGraph();
        EntityLayout[] entityLayoutArray = entities = this.context.getEntities();
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            EntityLayout element = entityLayoutArray[n2];
            node = new Node((Object)element);
            node.setSize(new Dimension(10, 10));
            mapping.put(element, node);
            graph.nodes.add((Object)node);
            ++n2;
        }
        node = connections = this.context.getConnections();
        int n3 = ((ConnectionLayout[])node).length;
        n = 0;
        while (n < n3) {
            Node connection = node[n];
            Node source = (Node)mapping.get(DirectedGraphLayoutAlgorithm.getEntity(connection.getSource()));
            Node dest = (Node)mapping.get(DirectedGraphLayoutAlgorithm.getEntity(connection.getTarget()));
            if (source != null && dest != null) {
                Edge edge = new Edge((Object)connection, source, dest);
                graph.edges.add((Object)edge);
            }
            ++n;
        }
        ExtendedDirectedGraphLayout directedGraphLayout = new ExtendedDirectedGraphLayout();
        directedGraphLayout.visit(graph);
        for (Object node2 : graph.nodes) {
            node = (Node)node2;
            EntityLayout entity = (EntityLayout)node.data;
            if (this.orientation == 512) {
                entity.setLocation(node.x, node.y);
                continue;
            }
            entity.setLocation(node.y, node.x);
        }
    }

    private static EntityLayout getEntity(NodeLayout node) {
        if (!node.isPruned()) {
            return node;
        }
        SubgraphLayout subgraph = node.getSubgraph();
        if (subgraph.isGraphEntity()) {
            return subgraph;
        }
        return null;
    }

    static class ExtendedDirectedGraphLayout
    extends DirectedGraphLayout {
        ExtendedDirectedGraphLayout() {
        }

        public void visit(DirectedGraph graph) {
            try {
                Field field = DirectedGraphLayout.class.getDeclaredField("steps");
                field.setAccessible(true);
                Object object = field.get((Object)this);
                Deque steps = (Deque)object;
                steps.remove(10);
                steps.remove(9);
                steps.remove(8);
                steps.remove(2);
                field.setAccessible(false);
                super.visit(graph);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated(since="2.0", forRemoval=true)
    public static class Zest1
    extends AbstractLayoutAlgorithm.Zest1 {
        @Deprecated
        public Zest1(int styles) {
            super(styles);
        }

        @Override
        @Deprecated
        protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
            HashMap<InternalNode, Node> mapping = new HashMap<InternalNode, Node>(entitiesToLayout.length);
            DirectedGraph graph = new DirectedGraph();
            LayoutItem[] layoutItemArray = entitiesToLayout;
            int n = entitiesToLayout.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode internalNode = layoutItemArray[n2];
                Node node = new Node((Object)internalNode);
                node.setSize(new Dimension(10, 10));
                mapping.put(internalNode, node);
                graph.nodes.add((Object)node);
                ++n2;
            }
            layoutItemArray = relationshipsToConsider;
            n = relationshipsToConsider.length;
            n2 = 0;
            while (n2 < n) {
                LayoutItem relationship = layoutItemArray[n2];
                Node source = (Node)mapping.get(((InternalRelationship)relationship).getSource());
                Node dest = (Node)mapping.get(((InternalRelationship)relationship).getDestination());
                Edge edge = new Edge((Object)relationship, source, dest);
                graph.edges.add((Object)edge);
                ++n2;
            }
            ExtendedDirectedGraphLayout directedGraphLayout = new ExtendedDirectedGraphLayout();
            directedGraphLayout.visit(graph);
            for (Object node2 : graph.nodes) {
                Node node = (Node)node2;
                InternalNode internalNode = (InternalNode)node.data;
                if ((this.layout_styles & 0x100) == 256) {
                    internalNode.setInternalLocation(node.y, node.x);
                    continue;
                }
                internalNode.setInternalLocation(node.x, node.y);
            }
            this.updateLayoutLocations(entitiesToLayout);
        }

        @Override
        @Deprecated
        protected int getCurrentLayoutStep() {
            return 0;
        }

        @Override
        @Deprecated
        protected int getTotalNumberOfLayoutSteps() {
            return 0;
        }

        @Override
        @Deprecated
        protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
            return true;
        }

        @Override
        @Deprecated
        protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
        }

        @Override
        @Deprecated
        protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        }

        @Override
        @Deprecated
        public void setLayoutArea(double x, double y, double width, double height) {
        }
    }
}

