/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.externalization.AttributesWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.ContentHandlerWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementWriter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.xml.sax.SAXException;

public class SaxTaskWriter
extends SaxTaskListElementWriter<AbstractTask> {
    public SaxTaskWriter(ContentHandlerWrapper handler) {
        super(handler);
    }

    @Override
    public void writeElement(AbstractTask task) throws SAXException {
        if (task.getClass() == TaskTask.class || task instanceof LocalTask) {
            this.handler.startElement("Task", this.createTaskElementAttributes(task));
            this.writeAttributes(task);
            for (ITask subTask : task.getChildren()) {
                this.createTaskReference(subTask);
            }
            this.handler.endElement("Task");
        } else {
            this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Unable to externalize task \"%s\" as it is of an unsupported type %s", task.getTaskId(), task.getClass())));
        }
    }

    private AttributesWrapper createTaskElementAttributes(AbstractTask task) {
        AttributesWrapper attributes = new AttributesWrapper();
        attributes.addAttribute("ConnectorKind", task.getConnectorKind());
        attributes.addAttribute("RepositoryUrl", task.getRepositoryUrl());
        attributes.addAttribute("TaskId", task.getTaskId());
        attributes.addAttribute("Key", task.getTaskKey());
        attributes.addAttribute("Handle", task.getHandleIdentifier());
        attributes.addAttribute("Label", this.stripControlCharacters(task.getSummary()));
        attributes.addAttribute("Priority", task.getPriority());
        attributes.addAttribute("Kind", task.getTaskKind());
        attributes.addAttribute("IssueURL", task.getUrl());
        attributes.addAttribute("Notes", this.stripControlCharacters(task.getNotes()));
        attributes.addAttribute("Estimated", Integer.toString(task.getEstimatedTimeHours()));
        attributes.addAttribute("EndDate", this.formatExternDate(task.getCompletionDate()));
        attributes.addAttribute("CreationDate", this.formatExternDate(task.getCreationDate()));
        attributes.addAttribute("ModificationDate", this.formatExternDate(task.getModificationDate()));
        attributes.addAttribute("DueDate", this.formatExternDate(task.getDueDate()));
        attributes.addAttribute("Owner", task.getOwner());
        attributes.addAttribute("OwnerId", task.getOwnerId());
        if (task.isActive()) {
            attributes.addAttribute("Active", "true");
        } else {
            attributes.addAttribute("Active", "false");
        }
        if (task.getScheduledForDate() != null) {
            attributes.addAttribute("ScheduledStartDate", this.formatExternCalendar(task.getScheduledForDate().getStartDate()));
            attributes.addAttribute("ScheduledEndDate", this.formatExternCalendar(task.getScheduledForDate().getEndDate()));
        }
        if (task.isReminded()) {
            attributes.addAttribute("Reminded", "true");
        } else {
            attributes.addAttribute("Reminded", "false");
        }
        if (task.isMarkReadPending()) {
            attributes.addAttribute("MarkReadPending", "true");
        } else {
            attributes.addAttribute("MarkReadPending", "false");
        }
        if (task.isNotified()) {
            attributes.addAttribute("NotifiedIncoming", "true");
        } else {
            attributes.addAttribute("NotifiedIncoming", "false");
        }
        if (task.getSynchronizationState() != null) {
            attributes.addAttribute("offlineSyncState", task.getSynchronizationState().name());
        } else {
            attributes.addAttribute("offlineSyncState", ITask.SynchronizationState.SYNCHRONIZED.name());
        }
        return attributes;
    }

    public void createTaskReference(ITask task) throws SAXException {
        AttributesWrapper attributes = new AttributesWrapper();
        attributes.addAttribute("Handle", task.getHandleIdentifier());
        this.handler.startElement("SubTask", attributes);
        this.handler.endElement("SubTask");
    }
}

