/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalCategory;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerRegistry;
import org.eclipse.wst.sse.ui.internal.util.SWTUtil;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;

public final class CodeAssistCyclingConfigurationBlock {
    private final Comparator fCategoryPageComparator = new Comparator(){

        private int getRank(Object o) {
            return ((ModelElement)o).getOwnPageRank();
        }

        public int compare(Object o1, Object o2) {
            int result = this.getRank(o1) - this.getRank(o2);
            if (result == 0) {
                result = ((ModelElement)o1).getId().compareTo(((ModelElement)o2).getId());
            }
            return result;
        }
    };
    private final Comparator fCategoryDefaultPageComparator = new Comparator(){

        private int getRank(Object o) {
            return ((ModelElement)o).getDefaultPageRank();
        }

        public int compare(Object o1, Object o2) {
            int result = this.getRank(o1) - this.getRank(o2);
            if (result == 0) {
                result = ((ModelElement)o1).getId().compareTo(((ModelElement)o2).getId());
            }
            return result;
        }
    };
    private final PreferenceModel fModel;
    private final Map fImages = new HashMap();
    private CheckboxTableViewer fDefaultPageViewer;
    private CheckboxTableViewer fOwnPageViewer;
    private Button fPageOrderUpButton;
    private Button fPageOrderDownButton;
    private Button fDefaultPageOrderUpButton;
    private Button fDefaultPageOrderDownButton;
    private String fContentTypeID;
    private ICompletionProposalCategoriesConfigurationWriter fConfigurationWriter;
    private static BindingManager fgLocalBindingManager = new BindingManager(new ContextManager(), new CommandManager());

    static {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        Scheme[] definedSchemes = bindingService.getDefinedSchemes();
        if (definedSchemes != null) {
            try {
                int i = 0;
                while (i < definedSchemes.length) {
                    Scheme scheme = definedSchemes[i];
                    Scheme copy = fgLocalBindingManager.getScheme(scheme.getId());
                    copy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                    ++i;
                }
            }
            catch (NotDefinedException e) {
                Logger.logException(e);
            }
        }
        fgLocalBindingManager.setLocale(bindingService.getLocale());
        fgLocalBindingManager.setPlatform(bindingService.getPlatform());
    }

    public CodeAssistCyclingConfigurationBlock(String contentTypeID, ICompletionProposalCategoriesConfigurationWriter configurationWriter) {
        this.fContentTypeID = contentTypeID;
        this.fConfigurationWriter = configurationWriter;
        List categories = CompletionProposalComputerRegistry.getDefault().getProposalCategories(this.fContentTypeID);
        this.fModel = new PreferenceModel(categories);
    }

    public boolean storeValues() {
        return this.fConfigurationWriter.saveConfiguration();
    }

    public void performDefaults() {
        this.fConfigurationWriter.loadDefaults();
        this.initializeValues();
        this.fModel.performDefaults();
    }

    public void dispose() {
        for (Image image : this.fImages.values()) {
            image.dispose();
        }
    }

    public Control createContents(Composite parent, String groupTitle) {
        Group container;
        if (groupTitle != null) {
            container = new Group(parent, 0);
            container.setText(groupTitle);
        } else {
            container = new Composite(parent, 0);
        }
        int columns = 2;
        GridLayout layout = new GridLayout(columns, false);
        container.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)data);
        this.createDefaultPageLabel((Composite)container, columns);
        this.createDefaultPageSection((Composite)container);
        this.createFiller((Composite)container, columns);
        this.createOwnPageLabel((Composite)container, columns);
        this.createOwnPageSection((Composite)container);
        this.createFiller((Composite)container, columns);
        if (this.fModel.pageElements.size() > 0) {
            this.fDefaultPageViewer.getTable().select(0);
            this.fOwnPageViewer.getTable().select(0);
            this.handleOwnPageTableSelection();
            this.handleDefaultPageTableSelection();
        }
        return container;
    }

    public void initializeValues() {
        this.updateCheckedState();
        this.fDefaultPageViewer.refresh();
        this.fOwnPageViewer.refresh();
        this.handleOwnPageTableSelection();
        this.handleDefaultPageTableSelection();
    }

    private void createDefaultPageSection(Composite composite) {
        this.createDefaultPageViewer(composite);
        this.createDefaultPageButtonList(composite);
    }

    private void createDefaultPageLabel(Composite composite, int h_span) {
        ICommandService commandSvc = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = commandSvc.getCommand("org.eclipse.ui.edit.text.contentAssist.proposals");
        ParameterizedCommand pCmd = new ParameterizedCommand(command, null);
        String key = CodeAssistCyclingConfigurationBlock.getKeyboardShortcut(pCmd);
        if (key == null) {
            key = SSEUIMessages.CodeAssistAdvancedConfigurationBlock_no_shortcut;
        }
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int width = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(NLS.bind((String)SSEUIMessages.CodeAssistAdvancedConfigurationBlock_page_description, (Object[])new Object[]{key}));
        GridData gd = new GridData(4, 4, true, false, h_span, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
        this.createFiller(composite, h_span);
        label = new Label(composite, 64);
        label.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_default_table_description);
        gd = new GridData(4, 4, true, false, h_span, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
    }

    private void createDefaultPageViewer(Composite composite) {
        this.fDefaultPageViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        Table table = this.fDefaultPageViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_default_table_category_column_title);
        nameColumn.setResizable(false);
        this.fDefaultPageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                ModelElement element = (ModelElement)event.getElement();
                element.setShouldDisplayOnDefaultPage(checked);
            }
        });
        this.fDefaultPageViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        DefaultPageTableLabelProvider labelProvider = new DefaultPageTableLabelProvider();
        this.fDefaultPageViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fDefaultPageViewer.setInput((Object)this.fModel.defaultPageElements);
        this.fDefaultPageViewer.setComparator((ViewerComparator)new ModelViewerComparator(this.fCategoryDefaultPageComparator));
        int minNameWidth = this.computeWidth((Control)table, nameColumn.getText()) + 20;
        int i = 0;
        while (i < this.fModel.defaultPageElements.size()) {
            minNameWidth = Math.max(minNameWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.defaultPageElements.get(i), 0)) + 50);
            ++i;
        }
        nameColumn.setWidth(minNameWidth);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistCyclingConfigurationBlock.this.handleDefaultPageTableSelection();
            }
        });
    }

    private void createDefaultPageButtonList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1, 1, false, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fDefaultPageOrderUpButton = new Button(composite, 0x1000008);
        this.fDefaultPageOrderUpButton.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_Up);
        this.fDefaultPageOrderUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistCyclingConfigurationBlock.this.fDefaultPageViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    CodeAssistCyclingConfigurationBlock.this.fModel.moveDefaultPageCategoryUp(index);
                    CodeAssistCyclingConfigurationBlock.this.fDefaultPageViewer.refresh();
                    CodeAssistCyclingConfigurationBlock.this.handleDefaultPageTableSelection();
                }
            }
        });
        this.fDefaultPageOrderUpButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fDefaultPageOrderUpButton);
        this.fDefaultPageOrderDownButton = new Button(composite, 0x1000008);
        this.fDefaultPageOrderDownButton.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_Down);
        this.fDefaultPageOrderDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistCyclingConfigurationBlock.this.fDefaultPageViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    CodeAssistCyclingConfigurationBlock.this.fModel.moveDefaultPageCategoryDown(index);
                    CodeAssistCyclingConfigurationBlock.this.fDefaultPageViewer.refresh();
                    CodeAssistCyclingConfigurationBlock.this.handleDefaultPageTableSelection();
                }
            }
        });
        this.fDefaultPageOrderDownButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fDefaultPageOrderDownButton);
    }

    private void createFiller(Composite composite, int h_span) {
        Label filler = new Label(composite, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, h_span, 1));
    }

    private void createOwnPageLabel(Composite composite, int h_span) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int width = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_separate_table_description);
        GridData gd = new GridData(4, 4, false, false, h_span, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
    }

    private void createOwnPageSection(Composite composite) {
        this.createOwnPageViewer(composite);
        this.createOwnPageButtonList(composite);
    }

    private void createOwnPageViewer(Composite composite) {
        this.fOwnPageViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        Table table = this.fOwnPageViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_separate_table_category_column_title);
        nameColumn.setResizable(false);
        this.fOwnPageViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        OwnPageTableLabelProvider labelProvider = new OwnPageTableLabelProvider();
        this.fOwnPageViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fOwnPageViewer.setInput((Object)this.fModel.pageElements);
        this.fOwnPageViewer.setComparator((ViewerComparator)new ModelViewerComparator(this.fCategoryPageComparator));
        int minNameWidth = this.computeWidth((Control)table, nameColumn.getText()) + 20;
        int i = 0;
        while (i < this.fModel.pageElements.size()) {
            minNameWidth = Math.max(minNameWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.pageElements.get(i), 0)) + 50);
            ++i;
        }
        nameColumn.setWidth(minNameWidth);
        this.fOwnPageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                ModelElement element = (ModelElement)event.getElement();
                element.setShouldDisplayOnOwnPage(checked);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistCyclingConfigurationBlock.this.handleOwnPageTableSelection();
            }
        });
    }

    private void createOwnPageButtonList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1, 1, false, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fPageOrderUpButton = new Button(composite, 0x1000008);
        this.fPageOrderUpButton.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_PagesUp);
        this.fPageOrderUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistCyclingConfigurationBlock.this.fOwnPageViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    CodeAssistCyclingConfigurationBlock.this.fModel.movePageUp(index);
                    CodeAssistCyclingConfigurationBlock.this.fOwnPageViewer.refresh();
                    CodeAssistCyclingConfigurationBlock.this.handleOwnPageTableSelection();
                }
            }
        });
        this.fPageOrderUpButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fPageOrderUpButton);
        this.fPageOrderDownButton = new Button(composite, 0x1000008);
        this.fPageOrderDownButton.setText(SSEUIMessages.CodeAssistAdvancedConfigurationBlock_PagesDown);
        this.fPageOrderDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistCyclingConfigurationBlock.this.fOwnPageViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    CodeAssistCyclingConfigurationBlock.this.fModel.movePageDown(index);
                    CodeAssistCyclingConfigurationBlock.this.fOwnPageViewer.refresh();
                    CodeAssistCyclingConfigurationBlock.this.handleOwnPageTableSelection();
                }
            }
        });
        this.fPageOrderDownButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fPageOrderDownButton);
    }

    private void handleOwnPageTableSelection() {
        ModelElement item = (ModelElement)((IStructuredSelection)this.fOwnPageViewer.getSelection()).getFirstElement();
        if (item != null) {
            int index = this.fOwnPageViewer.getTable().getSelectionIndex();
            this.fPageOrderUpButton.setEnabled(index > 0);
            this.fPageOrderDownButton.setEnabled(index < this.fModel.pageElements.size() - 1);
        } else {
            this.fPageOrderUpButton.setEnabled(false);
            this.fPageOrderDownButton.setEnabled(false);
        }
    }

    private void handleDefaultPageTableSelection() {
        ModelElement item = (ModelElement)((IStructuredSelection)this.fDefaultPageViewer.getSelection()).getFirstElement();
        if (item != null) {
            int index = this.fDefaultPageViewer.getTable().getSelectionIndex();
            this.fDefaultPageOrderUpButton.setEnabled(index > 0);
            this.fDefaultPageOrderDownButton.setEnabled(index < this.fModel.defaultPageElements.size() - 1);
        } else {
            this.fDefaultPageOrderUpButton.setEnabled(false);
            this.fDefaultPageOrderDownButton.setEnabled(false);
        }
    }

    private void updateCheckedState() {
        int size = this.fModel.pageElements.size();
        ArrayList<ModelElement> defaultChecked = new ArrayList<ModelElement>(size);
        ArrayList<ModelElement> separateChecked = new ArrayList<ModelElement>(size);
        for (ModelElement element : this.fModel.pageElements) {
            if (element.shouldDisplayOnDefaultPage()) {
                defaultChecked.add(element);
            }
            if (!element.shouldDisplayOnOwnPage()) continue;
            separateChecked.add(element);
        }
        this.fDefaultPageViewer.setCheckedElements(defaultChecked.toArray(new Object[defaultChecked.size()]));
        this.fOwnPageViewer.setCheckedElements(separateChecked.toArray(new Object[separateChecked.size()]));
    }

    private int computeWidth(Control control, String name) {
        if (name == null) {
            return 0;
        }
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            int n = gc.stringExtent((String)name).x + 10;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private static String getKeyboardShortcut(ParameterizedCommand command) {
        TriggerSequence[] bindings;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        fgLocalBindingManager.setBindings(bindingService.getBindings());
        try {
            Scheme activeScheme = bindingService.getActiveScheme();
            if (activeScheme != null) {
                fgLocalBindingManager.setActiveScheme(activeScheme);
            }
        }
        catch (NotDefinedException e) {
            Logger.logException(e);
        }
        if ((bindings = fgLocalBindingManager.getActiveBindingsDisregardingContextFor(command)).length > 0) {
            return bindings[0].format();
        }
        return null;
    }

    private Image getImage(ImageDescriptor imgDesc) {
        if (imgDesc == null) {
            return null;
        }
        Image img = (Image)this.fImages.get(imgDesc);
        if (img == null) {
            img = imgDesc.createImage(false);
            this.fImages.put(imgDesc, img);
        }
        return img;
    }

    private final class DefaultPageTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DefaultPageTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ModelElement)element).getImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ModelElement)element).getName();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private final class ModelElement {
        private final CompletionProposalCategory fCategory;

        ModelElement(CompletionProposalCategory category) {
            this.fCategory = category;
        }

        Image getImage() {
            return CodeAssistCyclingConfigurationBlock.this.getImage(this.fCategory.getImageDescriptor());
        }

        String getName() {
            return this.fCategory.getDisplayName();
        }

        String getId() {
            return this.fCategory.getId();
        }

        boolean shouldDisplayOnDefaultPage() {
            return CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.shouldDisplayOnDefaultPage(this.getId());
        }

        void setShouldDisplayOnDefaultPage(boolean included) {
            CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.setShouldDisplayOnDefaultPage(this.getId(), included);
        }

        boolean shouldDisplayOnOwnPage() {
            return CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.shouldDisplayOnOwnPage(this.getId());
        }

        void setShouldDisplayOnOwnPage(boolean shouldDisplay) {
            CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.setShouldDisplayOnOwnPage(this.getId(), shouldDisplay);
        }

        int getOwnPageRank() {
            return CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.getPageSortOrder(this.getId());
        }

        int getDefaultPageRank() {
            return CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.getDefaultPageSortOrder(this.getId());
        }
    }

    private class ModelViewerComparator
    extends ViewerComparator {
        private Comparator c;

        public ModelViewerComparator(Comparator comparator) {
            super(comparator);
            this.c = comparator;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.c.compare(e1, e2);
        }
    }

    private final class OwnPageTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private OwnPageTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ModelElement)element).getImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ModelElement)element).getName();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    private final class PreferenceModel {
        private final List fPageElements = new ArrayList();
        final List pageElements;
        private final List fDefaultPageElements = new ArrayList();
        final List defaultPageElements;

        public PreferenceModel(List categories) {
            for (CompletionProposalCategory category : categories) {
                if (!category.hasComputers()) continue;
                ModelElement elem = new ModelElement(category);
                this.fPageElements.add(elem);
                this.fDefaultPageElements.add(elem);
            }
            this.performDefaults();
            this.pageElements = Collections.unmodifiableList(this.fPageElements);
            this.defaultPageElements = Collections.unmodifiableList(this.fDefaultPageElements);
        }

        public void movePageUp(int elementIndex) {
            Object removed = this.fPageElements.remove(elementIndex);
            this.fPageElements.add(elementIndex - 1, removed);
            CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.setPageOrder(this.getPageOrderedCategoryIDs());
        }

        public void movePageDown(int elementIndex) {
            Object removed = this.fPageElements.remove(elementIndex);
            this.fPageElements.add(elementIndex + 1, removed);
            CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.setPageOrder(this.getPageOrderedCategoryIDs());
        }

        public void moveDefaultPageCategoryUp(int elementIndex) {
            Object removed = this.fDefaultPageElements.remove(elementIndex);
            this.fDefaultPageElements.add(elementIndex - 1, removed);
            CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.setDefaultPageOrder(this.getDefaultPageOrderedCategoryIDs());
        }

        public void moveDefaultPageCategoryDown(int elementIndex) {
            Object removed = this.fDefaultPageElements.remove(elementIndex);
            this.fDefaultPageElements.add(elementIndex + 1, removed);
            CodeAssistCyclingConfigurationBlock.this.fConfigurationWriter.setDefaultPageOrder(this.getDefaultPageOrderedCategoryIDs());
        }

        private List getPageOrderedCategoryIDs() {
            ArrayList<String> ordered = new ArrayList<String>(this.pageElements.size());
            int i = 0;
            while (i < this.pageElements.size()) {
                ordered.add(((ModelElement)this.pageElements.get(i)).getId());
                ++i;
            }
            return ordered;
        }

        private List getDefaultPageOrderedCategoryIDs() {
            ArrayList<String> ordered = new ArrayList<String>(this.defaultPageElements.size());
            int i = 0;
            while (i < this.defaultPageElements.size()) {
                ordered.add(((ModelElement)this.defaultPageElements.get(i)).getId());
                ++i;
            }
            return ordered;
        }

        public void performDefaults() {
            Collections.sort(this.fPageElements, CodeAssistCyclingConfigurationBlock.this.fCategoryPageComparator);
            Collections.sort(this.fDefaultPageElements, CodeAssistCyclingConfigurationBlock.this.fCategoryDefaultPageComparator);
        }
    }
}

