/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.ProjectFacetDetector;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

public final class ProjectFacetDetectorsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "detectors";
    private static final String EL_DETECTOR = "detector";
    private static final String ATTR_CLASS = "class";
    private static List<DetectorExtension> extensions = null;

    public static List<ProjectFacetDetector> getDetectors() {
        ProjectFacetDetectorsExtensionPoint.readExtensions();
        ArrayList<ProjectFacetDetector> detectors = new ArrayList<ProjectFacetDetector>();
        for (DetectorExtension extension : extensions) {
            detectors.add(extension.getDetector());
        }
        return Collections.unmodifiableList(detectors);
    }

    private static synchronized void readExtensions() {
        if (extensions != null) {
            return;
        }
        extensions = new ArrayList<DetectorExtension>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_DETECTOR)) continue;
            try {
                ProjectFacetDetectorsExtensionPoint.readExtension(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static void readExtension(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        String pluginId = config.getContributor().getName();
        String className = PluginUtil.findRequiredAttribute(config, ATTR_CLASS);
        if (className == null) {
            throw new PluginUtil.InvalidExtensionException();
        }
        DetectorExtension extension = new DetectorExtension(pluginId, className);
        extensions.add(extension);
    }

    private static final class DetectorExtension {
        private final String pluginId;
        private final String className;
        private ProjectFacetDetector detector;

        public DetectorExtension(String pluginId, String className) throws PluginUtil.InvalidExtensionException {
            this.pluginId = pluginId;
            this.className = className;
            this.detector = PluginUtil.instantiate(this.pluginId, this.className, ProjectFacetDetector.class);
            if (this.detector == null) {
                throw new PluginUtil.InvalidExtensionException();
            }
        }

        public ProjectFacetDetector getDetector() {
            return this.detector;
        }
    }
}

