/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.util.logging.Level;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jem.internal.beaninfo.adapters.BeanInfoAdapterMessages;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.util.logger.proxy.Logger;

class CreateRegistryJobHandler {
    private static CreateRegistryJobHandler jobHandler = null;

    CreateRegistryJobHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRegistry(BeaninfoNature nature) {
        Class<CreateRegistryJobHandler> clazz = CreateRegistryJobHandler.class;
        synchronized (CreateRegistryJobHandler.class) {
            if (jobHandler == null && Platform.getBundle((String)"org.eclipse.ui") != null) {
                try {
                    jobHandler = (CreateRegistryJobHandler)Class.forName("org.eclipse.jem.internal.beaninfo.adapters.UICreateRegistryJobHandler").newInstance();
                }
                catch (InstantiationException instantiationException) {
                    jobHandler = new CreateRegistryJobHandler();
                }
                catch (IllegalAccessException illegalAccessException) {
                    jobHandler = new CreateRegistryJobHandler();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    jobHandler = new CreateRegistryJobHandler();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            IJobManager jobManager = Job.getJobManager();
            Job currentJob = jobManager.currentJob();
            if (currentJob == null || !currentJob.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) && !currentJob.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD)) {
                Logger logger;
                int tries = 5;
                while (CreateRegistryJobHandler.isAutoWaiting() && --tries > 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (tries == 0 && (logger = BeaninfoPlugin.getPlugin().getLogger()).isLoggingLevel(Level.WARNING)) {
                    logger.log((Object)"Build job waiting when trying to start beaninfo registry. Possible race.", Level.WARNING);
                }
            }
            jobHandler.processCreateRegistry(nature);
            return;
        }
    }

    private static boolean isAutoWaiting() {
        Job[] autojobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
        int i = 0;
        while (i < autojobs.length) {
            int state = autojobs[i].getState();
            if (state == 2 || state == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void processCreateRegistry(final BeaninfoNature nature) {
        IJobManager jobManager = Job.getJobManager();
        ISchedulingRule buildRule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        boolean gotRuleLocally = true;
        try {
            try {
                jobManager.beginRule(buildRule, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                gotRuleLocally = false;
            }
            if (gotRuleLocally) {
                this.doCreateRegistry(nature, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            jobManager.endRule(buildRule);
        }
        if (!gotRuleLocally) {
            Job doCreateJob = new Job(BeanInfoAdapterMessages.UICreateRegistryJobHandler_StartBeaninfoRegistry){

                protected IStatus run(IProgressMonitor monitor) {
                    CreateRegistryJobHandler.this.doCreateRegistry(nature, monitor);
                    return Status.OK_STATUS;
                }
            };
            doCreateJob.schedule();
            while (true) {
                try {
                    doCreateJob.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    protected final void doCreateRegistry(BeaninfoNature nature, IProgressMonitor pm) {
        pm.beginTask("", 100);
        try {
            nature.createRegistry((IProgressMonitor)new SubProgressMonitor(pm, 100));
        }
        finally {
            pm.done();
        }
    }
}

