/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;

public class RegPublishServiceInterfaceAdvancedAction
extends PublishAction {
    public RegPublishServiceInterfaceAdvancedAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(2));
        this.propertyTable_.put("queryStyleServiceInterfaces", String.valueOf(1));
    }

    @Override
    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String wsdlURL = parser.getParameter("wsdlURL");
        String name = parser.getParameter("advancedServiceInterfaceName");
        String[] descriptionLanguages = parser.getParameterValues("advancedDescriptionLanguage");
        String[] descriptions = parser.getParameterValues("advancedDescription");
        String[] idTypes = parser.getParameterValues("advancedIdentifierType");
        String[] idKeyNames = parser.getParameterValues("advancedIdentifierKeyName");
        String[] idKeyValues = parser.getParameterValues("advancedIdentifierKeyValue");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        Hashtable<String, Boolean> languageHash = new Hashtable<String, Boolean>();
        if (wsdlURL != null) {
            this.propertyTable_.put("advancedServiceInterfaceWSDLURL", wsdlURL);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(wsdlURL)) {
            inputsValid = false;
            formToolPI.flagError("advancedServiceInterfaceWSDLURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_WSDL_URL"));
        }
        if (name != null) {
            this.propertyTable_.put("advancedServiceInterfaceName", name);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(name)) {
            inputsValid = false;
            formToolPI.flagError("advancedServiceInterfaceName");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_NAME"));
        }
        if (descriptionLanguages != null && descriptions != null) {
            Vector<Description> descriptionVector = new Vector<Description>();
            String[] parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DESCRIPTION");
            languageHash.clear();
            int i = 0;
            while (i < descriptions.length) {
                Description uddi4jDescription;
                parameters[1] = String.valueOf(i + 1);
                if (descriptionLanguages[i].length() > 0) {
                    uddi4jDescription = new Description(descriptions[i], descriptionLanguages[i]);
                } else {
                    uddi4jDescription = new Description(descriptions[i]);
                    if (i != 0 && !this.subQueryInitiated_) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedServiceInterfaceDescriptions", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(descriptionLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceInterfaceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(descriptionLanguages[i], Boolean.TRUE);
                }
                if (descriptions[i].trim().length() < 1) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceInterfaceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                descriptionVector.addElement(uddi4jDescription);
                ++i;
            }
            this.propertyTable_.put("advancedServiceInterfaceDescriptions", descriptionVector);
        } else {
            this.removeProperty("advancedServiceInterfaceDescriptions");
        }
        if (idTypes != null && idKeyNames != null && idKeyValues != null) {
            IdentifierBag idBag = new IdentifierBag();
            int i = 0;
            while (i < idKeyNames.length) {
                KeyedReference kr = new KeyedReference(idKeyNames[i], idKeyValues[i], idTypes[i]);
                idBag.add(kr);
                ++i;
            }
            this.propertyTable_.put("advancedServiceInterfaceIdentifiers", idBag);
        } else {
            this.removeProperty("advancedServiceInterfaceIdentifiers");
        }
        if (catTypes != null && catKeyNames != null && catKeyValues != null) {
            CategoryBag catBag = new CategoryBag();
            int i = 0;
            while (i < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i], catKeyValues[i], catTypes[i]);
                catBag.add(kr);
                ++i;
            }
            this.propertyTable_.put("advancedServiceInterfaceCategories", catBag);
        } else {
            this.removeProperty("advancedServiceInterfaceCategories");
        }
        return inputsValid;
    }

    @Override
    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            String wsdlURL = (String)this.propertyTable_.get("advancedServiceInterfaceWSDLURL");
            String name = (String)this.propertyTable_.get("advancedServiceInterfaceName");
            Vector descriptionVector = (Vector)this.propertyTable_.get("advancedServiceInterfaceDescriptions");
            IdentifierBag identifierBag = (IdentifierBag)this.propertyTable_.get("advancedServiceInterfaceIdentifiers");
            CategoryBag categoryBag = (CategoryBag)this.propertyTable_.get("advancedServiceInterfaceCategories");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            TModel tModel = new Uddi4jHelper().newTModel(wsdlURL);
            tModel.setName(name);
            tModel.setDescriptionVector(descriptionVector);
            tModel.setIdentifierBag(identifierBag);
            CategoryBag defaultCategoryBag = tModel.getCategoryBag();
            Vector defaultKeyedReferenceVector = null;
            if (defaultCategoryBag != null) {
                if (categoryBag == null) {
                    categoryBag = defaultCategoryBag;
                } else {
                    defaultKeyedReferenceVector = defaultCategoryBag.getKeyedReferenceVector();
                    int i = 0;
                    while (i < defaultKeyedReferenceVector.size()) {
                        KeyedReference kr = (KeyedReference)defaultKeyedReferenceVector.elementAt(i);
                        if (categoryBag != null) {
                            categoryBag.add(kr);
                        }
                        ++i;
                    }
                }
            }
            tModel.setCategoryBag(categoryBag);
            Vector<TModel> tModelVector = new Vector<TModel>();
            tModelVector.add(tModel);
            tModel = (TModel)proxy.save_tModel(regElement.getAuthInfoString(), tModelVector).getTModelVector().get(0);
            this.propertyTable_.put("savedTModel", tModel);
            this.addPublishedItemNode(tModel, regElement);
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_INTERFACE_PUBLISHED", tModel.getNameString()));
            return true;
        }
        catch (WSDLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("WSDLException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
                regElement.setDefaults();
            }
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

