/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class Strings {
    private static final int INDEX_NOT_FOUND = -1;
    private static final Pattern CAMEL_TO_SCREAMING_SNAKE_PAT = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    private static final Pattern SCREAMING_SNAKE_TO_CAMEL_PAT = Pattern.compile("_");

    private Strings() {
    }

    public static boolean equals(char[] first, char[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        for (int i = first.length - 1; i >= 0; --i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] first, char[] second, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return Strings.equals(first, second);
        }
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        for (int i = first.length - 1; i >= 0; --i) {
            if (Character.toLowerCase(first[i]) == Character.toLowerCase(second[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence first, CharSequence second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length() != second.length()) {
            return false;
        }
        for (int i = first.length() - 1; i >= 0; --i) {
            if (first.charAt(i) == second.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence first, CharSequence second, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return Strings.equals(first, second);
        }
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length() != second.length()) {
            return false;
        }
        for (int i = first.length() - 1; i >= 0; --i) {
            if (Character.toLowerCase(first.charAt(i)) == Character.toLowerCase(second.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(char toBeFound, char[] searchIn) {
        return Strings.indexOf(toBeFound, searchIn, 0);
    }

    public static int indexOf(char toBeFound, char[] searchIn, int start) {
        return Strings.indexOf(toBeFound, searchIn, start, searchIn.length);
    }

    public static int indexOf(char toBeFound, char[] searchIn, int start, int end) {
        int limit = Math.min(end, searchIn.length);
        for (int i = start; i < limit; ++i) {
            if (toBeFound != searchIn[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char toBeFound, CharSequence searchIn) {
        return Strings.indexOf(toBeFound, searchIn, 0);
    }

    public static int indexOf(char toBeFound, CharSequence searchIn, int start) {
        return Strings.indexOf(toBeFound, searchIn, start, searchIn.length());
    }

    public static int indexOf(char toBeFound, CharSequence searchIn, int start, int end) {
        int limit = Math.max(Math.min(end, searchIn.length()), 0);
        for (int i = start; i < limit; ++i) {
            if (toBeFound != searchIn.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence toBeFound, CharSequence searchIn) {
        return Strings.indexOf(toBeFound, searchIn, 0);
    }

    public static int indexOf(CharSequence toBeFound, CharSequence searchIn, int start) {
        return Strings.indexOf(toBeFound, searchIn, start, searchIn.length());
    }

    public static int indexOf(CharSequence toBeFound, CharSequence searchIn, int start, int end) {
        int toBeFoundLength = toBeFound.length();
        if (toBeFoundLength > end || start < 0) {
            return -1;
        }
        if (toBeFoundLength == 0) {
            return 0;
        }
        int max = end - toBeFoundLength + 1;
        block0: for (int i = start; i < max; ++i) {
            if (searchIn.charAt(i) != toBeFound.charAt(0)) continue;
            for (int j = 1; j < toBeFoundLength; ++j) {
                if (searchIn.charAt(i + j) != toBeFound.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] toBeFound, char[] searchIn) {
        return Strings.indexOf(toBeFound, searchIn, 0);
    }

    public static int indexOf(char[] toBeFound, char[] searchIn, int start) {
        return Strings.indexOf(toBeFound, searchIn, start, searchIn.length);
    }

    public static int indexOf(char[] toBeFound, char[] searchIn, int start, int end) {
        return Strings.indexOf(toBeFound, searchIn, start, end, true);
    }

    public static int indexOf(char[] toBeFound, char[] searchIn, int start, int end, boolean isCaseSensitive) {
        int toBeFoundLength = toBeFound.length;
        if (toBeFoundLength > end || start < 0) {
            return -1;
        }
        if (toBeFoundLength == 0) {
            return 0;
        }
        if (isCaseSensitive) {
            int max = end - toBeFoundLength + 1;
            block0: for (int i = start; i < max; ++i) {
                if (searchIn[i] != toBeFound[0]) continue;
                for (int j = 1; j < toBeFoundLength; ++j) {
                    if (searchIn[i + j] != toBeFound[j]) continue block0;
                }
                return i;
            }
        } else {
            int max = end - toBeFoundLength + 1;
            block2: for (int i = start; i < max; ++i) {
                if (Character.toLowerCase(searchIn[i]) != Character.toLowerCase(toBeFound[0])) continue;
                for (int j = 1; j < toBeFoundLength; ++j) {
                    if (Character.toLowerCase(searchIn[i + j]) != Character.toLowerCase(toBeFound[j])) continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char toBeFound, CharSequence searchIn) {
        return Strings.lastIndexOf(toBeFound, searchIn, 0);
    }

    public static int lastIndexOf(char toBeFound, CharSequence searchIn, int startIndex) {
        return Strings.lastIndexOf(toBeFound, searchIn, startIndex, searchIn.length());
    }

    public static int lastIndexOf(char toBeFound, CharSequence searchIn, int startIndex, int endIndex) {
        int i = endIndex;
        while (--i >= startIndex) {
            if (toBeFound != searchIn.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static int nextLineEnd(CharSequence searchIn, int offset) {
        int nlPos = Strings.indexOf('\n', searchIn, offset);
        if (nlPos < 0) {
            return searchIn.length();
        }
        if (nlPos > 0 && searchIn.charAt(nlPos - 1) == '\r') {
            --nlPos;
        }
        return nlPos;
    }

    public static CharSequence replace(CharSequence text, char search, char replacement) {
        if (text == null) {
            return null;
        }
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == search) {
                result.append(replacement);
                continue;
            }
            result.append(c);
        }
        return result;
    }

    public static char[] toCharArray(CharSequence s) {
        if (s instanceof StringBuilder) {
            StringBuilder sb = (StringBuilder)s;
            char[] buf = new char[s.length()];
            sb.getChars(0, buf.length, buf, 0);
            return buf;
        }
        if (s instanceof String) {
            String str = (String)s;
            return str.toCharArray();
        }
        if (s instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)s;
            return cb.array();
        }
        if (s instanceof StringBuffer) {
            StringBuffer sb = (StringBuffer)s;
            char[] buf = new char[s.length()];
            sb.getChars(0, buf.length, buf, 0);
            return buf;
        }
        char[] arr = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            arr[i] = s.charAt(i);
        }
        return arr;
    }

    public static CharSequence repeat(CharSequence str, int n) {
        if (str == null) {
            return null;
        }
        return str.toString().repeat(n);
    }

    public static CharSequence replace(CharSequence text, CharSequence searchString, CharSequence replacement) {
        if (Strings.isEmpty(text) || Strings.isEmpty(searchString) || replacement == null || Objects.equals(searchString, replacement)) {
            return text;
        }
        int start = 0;
        int end = Strings.indexOf(searchString, text, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = Math.max(increase, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            end = Strings.indexOf(searchString, text, start);
        }
        buf.append(text.subSequence(start, text.length()));
        return buf;
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (Strings.isEmpty(str) || Strings.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = Strings.indexOf(sub, str, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.isEmpty();
    }

    public static StringBuilder fromFile(Path file, Charset charset) throws IOException {
        Ensure.notNull(file);
        Ensure.notNull(charset);
        int size = (int)Files.size(file);
        try (BufferedReader reader = Files.newBufferedReader(file, charset);){
            StringBuilder stringBuilder = Strings.read(reader, size);
            return stringBuilder;
        }
    }

    public static StringBuilder fromInputStream(InputStream is, String charsetName) throws IOException {
        return Strings.fromInputStream(is, Charset.forName(charsetName));
    }

    public static StringBuilder fromInputStream(InputStream is, Charset charset) throws IOException {
        return Strings.fromInputStream(is, charset, -1);
    }

    public static StringBuilder fromInputStream(InputStream is, Charset charset, int estimatedSize) throws IOException {
        return Strings.read(new BufferedReader(new InputStreamReader(is, charset)), estimatedSize);
    }

    private static StringBuilder read(Reader in, int estimatedSize) throws IOException {
        int length;
        char[] buffer = new char[8192];
        StringBuilder out = new StringBuilder(estimatedSize > 0 ? estimatedSize : buffer.length);
        while ((length = in.read(buffer)) != -1) {
            out.append(buffer, 0, length);
        }
        return out;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String fromThrowable(Throwable t) {
        try (StringWriter w = new StringWriter();){
            PrintWriter p = new PrintWriter(w);
            try {
                t.printStackTrace(p);
                StringBuffer buffer = w.getBuffer();
                buffer.delete(buffer.length() - System.lineSeparator().length(), buffer.length());
                String string = w.toString();
                p.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "[" + e.toString() + "]" + String.valueOf(t);
        }
    }

    public static CharSequence withoutQuotes(CharSequence literal) {
        return Strings.withoutQuotes(literal, true, true, true);
    }

    public static CharSequence withoutQuotes(CharSequence literal, boolean removeDouble, boolean removeSingle, boolean removeBackTick) {
        boolean needsProcessing;
        if (literal == null || literal.length() < 2) {
            return literal;
        }
        boolean bl = needsProcessing = removeDouble || removeSingle || removeBackTick;
        if (!needsProcessing) {
            return literal;
        }
        boolean[] enabled = new boolean[]{removeDouble, removeSingle, removeBackTick};
        char[] toRemove = new char[]{'\"', '\'', '`'};
        for (int i = 0; i < toRemove.length; ++i) {
            if (!enabled[i] || literal.charAt(0) != toRemove[i] || literal.charAt(literal.length() - 1) != toRemove[i]) continue;
            return literal.subSequence(1, literal.length() - 1);
        }
        return literal;
    }

    public static CharSequence capitalize(CharSequence name) {
        if (Strings.isEmpty(name) || Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        return new StringBuilder(name.length()).append(Character.toUpperCase(name.charAt(0))).append(name, 1, name.length());
    }

    public static List<CharSequence> capitalize(Collection<? extends CharSequence> names) {
        return ((Collection)Optional.ofNullable(names).orElse(Collections.emptyList())).stream().map(Strings::capitalize).collect(Collectors.toList());
    }

    public static List<CharSequence> decapitalize(Collection<? extends CharSequence> names) {
        return ((Collection)Optional.ofNullable(names).orElse(Collections.emptyList())).stream().map(s -> s != null ? Introspector.decapitalize(s.toString()) : null).collect(Collectors.toList());
    }

    public static CharSequence escapeHtml(CharSequence html) {
        return Strings.replaceEach(html, new CharSequence[]{"\"", "&", "<", ">", "'", "/"}, new CharSequence[]{"&#34;", "&#38;", "&#60;", "&#62;", "&#39;", "&#47;"});
    }

    public static CharSequence replaceEach(CharSequence text, CharSequence[] searchList, CharSequence[] replacementList) {
        int tempIndex;
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (searchList == null || searchList.length == 0) {
            return text;
        }
        if (replacementList == null || replacementList.length == 0) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw Ensure.newFail("Search and Replace array lengths don't match: {} vs {}", searchLength, replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
            tempIndex = Strings.indexOf(searchList[i], text);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = Strings.getLengthIncreaseGuess(text, searchList, replacementList);
        StringBuilder result = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                result.append(text.charAt(i));
            }
            result.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = Strings.indexOf(searchList[i], text, start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            result.append(text.charAt(i));
        }
        return result;
    }

    private static int getLengthIncreaseGuess(CharSequence text, CharSequence[] searchList, CharSequence[] replacementList) {
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int longer;
            if (searchList[i] == null || replacementList[i] == null || (longer = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * longer;
        }
        return Math.min(increase, text.length() / 5);
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null || cs.isEmpty()) {
            return true;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (Strings.isInvisible(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvisible(char c) {
        return c <= ' ' || Character.isWhitespace(c);
    }

    public static CharSequence trim(CharSequence cs) {
        int start;
        if (cs == null) {
            return null;
        }
        int len = cs.length();
        if (len == 0) {
            return cs;
        }
        for (start = 0; start < len && Strings.isInvisible(cs.charAt(start)); ++start) {
        }
        if (start >= len) {
            return new StringBuilder(0);
        }
        int end = len;
        while (start < --end && Strings.isInvisible(cs.charAt(end))) {
        }
        StringBuilder result = new StringBuilder(++end - start);
        result.append(cs, start, end);
        return result;
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return Strings.startsWith(str, prefix, true);
    }

    public static boolean startsWith(CharSequence str, char c) {
        return Strings.startsWith(str, c, true);
    }

    public static boolean startsWith(CharSequence str, char c, boolean isCaseSensitive) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char first = str.charAt(0);
        char prefix = c;
        if (!isCaseSensitive) {
            prefix = Character.toLowerCase(prefix);
            first = Character.toLowerCase(first);
        }
        return first == prefix;
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix, boolean isCaseSensitive) {
        int prefixLength;
        if (str == null || prefix == null) {
            return false;
        }
        int strLength = str.length();
        if (strLength < (prefixLength = prefix.length())) {
            return false;
        }
        if (prefixLength == 0) {
            return true;
        }
        PrimitiveIterator.OfInt prefixIter = prefix.codePoints().iterator();
        PrimitiveIterator.OfInt strIter = str.codePoints().iterator();
        if (isCaseSensitive) {
            while (prefixIter.hasNext() && strIter.hasNext()) {
                if (prefixIter.nextInt() == strIter.nextInt()) continue;
                return false;
            }
        } else {
            while (prefixIter.hasNext() && strIter.hasNext()) {
                if (Character.toLowerCase(prefixIter.nextInt()) == Character.toLowerCase(strIter.nextInt())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean startsWith(String str, String prefix) {
        return Strings.startsWith(str, prefix, true);
    }

    public static boolean startsWith(String str, String prefix, boolean isCaseSensitive) {
        int prefixLength;
        if (str == null || prefix == null) {
            return false;
        }
        int stringLength = str.length();
        return stringLength >= (prefixLength = prefix.length()) && str.regionMatches(!isCaseSensitive, 0, prefix, 0, prefixLength);
    }

    public static boolean endsWith(CharSequence string, CharSequence suffix) {
        return Strings.endsWith(string, suffix, true);
    }

    public static boolean endsWith(CharSequence string, CharSequence suffix, boolean isCaseSensitive) {
        int suffixLength;
        if (string == null || suffix == null) {
            return false;
        }
        int stringLength = string.length();
        if (stringLength < (suffixLength = suffix.length())) {
            return false;
        }
        if (suffixLength == 0) {
            return true;
        }
        if (isCaseSensitive) {
            int i = stringLength - 1;
            for (int j = suffixLength - 1; j >= 0; --j) {
                if (string.charAt(i) != suffix.charAt(j)) {
                    return false;
                }
                --i;
            }
        } else {
            int i = stringLength - 1;
            for (int j = suffixLength - 1; j >= 0; --j) {
                if (Character.toLowerCase(string.charAt(i)) != Character.toLowerCase(suffix.charAt(j))) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public static boolean hasText(CharSequence cs) {
        return !Strings.isBlank(cs);
    }

    public static <T extends CharSequence> Optional<T> notEmpty(T value) {
        if (Strings.isEmpty(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static <T extends CharSequence> Optional<T> notBlank(T value) {
        if (Strings.isBlank(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static int compareTo(CharSequence a, CharSequence b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int limit = Math.min(a.length(), b.length());
        for (int i = 0; i < limit; ++i) {
            char y;
            char x = a.charAt(i);
            int diff = x - (y = b.charAt(i));
            if (diff == 0) continue;
            return diff;
        }
        return a.length() - b.length();
    }

    public static int levenshteinDistance(CharSequence s1, CharSequence s2) {
        int i;
        if (s1 == null || s2 == null || s1.equals(s2)) {
            return 0;
        }
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int[] col0 = new int[l1 + 1];
        int[] col1 = new int[l1 + 1];
        for (i = 0; i <= l1; ++i) {
            col0[i] = i;
        }
        for (int j = 1; j <= l2; ++j) {
            char jth = s2.charAt(j - 1);
            col1[0] = j;
            for (i = 1; i <= l1; ++i) {
                int cost = s1.charAt(i - 1) == jth ? 0 : 1;
                col1[i] = Math.min(Math.min(col1[i - 1] + 1, col0[i] + 1), col0[i - 1] + cost);
            }
            int[] col = col0;
            col0 = col1;
            col1 = col;
        }
        return col0[l1];
    }

    public static String removeSuffix(String string, CharSequence suffix) {
        return Strings.removeSuffix(string, suffix, true);
    }

    public static String removeSuffix(String string, CharSequence suffix, boolean isCaseSensitive) {
        if (Strings.endsWith(string, suffix, isCaseSensitive) && !suffix.isEmpty()) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String removePrefix(String string, CharSequence prefix) {
        return Strings.removePrefix(string, prefix, true);
    }

    public static String removePrefix(String string, CharSequence prefix, boolean isCaseSensitive) {
        if (Strings.startsWith((CharSequence)string, prefix, isCaseSensitive)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String camelCaseToScreamingSnakeCase(CharSequence s) {
        if (s == null) {
            return null;
        }
        return String.join((CharSequence)"_", CAMEL_TO_SCREAMING_SNAKE_PAT.split(s)).toUpperCase(Locale.US);
    }

    public static String screamingSnakeCaseToCamelCase(CharSequence s) {
        if (s == null) {
            return null;
        }
        return SCREAMING_SNAKE_TO_CAMEL_PAT.splitAsStream(s).filter(Predicate.not(Strings::isEmpty)).map(c -> Strings.capitalize(c.toLowerCase(Locale.US))).collect(Collectors.joining());
    }
}

