/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Location;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IField;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.internal.FieldImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationFieldWithEcj
extends AbstractMemberWithEcj<IField>
implements FieldSpi {
    private final DeclarationTypeWithEcj m_declaringType;
    private final FieldDeclaration m_astNode;
    private final char[] m_name;
    private final FinalValue<String> m_nameAsString;
    private final FinalValue<TypeSpi> m_type;
    private final FinalValue<List<DeclarationAnnotationWithEcj>> m_annotations;
    private final FinalValue<IMetaValue> m_constRef;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_initSource;
    private final FinalValue<SourceRange> m_javaDocSource;
    private int m_flags;

    protected DeclarationFieldWithEcj(AbstractJavaEnvironment env, DeclarationTypeWithEcj declaringType, FieldDeclaration astNode) {
        super(env);
        this.m_declaringType = (DeclarationTypeWithEcj)((Object)Ensure.notNull((Object)((Object)declaringType)));
        this.m_astNode = (FieldDeclaration)Ensure.notNull((Object)astNode);
        this.m_name = astNode.name != null ? astNode.name : CharOperation.NO_CHAR;
        this.m_flags = -1;
        this.m_nameAsString = new FinalValue();
        this.m_type = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_constRef = new FinalValue();
        this.m_source = new FinalValue();
        this.m_initSource = new FinalValue();
        this.m_javaDocSource = new FinalValue();
    }

    public FieldSpi internalFindNewElement() {
        TypeSpi newType = this.getDeclaringType().internalFindNewElement();
        if (newType == null) {
            return null;
        }
        return newType.getFields().stream().filter(newField -> this.getElementName().equals(newField.getElementName())).findFirst().orElse(null);
    }

    protected IField internalCreateApi() {
        return new FieldImplementor((FieldSpi)this);
    }

    public FieldDeclaration getInternalFieldDeclaration() {
        return this.m_astNode;
    }

    public DeclarationTypeWithEcj getDeclaringType() {
        return this.m_declaringType;
    }

    protected static Object computeConstantValue(DeclarationFieldWithEcj f) {
        return SpiWithEcjUtils.compileExpression(f.m_astNode.initialization, null, f.javaEnvWithEcj());
    }

    public IMetaValue getConstantValue() {
        return (IMetaValue)this.m_constRef.computeIfAbsentAndGet(() -> SpiWithEcjUtils.resolveCompiledValue(this.javaEnvWithEcj(), (AnnotatableSpi)this, DeclarationFieldWithEcj.computeConstantValue(this), () -> this.withNewElement(DeclarationFieldWithEcj::computeConstantValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TypeBinding getDataTypeBinding(DeclarationFieldWithEcj fd) {
        TypeBinding tb = fd.m_astNode.type.resolvedType;
        if (tb != null) {
            return tb;
        }
        Object object = fd.javaEnvWithEcj().lock();
        synchronized (object) {
            return fd.m_astNode.type.resolveType(SpiWithEcjUtils.classScopeOf(fd));
        }
    }

    public TypeSpi getDataType() {
        return (TypeSpi)this.m_type.computeIfAbsentAndGet(() -> {
            if (this.m_astNode.type == null) {
                return this.javaEnvWithEcj().createVoidType();
            }
            return SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), DeclarationFieldWithEcj.getDataTypeBinding(this), () -> (TypeBinding)this.withNewElement(DeclarationFieldWithEcj::getDataTypeBinding));
        });
    }

    public List<DeclarationAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createDeclarationAnnotations(this.javaEnvWithEcj(), (AnnotatableSpi)this, this.m_astNode.annotations));
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getTypeFlags(this.m_astNode.modifiers, null, SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    public String getElementName() {
        return (String)this.m_nameAsString.computeIfAbsentAndGet(() -> new String(this.m_name));
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return Collections.emptyList();
    }

    public boolean hasTypeParameters() {
        return false;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> this.javaEnvWithEcj().getSource(this.m_declaringType.getCompilationUnit(), this.m_astNode.declarationSourceStart, this.m_astNode.declarationSourceEnd));
    }

    public SourceRange getSourceOfInitializer() {
        return (SourceRange)this.m_initSource.computeIfAbsentAndGet(() -> {
            CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
            if (this.m_astNode instanceof Initializer) {
                return this.javaEnvWithEcj().getSource(cu, this.m_astNode.declarationSourceStart, this.m_astNode.declarationSourceEnd);
            }
            return SpiWithEcjUtils.createSourceRange((Location)this.m_astNode.initialization, cu, this.javaEnvWithEcj());
        });
    }

    public SourceRange getJavaDoc() {
        return (SourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createSourceRange((Location)this.m_astNode.javadoc, this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj()));
    }
}

