/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.generator.nodeelement;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.scout.sdk.core.typescript.generator.AbstractTypeScriptElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.ITypeScriptElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.INodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;

public abstract class AbstractNodeElementGenerator<TYPE extends INodeElementGenerator<TYPE>>
extends AbstractTypeScriptElementGenerator<TYPE>
implements INodeElementGenerator<TYPE> {
    private final Set<Modifier> m_modifiers = new HashSet<Modifier>();
    private ITypeScriptElementGenerator<?> m_declaringGenerator;

    protected AbstractNodeElementGenerator() {
    }

    @Override
    public TYPE withModifiers(Collection<Modifier> modifiers) {
        this.m_modifiers.addAll(modifiers);
        return (TYPE)((INodeElementGenerator)this.thisInstance());
    }

    @Override
    public Collection<Modifier> modifiers() {
        return Collections.unmodifiableSet(this.m_modifiers);
    }

    @Override
    public TYPE withoutModifiers(Collection<Modifier> modifiers) {
        this.m_modifiers.removeAll(modifiers);
        return (TYPE)((INodeElementGenerator)this.thisInstance());
    }

    @Override
    public Optional<ITypeScriptElementGenerator<?>> declaringGenerator() {
        return Optional.ofNullable(this.m_declaringGenerator);
    }

    public TYPE withDeclaringGenerator(ITypeScriptElementGenerator<?> parent) {
        this.m_declaringGenerator = parent;
        return (TYPE)((INodeElementGenerator)this.thisInstance());
    }
}

