/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.ast;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.editor.ast.ASTUtils;
import org.eclipse.php.ui.editor.SharedASTProvider;

public class ASTCache {
    private final ReentrantLock fWaitLock = new ReentrantLock(true);
    private final WeakReference<ISourceModule> fInput;
    private STATES fState = STATES.NONE;
    private Program fAST = null;

    public ASTCache(@NonNull ISourceModule input) {
        this.fInput = new WeakReference<ISourceModule>(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToBeReconciled(ISourceModule input) {
        ISourceModule refInput = (ISourceModule)this.fInput.get();
        if (refInput == null || input != refInput) {
            return;
        }
        ASTCache aSTCache = this;
        synchronized (aSTCache) {
            this.fState = STATES.STARTED;
            this.fAST = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(Program ast, ISourceModule input, IProgressMonitor progressMonitor) {
        ISourceModule refInput = (ISourceModule)this.fInput.get();
        if (refInput == null || input != refInput) {
            return;
        }
        ASTCache aSTCache = this;
        synchronized (aSTCache) {
            if (ast == null) {
                this.fState = STATES.CANCELED;
                this.fAST = null;
            } else {
                this.fState = STATES.DONE;
                this.fAST = ast;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Program getAST(ISourceModule input, SharedASTProvider.WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        if (waitFlag == SharedASTProvider.WAIT_ACTIVE_ONLY) {
            throw new IllegalArgumentException("Flag WAIT_ACTIVE_ONLY is unsupported");
        }
        ISourceModule refInput = (ISourceModule)this.fInput.get();
        if (refInput == null) return null;
        if (input != refInput) {
            return null;
        }
        ASTCache aSTCache = this;
        synchronized (aSTCache) {
            if (waitFlag == SharedASTProvider.WAIT_NO) return this.fAST;
            if (this.fState == STATES.DONE) {
                return this.fAST;
            }
        }
        if (!this.fWaitLock.tryLock(30L, TimeUnit.SECONDS)) return null;
        boolean isReconciling = false;
        int nbIterations = 300;
        do {
            ASTCache aSTCache2 = this;
            synchronized (aSTCache2) {
                block33: {
                    if (this.fState != STATES.DONE) break block33;
                    Program program = this.fAST;
                    return program;
                }
                if (this.fState == STATES.STARTED) {
                    isReconciling = true;
                } else {
                    nbIterations = 0;
                    this.fState = STATES.STARTED;
                }
            }
            if (!isReconciling || nbIterations <= 0) continue;
            Thread.sleep(100L);
            if (--nbIterations != 0 && this.fInput.get() != null) continue;
            aSTCache2 = this;
            synchronized (aSTCache2) {
                this.fState = STATES.CANCELED;
                Program program = this.fAST = null;
                return program;
            }
        } while (isReconciling && nbIterations > 0);
        Program currentAST = ASTUtils.createAST(input, progressMonitor);
        ASTCache aSTCache3 = this;
        synchronized (aSTCache3) {
            try {
                if (currentAST == null) {
                    this.fState = STATES.CANCELED;
                    this.fAST = null;
                    return this.fAST;
                } else {
                    this.fState = STATES.DONE;
                    this.fAST = currentAST;
                }
                return this.fAST;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable e) {
                    ASTCache aSTCache4 = this;
                    synchronized (aSTCache4) {
                        this.fState = STATES.CANCELED;
                        this.fAST = null;
                        return null;
                    }
                }
            }
        }
        finally {
            if (this.fWaitLock.isHeldByCurrentThread()) {
                this.fWaitLock.unlock();
            }
        }
    }

    public ISourceModule getInput() {
        return (ISourceModule)this.fInput.get();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ASTCache)) {
            return false;
        }
        ISourceModule thisInput = (ISourceModule)this.fInput.get();
        ISourceModule otherInput = (ISourceModule)((ASTCache)obj).fInput.get();
        return thisInput != null && otherInput != null && thisInput == otherInput;
    }

    static enum STATES {
        NONE,
        STARTED,
        DONE,
        CANCELED;

    }
}

