/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;

public class VariablesUtil {
    public static final String[] SUPER_GLOBAL_NAMES = new String[]{"$GLOBALS", "$_SERVER", "$_GET", "$_POST", "$_FILES", "$_COOKIE", "$_SESSION", "$_REQUEST", "$_ENV"};
    public static final String THIS = "$this";
    public static final String CLASS_INDICATOR = "<class>";

    private VariablesUtil() {
    }

    public static boolean isSuperGlobal(String name) {
        int i = 0;
        while (i < SUPER_GLOBAL_NAMES.length) {
            if (SUPER_GLOBAL_NAMES[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isThis(String name) {
        return THIS.equalsIgnoreCase(name);
    }

    public static boolean isClassIndicator(String name) {
        return CLASS_INDICATOR.equalsIgnoreCase(name);
    }

    public static void sortContextMembers(Object[] members) {
        if (members != null) {
            Arrays.sort(members, new ContextMembersComparator());
        }
    }

    public static void sortObjectMembers(Object[] members) {
        if (members != null) {
            Arrays.sort(members, new ObjectMembersComparator());
        }
    }

    private static final class ContextMembersComparator
    implements Comparator<Object> {
        private ContextMembersComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof IVariableFacet) && !(o2 instanceof IVariableFacet)) {
                return 0;
            }
            return this.getPriority((IVariableFacet)o1) - this.getPriority((IVariableFacet)o2);
        }

        private int getPriority(IVariableFacet facet) {
            if (facet.hasFacet(IVariableFacet.Facet.KIND_THIS) || facet.hasFacet(IVariableFacet.Facet.VIRTUAL_CLASS)) {
                return 0;
            }
            if (facet.hasFacet(IVariableFacet.Facet.KIND_LOCAL)) {
                return 1;
            }
            if (facet.hasFacet(IVariableFacet.Facet.KIND_SUPER_GLOBAL)) {
                return 2;
            }
            return 3;
        }
    }

    private static final class ObjectMembersComparator
    implements Comparator<Object> {
        private ObjectMembersComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof IVariableFacet) && !(o2 instanceof IVariableFacet)) {
                return 0;
            }
            int facetOrderDiff = this.getPriority((IVariableFacet)o1) - this.getPriority((IVariableFacet)o2);
            if (facetOrderDiff == 0) {
                if (o1 instanceof IVariable && o2 instanceof IVariable) {
                    try {
                        return ((IVariable)o1).getName().compareToIgnoreCase(((IVariable)o2).getName());
                    }
                    catch (DebugException e) {
                        return 0;
                    }
                }
                if (o1 instanceof Expression && o2 instanceof Expression) {
                    String o2name;
                    int o2idx;
                    String o1name = ((Expression)o1).getLastName();
                    int o1idx = o1name.lastIndexOf(58);
                    if (o1idx != -1) {
                        o1name = o1name.substring(o1idx + 1);
                    }
                    if ((o2idx = (o2name = ((Expression)o2).getLastName()).lastIndexOf(58)) != -1) {
                        o2name = o2name.substring(o2idx + 1);
                    }
                    return o1name.compareToIgnoreCase(o2name);
                }
                return facetOrderDiff;
            }
            return facetOrderDiff;
        }

        private int getPriority(IVariableFacet facet) {
            if (facet.hasFacet(IVariableFacet.Facet.MOD_STATIC)) {
                return 0;
            }
            return 1;
        }
    }
}

