/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class ClangdCompilationDatabaseSetterBase {
    public static final String CLANGD_CONFIG_FILE_NAME = ".clangd";
    private static final String COMPILE_FLAGS = "CompileFlags";
    private static final String COMPILATTION_DATABASE = "CompilationDatabase";
    protected static final String SET_COMPILATION_DB = "CompileFlags: {CompilationDatabase: %s}";
    private static final String BACKSLASH_REGEX = "\\\\";
    private static final String BACKSLASH_ESCAPE = "\\\\\\\\";
    private final Pattern pathMatchPattern = Pattern.compile("(?<=CompilationDatabase:)[^,}]*");
    private final Pattern pathGroupPattern = Pattern.compile(".*CompilationDatabase:\\s*([^,}]*).*");

    public WorkspaceJob setCompilationDatabase(final IProject project, final String databaseDirectoryPath) {
        final IFile configFile = project.getFile(CLANGD_CONFIG_FILE_NAME);
        WorkspaceJob updateClangdJob = new WorkspaceJob("Update .clangd"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    if (ClangdCompilationDatabaseSetterBase.this.createClangdConfigFile(configFile, project.getDefaultCharset(), databaseDirectoryPath, false)) {
                        return Status.OK_STATUS;
                    }
                    ClangdCompilationDatabaseSetterBase.this.updateClangdConfigFile(configFile, project.getDefaultCharset(), databaseDirectoryPath, monitor);
                }
                catch (CoreException e) {
                    Platform.getLog(((Object)((Object)this)).getClass()).log(e.getStatus());
                }
                catch (IOException | IllegalArgumentException e) {
                    Platform.getLog(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        updateClangdJob.setRule((ISchedulingRule)(configFile.exists() ? configFile : project));
        updateClangdJob.setSystem(true);
        updateClangdJob.schedule();
        return updateClangdJob;
    }

    private void updateClangdConfigFile(IFile configFile, String charset, String databaseDirectoryPath, IProgressMonitor monitor) throws CoreException, IOException {
        if (configFile.getLocation() != null) {
            List<String> lines = this.readClangdConfigFile(configFile);
            boolean isBlank = true;
            int i = 0;
            while (i < lines.size()) {
                String line = lines.get(i);
                isBlank &= line.isBlank();
                Matcher pathGroupMatcher = this.pathGroupPattern.matcher(line);
                if (pathGroupMatcher.matches() && !databaseDirectoryPath.contentEquals(pathGroupMatcher.replaceAll("$1").trim())) {
                    lines.set(i, this.pathMatchPattern.matcher(line).replaceAll(" " + databaseDirectoryPath.replaceAll(BACKSLASH_REGEX, BACKSLASH_ESCAPE)));
                    this.writeClangdConfigFile(configFile, charset, lines, monitor);
                    break;
                }
                ++i;
            }
            if (isBlank) {
                this.createClangdConfigFile(configFile, charset, databaseDirectoryPath, true);
            }
        }
    }

    private List<String> readClangdConfigFile(IFile configFile) throws IOException, CoreException {
        ArrayList<String> lines = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(configFile.getContents()));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lines;
    }

    private void writeClangdConfigFile(IFile configFile, String charset, List<String> lines, IProgressMonitor monitor) throws UnsupportedEncodingException, CoreException {
        StringBuilder stringBuilder = new StringBuilder();
        AtomicInteger counter = new AtomicInteger(0);
        int size = lines.size();
        String lineSeparator = System.lineSeparator();
        lines.stream().forEach(line -> {
            if (counter.incrementAndGet() == size) {
                stringBuilder.append((String)line);
            } else {
                stringBuilder.append((String)line).append(lineSeparator);
            }
        });
        configFile.setContents(stringBuilder.toString().getBytes(charset), 2, monitor);
    }

    private boolean createClangdConfigFile(IFile configFile, String charset, String databasePath, boolean overwriteContent) {
        block17: {
            if (!configFile.exists() || overwriteContent) {
                block16: {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    ByteArrayInputStream data = new ByteArrayInputStream(String.format(SET_COMPILATION_DB, databasePath).getBytes(charset));
                    try {
                        if (overwriteContent) {
                            configFile.setContents((InputStream)data, 2, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            configFile.create((InputStream)data, false, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (data == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (data != null) {
                                    data.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (CoreException e) {
                            Platform.getLog(this.getClass()).log(e.getStatus());
                            break block17;
                        }
                        catch (IOException e) {
                            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                        }
                    }
                    data.close();
                }
                return true;
            }
        }
        return false;
    }
}

