/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.internal.errorparsers.FixitManager;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DescriptionBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ParallelBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.StepBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String CONSOLE_HEADER = "ManagedMakeBuilder.message.console.header";
    private static final String ERROR_HEADER = "GeneratedmakefileBuilder error [";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private static final String NOTHING_BUILT = "ManagedMakeBuilder.message.no.build";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "GeneratedmakefileBuilder trace [";
    private static final String TYPE_CLEAN = "ManagedMakeBuilder.type.clean";
    private static final String TYPE_INC = "ManagedMakeBuider.type.incremental";
    private static final String WARNING_UNSUPPORTED_CONFIGURATION = "ManagedMakeBuilder.warning.unsupported.configuration";
    private static final String BUILD_CANCELLED = "ManagedMakeBuilder.message.cancelled";
    private static final String BUILD_FINISHED_WITH_ERRS = "ManagedMakeBuilder.message.finished.with.errs";
    private static final String BUILD_FAILED_ERR = "ManagedMakeBuilder.message.internal.builder.error";
    private static final String BUILD_STOPPED_ERR = "ManagedMakeBuilder.message.stopped.error";
    private static final String INTERNAL_BUILDER_HEADER_NOTE = "ManagedMakeBuilder.message.internal.builder.header.note";
    private static final String TYPE_REBUILD = "ManagedMakeBuider.type.rebuild";
    private static final String INTERNAL_BUILDER = "ManagedMakeBuilder.message.internal.builder";
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_DELETE_MARKERS = 100;
    public static boolean VERBOSE = false;
    protected Vector<IStatus> generationProblems;
    protected IProject[] referencedProjects;
    protected List<IResource> resourcesToBuild;
    private IConsole console;

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    private void addBuilderMarkers(ErrorParserManager epm) {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        for (IStatus stat : this.getGenerationProblems()) {
            IResource location = root.findMember(stat.getMessage());
            if (stat.getCode() != 0) continue;
            epm.generateMarker(location, -1, ManagedMakeMessages.getResourceString("MakefileGenerator.error.spaces"), 1, null);
        }
    }

    private void emitNoSourceMessage(int buildType, IStatus status, String configName) throws CoreException {
        try {
            StringBuilder buf = new StringBuilder();
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(this.getProject());
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[3];
            if (buildType == 6 || buildType == 10) {
                consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
            } else {
                consoleHeader[0] = "";
                GeneratedMakefileBuilder.outputError(this.getProject().getName(), "The given build type is not supported in this context");
            }
            consoleHeader[1] = configName;
            consoleHeader[2] = this.getProject().getName();
            buf.append(NEWLINE);
            buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader)).append(NEWLINE);
            buf.append(NEWLINE);
            buf.append(status.getMessage()).append(NEWLINE);
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected IManagedBuildInfo getBuildInfo() {
        return ManagedBuildManager.getBuildInfo((IResource)this.getProject());
    }

    protected IProject[] build(int kind, Map argsMap, IProgressMonitor monitor) throws CoreException {
        Map args = argsMap;
        this.referencedProjects = this.getProject().getReferencedProjects();
        IManagedBuildInfo info = this.getBuildInfo();
        if (info == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return this.referencedProjects;
        }
        if (!info.isValid()) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information is not valid");
            return this.referencedProjects;
        }
        IConfiguration[] cfgs = null;
        cfgs = GeneratedMakefileBuilder.needAllConfigBuild() ? info.getManagedProject().getConfigurations() : new IConfiguration[]{info.getDefaultConfiguration()};
        IConfiguration[] iConfigurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            this.updateOtherConfigs(cfg, kind);
            if (((Configuration)cfg).isInternalBuilderEnabled()) {
                this.invokeInternalBuilder(cfg, kind != 6, ((Configuration)cfg).getInternalBuilderIgnoreErr(), monitor);
                info.setRebuildState(false);
                return this.referencedProjects;
            }
            IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getBuildfileGenerator(info.getDefaultConfiguration());
            generator.initialize(this.getProject(), info, monitor);
            if (cfg.needsFullRebuild()) {
                GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "config rebuild state is set to true, making a full rebuild");
                this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                this.fullBuild(info, generator, monitor);
            } else {
                IResourceDelta delta;
                boolean fullBuildNeeded;
                block14: {
                    fullBuildNeeded = info.needsRebuild();
                    IBuildDescription des = null;
                    IResourceDelta iResourceDelta = delta = kind == 6 ? null : this.getDelta(this.getProject());
                    if (delta == null) {
                        fullBuildNeeded = true;
                    }
                    if (cfg.needsRebuild() || delta != null) {
                        try {
                            int flags = 14;
                            if (delta != null) {
                                flags |= 1;
                            }
                            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "using a build description..");
                            des = BuildDescriptionManager.createBuildDescription(info.getDefaultConfiguration(), this.getDelta(this.getProject()), flags);
                            BuildDescriptionManager.cleanGeneratedRebuildResources(des);
                        }
                        catch (Throwable e) {
                            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "error occured while build description calculation: " + e.getLocalizedMessage());
                            if (info.needsRebuild()) {
                                this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                                fullBuildNeeded = true;
                            }
                            if (delta == null || fullBuildNeeded) break block14;
                            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(info);
                            delta.accept((IResourceDeltaVisitor)visitor);
                            if (!visitor.shouldBuildFull()) break block14;
                            this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                            fullBuildNeeded = true;
                        }
                    }
                }
                if (fullBuildNeeded) {
                    GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "performing a full build");
                    this.fullBuild(info, generator, monitor);
                } else {
                    GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "performing an incremental build");
                    this.incrementalBuild(delta, info, generator, monitor);
                }
            }
            ++n2;
        }
        info.setRebuildState(false);
        return this.referencedProjects;
    }

    private void updateOtherConfigs(IConfiguration cfg, int buildKind) {
        new OtherConfigVerifier(cfg).updateOtherConfigs(buildKind == 6 ? null : this.getDelta(this.getProject()));
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Build cancelled");
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Clean build requested");
        IManagedBuildInfo info = this.getBuildInfo();
        if (info == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return;
        }
        if (!info.isValid()) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information is not valid");
            return;
        }
        IPath buildDirPath = this.getProject().getLocation().append(info.getConfigurationName());
        IWorkspace workspace = CCorePlugin.getWorkspace();
        IContainer buildDir = workspace.getRoot().getContainerForLocation(buildDirPath);
        if (buildDir == null || !buildDir.isAccessible()) {
            GeneratedMakefileBuilder.outputError(buildDir == null ? "null" : buildDir.getName(), "Could not delete the build directory");
            return;
        }
        try {
            String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.deleting.output", buildDir.getName());
            monitor.subTask(status);
            workspace.delete(new IResource[]{buildDir}, true, monitor);
            StringBuilder buf = new StringBuilder();
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(this.getProject());
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[]{ManagedMakeMessages.getResourceString(TYPE_CLEAN), info.getConfigurationName(), this.getProject().getName()};
            buf.append(NEWLINE);
            buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader)).append(NEWLINE);
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            buf = new StringBuilder();
            String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
            buf.append(successMsg).append(NEWLINE);
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (CoreException e) {
            String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.build.clean", buildDir.getName());
            monitor.subTask(status);
            IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getBuildfileGenerator(info.getDefaultConfiguration());
            generator.initialize(this.getProject(), info, monitor);
            this.cleanBuild(info, generator, monitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void cleanBuild(IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) {
        IPath buildDir = generator.getBuildWorkingDir();
        if (buildDir == null) {
            buildDir = new Path(info.getConfigurationName());
        }
        IPath makefilePath = this.getProject().getLocation().append(buildDir.append(generator.getMakefileName()));
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile makefile = root.getFileForLocation(makefilePath);
        if (makefile != null && makefile.isAccessible()) {
            String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
            monitor.subTask(statusMsg);
            this.checkCancel(monitor);
            this.invokeMake(15, buildDir, info, generator, monitor);
        }
    }

    protected void fullBuild(IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.rebuild.makefiles", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.initialize(this.getProject(), info, monitor);
        MultiStatus result = generator.regenerateMakefiles();
        if (result.getCode() == 2 || result.getCode() == 1) {
            IStatus[] kids = result.getChildren();
            int index = 0;
            while (index < kids.length) {
                IStatus status = kids[index];
                if (status.getCode() == 1) {
                    this.emitNoSourceMessage(6, status, info.getConfigurationName());
                    return;
                }
                this.getGenerationProblems().add(status);
                ++index;
            }
        }
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        monitor.subTask(statusMsg);
        IPath topBuildDir = generator.getBuildWorkingDir();
        if (topBuildDir == null) {
            statusMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            monitor.subTask(statusMsg);
            return;
        }
        this.invokeMake(6, topBuildDir, info, generator, monitor);
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.regen.deps", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.regenerateDependencies(false);
        statusMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        monitor.subTask(statusMsg);
    }

    private Vector<IStatus> getGenerationProblems() {
        if (this.generationProblems == null) {
            this.generationProblems = new Vector();
        }
        return this.generationProblems;
    }

    protected String[] getMakeTargets(int buildType) {
        ArrayList<String> args = new ArrayList<String>();
        switch (buildType) {
            case 15: {
                args.add("clean");
                break;
            }
            case 6: 
            case 10: {
                args.add("all");
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected List<IResource> getResourcesToBuild() {
        if (this.resourcesToBuild == null) {
            this.resourcesToBuild = new ArrayList<IResource>();
        }
        return this.resourcesToBuild;
    }

    public IPath getWorkingDirectory() {
        return this.getProject().getLocation();
    }

    protected void incrementalBuild(IResourceDelta delta, IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.update.makefiles", this.getProject().getName());
        monitor.subTask(statusMsg);
        MultiStatus result = generator.generateMakefiles(delta);
        if (result.getCode() == 2 || result.getCode() == 1) {
            IStatus[] kids = result.getChildren();
            int index = 0;
            while (index < kids.length) {
                IStatus status = kids[index];
                if (status.getCode() == 1) {
                    this.emitNoSourceMessage(10, status, info.getConfigurationName());
                    return;
                }
                this.getGenerationProblems().add(status);
                ++index;
            }
        }
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        monitor.subTask(statusMsg);
        IPath buildDir = generator.getBuildWorkingDir();
        if (buildDir == null) {
            statusMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            monitor.subTask(statusMsg);
            return;
        }
        this.invokeMake(10, buildDir, info, generator, monitor);
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.updating.deps", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.generateDependencies();
        statusMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        monitor.subTask(statusMsg);
    }

    protected void invokeMake(int buildType, IPath buildDir, IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) {
        block51: {
            IProject project = this.getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                URI workingDirectoryURI = this.getProject().getFolder(buildDir).getLocationURI();
                String pathFromURI = EFSExtensionManager.getDefault().getPathFromURI(workingDirectoryURI);
                if (pathFromURI == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", ManagedMakeMessages.getString(BUILD_ERROR), null));
                }
                Path workingDirectory = new Path(pathFromURI);
                IWorkspace workspace = project.getWorkspace();
                if (workspace == null) {
                    return;
                }
                IWorkspaceRoot root = workspace.getRoot();
                if (root == null) {
                    return;
                }
                IPath makefile = workingDirectory.append(generator.getMakefileName());
                if (root.getFileForLocation(makefile) == null) {
                    return;
                }
                try {
                    String makeCmd = info.getBuildCommand();
                    try {
                        String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(makeCmd, "", " ", 3, info.getDefaultConfiguration());
                        resolved = resolved.trim();
                        if (resolved.length() > 0) {
                            makeCmd = resolved;
                        }
                    }
                    catch (BuildMacroException resolved) {
                        // empty catch block
                    }
                    Path makeCommand = new Path(makeCmd);
                    String[] msgs = new String[]{makeCommand.toString(), project.getName()};
                    monitor.subTask(ManagedMakeMessages.getFormattedString(MAKE, msgs));
                    StringBuilder buf = new StringBuilder();
                    IConsole console = CCorePlugin.getDefault().getConsole();
                    console.start(project);
                    ConsoleOutputStream consoleOutStream = console.getOutputStream();
                    String[] consoleHeader = new String[3];
                    switch (buildType) {
                        case 6: 
                        case 10: {
                            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
                            break;
                        }
                        case 15: {
                            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_CLEAN);
                        }
                    }
                    consoleHeader[1] = info.getConfigurationName();
                    consoleHeader[2] = project.getName();
                    buf.append(NEWLINE);
                    buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader)).append(NEWLINE);
                    buf.append(NEWLINE);
                    IConfiguration cfg = info.getDefaultConfiguration();
                    if (!cfg.isSupported()) {
                        String msg = ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{cfg.getName(), cfg.getToolChain().getName()});
                        buf.append(msg).append(NEWLINE);
                        buf.append(NEWLINE);
                    }
                    consoleOutStream.write(buf.toString().getBytes());
                    consoleOutStream.flush();
                    this.removeAllMarkers(project);
                    String errMsg = null;
                    IBuilder builder = info.getDefaultConfiguration().getBuilder();
                    ICommandLauncher launcher = builder.getCommandLauncher();
                    launcher.setProject(project);
                    launcher.showCommand(true);
                    IEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
                    String[] envp = null;
                    ArrayList<CallSite> envList = new ArrayList<CallSite>();
                    if (variables != null) {
                        int i = 0;
                        while (i < variables.length) {
                            envList.add((CallSite)((Object)(variables[i].getName() + "=" + variables[i].getValue())));
                            ++i;
                        }
                        envp = envList.toArray(new String[envList.size()]);
                    }
                    String[] errorParsers = info.getDefaultConfiguration().getErrorParserList();
                    ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectoryURI, (IMarkerGenerator)this, errorParsers);
                    epm.setOutputStream((OutputStream)consoleOutStream);
                    OutputStream epmOutputStream = epm.getOutputStream();
                    ArrayList<String> makeArgs = new ArrayList<String>();
                    String arg = info.getBuildArguments();
                    if (arg.length() > 0) {
                        String[] args = arg.split("\\s");
                        int i = 0;
                        while (i < args.length) {
                            makeArgs.add(args[i]);
                            ++i;
                        }
                    }
                    String prebuildStep = info.getPrebuildStep();
                    try {
                        prebuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prebuildStep, "", " ", 3, cfg);
                    }
                    catch (BuildMacroException buildMacroException) {
                        // empty catch block
                    }
                    boolean prebuildStepPresent = prebuildStep.length() > 0;
                    Process proc = null;
                    boolean isuptodate = false;
                    if (prebuildStepPresent) {
                        ArrayList premakeArgs = (ArrayList)makeArgs.clone();
                        switch (buildType) {
                            case 10: {
                                premakeArgs.add("-q");
                                premakeArgs.add("main-build");
                                String[] premakeTargets = premakeArgs.toArray(new String[premakeArgs.size()]);
                                proc = launcher.execute((IPath)makeCommand, premakeTargets, envp, (IPath)workingDirectory, monitor);
                                if (proc != null) {
                                    try {
                                        proc.getOutputStream().close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    if (launcher.waitAndRead(epm.getOutputStream(), epm.getOutputStream(), (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                                        errMsg = launcher.getErrorMessage();
                                    }
                                } else {
                                    errMsg = launcher.getErrorMessage();
                                }
                                if (errMsg != null && errMsg.length() > 0 || proc == null) {
                                    makeArgs.add("pre-build");
                                    makeArgs.add("main-build");
                                    break;
                                }
                                if (proc.exitValue() == 0) {
                                    isuptodate = true;
                                    String uptodateMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, project.getName());
                                    buf = new StringBuilder();
                                    buf.append(NEWLINE);
                                    buf.append(uptodateMsg).append(NEWLINE);
                                    consoleOutStream.write(buf.toString().getBytes());
                                    consoleOutStream.flush();
                                    epmOutputStream.close();
                                    consoleOutStream.close();
                                    break;
                                }
                                makeArgs.add("pre-build");
                                makeArgs.add("main-build");
                                break;
                            }
                            case 6: {
                                makeArgs.add("pre-build");
                                makeArgs.add("main-build");
                                break;
                            }
                            case 15: {
                                makeArgs.add("clean");
                            }
                        }
                    } else {
                        makeArgs.addAll(Arrays.asList(this.getMakeTargets(buildType)));
                    }
                    String[] makeTargets = makeArgs.toArray(new String[makeArgs.size()]);
                    if (isuptodate) break block51;
                    proc = launcher.execute((IPath)makeCommand, makeTargets, envp, (IPath)workingDirectory, monitor);
                    if (proc != null) {
                        try {
                            proc.getOutputStream().close();
                        }
                        catch (IOException premakeArgs) {
                            // empty catch block
                        }
                        int state = launcher.waitAndRead(epm.getOutputStream(), epm.getOutputStream(), (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                        if (state != 0) {
                            errMsg = launcher.getErrorMessage();
                            if (state == 1) {
                                info.getDefaultConfiguration().setRebuildState(true);
                            }
                        }
                        monitor.subTask(ManagedMakeMessages.getResourceString(REFRESH));
                        try {
                            RefreshScopeManager refreshManager = RefreshScopeManager.getInstance();
                            IWorkspaceRunnable runnable = refreshManager.getRefreshRunnable(project, cfg.getName());
                            ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
                        }
                        catch (CoreException e) {
                            monitor.subTask(ManagedMakeMessages.getResourceString(REFRESH_ERROR));
                        }
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    buf = new StringBuilder();
                    if (errMsg != null && errMsg.length() > 0) {
                        buf.append(errMsg).append(NEWLINE);
                    } else {
                        String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, project.getName());
                        buf.append(successMsg).append(NEWLINE);
                    }
                    consoleOutStream.write(buf.toString().getBytes());
                    consoleOutStream.flush();
                    epmOutputStream.close();
                    monitor.subTask(ManagedMakeMessages.getResourceString(MARKERS));
                    this.addBuilderMarkers(epm);
                    consoleOutStream.close();
                }
                catch (Exception e) {
                    this.forgetLastBuiltState();
                }
            }
            finally {
                this.getGenerationProblems().clear();
            }
        }
    }

    private void removeAllMarkers(IProject project) {
        IMarker[] markers;
        if (project == null || !project.isAccessible()) {
            return;
        }
        IWorkspace workspace = project.getWorkspace();
        try {
            markers = project.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        }
        catch (CoreException e) {
            return;
        }
        if (markers != null) {
            try {
                workspace.deleteMarkers(markers);
                FixitManager.getInstance().deleteMarkers(markers);
            }
            catch (CoreException e) {
                return;
            }
        }
    }

    protected void invokeInternalBuilder(IConfiguration cfg, boolean buildIncrementaly, boolean resumeOnErr, IProgressMonitor monitor) {
        block35: {
            boolean isParallel = ((Configuration)cfg).getParallelDef();
            IProject currentProject = cfg.getOwner().getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            String[] msgs = new String[]{ManagedMakeMessages.getResourceString(INTERNAL_BUILDER), currentProject.getName()};
            ConsoleOutputStream consoleOutStream = null;
            IConsole console = null;
            OutputStream epmOutputStream = null;
            try {
                try {
                    int flags = 0;
                    IResourceDelta delta = null;
                    if (buildIncrementaly) {
                        flags = 7;
                        delta = this.getDelta(currentProject);
                    }
                    IBuildDescription des = BuildDescriptionManager.createBuildDescription(cfg, delta, flags);
                    DescriptionBuilder builder = null;
                    if (!isParallel) {
                        builder = new DescriptionBuilder(des, buildIncrementaly, resumeOnErr, null);
                    }
                    StringBuilder buf = new StringBuilder();
                    console = CCorePlugin.getDefault().getConsole();
                    console.start(currentProject);
                    consoleOutStream = console.getOutputStream();
                    String[] consoleHeader = new String[]{buildIncrementaly ? ManagedMakeMessages.getResourceString(TYPE_INC) : ManagedMakeMessages.getResourceString(TYPE_REBUILD), cfg.getName(), currentProject.getName()};
                    buf.append(NEWLINE);
                    buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader)).append(NEWLINE);
                    buf.append(NEWLINE);
                    buf.append(ManagedMakeMessages.getResourceString(INTERNAL_BUILDER_HEADER_NOTE));
                    buf.append("\n");
                    if (!cfg.isSupported()) {
                        String msg = ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{cfg.getName(), cfg.getToolChain().getName()});
                        buf.append(msg).append(NEWLINE);
                        buf.append(NEWLINE);
                    }
                    consoleOutStream.write(buf.toString().getBytes());
                    consoleOutStream.flush();
                    if (isParallel || builder.getNumCommands() > 0) {
                        this.removeAllMarkers(currentProject);
                        String[] errorParsers = cfg.getErrorParserList();
                        ErrorParserManager epm = new ErrorParserManager(this.getProject(), des.getDefaultBuildDirLocationURI(), (IMarkerGenerator)this, errorParsers);
                        epm.setOutputStream((OutputStream)consoleOutStream);
                        epmOutputStream = epm.getOutputStream();
                        int status = 0;
                        long t1 = System.currentTimeMillis();
                        status = isParallel ? ParallelBuilder.build(des, null, null, epmOutputStream, epmOutputStream, monitor, resumeOnErr, buildIncrementaly) : builder.build(epmOutputStream, epmOutputStream, monitor);
                        long t2 = System.currentTimeMillis();
                        buf = new StringBuilder();
                        switch (status) {
                            case 0: {
                                buf.append(ManagedMakeMessages.getFormattedString(BUILD_FINISHED, currentProject.getName()));
                                break;
                            }
                            case -3: {
                                buf.append(ManagedMakeMessages.getResourceString(BUILD_CANCELLED));
                                break;
                            }
                            case -1: {
                                String msg = resumeOnErr ? ManagedMakeMessages.getResourceString(BUILD_FINISHED_WITH_ERRS) : ManagedMakeMessages.getResourceString(BUILD_STOPPED_ERR);
                                buf.append(msg);
                                break;
                            }
                            default: {
                                buf.append(ManagedMakeMessages.getResourceString(BUILD_FAILED_ERR));
                            }
                        }
                        buf.append(NEWLINE);
                        buf.append(ManagedMakeMessages.getFormattedString("CommonBuilder.6", Integer.toString((int)(t2 - t1))));
                        if (isParallel) {
                            buf.append(ManagedMakeMessages.getFormattedString("CommonBuilder.7", Integer.toString(ParallelBuilder.lastThreadsUsed)));
                        }
                        buf.append(NEWLINE);
                        consoleOutStream.write(buf.toString().getBytes());
                        consoleOutStream.flush();
                        epmOutputStream.close();
                        epmOutputStream = null;
                        monitor.subTask(ManagedMakeMessages.getResourceString(MARKERS));
                        this.addBuilderMarkers(epm);
                        break block35;
                    }
                    buf = new StringBuilder();
                    buf.append(ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName())).append(NEWLINE);
                    consoleOutStream.write(buf.toString().getBytes());
                    consoleOutStream.flush();
                }
                catch (Exception e) {
                    if (consoleOutStream != null) {
                        StringBuilder buf = new StringBuilder();
                        String errorDesc = ManagedMakeMessages.getResourceString(BUILD_ERROR);
                        buf.append(errorDesc).append(NEWLINE);
                        buf.append("(").append(e.getLocalizedMessage()).append(")").append(NEWLINE);
                        try {
                            consoleOutStream.write(buf.toString().getBytes());
                            consoleOutStream.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.forgetLastBuiltState();
                    if (epmOutputStream != null) {
                        try {
                            epmOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (consoleOutStream != null) {
                        try {
                            consoleOutStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.getGenerationProblems().clear();
                    monitor.done();
                }
            }
            finally {
                if (epmOutputStream != null) {
                    try {
                        epmOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (consoleOutStream != null) {
                    try {
                        consoleOutStream.close();
                    }
                    catch (IOException iOException) {}
                }
                this.getGenerationProblems().clear();
                monitor.done();
            }
        }
    }

    private Map<IProject, List<IFile>> arrangeFilesByProject(List<IFile> files) {
        HashMap<IProject, List<IFile>> projectMap = new HashMap<IProject, List<IFile>>();
        for (IFile file : files) {
            IProject project = file.getProject();
            ArrayList<IFile> filesInProject = (ArrayList<IFile>)projectMap.get(project);
            if (filesInProject == null) {
                filesInProject = new ArrayList<IFile>();
                projectMap.put(project, filesInProject);
            }
            filesInProject.add(file);
        }
        return projectMap;
    }

    public IStatus invokeInternalBuilder(List<IFile> files, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            Map<IProject, List<IFile>> projectMap = this.arrangeFilesByProject(files);
            monitor.beginTask("", projectMap.size() * 100);
            for (List<IFile> filesInProject : projectMap.values()) {
                IProject project = filesInProject.get(0).getProject();
                this.setCurrentProject(project);
                monitor.subTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.buildingProject", project.getName()));
                this.invokeInternalBuilderForOneProject(filesInProject, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
            }
        }
        finally {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void invokeInternalBuilderForOneProject(List<IFile> files, IProgressMonitor monitor) {
        IProject project = files.get(0).getProject();
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
        try {
            try {
                monitor.beginTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.buildingProject", project.getName()) + ":", 100 + files.size() * 100);
                this.console = CCorePlugin.getDefault().getConsole();
                this.console.start(project);
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                IConfiguration configuration = buildInfo.getDefaultConfiguration();
                String cfgName = configuration.getName();
                String toolchainName = configuration.getToolChain().getName();
                boolean isSupported = configuration.isSupported();
                IBuildDescription des = BuildDescriptionManager.createBuildDescription(configuration, null, 0);
                String[] errorParsers = configuration.getErrorParserList();
                ErrorParserManager epm = new ErrorParserManager(project, des.getDefaultBuildDirLocationURI(), (IMarkerGenerator)this, errorParsers);
                buildRunnerHelper.prepareStreams(epm, null, this.console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                OutputStream stdout = buildRunnerHelper.getOutputStream();
                OutputStream stderr = buildRunnerHelper.getErrorStream();
                buildRunnerHelper.greeting(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.buildingSelectedFiles"), cfgName, toolchainName, isSupported);
                buildRunnerHelper.printLine(ManagedMakeMessages.getResourceString(INTERNAL_BUILDER_HEADER_NOTE));
                block16: for (IFile file : files) {
                    if (monitor.isCanceled()) break;
                    String filePath = file.getProjectRelativePath().toString();
                    try {
                        IBuildIOType[] depTypes;
                        IBuildResource buildResource = des.getBuildResource((IResource)file);
                        HashSet<IBuildStep> dependentSteps = new HashSet<IBuildStep>();
                        IBuildIOType[] iBuildIOTypeArray = depTypes = buildResource.getDependentIOTypes();
                        int n = depTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBuildIOType btype = iBuildIOTypeArray[n2];
                            if (btype != null && btype.getStep() != null) {
                                dependentSteps.add(btype.getStep());
                            }
                            ++n2;
                        }
                        SubProgressMonitor monitor2 = new SubProgressMonitor(monitor, 100, 4);
                        try {
                            monitor2.beginTask("", 100 + dependentSteps.size() * 100);
                            monitor2.subTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.removingResourceMarkers", filePath));
                            buildRunnerHelper.removeOldMarkers((IResource)file, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor2, 100, 2));
                            for (IBuildStep step : dependentSteps) {
                                IBuildIOType[] outputIOTypes;
                                if (monitor2.isCanceled()) {
                                    continue block16;
                                }
                                monitor2.subTask(filePath);
                                StepBuilder stepBuilder = new StepBuilder(step, null);
                                stepBuilder.build(stdout, stderr, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor2, 100, 2));
                                monitor2.subTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.refreshingArtifacts", filePath));
                                IBuildIOType[] iBuildIOTypeArray2 = outputIOTypes = step.getOutputIOTypes();
                                int n3 = outputIOTypes.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IBuildIOType type = iBuildIOTypeArray2[n4];
                                    IBuildResource[] iBuildResourceArray = type.getResources();
                                    int n5 = iBuildResourceArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IBuildResource outResource = iBuildResourceArray[n6];
                                        IFile outFile = project.getFile(outResource.getLocation());
                                        outFile.refreshLocal(2, null);
                                        ++n6;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        finally {
                            monitor2.done();
                        }
                    }
                    catch (Exception e) {
                        ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
                    }
                }
                buildRunnerHelper.close();
                buildRunnerHelper.goodbye();
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
                this.forgetLastBuiltState();
                this.getGenerationProblems().clear();
                try {
                    buildRunnerHelper.close();
                }
                catch (IOException e2) {
                    ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e2)));
                }
                monitor.done();
            }
        }
        finally {
            this.getGenerationProblems().clear();
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
            }
            monitor.done();
        }
    }

    public IStatus cleanFiles(List<IFile> files, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            Map<IProject, List<IFile>> projectMap = this.arrangeFilesByProject(files);
            monitor.beginTask("", projectMap.size() * 100);
            for (List<IFile> filesInProject : projectMap.values()) {
                IProject project = filesInProject.get(0).getProject();
                monitor.subTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.cleaningProject", project.getName()));
                this.cleanFilesForOneProject(filesInProject, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
            }
        }
        finally {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void cleanFilesForOneProject(List<IFile> files, IProgressMonitor monitor) {
        IProject project = files.get(0).getProject();
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
        int countDeleted = 0;
        try {
            try {
                monitor.beginTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.cleaningProject", project.getName()) + ":", 100 + files.size() * 100);
                this.console = CCorePlugin.getDefault().getConsole();
                this.console.start(project);
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                IConfiguration configuration = buildInfo.getDefaultConfiguration();
                String cfgName = configuration.getName();
                String toolchainName = configuration.getToolChain().getName();
                boolean isSupported = configuration.isSupported();
                int flags = 3;
                IResourceDelta delta = this.getDelta(project);
                IBuildDescription des = BuildDescriptionManager.createBuildDescription(configuration, delta, flags);
                String[] errorParsers = configuration.getErrorParserList();
                ErrorParserManager epm = new ErrorParserManager(project, des.getDefaultBuildDirLocationURI(), (IMarkerGenerator)this, errorParsers);
                buildRunnerHelper.prepareStreams(epm, null, this.console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                buildRunnerHelper.greeting(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.cleanSelectedFiles"), cfgName, toolchainName, isSupported);
                buildRunnerHelper.printLine(ManagedMakeMessages.getResourceString(INTERNAL_BUILDER_HEADER_NOTE));
                block16: for (IFile file : files) {
                    if (monitor.isCanceled()) break;
                    String filePath = file.getProjectRelativePath().toString();
                    try {
                        IBuildIOType[] depTypes;
                        IBuildResource buildResource = des.getBuildResource((IResource)file);
                        if (buildResource == null) continue;
                        HashSet<IBuildStep> dependentSteps = new HashSet<IBuildStep>();
                        IBuildIOType[] iBuildIOTypeArray = depTypes = buildResource.getDependentIOTypes();
                        int n = depTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBuildIOType btype = iBuildIOTypeArray[n2];
                            if (btype != null && btype.getStep() != null) {
                                dependentSteps.add(btype.getStep());
                            }
                            ++n2;
                        }
                        SubProgressMonitor monitor2 = new SubProgressMonitor(monitor, 100, 4);
                        try {
                            monitor2.beginTask("", 100 + dependentSteps.size() * 100);
                            monitor2.subTask(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.removingResourceMarkers", filePath));
                            buildRunnerHelper.removeOldMarkers((IResource)file, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor2, 100, 2));
                            for (IBuildStep step : dependentSteps) {
                                IBuildIOType[] outputIOTypes;
                                if (monitor2.isCanceled()) {
                                    continue block16;
                                }
                                monitor2.subTask(filePath);
                                IBuildIOType[] iBuildIOTypeArray2 = outputIOTypes = step.getOutputIOTypes();
                                int n3 = outputIOTypes.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IBuildIOType ioType = iBuildIOTypeArray2[n4];
                                    IBuildResource[] iBuildResourceArray = ioType.getResources();
                                    int n5 = iBuildResourceArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IBuildResource rc = iBuildResourceArray[n6];
                                        IResource outputFile = project.findMember(rc.getFullPath().removeFirstSegments(1));
                                        if (outputFile != null) {
                                            outputFile.delete(true, null);
                                            ++countDeleted;
                                            buildRunnerHelper.printLine(ManagedMakeMessages.getFormattedString("GeneratedMakefileBuilder.fileDeleted", outputFile.getProjectRelativePath().toString()));
                                        }
                                        ++n6;
                                    }
                                    ++n4;
                                }
                                monitor2.worked(100);
                            }
                        }
                        finally {
                            monitor2.done();
                        }
                    }
                    catch (Exception e) {
                        ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
                    }
                }
                if (countDeleted == 0) {
                    buildRunnerHelper.printLine(ManagedMakeMessages.getResourceString("GeneratedMakefileBuilder.nothingToClean"));
                }
                buildRunnerHelper.close();
                buildRunnerHelper.goodbye();
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
                try {
                    buildRunnerHelper.close();
                }
                catch (IOException e2) {
                    ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e2)));
                }
                monitor.done();
            }
        }
        finally {
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "CDT Build Error", (Throwable)e)));
            }
            monitor.done();
        }
    }

    private static class OtherConfigVerifier
    implements IResourceDeltaVisitor {
        IConfiguration config;
        IConfiguration[] configs;
        Configuration[] otherConfigs;
        int resourceChangeState;
        private static final IPath[] ignoreList = new IPath[]{new Path(".cdtproject"), new Path(".cproject"), new Path(".cdtbuild"), new Path(".settings")};

        OtherConfigVerifier(IConfiguration cfg) {
            this.config = cfg;
            this.configs = cfg.getManagedProject().getConfigurations();
            this.otherConfigs = new Configuration[this.configs.length - 1];
            int counter = 0;
            int i = 0;
            while (i < this.configs.length) {
                if (this.configs[i] != this.config) {
                    this.otherConfigs[counter++] = (Configuration)this.configs[i];
                }
                ++i;
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource rc = delta.getResource();
            if (rc.getType() == 1) {
                if (this.isResourceValuable(rc)) {
                    this.resourceChangeState |= delta.getKind();
                }
                return false;
            }
            return !this.isGeneratedForConfig(rc, this.config) && this.isResourceValuable(rc);
        }

        public void updateOtherConfigs(IResourceDelta delta) {
            if (delta == null) {
                this.resourceChangeState = -1;
            } else {
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    this.resourceChangeState = -1;
                }
            }
            this.setResourceChangeStateForOtherConfigs();
        }

        private void setResourceChangeStateForOtherConfigs() {
            int i = 0;
            while (i < this.otherConfigs.length) {
                this.otherConfigs[i].addResourceChangeState(this.resourceChangeState);
                ++i;
            }
        }

        private boolean isGeneratedForConfig(IResource resource, IConfiguration cfg) {
            IPath path = resource.getProjectRelativePath();
            Path root = new Path(cfg.getName());
            return root.isPrefixOf(path);
        }

        private boolean isResourceValuable(IResource rc) {
            IPath path = rc.getProjectRelativePath();
            int i = 0;
            while (i < ignoreList.length) {
                if (ignoreList[i].equals((Object)path)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private String buildGoalName;
        private IManagedBuildInfo buildInfo;
        private boolean incrBuildNeeded = false;
        private boolean fullBuildNeeded = false;
        private List<String> reservedNames;

        public ResourceDeltaVisitor(IManagedBuildInfo info) {
            this.buildInfo = info;
            String ext = this.buildInfo.getBuildArtifactExtension();
            try {
                ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, info.getDefaultConfiguration());
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
            String name = this.buildInfo.getBuildArtifactName();
            try {
                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, info.getDefaultConfiguration());
                resolved = resolved.trim();
                if (resolved.length() > 0) {
                    name = resolved;
                }
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
            this.buildGoalName = ext.length() > 0 ? this.buildInfo.getOutputPrefix(ext) + name + "." + ext : name;
            this.reservedNames = Arrays.asList(".cdtbuild", ".cdtproject", ".project");
        }

        private boolean isGeneratedResource(IResource resource) {
            IPath path = resource.getProjectRelativePath();
            String[] configNames = this.buildInfo.getConfigurationNames();
            int i = 0;
            while (i < configNames.length) {
                String name = configNames[i];
                Path root = new Path(name);
                if (root.isPrefixOf(path)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isProjectFile(IResource resource) {
            return this.reservedNames.contains(resource.getName());
        }

        public boolean shouldBuildIncr() {
            return this.incrBuildNeeded;
        }

        public boolean shouldBuildFull() {
            return this.fullBuildNeeded;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == GeneratedMakefileBuilder.this.getProject()) {
                switch (resource.getType()) {
                    case 1: {
                        String name = resource.getName();
                        if (name.equals(this.buildGoalName) || !resource.isDerived() && !this.isProjectFile(resource) && !this.isGeneratedResource(resource)) {
                            this.incrBuildNeeded = true;
                            if (delta.getKind() == 2) {
                                this.fullBuildNeeded = true;
                                break;
                            }
                        }
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

