/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.net.URL;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryInfo;
import org.eclipse.mylyn.tasks.core.TaskMigrationEvent;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskHistory;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public abstract class AbstractRepositoryConnector {
    private static final long REPOSITORY_CONFIGURATION_UPDATE_INTERVAL = 86400000L;

    public abstract boolean canCreateNewTask(@NonNull TaskRepository var1);

    public abstract boolean canCreateTaskFromKey(@NonNull TaskRepository var1);

    public boolean canGetTaskHistory(@NonNull TaskRepository repository, @NonNull ITask task) {
        return false;
    }

    public boolean canQuery(@NonNull TaskRepository repository) {
        return true;
    }

    public boolean canSynchronizeTask(@NonNull TaskRepository taskRepository, @NonNull ITask task) {
        return true;
    }

    public boolean canDeleteTask(@NonNull TaskRepository repository, @NonNull ITask task) {
        return false;
    }

    public boolean canCreateRepository() {
        return true;
    }

    public abstract @NonNull String getConnectorKind();

    public abstract @NonNull String getLabel();

    public abstract @Nullable String getRepositoryUrlFromTaskUrl(@NonNull String var1);

    public @Nullable String getShortLabel() {
        String label = this.getLabel();
        if (label == null) {
            return null;
        }
        int i = label.indexOf("(");
        if (i != -1) {
            return label.substring(0, i).trim();
        }
        i = label.indexOf(" ");
        if (i != -1) {
            return label.substring(0, i).trim();
        }
        return label;
    }

    public @Nullable AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return null;
    }

    public abstract @NonNull TaskData getTaskData(@NonNull TaskRepository var1, @NonNull String var2, @NonNull IProgressMonitor var3) throws CoreException;

    public boolean supportsSearchByTaskKey(@NonNull TaskRepository repository) throws CoreException {
        return false;
    }

    public @Nullable TaskData searchByTaskKey(@NonNull TaskRepository repository, @NonNull String taskKey, @NonNull IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public @Nullable AbstractTaskDataHandler getTaskDataHandler() {
        return null;
    }

    public abstract @Nullable String getTaskIdFromTaskUrl(@NonNull String var1);

    public @NonNull String getTaskIdPrefix() {
        return "task";
    }

    public @Nullable String[] getTaskIdsFromComment(@NonNull TaskRepository repository, @NonNull String comment) {
        return null;
    }

    public @NonNull ITaskMapping getTaskMapping(@NonNull TaskData taskData) {
        return new TaskMapper(taskData);
    }

    public @Nullable Collection<TaskRelation> getTaskRelations(@NonNull TaskData taskData) {
        return null;
    }

    public abstract @Nullable String getTaskUrl(@NonNull String var1, @NonNull String var2);

    public @Nullable URL getAuthenticatedUrl(@NonNull TaskRepository repository, @NonNull IRepositoryElement element) {
        return null;
    }

    public @Nullable URL getBrowserUrl(@NonNull TaskRepository repository, @NonNull IRepositoryElement element) {
        return null;
    }

    public abstract boolean hasTaskChanged(@NonNull TaskRepository var1, @NonNull ITask var2, @NonNull TaskData var3);

    public boolean hasLocalCompletionState(@NonNull TaskRepository repository, @NonNull ITask task) {
        return false;
    }

    public boolean hasRepositoryDueDate(@NonNull TaskRepository repository, @NonNull ITask task, @NonNull TaskData taskData) {
        return false;
    }

    public boolean isRepositoryConfigurationStale(@NonNull TaskRepository repository, @NonNull IProgressMonitor monitor) throws CoreException {
        Date configDate = repository.getConfigurationDate();
        if (configDate != null) {
            return new Date().getTime() - configDate.getTime() > 86400000L;
        }
        return true;
    }

    public boolean isUserManaged() {
        return true;
    }

    public abstract @NonNull IStatus performQuery(@NonNull TaskRepository var1, @NonNull IRepositoryQuery var2, @NonNull TaskDataCollector var3, @Nullable ISynchronizationSession var4, @NonNull IProgressMonitor var5);

    public @NonNull IStatus deleteTask(@NonNull TaskRepository repository, @NonNull ITask task, @NonNull IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void postSynchronization(@NonNull ISynchronizationSession event, @NonNull IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
        }
        finally {
            monitor.done();
        }
    }

    public void preSynchronization(@NonNull ISynchronizationSession event, @NonNull IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
        }
        finally {
            monitor.done();
        }
    }

    public abstract void updateRepositoryConfiguration(@NonNull TaskRepository var1, @NonNull IProgressMonitor var2) throws CoreException;

    public void updateRepositoryConfiguration(@NonNull TaskRepository taskRepository, @Nullable ITask task, @NonNull IProgressMonitor monitor) throws CoreException {
        this.updateRepositoryConfiguration(taskRepository, monitor);
    }

    public abstract void updateTaskFromTaskData(@NonNull TaskRepository var1, @NonNull ITask var2, @NonNull TaskData var3);

    public void updateNewTaskFromTaskData(@NonNull TaskRepository taskRepository, @NonNull ITask task, @NonNull TaskData taskData) {
    }

    public void migrateTask(@NonNull TaskMigrationEvent event) {
    }

    public boolean isOwnedByUser(@NonNull TaskRepository repository, @NonNull ITask task) {
        return task.getOwner() != null && task.getOwner().equals(repository.getUserName()) || task.getOwnerId() != null && task.getOwnerId().equals(repository.getUserName());
    }

    public @NonNull TaskHistory getTaskHistory(@NonNull TaskRepository repository, @NonNull ITask task, @NonNull IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public @NonNull RepositoryInfo validateRepository(@NonNull TaskRepository repository, @Nullable IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void applyDefaultCategory(@NonNull TaskRepository repository) {
        repository.setCategory("org.eclipse.mylyn.category.bugs");
    }
}

