/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.parsers;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SAXToDOMHandler
extends DefaultHandler
implements LexicalHandler {
    private static final Logger logger = Logger.getLogger(SAXToDOMHandler.class.getName());
    private static final String PROPERTY_DOM_STRICT = "nekohtml.dom.strict";
    private final DocumentBuilder documentBuilder;
    private Document document;
    private final Stack<Node> elementStack;
    private StringBuilder textBuffer;
    private int skipDepth;

    private static DOMStrictMode getDOMStrictMode() {
        String propertyValue = System.getProperty(PROPERTY_DOM_STRICT);
        if (propertyValue == null) {
            return DOMStrictMode.NOT_SET;
        }
        if ("true".equalsIgnoreCase(propertyValue)) {
            return DOMStrictMode.TRUE;
        }
        return DOMStrictMode.FALSE;
    }

    public SAXToDOMHandler(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
        this.elementStack = new Stack();
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void startDocument() throws SAXException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting DOM document building");
        }
        this.document = this.documentBuilder.newDocument();
        this.elementStack.clear();
        this.elementStack.push(this.document);
        this.textBuffer = new StringBuilder();
        this.skipDepth = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushText();
        this.elementStack.clear();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Completed DOM document building");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushText();
        if (this.skipDepth > 0) {
            ++this.skipDepth;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Skipping element (skip depth " + this.skipDepth + "): " + qName);
            }
            return;
        }
        if (this.document == null) {
            DOMStrictMode strictMode = SAXToDOMHandler.getDOMStrictMode();
            if (strictMode == DOMStrictMode.TRUE) {
                throw new SAXException("Attempted to start element <" + qName + "> before startDocument() was called. The DOM document has not been initialized.");
            }
            String message = "Attempted to start element <" + qName + "> before startDocument() was called. The DOM document has not been initialized. Skipping this element and its children. (Use -Dnekohtml.dom.strict=true to fail on such errors)";
            if (strictMode == DOMStrictMode.FALSE) {
                logger.warning(message);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(message);
            }
            this.skipDepth = 1;
            return;
        }
        Element element = this.document.createElement(qName);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating DOM element: " + qName);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            element.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        if (this.elementStack.isEmpty()) {
            DOMStrictMode strictMode = SAXToDOMHandler.getDOMStrictMode();
            if (strictMode == DOMStrictMode.TRUE) {
                throw new SAXException("Attempted to start element <" + qName + "> with empty element stack. This may indicate startElement() was called before startDocument() or due to unbalanced tags.");
            }
            String message = "Attempted to start element <" + qName + "> with empty element stack. This may indicate startElement() was called before startDocument() or due to unbalanced tags. Skipping this element and its children. (Use -Dnekohtml.dom.strict=true to fail on such errors)";
            if (strictMode == DOMStrictMode.FALSE) {
                logger.warning(message);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(message);
            }
            this.skipDepth = 1;
            return;
        }
        Node parent = this.elementStack.peek();
        try {
            parent.appendChild(element);
        }
        catch (DOMException e) {
            DOMStrictMode strictMode = SAXToDOMHandler.getDOMStrictMode();
            if (strictMode == DOMStrictMode.TRUE) {
                throw new SAXException("DOM hierarchy violation: " + e.getMessage(), e);
            }
            String message = "Could not append element <" + qName + "> to parent <" + parent.getNodeName() + ">: " + e.getMessage() + " (Use -Dnekohtml.dom.strict=true to fail on such errors)";
            if (strictMode == DOMStrictMode.FALSE) {
                logger.warning(message);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(message);
            }
            this.skipDepth = 1;
            return;
        }
        this.elementStack.push(element);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushText();
        if (this.skipDepth > 0) {
            --this.skipDepth;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Unskipping element (skip depth " + this.skipDepth + "): " + qName);
            }
            return;
        }
        if (!this.elementStack.isEmpty()) {
            Node topElement = this.elementStack.peek();
            if (topElement.getNodeName().equals(qName)) {
                this.elementStack.pop();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Popped element from DOM stack: " + qName + " (stack depth: " + this.elementStack.size() + ")");
                }
            } else {
                DOMStrictMode strictMode = SAXToDOMHandler.getDOMStrictMode();
                String message = "Mismatched end tag: expected </" + topElement.getNodeName() + "> but found </" + qName + ">. Ignoring this end tag. This may indicate malformed HTML.";
                if (strictMode == DOMStrictMode.FALSE) {
                    logger.warning(message);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine(message);
                }
            }
        } else {
            DOMStrictMode strictMode = SAXToDOMHandler.getDOMStrictMode();
            String message = "Attempted to pop element <" + qName + "> from empty element stack. This may indicate mismatched start/end tags in the HTML document.";
            if (strictMode == DOMStrictMode.FALSE) {
                logger.warning(message);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(message);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textBuffer == null) {
            return;
        }
        this.textBuffer.append(ch, start, length);
    }

    private void flushText() {
        if (this.textBuffer == null) {
            return;
        }
        if (this.textBuffer.length() > 0) {
            String text = this.textBuffer.toString();
            this.textBuffer.setLength(0);
            if (this.skipDepth > 0) {
                return;
            }
            if (this.elementStack.isEmpty()) {
                return;
            }
            Node parent = this.elementStack.peek();
            if (parent.getNodeType() == 1 && !text.isEmpty()) {
                Text textNode = this.document.createTextNode(text);
                parent.appendChild(textNode);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Added text node (" + text.length() + " chars) to element: " + parent.getNodeName());
                }
            }
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        block6: {
            this.flushText();
            if (this.skipDepth > 0) {
                return;
            }
            String commentText = new String(ch, start, length);
            Comment commentNode = this.document.createComment(commentText);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Creating comment node (" + commentText.length() + " chars)");
            }
            Node parent = this.elementStack.peek();
            try {
                parent.appendChild(commentNode);
            }
            catch (DOMException e) {
                DOMStrictMode strictMode = SAXToDOMHandler.getDOMStrictMode();
                if (strictMode == DOMStrictMode.TRUE) {
                    throw new SAXException("DOM hierarchy violation: " + e.getMessage(), e);
                }
                String message = "Could not append comment to parent <" + parent.getNodeName() + ">: " + e.getMessage();
                if (strictMode == DOMStrictMode.FALSE) {
                    logger.warning(message);
                }
                if (!logger.isLoggable(Level.FINE)) break block6;
                logger.fine(message);
            }
        }
    }

    private static enum DOMStrictMode {
        NOT_SET,
        FALSE,
        TRUE;

    }
}

