/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.autotools.ui.MakeUIImages;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.EditorUtility;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ElementListSelectionDialog;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.MessageBox;

public class OpenIncludeAction
extends Action {
    private static final String PREFIX = "OpenIncludeAction.";
    private static final String DIALOG_TITLE = "OpenIncludeAction.dialog.title";
    private static final String DIALOG_MESSAGE = "OpenIncludeAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(CUIPlugin.getResourceString((String)"OpenIncludeAction.label"));
        this.setDescription(CUIPlugin.getResourceString((String)"OpenIncludeAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString((String)"OpenIncludeAction.tooltip"));
        MakeUIImages.setImageDescriptors((IAction)this, "lcl16/", MakeUIImages.IMG_MENU_OPEN_INCLUDE);
        this.fSelectionProvider = provider;
    }

    public void run() {
        IInclude include = OpenIncludeAction.getIncludeStatement(this.fSelectionProvider.getSelection());
        if (include == null) {
            return;
        }
        try {
            IPath fileToOpen;
            int nElementsFound;
            Path fullPath;
            IResource res = include.getUnderlyingResource();
            ArrayList<Object> filesFound = new ArrayList<Object>(4);
            String fullFileName = include.getFullFileName();
            if (fullFileName != null && (fullPath = new Path(fullFileName)).isAbsolute() && fullPath.toFile().exists()) {
                filesFound.add(fullPath);
            }
            if (filesFound.isEmpty() && res != null) {
                IProject proj = res.getProject();
                String includeName = include.getElementName();
                IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(proj);
                if (provider != null) {
                    IScannerInfo info = provider.getScannerInformation(res);
                    if (info == null) {
                        info = provider.getScannerInformation((IResource)proj);
                    }
                    if (info != null) {
                        ExtendedScannerInfo scanInfo = new ExtendedScannerInfo(info);
                        boolean isSystemInclude = include.isStandard();
                        if (!isSystemInclude) {
                            IPath location = include.getTranslationUnit().getLocation();
                            if (location != null) {
                                String currentDir = location.removeLastSegments(1).toOSString();
                                this.findFile(new String[]{currentDir}, includeName, filesFound);
                            }
                            if (filesFound.isEmpty()) {
                                String[] localIncludePaths = scanInfo.getLocalIncludePath();
                                this.findFile(localIncludePaths, includeName, filesFound);
                            }
                        }
                        if (filesFound.isEmpty()) {
                            String[] includePaths = scanInfo.getIncludePaths();
                            this.findFile(includePaths, includeName, filesFound);
                        }
                    }
                    if (filesFound.isEmpty()) {
                        this.findFile((IContainer)proj, (IPath)new Path(includeName), filesFound);
                    }
                }
            }
            if ((nElementsFound = filesFound.size()) == 0) {
                this.noElementsFound();
                fileToOpen = null;
            } else {
                fileToOpen = nElementsFound == 1 ? (IPath)filesFound.get(0) : this.chooseFile(filesFound);
            }
            if (fileToOpen != null) {
                EditorUtility.openInEditor(fileToOpen, (ICElement)include);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((IStatus)e.getStatus());
        }
    }

    private void noElementsFound() {
        MessageBox errorMsg = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        errorMsg.setText(CUIPlugin.getResourceString((String)"OpenIncludeAction.error"));
        errorMsg.setMessage(CUIPlugin.getResourceString((String)"OpenIncludeAction.error.description"));
        errorMsg.open();
    }

    private boolean isInProject(IPath path) {
        return this.getWorkspaceRoot().getFileForLocation(path) != null;
    }

    private IPath[] resolveIncludeLink(IPath path) {
        IFile[] files;
        if (!this.isInProject(path) && (files = this.getWorkspaceRoot().findFilesForLocationURI(URIUtil.toURI((IPath)path))).length > 0) {
            IPath[] paths = new IPath[files.length];
            int i = 0;
            while (i < files.length) {
                paths[i] = files[i].getFullPath();
                ++i;
            }
            return paths;
        }
        return new IPath[]{path};
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void findFile(String[] includePaths, String name, List<Object> list) {
        Path includeFile = new Path(name);
        if (includeFile.isAbsolute() && (includeFile = PathUtil.getCanonicalPath((IPath)includeFile)).toFile().exists()) {
            list.add(includeFile);
            return;
        }
        HashSet<IPath> foundSet = new HashSet<IPath>();
        int i = 0;
        while (i < includePaths.length) {
            IPath path = PathUtil.getCanonicalPath((IPath)new Path(includePaths[i]).append((IPath)includeFile));
            File file = path.toFile();
            if (file.exists()) {
                IPath[] paths = this.resolveIncludeLink(path);
                int j = 0;
                while (j < paths.length) {
                    IPath p = paths[j];
                    if (foundSet.add(p)) {
                        list.add(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void findFile(IContainer parent, IPath name, List<Object> list) throws CoreException {
        parent.accept(proxy -> {
            if (proxy.getType() == 1 && proxy.getName().equalsIgnoreCase(name.lastSegment())) {
                IPath rPath = proxy.requestResource().getLocation();
                int numSegToRemove = rPath.segmentCount() - name.segmentCount();
                IPath sPath = rPath.removeFirstSegments(numSegToRemove);
                sPath = sPath.setDevice(name.getDevice());
                if (Platform.getOS().equals("win32") ? sPath.toOSString().equalsIgnoreCase(name.toOSString()) : sPath.equals((Object)name)) {
                    list.add(rPath);
                }
                return false;
            }
            return true;
        }, 0);
    }

    private IPath chooseFile(ArrayList<Object> filesFound) {
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    IPath file = (IPath)element;
                    return file.lastSegment() + " - " + file.toString();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)renderer, false, false);
        dialog.setTitle(CUIPlugin.getResourceString((String)DIALOG_TITLE));
        dialog.setMessage(CUIPlugin.getResourceString((String)DIALOG_MESSAGE));
        dialog.setElements(filesFound);
        if (dialog.open() == 0) {
            return (IPath)dialog.getSelectedElement();
        }
        return null;
    }

    private static IInclude getIncludeStatement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof IInclude) {
            return (IInclude)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        IResource res;
        IInclude include = OpenIncludeAction.getIncludeStatement(selection);
        return include != null && (res = include.getUnderlyingResource()) != null;
    }
}

