/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.ClassUtility;
import org.eclipse.jst.j2ee.model.internal.validation.IClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBType;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodAndFieldConstants;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodType;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.MethodUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class ATypeVRule
extends AValidationRule
implements IClassVRule,
IEJBType {
    private static final int NO_FIELDS = 0;
    private long _methodList = 0L;
    private long _fieldList = 0L;

    @Override
    public final void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationException {
        vc.subtask("STATUS_VALIDATING", new String[]{((JavaClass)target).getJavaName()});
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = vc.getLogEntry();
            entry.setSourceID("EJB20Validator - validate");
            entry.setText(String.valueOf(this.getClass().getName()) + "::validate(" + targetParent + ", " + target);
            logger.write(Level.FINEST, (Object)entry);
        }
        try {
            vc.terminateIfCancelled();
            EnterpriseBean bean = (EnterpriseBean)targetParent;
            JavaClass clazz = (JavaClass)target;
            try {
                vc.removeMessages(clazz);
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)clazz);
            }
            catch (InvalidInputException invalidInputException) {
                this.reflectionError(vc, bean, clazz);
                return;
            }
            if (ValidationRuleUtility.isUnnamedPackage(clazz.getJavaPackage())) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2041", 4, bean, clazz, (IValidationRule)this);
                vc.addMessage(message);
            }
            try {
                this.validate(vc, bean, clazz);
                vc.terminateIfCancelled();
                List[] methodsExtendedList = this.getMethodsExtended(vc, bean, clazz);
                this.validate(vc, bean, clazz, clazz.listMethodExtended(), methodsExtendedList);
                vc.terminateIfCancelled();
                List[] fieldsExtendedList = this.getFieldsExtended(vc, bean, clazz);
                this.validate(vc, bean, clazz, clazz.listFieldExtended(), fieldsExtendedList);
                vc.terminateIfCancelled();
                this.validateSupertypes(vc, bean, clazz);
                vc.terminateIfCancelled();
                this.validateMethodsWhichMustExist(vc, bean, clazz);
                vc.terminateIfCancelled();
            }
            catch (InvalidInputException invalidInputException) {
                this.reflectionError(vc, bean, clazz);
                return;
            }
        }
        catch (ValidationCancelledException validationCancelledException) {}
    }

    protected final void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field[] fields, List[] fieldsExtendedLists) throws ValidationException {
        try {
            vc.terminateIfCancelled();
            Field field = null;
            int i = 0;
            while (i < fields.length) {
                LogEntry entry;
                Logger logger;
                vc.terminateIfCancelled();
                field = fields[i];
                if (field == null) {
                    logger = vc.getMsgLogger();
                    if (logger != null && logger.isLoggingLevel(Level.FINE)) {
                        entry = vc.getLogEntry();
                        entry.setSourceID("EJB20Validator - validate fields");
                        entry.setText("A field is null on " + clazz.getQualifiedName());
                        logger.write(Level.FINE, (Object)entry);
                    }
                } else {
                    try {
                        logger = vc.getMsgLogger();
                        if (logger.isLoggingLevel(Level.FINEST)) {
                            entry = vc.getLogEntry();
                            entry.setSourceID("EJB20Validator - validate fields");
                            entry.setText("Validating field " + field.getName() + "on clazz " + clazz + " and isValid returns " + this.isValid(bean, clazz, field));
                            logger.write(Level.FINEST, (Object)entry);
                        }
                        if (this.isValid(bean, clazz, field)) {
                            this.register(vc, bean, clazz, field, fieldsExtendedLists);
                            this.validate(vc, bean, clazz, field, fieldsExtendedLists);
                        }
                    }
                    catch (InvalidInputException e) {
                        this.reflectionWarning(vc, bean, clazz, field, e);
                    }
                }
                ++i;
            }
            vc.terminateIfCancelled();
        }
        catch (ValidationCancelledException validationCancelledException) {}
    }

    protected final boolean isValid(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) throws InvalidInputException {
        if (this.isOwnedByBase(bean, method)) {
            return false;
        }
        return (this.getMethodType(bean, clazz, method, methodsExtendedLists) & EXCLUDED_METHOD) != EXCLUDED_METHOD;
    }

    protected final boolean isOwnedByBase(EnterpriseBean bean, Field field) throws InvalidInputException {
        if (field == null) {
            return false;
        }
        long[] baseTypes = this.getBaseTypes();
        if (baseTypes == null) {
            return false;
        }
        int i = 0;
        while (i < baseTypes.length) {
            if (ClassUtility.getUtility().isClassType(bean, field.getJavaClass(), baseTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final boolean isOwnedByBase(EnterpriseBean bean, Method method) throws InvalidInputException {
        if (method == null) {
            return false;
        }
        long[] baseTypes = this.getBaseTypes();
        if (baseTypes == null) {
            return false;
        }
        int i = 0;
        while (i < baseTypes.length) {
            if (ClassUtility.getUtility().isClassType(bean, method.getJavaClass(), baseTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final boolean isValid(EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (this.isOwnedByBase(bean, field)) {
            return false;
        }
        return (this.getFieldType(bean, clazz, field) & EXCLUDED_FIELD) != EXCLUDED_FIELD;
    }

    protected final void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method[] methods, List[] methodsExtendedLists) throws ValidationException {
        try {
            vc.terminateIfCancelled();
            Method method = null;
            int i = 0;
            while (i < methods.length) {
                LogEntry entry;
                Logger logger;
                vc.terminateIfCancelled();
                method = methods[i];
                if (method == null) {
                    logger = vc.getMsgLogger();
                    if (logger != null && logger.isLoggingLevel(Level.FINE)) {
                        entry = vc.getLogEntry();
                        entry.setSourceID("EJB20Validator - validate methods");
                        entry.setText("On " + clazz.getQualifiedName() + ", there is a null method.");
                        logger.write(Level.FINE, (Object)entry);
                    }
                } else {
                    try {
                        logger = vc.getMsgLogger();
                        if (logger.isLoggingLevel(Level.FINEST)) {
                            entry = vc.getLogEntry();
                            entry.setSourceID("EJB20Validator - validate methods");
                            entry.setText("Validating method " + method.getMethodElementSignature() + " on clazz " + clazz + " and isValid returns " + this.isValid(bean, clazz, method, methodsExtendedLists));
                            logger.write(Level.FINEST, (Object)entry);
                        }
                        if (this.isValid(bean, clazz, method, methodsExtendedLists)) {
                            this.register(vc, bean, clazz, method, methodsExtendedLists);
                            if (this.isMethodAllowedToExist(bean, clazz, method, methodsExtendedLists)) {
                                this.validate(vc, bean, clazz, method, methodsExtendedLists);
                            } else {
                                this.validateMethodWhichMustNotExist(vc, bean, clazz, method, methodsExtendedLists);
                            }
                        } else if (!this.isOwnedByBase(bean, method) && (MethodUtility.getUtility().getMethodTypeId(bean, clazz, method, methodsExtendedLists, this) & EXCLUDED_METHOD) == EXCLUDED_METHOD) {
                            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2502", 4, bean, clazz, method, new String[]{method.getName()}, (IValidationRule)this);
                            vc.addMessage(message);
                        }
                    }
                    catch (InvalidInputException e) {
                        this.reflectionWarning(vc, bean, clazz, method, e);
                    }
                }
                ++i;
            }
            vc.terminateIfCancelled();
        }
        catch (ValidationCancelledException validationCancelledException) {}
    }

    @Override
    public final void register(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldsExtendedList) throws InvalidInputException, ValidationCancelledException, ValidationException {
        this._fieldList |= this.getFieldType(bean, clazz, field);
    }

    private boolean isDefaultConstructor(long methodType) {
        return (methodType & IMethodAndFieldConstants.CONSTRUCTOR_NOPARM) == IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
    }

    private boolean doesPublicDefaultConstructorExist() {
        return (this._methodList & IMethodAndFieldConstants.CONSTRUCTOR_NOPARM) == IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
    }

    private boolean isDefaultConstructorInsertedByCompiler() {
        return (this._methodList & IMethodAndFieldConstants.CONSTRUCTOR) != IMethodAndFieldConstants.CONSTRUCTOR;
    }

    protected final boolean isMethodAllowedToExist(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
        long[] methods = this.getMethodsWhichMustNotExist();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                long methodType = methods[i];
                long existingMethodType = MethodUtility.getUtility().getMethodTypeId(bean, clazz, method, methodsExtendedLists, this);
                if ((existingMethodType & methodType) == methodType) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void validateMethodsWhichMustExist(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException, ValidationCancelledException, ValidationException {
        long[] methods = this.getMethodsWhichMustExist();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                long methodType = methods[i];
                boolean emitWarning = false;
                if (this.isDefaultConstructor(methodType)) {
                    if (!this.doesPublicDefaultConstructorExist() && !this.isDefaultConstructorInsertedByCompiler()) {
                        emitWarning = true;
                    }
                } else {
                    boolean bl = emitWarning = !this.exists(methodType);
                }
                if (emitWarning) {
                    IMethodType mType = MethodUtility.getUtility().getMethodType(methodType);
                    if (mType == null) {
                        Logger logger = vc.getMsgLogger();
                        if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
                            LogEntry entry = vc.getLogEntry();
                            entry.setSourceID("EJB20Validator - validate methods which must exist");
                            entry.setText("Method type is null: " + methodType);
                            logger.write(Level.FINEST, (Object)entry);
                        }
                    } else {
                        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)mType.getMessageId_messageMissing(), 2, bean, clazz, new String[]{mType.getMethodName(bean, clazz, null)}, (IValidationRule)this);
                        vc.addMessage(message);
                    }
                }
                ++i;
            }
        }
    }

    public final void validateMethodWhichMustNotExist(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) throws InvalidInputException, ValidationCancelledException, ValidationException {
        IMethodType mType = MethodUtility.getUtility().getMethodType(bean, clazz, method, methodsExtendedLists, this);
        if (mType == null) {
            Logger logger = vc.getMsgLogger();
            if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("EJB20Validator - validate method which must not exist");
                entry.setText("Method type is null: " + MethodUtility.getUtility().getMethodType(bean, clazz, method, methodsExtendedLists, this));
                logger.write(Level.FINEST, (Object)entry);
            }
            return;
        }
        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)mType.getMessageId_messageExists(), 4, bean, clazz, method, new String[]{mType.getMethodName(bean, clazz, method)}, (IValidationRule)this);
        vc.addMessage(message);
    }

    public abstract long getFieldType(EnterpriseBean var1, JavaClass var2, Field var3);

    public abstract long[] getBaseTypes();

    public abstract int getMessageRemoteExceptionSeverity();

    public final long getMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList) {
        if (method == null) {
            return EXCLUDED_METHOD;
        }
        long id = MethodUtility.getUtility().getMethodTypeId(bean, clazz, method, methodsExtendedList, this);
        if ((id & CLINIT) == CLINIT) {
            return EXCLUDED_METHOD;
        }
        return id;
    }

    @Override
    public final void register(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList) throws InvalidInputException, ValidationCancelledException, ValidationException {
        this._methodList |= MethodUtility.getUtility().getMethodTypeId(bean, clazz, method, methodsExtendedList, this);
    }

    public final void validateSupertypes(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException, ValidationCancelledException, ValidationException {
        this.validateShouldBeSuperTypes(vc, bean, clazz);
        this.validateShouldNotBeSuperTypes(vc, bean, clazz);
    }

    protected void validateShouldNotBeSuperTypes(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        long[] types = this.getShouldNotBeSupertypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                JavaHelpers superType = ClassUtility.getUtility().getSupertype(bean, types[i]);
                if (superType != null && ValidationRuleUtility.isAssignableFrom((JavaHelpers)clazz, superType)) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2040", 4, bean, clazz, (IValidationRule)this);
                    vc.addMessage(message);
                }
                ++i;
            }
        }
    }

    protected void validateShouldBeSuperTypes(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        long[] types = this.getSupertypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                JavaHelpers superType = ClassUtility.getUtility().getSupertype(bean, types[i]);
                if (superType != null && !ValidationRuleUtility.isAssignableFrom((JavaHelpers)clazz, superType)) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2017", 1, bean, clazz, new String[]{superType.getJavaName()}, (IValidationRule)this);
                    vc.addMessage(message);
                }
                ++i;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this._methodList = 0L;
        this._fieldList = 0L;
    }

    protected final void reflectionError(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2907", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
        vc.addMessage(message);
    }

    protected final void reflectionWarning(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, InvalidInputException exc) {
        vc.removeMessages(field);
        vc.removeMessages(clazz, field.getName());
        IMessage message = this.getReflectionWarning(vc, exc, bean, clazz, (EObject)field);
        vc.addMessage(message);
    }

    protected final void reflectionWarning(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, InvalidInputException exc) {
        vc.removeMessages(method);
        vc.removeMessages(clazz, method.getSignature());
        IMessage message = this.getReflectionWarning(vc, exc, bean, clazz, (EObject)method);
        vc.addMessage(message);
    }

    protected final IMessage getReflectionWarning(IEJBValidationContext vc, InvalidInputException exc, EnterpriseBean bean, JavaClass clazz, EObject fieldOrMethod) {
        Logger logger;
        String name;
        if (exc == null) {
            return null;
        }
        JavaClass badClazz = exc.getJavaClass();
        String typeName = badClazz == null ? "?" : badClazz.getQualifiedName();
        IMessage message = null;
        if (fieldOrMethod instanceof Field) {
            name = ((Field)fieldOrMethod).getName();
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2433", 2, bean, clazz, (Field)fieldOrMethod, new String[]{name, typeName}, (IValidationRule)this);
        } else if (fieldOrMethod instanceof Method) {
            name = ((Method)fieldOrMethod).getMethodElementSignature();
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2433", 2, bean, clazz, (Method)fieldOrMethod, new String[]{name, typeName}, (IValidationRule)this);
        } else {
            name = ((XMIResource)fieldOrMethod.eResource()).getID(fieldOrMethod);
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2433", 2, bean, clazz, new String[]{name, typeName}, (IValidationRule)this);
        }
        if (badClazz == null && (logger = vc.getMsgLogger()) != null && logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = vc.getLogEntry();
            entry.setSourceID("getMessageId(IEJBValidationContext, InvalidInputException, boolean)");
            entry.setText("InvalidInputException thrown on unknown class");
            entry.setTargetException((Throwable)exc);
            logger.write(Level.FINEST, (Object)entry);
        }
        return message;
    }

    public final JavaClass getComponentInterface(EnterpriseBean bean) {
        if ((this.isRemote() & 1) == 1) {
            return bean.getRemoteInterface();
        }
        return bean.getLocalInterface();
    }

    public final boolean exists(long methodType) {
        return (this._methodList & methodType) == methodType;
    }

    public final JavaClass getHomeInterface(EnterpriseBean bean) {
        if ((this.isRemote() & 1) == 1) {
            return bean.getHomeInterface();
        }
        return bean.getLocalHomeInterface();
    }

    public boolean followRemoteExceptionRules(EnterpriseBean bean, Method method) throws InvalidInputException, ValidationCancelledException {
        if ((this.isRemote() & 1) == 1) {
            return ValidationRuleUtility.throwsRemoteExceptionOrParent(bean, method);
        }
        if ((this.isRemote() & 2) == 2) {
            return ValidationRuleUtility.doesNotThrowRemoteException(bean, method);
        }
        return true;
    }

    public final void validateRMI_IIOPTypeRules(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList, boolean checkReturnType) throws InvalidInputException {
        if ((this.isRemote() & 1) == 1) {
            IMethodType mt;
            JavaParameter[] parms = method.listParametersWithoutReturn();
            int i = 0;
            while (i < parms.length) {
                IMethodType mt2;
                JavaParameter parm = parms[i];
                if (!ValidationRuleUtility.isLegalRMI_IIOPType(bean, parm.getJavaType()) && (mt2 = MethodUtility.getUtility().getMethodType(bean, clazz, method, methodsExtendedList, this)) != null) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)mt2.getMessageId_messageRMI_IIOPParm(), 4, bean, clazz, method, new String[]{parm.getJavaType().getJavaName()}, (IValidationRule)this);
                    vc.addMessage(message);
                }
                ++i;
            }
            if (checkReturnType && !ValidationRuleUtility.isLegalRMI_IIOPType(bean, method.getReturnType()) && (mt = MethodUtility.getUtility().getMethodType(bean, clazz, method, methodsExtendedList, this)) != null) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)mt.getMessageId_messageRMI_IIOPParm(), 4, bean, clazz, method, new String[]{method.getReturnType().getJavaName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        } else {
            return;
        }
    }

    public final boolean followRMI_IIOPInheritanceRules(EnterpriseBean bean, JavaClass clazz) {
        if ((this.isRemote() & 1) == 1) {
            return ValidationRuleUtility.isLegalRMI_IIOPInheritance(clazz);
        }
        return true;
    }

    public void validateSerialVersionUID(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) {
    }
}

