/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jem.java.util.JavaContext;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.logger.proxyrender.EclipseLogger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JavaPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jem.workbench";
    private static JavaPlugin INSTANCE;
    private Logger logger;

    public JavaPlugin() {
        INSTANCE = this;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = EclipseLogger.getEclipseLogger((Plugin)this);
        }
        return this.logger;
    }

    public static JavaPlugin getDefault() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        JavaContext.setReflectionAdapterFactoryClass(JavaJDOMAdapterFactory.class);
        JEMUtilPlugin.getPluginResourceSet().getAdapterFactories().add((Object)new JavaJDKAdapterFactory());
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return JavaPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(JavaPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

