/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.binding;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForOfStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IReference;
import org.eclipse.wst.jsdt.internal.core.dom.binding.Reference;
import org.eclipse.wst.jsdt.internal.core.dom.binding.Scope;
import org.eclipse.wst.jsdt.internal.core.dom.binding.ScopeDeclarationScanner;

public class SymbolCollector {
    Map<IDeclaration, List<IReference>> classReferenceMap = new LinkedHashMap<IDeclaration, List<IReference>>();
    Map<IDeclaration, List<IReference>> functionReferenceMap = new LinkedHashMap<IDeclaration, List<IReference>>();
    Map<IDeclaration, List<IReference>> variableReferenceMap = new LinkedHashMap<IDeclaration, List<IReference>>();
    Map<String, List<IReference>> unresolvedReferences = new LinkedHashMap<String, List<IReference>>();
    JavaScriptUnit unit;
    private Stack<Scope> scopes = new Stack();

    public SymbolCollector(JavaScriptUnit unit) {
        this.unit = unit;
    }

    public void process() {
        this.unit.accept(new Visitor());
    }

    public Map<IDeclaration, List<IReference>> getClassReferences() {
        return this.classReferenceMap;
    }

    public Map<IDeclaration, List<IReference>> getFunctionReferences() {
        return this.functionReferenceMap;
    }

    public Map<IDeclaration, List<IReference>> getVariableReferences() {
        return this.variableReferenceMap;
    }

    public Map<String, List<IReference>> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    private Scope createScope(ASTNode node) {
        Scope parent = this.scopes.empty() ? null : this.scopes.peek();
        Scope result = new Scope(parent, node);
        this.scopes.push(result);
        return result;
    }

    private void popScope() {
        this.scopes.pop();
    }

    private Scope getScope() {
        return this.scopes.empty() ? null : this.scopes.peek();
    }

    private void processScope(Scope scope) {
        ScopeDeclarationScanner.process(scope);
    }

    private void addReference(SimpleName node) {
        IDeclaration v = this.getScope().getDeclaration(node.getIdentifier());
        if (v != null) {
            this.addReference(v, node, this.getScope());
        } else {
            this.addUnresolvedReference(node, this.getScope());
        }
    }

    private Map<IDeclaration, List<IReference>> selectMap(IDeclaration v) {
        switch (v.getKind()) {
            case CLASS: {
                return this.classReferenceMap;
            }
            case FUNCTION: {
                return this.functionReferenceMap;
            }
            case VARIABLE: {
                return this.variableReferenceMap;
            }
        }
        return null;
    }

    private void addReference(IDeclaration v, SimpleName node, Scope scope) {
        Map<IDeclaration, List<IReference>> map = this.selectMap(v);
        int index = scope.registerReference();
        List<IReference> referenceInfo = map.get(v);
        if (referenceInfo == null) {
            referenceInfo = new ArrayList<IReference>();
            map.put(v, referenceInfo);
        }
        referenceInfo.add(new Reference(node, scope, index, v));
    }

    private void addUnresolvedReference(SimpleName node, Scope scope) {
        int index = scope.registerReference();
        String name = node.getIdentifier();
        List<IReference> referenceInfo = this.unresolvedReferences.get(name);
        if (referenceInfo == null) {
            referenceInfo = new ArrayList<IReference>();
            this.unresolvedReferences.put(name, referenceInfo);
        }
        referenceInfo.add(new Reference(node, scope, index, null));
    }

    private class Visitor
    extends ASTVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(JavaScriptUnit node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            return true;
        }

        @Override
        public boolean visit(FunctionDeclaration node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            this.internalVisit(node.getMethodName());
            this.internalVisit(node.parameters());
            node.getBody().accept(this);
            SymbolCollector.this.popScope();
            return false;
        }

        @Override
        public boolean visit(FunctionExpression node) {
            FunctionDeclaration fd = node.getMethod();
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            this.internalVisit(fd.getMethodName());
            this.internalVisit(fd.parameters());
            fd.getBody().accept(this);
            SymbolCollector.this.popScope();
            return false;
        }

        @Override
        public boolean visit(FunctionDeclarationStatement node) {
            FunctionDeclaration fd = node.getDeclaration();
            this.internalVisit(fd.getMethodName());
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            this.internalVisit(fd.parameters());
            this.internalVisit(fd.getBody());
            SymbolCollector.this.popScope();
            return false;
        }

        @Override
        public boolean visit(TypeDeclarationStatement node) {
            TypeDeclaration td = (TypeDeclaration)node.getDeclaration();
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            this.internalVisit(td.getName());
            this.internalVisit(td.getSuperclassExpression());
            this.internalVisit(td.bodyDeclarations());
            SymbolCollector.this.popScope();
            return false;
        }

        @Override
        public boolean visit(TypeDeclarationExpression node) {
            TypeDeclaration td = (TypeDeclaration)node.getDeclaration();
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            this.internalVisit(td.getName());
            this.internalVisit(td.getSuperclassExpression());
            this.internalVisit(td.bodyDeclarations());
            SymbolCollector.this.popScope();
            return false;
        }

        @Override
        public boolean visit(ForStatement node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            return true;
        }

        @Override
        public void endVisit(ForStatement node) {
            SymbolCollector.this.popScope();
        }

        @Override
        public boolean visit(ForInStatement node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            return true;
        }

        @Override
        public void endVisit(ForInStatement node) {
            SymbolCollector.this.popScope();
        }

        @Override
        public boolean visit(ForOfStatement node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            return true;
        }

        @Override
        public void endVisit(ForOfStatement node) {
            SymbolCollector.this.popScope();
        }

        @Override
        public boolean visit(SwitchStatement node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            return true;
        }

        @Override
        public void endVisit(SwitchStatement node) {
            SymbolCollector.this.popScope();
        }

        @Override
        public boolean visit(Block node) {
            SymbolCollector.this.processScope(SymbolCollector.this.createScope(node));
            return true;
        }

        @Override
        public void endVisit(Block node) {
            SymbolCollector.this.popScope();
        }

        @Override
        public boolean visit(ObjectLiteralField node) {
            this.internalVisit(node.getInitializer());
            return false;
        }

        @Override
        public boolean visit(FieldAccess node) {
            this.internalVisit(node.getExpression());
            return false;
        }

        @Override
        public boolean visit(SimpleName node) {
            SymbolCollector.this.addReference(node);
            return false;
        }

        protected void internalVisit(List<ASTNode> nodes) {
            if (nodes != null) {
                for (ASTNode node : nodes) {
                    node.accept(this);
                }
            }
        }

        protected void internalVisit(ASTNode node) {
            if (node != null) {
                node.accept(this);
            }
        }
    }
}

