/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;

public class ExceptionTableEntry
extends ClassFileStruct {
    private final int startPC;
    private final int endPC;
    private final int handlerPC;
    private final int catchTypeIndex;
    private char[] catchType;

    ExceptionTableEntry(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        this.startPC = this.u2At(classFileBytes, 0, offset);
        this.endPC = this.u2At(classFileBytes, 2, offset);
        this.handlerPC = this.u2At(classFileBytes, 4, offset);
        this.catchTypeIndex = this.u2At(classFileBytes, 6, offset);
        if (this.catchTypeIndex != 0) {
            ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.catchTypeIndex);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.catchType = constantPoolEntry.getClassInfoName();
        }
    }

    public int getStartPC() {
        return this.startPC;
    }

    public int getEndPC() {
        return this.endPC;
    }

    public int getHandlerPC() {
        return this.handlerPC;
    }

    public int getCatchTypeIndex() {
        return this.catchTypeIndex;
    }

    public char[] getCatchType() {
        return this.catchType;
    }
}

