/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.util.List;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.InvokeWSDLOperationTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLBindingNode;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;

public class UpdateWSDLBindingAction
extends WSDLPropertiesFormAction {
    public UpdateWSDLBindingAction(Controller controller) {
        super(controller);
    }

    @Override
    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String[] nodeIds = parser.getParameterValues("nodeId");
        if (nodeIds == null) {
            nodeIds = new String[]{};
        }
        this.propertyTable_.put("nodeId", nodeIds);
        String[] endpoints = parser.getParameterValues("::endPoint");
        if (endpoints == null) {
            endpoints = new String[]{};
        }
        this.propertyTable_.put("::endPoint", endpoints);
        return true;
    }

    @Override
    public boolean run() {
        String[] nodeIds = this.getPropertyAsStringArray("nodeId");
        String[] endpoints = this.getPropertyAsStringArray("::endPoint");
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        NodeManager nodeManager = wsdlPerspective.getNodeManager();
        int i = 0;
        while (i < nodeIds.length) {
            try {
                Node bindingNode = nodeManager.getNode(Integer.parseInt(nodeIds[i]));
                if (bindingNode instanceof WSDLBindingNode) {
                    WSDLBindingElement bindingElement = (WSDLBindingElement)bindingNode.getTreeElement();
                    String[] endpointsCopy = endpoints;
                    bindingElement.setEndPoints(endpointsCopy);
                    if (endpointsCopy.length <= 0) {
                        endpointsCopy = bindingElement.getEndPoints();
                    }
                    if (endpointsCopy.length > 0) {
                        Vector operationNodes = bindingNode.getChildNodes();
                        for (Node operationNode : operationNodes) {
                            List tools = operationNode.getCurrentToolManager().getTools();
                            for (Tool tool : tools) {
                                if (!(tool instanceof InvokeWSDLOperationTool)) continue;
                                ((InvokeWSDLOperationTool)tool).setEndPoint(endpointsCopy[0]);
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        MessageQueue messageQueue = wsdlPerspective.getMessageQueue();
        messageQueue.addMessage(wsdlPerspective.getMessage("MSG_INFO_UPDATE_WSDL_BINDING_SUCCESSFUL"));
        return true;
    }
}

