/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.transport.TransportException;

public class RegPublishBusinessSimpleAction
extends PublishAction {
    public RegPublishBusinessSimpleAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(0));
        this.propertyTable_.put("queryStyleBusinesses", String.valueOf(0));
    }

    @Override
    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String name = parser.getParameter("simpleBusinessName");
        String description = parser.getParameter("simpleBusinessDescription");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (name != null) {
            this.propertyTable_.put("simpleBusinessName", name);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(name)) {
            inputsValid = false;
            formToolPI.flagError("simpleBusinessName");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_NAME"));
        }
        if (description != null) {
            this.propertyTable_.put("simpleBusinessDescription", description);
        }
        return inputsValid;
    }

    @Override
    public final boolean run() {
        String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
        String userId = (String)this.propertyTable_.get("advancedUserId");
        String password = (String)this.propertyTable_.get("advancedPassword");
        String name = (String)this.propertyTable_.get("simpleBusinessName");
        String description = (String)this.propertyTable_.get("simpleBusinessDescription");
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        try {
            UDDIProxy proxy = regElement.getProxy();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            BusinessEntity be = new BusinessEntity();
            be.setBusinessKey("");
            be.setDefaultName(new Name(name));
            be.setDefaultDescriptionString(description);
            Vector<BusinessEntity> beVector = new Vector<BusinessEntity>();
            beVector.add(be);
            be = (BusinessEntity)proxy.save_business(regElement.getAuthInfoString(), beVector).getBusinessEntityVector().get(0);
            this.addPublishedItemNode(be, regElement);
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESS_PUBLISHED", be.getDefaultNameString()));
            return true;
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

