/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageReferenceCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public final class AddOutputCommand
extends AddMessageReferenceCommand {
    private Output originalOutput;

    public AddOutputCommand(Operation operation, String name) {
        super(operation, name);
    }

    public AddOutputCommand(Operation operation, String name, boolean createMessage) {
        super(operation, name, createMessage);
    }

    public AddOutputCommand(Operation operation, Output originalOutput, String name) {
        super(operation, name, false);
        this.originalOutput = originalOutput;
    }

    @Override
    public void run() {
        this.messageReference = WSDLFactory.eINSTANCE.createOutput();
        this.messageReference.setEnclosingDefinition(this.operation.getEnclosingDefinition());
        this.operation.setOutput((javax.wsdl.Output)((Output)this.messageReference));
        if (this.originalOutput == null) {
            if (this.createMessage) {
                this.createMessage();
            }
        } else if (this.originalOutput.getEMessage() != null) {
            String originalMsgName = this.originalOutput.getEMessage().getQName().getLocalPart();
            boolean gened = false;
            if (this.originalOutput.eContainer() instanceof Operation) {
                gened = SmartRenameAction.isMessageNameGenerated(originalMsgName, ((Operation)this.originalOutput.eContainer()).getName(), "Response");
            }
            String newMsgName = "";
            if (gened) {
                newMsgName = NameUtil.buildUniqueMessageName(this.operation.getEnclosingDefinition(), this.messageReference);
            } else {
                Definition definition = this.operation.getEnclosingDefinition();
                Message tMessage = this.originalOutput.getEMessage();
                newMsgName = NameUtil.buildUniqueMessageName(definition, tMessage.getQName().getLocalPart());
            }
            this.createMessage((MessageReference)this.originalOutput, newMsgName);
        }
    }
}

