/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaElementsAdapterFactory
implements IAdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(JavaElementsAdapterFactory.class);
    private static final Class<?>[] ADAPTER_LIST = new Class[]{ArtifactKey.class, IPath.class, IMavenProjectFacade.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IJavaElement javaElement;
        IProject project;
        IMavenProjectFacade projectFacade;
        if (adapterType == ArtifactKey.class) {
            if (adaptableObject instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragment = (IPackageFragmentRoot)adaptableObject;
                IProject project2 = fragment.getJavaProject().getProject();
                if (project2.isAccessible() && fragment.isArchive()) {
                    try {
                        return adapterType.cast(this.getBuildPathManager().findArtifact(project2, fragment.getPath()));
                    }
                    catch (CoreException ex) {
                        log.error("Can't find artifact for " + String.valueOf(fragment), (Throwable)ex);
                        return null;
                    }
                }
            } else if (adaptableObject instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)adaptableObject;
                return adapterType.cast(javaProject.getProject().getAdapter(ArtifactKey.class));
            }
        } else if (adapterType == IPath.class) {
            IJavaElement javaElement2;
            IResource resource;
            if (adaptableObject instanceof IJavaElement && (resource = (javaElement2 = (IJavaElement)adaptableObject).getResource()) != null) {
                return adapterType.cast(resource.getLocation());
            }
        } else if (adapterType == IMavenProjectFacade.class && adaptableObject instanceof IJavaElement && (projectFacade = this.getProjectFacade(project = (javaElement = (IJavaElement)adaptableObject).getJavaProject().getProject())) != null) {
            return adapterType.cast(projectFacade);
        }
        return null;
    }

    private BuildPathManager getBuildPathManager() {
        return (BuildPathManager)MavenJdtPlugin.getDefault().getBuildpathManager();
    }

    private IMavenProjectFacade getProjectFacade(IProject project) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        return projectManager.create(project, (IProgressMonitor)new NullProgressMonitor());
    }
}

