/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_wo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BY = "Belaris";
        final String metaValue_MT = "Malt";
        final String metaValue_ar = "Araab";
        final String metaValue_la = "Latin";
        final Object[][] data = new Object[][] {
            { "AD", "Andoor" },
            { "AE", "Emira Arab Ini" },
            { "AF", "Afganista\u014b" },
            { "AG", "Antiguwa ak Barbuda" },
            { "AI", "Angiiy" },
            { "AL", "Albani" },
            { "AM", "Armeni" },
            { "AO", "\u00c0ngolaa" },
            { "AQ", "Antarktik" },
            { "AR", "Ars\u00e0ntin" },
            { "AS", "Samowa bu Amerig" },
            { "AT", "\u00d3tiriis" },
            { "AU", "Ostarali" },
            { "AW", "Aruba" },
            { "AX", "Duni Aal\u00e0nd" },
            { "AZ", "Aserbayja\u014b" },
            { "BA", "Bosni Ersegowin" },
            { "BB", "Barbad" },
            { "BD", "Bengalades" },
            { "BE", "Belsig" },
            { "BF", "Burkina Faaso" },
            { "BG", "Bilgari" },
            { "BH", "Bahreyin" },
            { "BI", "Burundi" },
            { "BJ", "Benee" },
            { "BL", "Sa\u014b Bartalemi" },
            { "BM", "Bermid" },
            { "BN", "Burney" },
            { "BO", "Boliwi" },
            { "BR", "Beresil" },
            { "BS", "Bahamas" },
            { "BT", "Buta\u014b" },
            { "BV", "Dunu Buwet" },
            { "BW", "Botswana" },
            { "BY", metaValue_BY },
            { "BZ", "Belis" },
            { "CA", "Kanadaa" },
            { "CC", "Duni Koko (Kilin)" },
            { "CD", "Kongo (R K D)" },
            { "CF", "Repiblik S\u00e0ntar Afrik" },
            { "CG", "R\u00e9ewum Kongo" },
            { "CH", "Siwis" },
            { "CI", "Kodiwaar" },
            { "CK", "Duni Kuuk" },
            { "CL", "Sili" },
            { "CM", "Kamerun" },
            { "CN", "Siin" },
            { "CO", "Kolombi" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo Werde" },
            { "CW", "Kursawo" },
            { "CX", "Dunu Kirismas" },
            { "CY", "Siipar" },
            { "CZ", "R\u00e9ewum Cek" },
            { "DE", "Almaa\u00f1" },
            { "DJ", "Jibuti" },
            { "DK", "Danm\u00e0rk" },
            { "DM", "Dominik" },
            { "DO", "Repiblik Dominiken" },
            { "DZ", "Alseri" },
            { "EC", "Ekwaat\u00ebr" },
            { "EE", "Estoni" },
            { "EG", "Esipt" },
            { "ER", "Eritere" },
            { "ES", "Espa\u00f1" },
            { "ET", "Ecopi" },
            { "FI", "Finl\u00e0nd" },
            { "FJ", "Fijji" },
            { "FK", "Duni Falkland" },
            { "FM", "Mikoronesi" },
            { "FO", "Duni Faro" },
            { "FR", "Faraans" },
            { "GA", "Gabo\u014b" },
            { "GB", "Ruwaayom Ini" },
            { "GD", "Garanad" },
            { "GE", "Seworsi" },
            { "GF", "Guyaan Fara\u00f1se" },
            { "GG", "Gernase" },
            { "GH", "Gana" },
            { "GI", "Sibraltaar" },
            { "GL", "Girinl\u00e0nd" },
            { "GM", "G\u00e0mbi" },
            { "GN", "Gine" },
            { "GP", "Guwaadelup" },
            { "GQ", "Gine Ekuwatoriyal" },
            { "GR", "Gerees" },
            { "GS", "Seworsi di Sid ak Duni S\u00e0ndwiis di Sid" },
            { "GT", "Guwatemala" },
            { "GU", "Guwam" },
            { "GW", "Gine-Bisaaw\u00f3o" },
            { "GY", "Giyaan" },
            { "HK", "Oo\u014b Ko\u014b" },
            { "HM", "Duni H\u00ebrd ak Duni MakDonald" },
            { "HN", "Onduraas" },
            { "HR", "Korowasi" },
            { "HT", "Ayti" },
            { "HU", "Ongari" },
            { "ID", "Indonesi" },
            { "IE", "Irl\u00e0nd" },
            { "IL", "Israyel" },
            { "IM", "Dunu Maan" },
            { "IN", "End" },
            { "IO", "Terituwaaru Br\u00ebtaa\u00f1 ci Oseyaa Enje\u014b" },
            { "IQ", "Irag" },
            { "IR", "Ira\u014b" },
            { "IS", "Isl\u00e0nd" },
            { "IT", "Itali" },
            { "JE", "Serse" },
            { "JM", "Samayig" },
            { "JO", "Sordani" },
            { "JP", "S\u00e0ppo\u014b" },
            { "KE", "Kee\u00f1a" },
            { "KG", "Kirgista\u014b" },
            { "KH", "K\u00e0mboj" },
            { "KI", "Kiribati" },
            { "KM", "Komoor" },
            { "KN", "Sa\u014b Kits ak Newis" },
            { "KP", "Kore Noor" },
            { "KW", "Kowet" },
            { "KY", "Duni Kayma\u014b" },
            { "KZ", "Kasaxsta\u014b" },
            { "LA", "Lawos" },
            { "LB", "Libaa" },
            { "LC", "Sa\u014b Lusi" },
            { "LI", "Liktensteyin" },
            { "LK", "Siri L\u00e0nka" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litiyani" },
            { "LU", "Liks\u00e0mbur" },
            { "LV", "Letoni" },
            { "LY", "Libi" },
            { "MA", "Marog" },
            { "MC", "Monako" },
            { "MD", "Moldawi" },
            { "ME", "Montenegoro" },
            { "MF", "Sa\u014b Marte\u014b" },
            { "MG", "Madagaskaar" },
            { "MH", "Duni Marsaal" },
            { "MK", "Maseduwaan b\u00ebj G\u00e0nnaar" },
            { "ML", "Mali" },
            { "MM", "Miyanmaar" },
            { "MN", "Mongoli" },
            { "MO", "Makaawo" },
            { "MP", "Duni Mariyaan Noor" },
            { "MQ", "Martinik" },
            { "MR", "Mooritani" },
            { "MS", "Mooseraa" },
            { "MT", metaValue_MT },
            { "MU", "Moriis" },
            { "MV", "Maldiiw" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesi" },
            { "MZ", "Mos\u00e0mbig" },
            { "NA", "Namibi" },
            { "NC", "Nuwel Kaledoni" },
            { "NE", "Niiseer" },
            { "NF", "Dunu Norfolk" },
            { "NG", "Niseriya" },
            { "NI", "Nikaraguwa" },
            { "NL", "Peyi Baa" },
            { "NO", "Norwees" },
            { "NP", "Nepaal" },
            { "NR", "Nawru" },
            { "NU", "Niw" },
            { "NZ", "Nuwel Sel\u00e0nd" },
            { "OM", "Omaan" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesi Fara\u00f1se" },
            { "PG", "Papuwasi Gine Gu Bees" },
            { "PH", "Filipin" },
            { "PK", "Pakista\u014b" },
            { "PL", "Polo\u00f1" },
            { "PM", "Sa\u014b Peer ak Mikelo\u014b" },
            { "PN", "Duni Pitkayirn" },
            { "PR", "Porto Riko" },
            { "PT", "Portigaal" },
            { "PW", "Palaw" },
            { "PY", "Paraguwe" },
            { "QA", "Kataar" },
            { "RE", "Ree\u00f1oo" },
            { "RO", "Rumani" },
            { "RS", "Serbi" },
            { "RU", "Risi" },
            { "RW", "Ruw\u00e0nda" },
            { "SA", "Arabi Sawudi" },
            { "SB", "Duni Salmoon" },
            { "SC", "Seysel" },
            { "SD", "Suda\u014b" },
            { "SE", "Suwed" },
            { "SG", "Singapuur" },
            { "SH", "Sa\u014b Eleen" },
            { "SI", "Esloweni" },
            { "SJ", "Swalbaar ak Jan Mayen" },
            { "SK", "Eslowaki" },
            { "SL", "Siyera Lewon" },
            { "SM", "San Marino" },
            { "SN", "Senegaal" },
            { "SO", "Somali" },
            { "SR", "Sirinam" },
            { "SS", "Suda\u014b di Sid" },
            { "ST", "Sawo Tome ak Pirinsipe" },
            { "SV", "El Salwadoor" },
            { "SX", "Sin Marten" },
            { "SY", "Siri" },
            { "SZ", "Suwasil\u00e0nd" },
            { "TC", "Duni Tirk ak Kaykos" },
            { "TD", "C\u00e0dd" },
            { "TF", "Teer Ostraal gu Fraas" },
            { "TG", "Togo" },
            { "TH", "Tayl\u00e0nd" },
            { "TJ", "Tajikista\u014b" },
            { "TK", "Tokoloo" },
            { "TL", "Timor Leste" },
            { "TM", "Tirkmenista\u014b" },
            { "TN", "Tinisi" },
            { "TO", "Tonga" },
            { "TR", "Tirki" },
            { "TT", "Tirinite ak Tobago" },
            { "TV", "Tuwalo" },
            { "TW", "Taywan" },
            { "TZ", "Ta\u014bsani" },
            { "UA", "Ikeren" },
            { "UG", "Ug\u00e0nda" },
            { "UM", "Duni Amerig Utar meer" },
            { "US", "Etaa Sini" },
            { "UY", "Uruge" },
            { "UZ", "Usbekista\u014b" },
            { "VA", "Site bu Watikaa" },
            { "VC", "Sa\u014b Weesaa ak Garanadin" },
            { "VE", "Wenesiyela" },
            { "VG", "Duni Wirsin yu Br\u00ebtaa\u00f1" },
            { "VI", "Duni Wirsin yu Etaa-sini" },
            { "VN", "Wiyetnam" },
            { "VU", "Wanuatu" },
            { "WF", "Walis ak Futuna" },
            { "WS", "Samowa" },
            { "XK", "Kosowo" },
            { "YE", "Yaman" },
            { "YT", "Mayot" },
            { "ZA", "Afrik di Sid" },
            { "ZM", "S\u00e0mbi" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Gox bu\u00f1 xamul" },
            { "af", "Afrikaans" },
            { "am", "Amharik" },
            { "ar", metaValue_ar },
            { "as", "Asame" },
            { "az", "Aserbayjane" },
            { "ba", "Baskir" },
            { "be", metaValue_BY },
            { "bg", "Bilgaar" },
            { "bn", "Ba\u014bla" },
            { "bo", "Tibetan" },
            { "br", "Breton" },
            { "bs", "Bos\u00f1ak" },
            { "ca", "Katalan" },
            { "co", "Kors" },
            { "cs", "Cek" },
            { "cy", "Wels" },
            { "da", "Danuwa" },
            { "de", "Almaa" },
            { "dv", "Diweyi" },
            { "dz", "Dsongkaa" },
            { "el", "Gereg" },
            { "en", "\u00c0ngale" },
            { "eo", "Esperantoo" },
            { "es", "Espa\u00f1ol" },
            { "et", "Esto\u00f1iye" },
            { "eu", "Bask" },
            { "fa", "Pers" },
            { "ff", "P\u00ebl" },
            { "fi", "Feyl\u00e0nde" },
            { "fo", "Feroos" },
            { "fr", "Fara\u00f1se" },
            { "ga", "Irl\u00e0nde" },
            { "gd", "Galuwaa bu Ekos" },
            { "gl", "Galisiye" },
            { "gn", "Garani" },
            { "gu", "Gujarati" },
            { "ha", "Hawsa" },
            { "he", "Ebr\u00eb" },
            { "hi", "Endo" },
            { "hr", "Krowat" },
            { "ht", "Kereyolu Ayti" },
            { "hu", "Ongruwaa" },
            { "hy", "Armaniye" },
            { "hz", "Herero" },
            { "id", "Endonesiye" },
            { "ig", "Igbo" },
            { "is", "Isl\u00e0nde" },
            { "it", "Italiye" },
            { "iu", "Inuktitit" },
            { "ja", "Sapone" },
            { "ka", "Sorsiye" },
            { "kk", "Kasax" },
            { "km", "Xmer" },
            { "kn", "Kannadaa" },
            { "ko", "Koreye" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdi" },
            { "ky", "Kirgiis" },
            { "la", metaValue_la },
            { "lb", "Liks\u00e0mbursuwaa" },
            { "lo", "Laaw" },
            { "lt", "Lituyaniye" },
            { "lv", "Letoniye" },
            { "mg", "Malagasi" },
            { "mi", "Mawri" },
            { "mk", "Maseduwaane" },
            { "ml", "Malayalam" },
            { "mn", "Mongoliye" },
            { "mr", "Marati" },
            { "ms", "Malay" },
            { "mt", metaValue_MT },
            { "my", "Birmes" },
            { "ne", "Nepale" },
            { "nl", "Neyerl\u00e0nde" },
            { "no", "Nerwesiye" },
            { "ny", "Sewa" },
            { "oc", "Ositan" },
            { "om", "Oromo" },
            { "or", "Oja" },
            { "pa", "Punjabi" },
            { "pl", "Polone" },
            { "ps", "Pasto" },
            { "pt", "Purtugees" },
            { "qu", "Kesuwa" },
            { "rm", "Romaas" },
            { "ro", "Rumaniyee" },
            { "ru", "Rus" },
            { "rw", "Kinyarw\u00e0nda" },
            { "sa", "Sanskrit" },
            { "sd", "Sindi" },
            { "se", "Penku Sami" },
            { "si", "Sinala" },
            { "sk", "Eslowaki (Eslowak)" },
            { "sl", "Esloweniye" },
            { "so", "Somali (l\u00e0kk)" },
            { "sq", "Albane" },
            { "sr", "Serb" },
            { "sv", "Suweduwaa" },
            { "ta", "Tamil" },
            { "te", "Telugu" },
            { "tg", "Tajis" },
            { "th", "Tay" },
            { "ti", "Tigri\u00f1a" },
            { "tk", "Tirkmen" },
            { "to", "Tongan" },
            { "tr", "Tirk" },
            { "tt", "Tatar" },
            { "ug", "Uygur" },
            { "uk", "Ikreniye" },
            { "ur", "Urdu" },
            { "uz", "Usbek" },
            { "ve", "Wenda" },
            { "vi", "Wiyetnaamiye" },
            { "wo", "Wolof" },
            { "yi", "Yidis" },
            { "yo", "Yoruba" },
            { "zh", "Sinuwaa" },
            { "ban", "Bali" },
            { "bem", "Bemba" },
            { "ceb", "Sibiyanoo" },
            { "chm", "Mari" },
            { "chr", "Ceroki" },
            { "ckb", "Kurdi gu Diggu" },
            { "dsb", "Sorab-Suuf" },
            { "fil", "Filipiye" },
            { "haw", "Hawaye" },
            { "hil", "Hiligaynon" },
            { "hsb", "Sorab-Kaw" },
            { "ibb", "Ibibiyo" },
            { "kok", "Konkani" },
            { "kru", "Kuruks" },
            { "men", "Mende" },
            { "mni", "Manipuri" },
            { "moh", "Mowak" },
            { "niu", "Niweyan" },
            { "pap", "Papiyamento" },
            { "quc", "Kishe" },
            { "sah", "Saxa" },
            { "sat", "Santali" },
            { "sma", "Sami gu Saalum" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Eskolt Sami" },
            { "syr", "Siryak" },
            { "tzm", "Tamasis gu Digg Atlaas" },
            { "und", "L\u00e0kk wu\u00f1 xamul" },
            { "Arab", metaValue_ar },
            { "Cyrl", "Sirilik" },
            { "Hans", "Bu\u00f1 woyofal" },
            { "Hant", "Cosaan" },
            { "Latn", metaValue_la },
            { "Zxxx", "Lu\u00f1 bindul" },
            { "Zzzz", "Mbind mu\u00f1 xamul" },
            { "de_AT", "Almaa bu \u00d3tiriis" },
            { "de_CH", "Almaa bu Kawe bu Swis" },
            { "en_AU", "\u00c0ngale bu \u00d3straali" },
            { "en_CA", "\u00c0ngale bu Kanadaa" },
            { "en_GB", "\u00c0ngale bu Gr\u00e0nd Br\u00ebtaa\u00f1" },
            { "en_US", "\u00c0ngale bu Amerik" },
            { "es_ES", "Espa\u00f1ol bu Tug\u00ebl" },
            { "es_MX", "Espa\u00f1ol bu Meksik" },
            { "fr_CA", "Fra\u00f1se bu Kanadaa" },
            { "fr_CH", "Fra\u00f1se bu Swis" },
            { "pt_BR", "Purtugees bu Bresil" },
            { "pt_PT", "Portugees bu Tug\u00ebl" },
            { "es_419", "Espa\u00f1ol bu Amerik Latin" },
            { "zh_Hans", "Sinuwaa bu\u00f1 woyofal" },
            { "zh_Hant", "Sinuwaa bu cosaan" },
            { "type.nu.latn", "Siifari Tugal" },
            { "type.co.standard", "SSO (Toftalin wi\u00f1 g\u00ebn a xam)" },
            { "type.ca.gregorian", "Arminaatu Gregoriyee" },
        };
        return data;
    }
}
