/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    private static final String UTF8_STRING = "UTF8_STRING";
    private static final String STRING = "STRING";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_PLAIN_UTF8 = "text/plain;charset=utf-8";
    private static final int COMPOUND_TEXT_ID = TextTransfer.registerType("COMPOUND_TEXT");
    private static final int UTF8_STRING_ID = TextTransfer.registerType("UTF8_STRING");
    private static final int STRING_ID = TextTransfer.registerType("STRING");
    private static final int TEXT_PLAIN_ID = TextTransfer.registerType("text/plain");
    private static final int TEXT_PLAIN_UTF8_ID = TextTransfer.registerType("text/plain;charset=utf-8");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (GTK.GTK4) {
            this.javaToNativeGTK4(object, transferData);
            return;
        }
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] utf8 = Converter.wcsToMbcs(string, true);
        if (OS.isX11() && transferData.type == (long)COMPOUND_TEXT_ID) {
            long[] encoding = new long[1];
            int[] format = new int[1];
            long[] ctext = new long[1];
            int[] length = new int[1];
            boolean result = GDK.gdk_x11_display_utf8_to_compound_text(GDK.gdk_display_get_default(), utf8, encoding, format, ctext, length);
            if (!result) {
                return;
            }
            transferData.type = encoding[0];
            transferData.format = format[0];
            transferData.length = length[0];
            transferData.pValue = ctext[0];
            transferData.result = 1;
        }
        if (transferData.type == (long)UTF8_STRING_ID || transferData.type == (long)TEXT_PLAIN_UTF8_ID) {
            long pValue = OS.g_malloc(utf8.length);
            if (pValue == 0L) {
                return;
            }
            C.memmove(pValue, utf8, (long)utf8.length);
            transferData.format = 8;
            transferData.length = utf8.length - 1;
            transferData.pValue = pValue;
            transferData.result = 1;
        }
        if (transferData.type == (long)STRING_ID) {
            long string_target = GDK.gdk_utf8_to_string_target(utf8);
            if (string_target == 0L) {
                return;
            }
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = C.strlen(string_target);
            transferData.pValue = string_target;
            transferData.result = 1;
        }
    }

    private void javaToNativeGTK4(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        super.javaToNative(Converter.wcsToMbcs((String)object, false), transferData);
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (GTK.GTK4) {
            return this.nativeToJavaGTK4(transferData);
        }
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        long[] list = new long[1];
        int count = GDK.gdk_text_property_to_utf8_list_for_display(GDK.gdk_display_get_default(), transferData.type, transferData.format, transferData.pValue, transferData.length, list);
        if (count == 0) {
            return null;
        }
        long[] ptr = new long[1];
        C.memmove(ptr, list[0], (long)C.PTR_SIZEOF);
        int length = C.strlen(ptr[0]);
        byte[] utf8 = new byte[length];
        C.memmove(utf8, ptr[0], (long)length);
        OS.g_strfreev(list[0]);
        char[] unicode = Converter.mbcsToWcs(utf8);
        String string = new String(unicode);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    private Object nativeToJavaGTK4(TransferData transferData) {
        Object buffer = super.nativeToJava(transferData);
        if (buffer instanceof byte[]) {
            byte[] bytes = (byte[])buffer;
            return new String(Converter.mbcsToWcs(bytes));
        }
        return null;
    }

    @Override
    protected int[] getTypeIds() {
        if (GTK.GTK4) {
            return new int[]{TEXT_PLAIN_UTF8_ID, TEXT_PLAIN_ID, STRING_ID};
        }
        if (OS.isX11()) {
            return new int[]{UTF8_STRING_ID, COMPOUND_TEXT_ID, STRING_ID};
        }
        return new int[]{UTF8_STRING_ID, STRING_ID, TEXT_PLAIN_UTF8_ID};
    }

    @Override
    protected String[] getTypeNames() {
        if (GTK.GTK4) {
            return new String[]{TEXT_PLAIN_UTF8, TEXT_PLAIN, STRING};
        }
        if (OS.isX11()) {
            return new String[]{UTF8_STRING, COMPOUND_TEXT, STRING};
        }
        return new String[]{UTF8_STRING, STRING, TEXT_PLAIN_UTF8};
    }

    boolean checkText(Object object) {
        return object instanceof String && !((String)object).isEmpty();
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

