/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;

public final class ExtractInterfaceConstraintsSolver
extends SuperTypeConstraintsSolver {
    private final String fName;

    public ExtractInterfaceConstraintsSolver(SuperTypeConstraintsModel model, String name) {
        super(model);
        Assert.isNotNull((Object)name);
        this.fName = name;
    }

    @Override
    protected ITypeSet computeTypeEstimate(ConstraintVariable2 variable) {
        TType type = variable.getType();
        if (variable instanceof ImmutableTypeVariable2 || !type.getErasure().equals(this.fModel.getSubType().getErasure())) {
            return SuperTypeSet.createTypeSet(type);
        }
        TType[] tTypeArray = type.getInterfaces();
        int n = tTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TType t = tTypeArray[n2];
            if (t.getName().startsWith(this.fName) && t.getErasure().equals(this.fModel.getSuperType().getErasure())) {
                return SuperTypeSet.createTypeSet(type, t);
            }
            ++n2;
        }
        return SuperTypeSet.createTypeSet(type);
    }
}

