/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewRepositoryWizard;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.TaskRepositoryWizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddRepositoryAction
extends Action {
    @Deprecated
    private static final String PREF_ADD_QUERY = "org.eclipse.mylyn.internal.tasks.add.query";
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.add";
    public static final String TITLE = Messages.AddRepositoryAction_Add_Task_Repository;
    private boolean promptToAddQuery = true;

    public AddRepositoryAction() {
        this.setImageDescriptor(TasksUiImages.REPOSITORY_NEW);
        this.setText(TITLE);
        this.setId(ID);
        boolean enabled = TasksUiPlugin.getRepositoryManager().hasUserManagedRepositoryConnectors();
        if (!enabled) {
            Command command = TasksUiInternal.getConfiguredDiscoveryWizardCommand();
            enabled = command != null && command.isEnabled();
        }
        this.setEnabled(enabled);
    }

    public boolean getPromptToAddQuery() {
        return this.promptToAddQuery;
    }

    public void setPromptToAddQuery(boolean promptToAddQuery) {
        this.promptToAddQuery = promptToAddQuery;
    }

    public void run() {
        this.showWizard();
    }

    public TaskRepository showWizard() {
        return this.showWizard(WorkbenchUtil.getShell(), null);
    }

    public TaskRepository showWizard(Shell shell, String connectorKind) {
        NewRepositoryWizard repositoryWizard = new NewRepositoryWizard(connectorKind);
        repositoryWizard.setShowNewQueryPromptOnFinish(this.getPromptToAddQuery());
        TaskRepositoryWizardDialog dialog = new TaskRepositoryWizardDialog(shell, (IWizard)repositoryWizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            return repositoryWizard.getTaskRepository();
        }
        return null;
    }

    @Deprecated
    public void promptToAddQuery(TaskRepository taskRepository) {
        IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean(PREF_ADD_QUERY)) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.AddRepositoryAction_Add_new_query, (String)Messages.AddRepositoryAction_Add_a_query_to_the_Task_List, (String)Messages.AddRepositoryAction_Do_not_show_again, (boolean)false, (IPreferenceStore)preferenceStore, (String)PREF_ADD_QUERY);
            preferenceStore.setValue(PREF_ADD_QUERY, messageDialog.getToggleState());
            if (messageDialog.getReturnCode() == 2) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
                IWizard queryWizard = connectorUi.getQueryWizard(taskRepository, null);
                if (queryWizard instanceof Wizard) {
                    ((Wizard)queryWizard).setForcePreviousAndNextButtons(true);
                }
                WizardDialog queryDialog = new WizardDialog(shell, queryWizard);
                queryDialog.create();
                queryDialog.setBlockOnOpen(true);
                queryDialog.open();
            }
        }
    }
}

