/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.raw;

import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawCaptures;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRule;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;

final class RawCaptures
extends PropertySettable.HashMap<IRawRule>
implements IRawCaptures {
    private static final System.Logger LOGGER = System.getLogger(RawCaptures.class.getName());
    private static final long serialVersionUID = 1L;

    RawCaptures() {
    }

    @Override
    public @Nullable IRawRule getCapture(String captureId) {
        try {
            return (IRawRule)this.get(captureId);
        }
        catch (ClassCastException ex) {
            LOGGER.log(System.Logger.Level.ERROR, "Unexpected ClassCastException in RawCaptures.getCapture(\"" + captureId + "\")", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Iterable<String> getCaptureIds() {
        return this.keySet();
    }

    @Override
    public void forEachCapture(BiConsumer<String, IRawRule> action) {
        this.forEach((captureId, rule) -> {
            try {
                if ("comment".equals(captureId) && rule instanceof String) {
                    return;
                }
                action.accept((String)captureId, (IRawRule)rule);
            }
            catch (ClassCastException ex) {
                LOGGER.log(System.Logger.Level.ERROR, "Unexpected ClassCastException in RawCaptures.getCapture(\"" + captureId + "\")", (Throwable)ex);
                throw ex;
            }
        });
    }
}

