/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.MultiLongValues;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.internal.hppc.LongIntHashMap;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.PriorityQueue;

public class LongValueFacetCounts
extends Facets {
    private int[] counts;
    private LongIntHashMap hashCounts;
    private boolean initialized;
    private final String field;
    private int totCount;

    public LongValueFacetCounts(String field, FacetsCollector hits) throws IOException {
        this(field, (LongValuesSource)null, hits);
    }

    public LongValueFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits) throws IOException {
        this.field = field;
        if (valueSource != null) {
            this.count(valueSource, hits.getMatchingDocs());
        } else {
            this.count(field, hits.getMatchingDocs());
        }
    }

    public LongValueFacetCounts(String field, MultiLongValuesSource valuesSource, FacetsCollector hits) throws IOException {
        this.field = field;
        if (valuesSource != null) {
            LongValuesSource singleValues = MultiLongValuesSource.unwrapSingleton(valuesSource);
            if (singleValues != null) {
                this.count(singleValues, hits.getMatchingDocs());
            } else {
                this.count(valuesSource, hits.getMatchingDocs());
            }
        } else {
            this.count(field, hits.getMatchingDocs());
        }
    }

    public LongValueFacetCounts(String field, IndexReader reader) throws IOException {
        this(field, (LongValuesSource)null, reader);
    }

    public LongValueFacetCounts(String field, LongValuesSource valueSource, IndexReader reader) throws IOException {
        this.field = field;
        this.initializeCounters();
        if (valueSource != null) {
            this.countAll(reader, valueSource);
        } else {
            this.countAll(reader, field);
        }
    }

    public LongValueFacetCounts(String field, MultiLongValuesSource valuesSource, IndexReader reader) throws IOException {
        this.field = field;
        this.initializeCounters();
        if (valuesSource != null) {
            LongValuesSource singleValued = MultiLongValuesSource.unwrapSingleton(valuesSource);
            if (singleValued != null) {
                this.countAll(reader, singleValued);
            } else {
                this.countAll(reader, valuesSource);
            }
        } else {
            this.countAll(reader, field);
        }
    }

    private void initializeCounters() {
        if (this.initialized) {
            return;
        }
        assert (this.counts == null && this.hashCounts == null);
        this.initialized = true;
        this.counts = new int[1024];
        this.hashCounts = new LongIntHashMap();
    }

    private void count(LongValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits() == 0) continue;
            this.initializeCounters();
            LongValues fv = valueSource.getValues(hits.context(), null);
            DocIdSetIterator docs = hits.bits().iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    this.increment(fv.longValue());
                    ++this.totCount;
                }
                doc = docs.nextDoc();
            }
        }
    }

    private void count(MultiLongValuesSource valuesSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits() == 0) continue;
            this.initializeCounters();
            MultiLongValues multiValues = valuesSource.getValues(hits.context());
            DocIdSetIterator docs = hits.bits().iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (multiValues.advanceExact(doc)) {
                    long limit = multiValues.getValueCount();
                    if (limit > 0L) {
                        ++this.totCount;
                    }
                    long previousValue = 0L;
                    int i = 0;
                    while ((long)i < limit) {
                        long value = multiValues.nextValue();
                        if (i == 0 || value != previousValue) {
                            this.increment(value);
                            previousValue = value;
                        }
                        ++i;
                    }
                }
                doc = docs.nextDoc();
            }
        }
    }

    private void count(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int doc;
            DocIdSetIterator it;
            if (hits.totalHits() == 0) continue;
            this.initializeCounters();
            SortedNumericDocValues multiValues = DocValues.getSortedNumeric((LeafReader)hits.context().reader(), (String)field);
            NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)multiValues);
            if (singleValues != null) {
                it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits().iterator(), singleValues));
                doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    this.increment(singleValues.longValue());
                    ++this.totCount;
                    doc = it.nextDoc();
                }
                continue;
            }
            it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits().iterator(), multiValues));
            doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int limit = multiValues.docValueCount();
                if (limit > 0) {
                    ++this.totCount;
                }
                long previousValue = 0L;
                for (int i = 0; i < limit; ++i) {
                    long value = multiValues.nextValue();
                    if (i != 0 && value == previousValue) continue;
                    this.increment(value);
                    previousValue = value;
                }
                doc = it.nextDoc();
            }
        }
    }

    private void countAll(IndexReader reader, LongValuesSource valueSource) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            LongValues fv = valueSource.getValues(context, null);
            int maxDoc = context.reader().maxDoc();
            for (int doc = 0; doc < maxDoc; ++doc) {
                if (!fv.advanceExact(doc)) continue;
                this.increment(fv.longValue());
                ++this.totCount;
            }
        }
    }

    private void countAll(IndexReader reader, MultiLongValuesSource valueSource) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            MultiLongValues multiValues = valueSource.getValues(context);
            int maxDoc = context.reader().maxDoc();
            for (int doc = 0; doc < maxDoc; ++doc) {
                if (!multiValues.advanceExact(doc)) continue;
                long limit = multiValues.getValueCount();
                if (limit > 0L) {
                    ++this.totCount;
                }
                long previousValue = 0L;
                int i = 0;
                while ((long)i < limit) {
                    long value = multiValues.nextValue();
                    if (i == 0 || value != previousValue) {
                        this.increment(value);
                        previousValue = value;
                    }
                    ++i;
                }
            }
        }
    }

    private void countAll(IndexReader reader, String field) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            int doc;
            SortedNumericDocValues multiValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
            NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)multiValues);
            Bits liveDocs = context.reader().getLiveDocs();
            NumericDocValues valuesIt = singleValues != null ? singleValues : multiValues;
            Object object = valuesIt = liveDocs != null ? FacetUtils.liveDocsDISI((DocIdSetIterator)valuesIt, liveDocs) : valuesIt;
            if (singleValues != null) {
                doc = valuesIt.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    ++this.totCount;
                    this.increment(singleValues.longValue());
                    doc = valuesIt.nextDoc();
                }
                continue;
            }
            doc = valuesIt.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int limit = multiValues.docValueCount();
                if (limit > 0) {
                    ++this.totCount;
                }
                long previousValue = 0L;
                for (int i = 0; i < limit; ++i) {
                    long value = multiValues.nextValue();
                    if (i != 0 && value == previousValue) continue;
                    this.increment(value);
                    previousValue = value;
                }
                doc = valuesIt.nextDoc();
            }
        }
    }

    private void increment(long value) {
        if (value >= 0L && value < (long)this.counts.length) {
            int n = (int)value;
            this.counts[n] = this.counts[n] + 1;
        } else {
            this.hashCounts.addTo(value, 1);
        }
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        this.validateDimAndPathForGetChildren(dim, path);
        if (!this.initialized) {
            assert (this.totCount == 0);
            return new FacetResult(this.field, new String[0], this.totCount, new LabelAndValue[0], 0);
        }
        ArrayList<LabelAndValue> labelValues = new ArrayList<LabelAndValue>();
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            labelValues.add(new LabelAndValue(Long.toString(i), this.counts[i]));
        }
        if (this.hashCounts.size() != 0) {
            for (LongIntHashMap.LongIntCursor c : this.hashCounts) {
                int count = c.value;
                if (count == 0) continue;
                labelValues.add(new LabelAndValue(Long.toString(c.key), c.value));
            }
        }
        return new FacetResult(this.field, new String[0], this.totCount, labelValues.toArray(new LabelAndValue[0]), labelValues.size());
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) {
        LongValueFacetCounts.validateTopN(topN);
        this.validateDimAndPathForGetChildren(dim, path);
        if (!this.initialized) {
            assert (this.totCount == 0);
            return new FacetResult(this.field, new String[0], this.totCount, new LabelAndValue[0], 0);
        }
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(this, Math.min(topN, this.counts.length + this.hashCounts.size())){

            protected boolean lessThan(Entry a, Entry b) {
                return a.count < b.count || a.count == b.count && a.value > b.value;
            }
        };
        int childCount = 0;
        Entry e = null;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            ++childCount;
            if (e == null) {
                e = new Entry();
            }
            e.value = i;
            e.count = this.counts[i];
            e = (Entry)pq.insertWithOverflow((Object)e);
        }
        if (this.hashCounts.size() != 0) {
            childCount += this.hashCounts.size();
            for (LongIntHashMap.LongIntCursor c : this.hashCounts) {
                int count = c.value;
                if (count == 0) continue;
                if (e == null) {
                    e = new Entry();
                }
                e.value = c.key;
                e.count = count;
                e = (Entry)pq.insertWithOverflow((Object)e);
            }
        }
        LabelAndValue[] results = new LabelAndValue[pq.size()];
        while (pq.size() != 0) {
            Entry entry = (Entry)pq.pop();
            results[pq.size()] = new LabelAndValue(Long.toString(entry.value), entry.count);
        }
        return new FacetResult(this.field, new String[0], this.totCount, results, childCount);
    }

    public FacetResult getAllChildrenSortByValue() {
        if (!this.initialized) {
            assert (this.totCount == 0);
            return new FacetResult(this.field, new String[0], this.totCount, new LabelAndValue[0], 0);
        }
        ArrayList<LabelAndValue> labelValues = new ArrayList<LabelAndValue>();
        final int[] hashCounts = new int[this.hashCounts.size()];
        final long[] hashValues = new long[this.hashCounts.size()];
        int upto = 0;
        for (LongIntHashMap.LongIntCursor c : this.hashCounts) {
            if (c.value == 0) continue;
            hashCounts[upto] = c.value;
            hashValues[upto] = c.key;
            ++upto;
        }
        assert (upto == this.hashCounts.size()) : "upto=" + upto + " hashCounts.size=" + this.hashCounts.size();
        new InPlaceMergeSorter(this){

            public int compare(int i, int j) {
                return Long.compare(hashValues[i], hashValues[j]);
            }

            public void swap(int i, int j) {
                int x = hashCounts[i];
                hashCounts[i] = hashCounts[j];
                hashCounts[j] = x;
                long y = hashValues[j];
                hashValues[j] = hashValues[i];
                hashValues[i] = y;
            }
        }.sort(0, upto);
        boolean countsAdded = false;
        for (int i = 0; i < upto; ++i) {
            if (!countsAdded && hashValues[i] >= (long)this.counts.length) {
                countsAdded = true;
                this.appendCounts(labelValues);
            }
            labelValues.add(new LabelAndValue(Long.toString(hashValues[i]), hashCounts[i]));
        }
        if (!countsAdded) {
            this.appendCounts(labelValues);
        }
        return new FacetResult(this.field, new String[0], this.totCount, labelValues.toArray(new LabelAndValue[0]), labelValues.size());
    }

    private void appendCounts(List<LabelAndValue> labelValues) {
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            labelValues.add(new LabelAndValue(Long.toString(i), this.counts[i]));
        }
    }

    private void validateDimAndPathForGetChildren(String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) {
        LongValueFacetCounts.validateTopN(topN);
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongValueFacetCounts totCount=");
        b.append(this.totCount);
        if (this.initialized) {
            b.append(":\n");
            for (int i = 0; i < this.counts.length; ++i) {
                if (this.counts[i] == 0) continue;
                b.append("  ");
                b.append(i);
                b.append(" -> count=");
                b.append(this.counts[i]);
                b.append('\n');
            }
            if (this.hashCounts.size() != 0) {
                for (LongIntHashMap.LongIntCursor c : this.hashCounts) {
                    if (c.value == 0) continue;
                    b.append("  ");
                    b.append(c.key);
                    b.append(" -> count=");
                    b.append(c.value);
                    b.append('\n');
                }
            }
        }
        return b.toString();
    }

    private static class Entry {
        int count;
        long value;

        private Entry() {
        }
    }
}

