/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.progress.WorkbenchJob;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ExternalToolAction
extends AbstractBreakpointAction {
    private String externalToolName = "";

    public IStatus execute(final IBreakpoint breakpoint, final IAdaptable context, IProgressMonitor monitor) {
        WorkbenchJob uiJob = new WorkbenchJob("ExternalToolAction"){
            {
                super($anonymous0);
                this.setPriority(10);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                return ExternalToolAction.this.executeInUIThread(breakpoint, context, monitor);
            }
        };
        uiJob.schedule();
        try {
            uiJob.join();
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        return uiJob.getResult();
    }

    private IStatus executeInUIThread(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        IStatus errorStatus = null;
        ILaunchManager lcm = DebugPlugin.getDefault().getLaunchManager();
        try {
            boolean launched = false;
            ILaunchConfiguration[] launchConfigurations = lcm.getLaunchConfigurations();
            int i = 0;
            while (i < launchConfigurations.length) {
                if (launchConfigurations[i].getName().equals(this.externalToolName)) {
                    DebugUITools.launch((ILaunchConfiguration)launchConfigurations[i], (String)"run");
                    launched = true;
                    break;
                }
                ++i;
            }
            if (!launched) {
                String errorMsg = MessageFormat.format(Messages.getString("ExternalToolAction.error.0"), this.externalToolName);
                errorStatus = new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, errorMsg, null);
            }
        }
        catch (CoreException e) {
            errorStatus = e.getStatus();
        }
        catch (Exception e) {
            errorStatus = new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), (Throwable)e);
        }
        if (errorStatus != null) {
            String errorMsg = MessageFormat.format(Messages.getString("ExternalToolAction.error.1"), this.externalToolName);
            MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, errorMsg, null);
            ms.add(errorStatus);
            return ms;
        }
        return Status.OK_STATUS;
    }

    public String getDefaultName() {
        return "Untitled External Tool Action";
    }

    public String getExternalToolName() {
        return this.externalToolName;
    }

    public void setExternalToolName(String launchConfigName) {
        this.externalToolName = launchConfigName;
    }

    public String getIdentifier() {
        return "org.eclipse.cdt.debug.ui.breakpointactions.ExternalToolAction";
    }

    public String getMemento() {
        String executeData = "";
        if (this.externalToolName != null) {
            try {
                DocumentBuilder docBuilder = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("launchConfigName");
                rootElement.setAttribute("configName", this.externalToolName);
                doc.appendChild(rootElement);
                ByteArrayOutputStream s = new ByteArrayOutputStream();
                TransformerFactory factory = XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult outputTarget = new StreamResult(s);
                transformer.transform(source, outputTarget);
                executeData = s.toString("UTF8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return executeData;
    }

    public String getSummary() {
        return MessageFormat.format(Messages.getString("ExternalToolAction.Summary"), this.externalToolName);
    }

    public String getTypeName() {
        return Messages.getString("ExternalToolAction.TypeName");
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            String value = root.getAttribute("configName");
            if (value == null) {
                throw new Exception();
            }
            this.externalToolName = value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

