/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities;

import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lsp4j.MarkupContent;

public class EntitiesDocumentationUtils {
    private EntitiesDocumentationUtils() {
    }

    public static MarkupContent getDocumentation(String entityName, String entityValue, EntityOriginType type, boolean markdown) {
        return EntitiesDocumentationUtils.getDocumentation(entityName, entityValue, null, null, null, type, markdown);
    }

    public static MarkupContent getDocumentation(DTDEntityDecl entity, EntityOriginType type, boolean markdown) {
        String systemID = entity.getSystemId();
        String publicID = entity.getPublicId();
        String targetURI = entity.getNameParameter().getTargetURI();
        return EntitiesDocumentationUtils.getDocumentation(entity.getName(), entity.getNotationName(), systemID, publicID, targetURI, type, markdown);
    }

    public static MarkupContent getDocumentation(String entityName, String entityValue, String systemID, String publicID, String targetURI, EntityOriginType type, boolean markdown) {
        StringBuilder documentation = new StringBuilder();
        if (markdown) {
            documentation.append("**");
        }
        documentation.append("Entity ");
        documentation.append(entityName);
        if (markdown) {
            documentation.append("**");
        }
        EntitiesDocumentationUtils.addParameter("Value", entityValue, documentation, markdown);
        EntitiesDocumentationUtils.addParameter("Type", type.getLabel(), documentation, markdown);
        EntitiesDocumentationUtils.addParameter("Public ID", publicID, documentation, markdown);
        EntitiesDocumentationUtils.addParameter("System ID", systemID, documentation, markdown);
        if (targetURI != null) {
            documentation.append(System.lineSeparator());
            if (markdown) {
                documentation.append(" * ");
            }
            documentation.append("Source: ");
            if (markdown) {
                documentation.append("[");
                documentation.append(EntitiesDocumentationUtils.getFileName(targetURI));
                documentation.append("]");
                documentation.append("(");
            }
            documentation.append(targetURI);
            if (markdown) {
                documentation.append(")");
            }
        }
        return new MarkupContent(markdown ? "markdown" : "plaintext", documentation.toString());
    }

    private static void addParameter(String name, String value, StringBuilder documentation, boolean markdown) {
        if (value != null && !value.isEmpty()) {
            documentation.append(System.lineSeparator());
            if (markdown) {
                documentation.append(" * ");
            }
            documentation.append(name);
            documentation.append(": ");
            if (markdown) {
                documentation.append("`");
            }
            documentation.append(value);
            if (markdown) {
                documentation.append("`");
            }
        }
    }

    private static String getFileName(String schemaURI) {
        int index = schemaURI.lastIndexOf(47);
        if (index == -1) {
            index = schemaURI.lastIndexOf(92);
        }
        if (index == -1) {
            return schemaURI;
        }
        return schemaURI.substring(index + 1, schemaURI.length());
    }

    public static enum PredefinedEntity {
        lt("&#60;"),
        gt("&#62;"),
        amp("&#38;"),
        apos("&#39;"),
        quot("&#34;");

        private final String value;

        private PredefinedEntity(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name();
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum EntityOriginType {
        PREDEFINED("Predefined"),
        LOCAL("Local"),
        EXTERNAL("External");

        private final String label;

        private EntityOriginType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

