/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DefaultMultilineCommentAutoEditStrategy
implements IAutoEditStrategy {
    protected static final String MULTILINE_START = "/*";
    protected static final String MULTILINE_MID = " * ";
    protected static final String MULTILINE_END = "*/";
    private static String fgDefaultLineDelim = "\n";
    private ICProject fProject;

    public DefaultMultilineCommentAutoEditStrategy() {
        this(null);
    }

    public DefaultMultilineCommentAutoEditStrategy(ICProject project) {
        this.fProject = project;
    }

    protected Optional<IProject> getProject() {
        if (this.fProject != null) {
            return Optional.of(this.fProject.getProject());
        }
        return Optional.empty();
    }

    protected boolean isEnabled() {
        boolean formatBlocks = false;
        formatBlocks = this.fProject == null ? "true".equals(CCorePlugin.getOption((String)"org.eclipse.cdt.core.formatter.format_block_comment")) : "true".equals(this.fProject.getOption("org.eclipse.cdt.core.formatter.format_block_comment", true));
        return formatBlocks;
    }

    public void customizeDocumentCommand(IDocument doc, DocumentCommand cmd) {
        if (!this.isEnabled()) {
            return;
        }
        fgDefaultLineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        if (doc instanceof IDocumentExtension4) {
            boolean forNewLine = cmd.length == 0 && cmd.text != null && DefaultMultilineCommentAutoEditStrategy.endsWithDelimiter(doc, cmd.text);
            boolean forCommentEnd = "/".equals(cmd.text);
            if (forNewLine || forCommentEnd) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)doc;
                DocumentRewriteSession drs = ext4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                try {
                    if (forNewLine) {
                        this.customizeDocumentAfterNewLine(doc, cmd);
                    } else if (forCommentEnd) {
                        this.customizeDocumentForMultilineCommentEnd(doc, cmd);
                    }
                }
                finally {
                    ext4.stopRewriteSession(drs);
                }
            }
        }
    }

    protected void customizeDocumentForMultilineCommentEnd(IDocument doc, DocumentCommand command) {
        if (command.offset < 2 || doc.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(doc.get(command.offset - 2, 2))) {
                ++command.length;
                --command.offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void customizeDocumentAfterNewLine(IDocument doc, DocumentCommand c) {
        if (!this.isEnabled()) {
            return;
        }
        int offset = c.offset;
        if (offset == -1 || doc.getLength() == 0) {
            return;
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        StringBuilder buf = new StringBuilder(c.text);
        try {
            boolean commentAtStart;
            IRegion line = doc.getLineInformationOfOffset(c.offset);
            int lineStart = line.getOffset();
            int firstNonWS = DefaultMultilineCommentAutoEditStrategy.findEndOfWhiteSpaceAt(doc, lineStart, c.offset);
            IRegion prefix = DefaultMultilineCommentAutoEditStrategy.findPrefixRange(doc, line);
            String indentation = doc.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            boolean bl = commentAtStart = firstNonWS < c.offset && doc.getChar(firstNonWS) == '/';
            if (commentAtStart) {
                buf.append(MULTILINE_MID);
            }
            c.shiftsCaret = false;
            c.caretOffset = c.offset + buf.length();
            if (commentAtStart && this.shouldCloseMultiline(doc, c.offset)) {
                try {
                    doc.replace(c.offset, 0, indentation + " */");
                    buf.append(lineDelim);
                    IASTNode dec = null;
                    IIndex index = null;
                    ITranslationUnit unit = this.getTranslationUnitForActiveEditor();
                    if (unit != null) {
                        index = CCorePlugin.getIndexManager().getIndex(unit.getCProject());
                        try {
                            index.acquireReadLock();
                        }
                        catch (InterruptedException e) {
                            index = null;
                        }
                    }
                    try {
                        IASTTranslationUnit ast = this.getAST(unit, index);
                        if (this instanceof IDocCustomizer) {
                            IASTNodeSelector ans;
                            IASTNode node;
                            if (ast != null && (dec = DefaultMultilineCommentAutoEditStrategy.findNextDocumentNode(ast, offset)) == null && (node = (ans = ast.getNodeSelector(ast.getFilePath())).findEnclosingNode(offset, 0)) instanceof IASTDeclaration) {
                                dec = node;
                            }
                            if (dec != null) {
                                ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false);
                                StringBuilder content = null;
                                IDocCustomizer customizer = (IDocCustomizer)((Object)this);
                                CustomizeOptions options = new CustomizeOptions();
                                content = customizer.customizeForDeclaration(doc, dec, partition, options);
                                if (!options.addNewLine) {
                                    buf.setLength(buf.length() - MULTILINE_MID.length() - lineDelim.length());
                                }
                                buf.append((CharSequence)DefaultMultilineCommentAutoEditStrategy.indent(content, indentation + MULTILINE_MID, lineDelim));
                            }
                        } else {
                            IASTNodeSelector ans;
                            IASTNode node;
                            if (ast != null && (dec = DefaultMultilineCommentAutoEditStrategy.findFollowingDeclaration(ast, offset)) == null && (node = (ans = ast.getNodeSelector(ast.getFilePath())).findEnclosingNode(offset, 0)) instanceof IASTDeclaration) {
                                dec = node;
                            }
                            if (dec != null) {
                                ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false);
                                StringBuilder content = null;
                                content = this.customizeAfterNewLineForDeclaration(doc, (IASTDeclaration)dec, partition);
                                buf.append((CharSequence)DefaultMultilineCommentAutoEditStrategy.indent(content, indentation + MULTILINE_MID, lineDelim));
                            }
                        }
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
                catch (BadLocationException ble) {
                    CUIPlugin.log(ble);
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Deprecated
    protected StringBuilder customizeAfterNewLineForDeclaration(IDocument doc, IASTDeclaration dec, ITypedRegion region) {
        return new StringBuilder();
    }

    public static IASTNode findNextDocumentNode(IASTTranslationUnit unit, int offset) {
        IASTDeclaration bestNode = null;
        if (unit != null) {
            IASTPreprocessorMacroDefinition[] macros = unit.getMacroDefinitions();
            SearchVisitor av = new SearchVisitor(offset);
            unit.accept((ASTVisitor)av);
            int nearest = av.getNearest();
            bestNode = av.getTarget();
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = macros;
            int n = macros.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPreprocessorMacroDefinition m = iASTPreprocessorMacroDefinitionArray[n2];
                if (m.getExpansionLocation() != null && m.getExpansionLocation().getNodeOffset() < nearest && offset <= m.getExpansionLocation().getNodeOffset()) {
                    bestNode = m;
                    nearest = m.getExpansionLocation().getNodeOffset();
                }
                ++n2;
            }
        }
        return bestNode;
    }

    public static IASTDeclaration findFollowingDeclaration(IASTTranslationUnit unit, int offset) {
        IASTDeclaration[] dec = new IASTDeclaration[1];
        if (unit != null) {
            SearchVisitor av = new SearchVisitor(offset);
            unit.accept((ASTVisitor)av);
            dec[0] = av.getTarget();
        }
        return dec[0];
    }

    public IASTTranslationUnit getAST() {
        return this.getAST(this.getTranslationUnitForActiveEditor(), null);
    }

    public IASTTranslationUnit getAST(ITranslationUnit unit, IIndex index) {
        try {
            if (unit != null) {
                IASTTranslationUnit ast = unit.getAST(index, 6);
                return ast;
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return null;
    }

    public boolean shouldCloseMultiline(IDocument document, int offset) {
        String comment;
        int partitionEnd;
        block6: {
            ITypedRegion partition;
            block5: {
                try {
                    IRegion line = document.getLineInformationOfOffset(offset);
                    partition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
                    partitionEnd = partition.getOffset() + partition.getLength();
                    if (line.getOffset() < partitionEnd) break block5;
                    return false;
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
            comment = document.get(partition.getOffset(), partition.getLength());
            if (comment.indexOf(MULTILINE_START, offset - partition.getOffset()) == -1) break block6;
            return true;
        }
        if (document.getLength() == partitionEnd) {
            return !comment.endsWith(MULTILINE_END);
        }
        return false;
    }

    @Deprecated
    protected static ITranslationUnit getTranslationUnit() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy unit = manager.getWorkingCopy(editor.getEditorInput());
        if (unit == null) {
            return null;
        }
        return unit;
    }

    protected ITranslationUnit getTranslationUnitForActiveEditor() {
        return DefaultMultilineCommentAutoEditStrategy.getTranslationUnit();
    }

    protected static final StringBuilder indent(StringBuilder buffer, String indent, String lineDelim) {
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(buffer.toString()));
        try {
            String line = br.readLine();
            while (line != null) {
                result.append(indent).append(line).append(lineDelim);
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            throw new AssertionError();
        }
        return result;
    }

    @Deprecated
    protected static final StringBuilder indent(StringBuilder buffer, String indent) {
        return DefaultMultilineCommentAutoEditStrategy.indent(buffer, indent, fgDefaultLineDelim);
    }

    protected static int findEndOfWhiteSpaceAt(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    protected static IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = DefaultMultilineCommentAutoEditStrategy.findEndOfWhiteSpaceAt(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && !DefaultMultilineCommentAutoEditStrategy.isWhitespace(document.getChar(indentEnd))) {
                ++indentEnd;
            }
            while (indentEnd < lineEnd && DefaultMultilineCommentAutoEditStrategy.isWhitespace(document.getChar(indentEnd))) {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    protected static boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class CustomizeOptions {
        public boolean addNewLine = true;
    }

    public static interface IDocCustomizer {
        public StringBuilder customizeForDeclaration(IDocument var1, IASTNode var2, ITypedRegion var3, CustomizeOptions var4);
    }

    private static class SearchVisitor
    extends ASTVisitor {
        private int nearestOffset = Integer.MAX_VALUE;
        private int offset;
        private IASTDeclaration target;
        IASTDeclaration stopWhenLeaving;

        public SearchVisitor(int offset) {
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitNamespaces = true;
            this.offset = offset;
        }

        public int getNearest() {
            return this.nearestOffset;
        }

        public IASTDeclaration getTarget() {
            return this.target;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            int candidateOffset;
            IASTFileLocation loc = namespace.getFileLocation();
            if (loc != null && this.offset <= (candidateOffset = loc.getNodeOffset()) && candidateOffset <= this.nearestOffset) {
                this.nearestOffset = candidateOffset;
                this.target = namespace;
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            IASTFileLocation loc = declaration.getFileLocation();
            if (loc != null) {
                boolean candidateEnclosesOffset;
                int candidateOffset = loc.getNodeOffset();
                int candidateEndOffset = candidateOffset + loc.getNodeLength();
                if (this.offset <= candidateOffset && candidateOffset <= this.nearestOffset) {
                    this.nearestOffset = candidateOffset;
                    this.target = declaration;
                    return 2;
                }
                boolean bl = candidateEnclosesOffset = this.offset >= candidateOffset && this.offset < candidateEndOffset;
                if (candidateEnclosesOffset) {
                    this.stopWhenLeaving = declaration;
                }
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            if (declaration == this.stopWhenLeaving) {
                return 2;
            }
            return 3;
        }
    }
}

