/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.utils;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IUpdateableItemText;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SelectionTreeTextEditor
extends AdapterFactoryTreeEditor {
    protected EditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected String featureValue;

    public SelectionTreeTextEditor(EditingDomain editingDomain, Tree tree, ComposedAdapterFactory adapterFactory) {
        super(tree, (AdapterFactory)adapterFactory);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
    }

    protected void editItem(TreeItem treeItem) {
        String string;
        final Object treeItemData = treeItem.getData();
        IUpdateableItemText updateableItemText = (IUpdateableItemText)this.adapterFactory.adapt(treeItemData, IUpdateableItemText.class);
        if (updateableItemText != null && (string = updateableItemText.getUpdateableText(treeItemData)) != null) {
            this.horizontalAlignment = 16384;
            this.minimumWidth = Math.max(50, treeItem.getBounds().width);
            this.featureValue = string.substring(string.indexOf(" ") + 1);
            final Text textComposite = new Text((Composite)this.tree, 2048);
            this.setEditor((Control)textComposite, treeItem);
            textComposite.setText(this.featureValue);
            textComposite.setFocus();
            textComposite.setSelection(new Point(0, this.featureValue.length()));
            textComposite.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    SelectionTreeTextEditor.this.updateText(treeItemData, textComposite);
                    textComposite.setVisible(false);
                }
            });
            textComposite.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\r' || event.character == '\n') {
                        SelectionTreeTextEditor.this.updateText(treeItemData, textComposite);
                        SelectionTreeTextEditor.this.setEditor(null);
                        textComposite.dispose();
                    } else if (event.character == '\u001b') {
                        SelectionTreeTextEditor.this.setEditor(null);
                        textComposite.dispose();
                    }
                }
            });
        }
    }

    private void updateText(Object textOwner, Text text) {
        EAttribute updateableField = null;
        EList objectReferences = ((EObject)textOwner).eClass().getEAllAttributes();
        for (EAttribute attribute : objectReferences) {
            if (!((EObject)textOwner).eGet((EStructuralFeature)attribute).toString().equals(this.featureValue)) continue;
            updateableField = attribute;
            break;
        }
        Object value = null;
        Class instanceClass = updateableField.getEAttributeType().getInstanceClass();
        value = instanceClass.equals(Integer.TYPE) ? Integer.valueOf(text.getText()) : (instanceClass.equals(Double.TYPE) ? Double.valueOf(text.getText()) : text.getText());
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)textOwner, (Object)updateableField, (Object)value));
    }
}

