/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TSRuntimeConfiguration {
    private static Boolean runningS1AS;
    public static final String SUN_EJB_JAR_XML = ".sun-ejb-jar.xml";
    public static final String SUN_WEB_XML = ".sun-web.xml";
    public static final String SUN_APPLICATION_XML = ".sun-application.xml";
    public static final String SUN_APPLICATION_CLIENT_XML = ".sun-application-client.xml";
    public static final String SUN_CONNECTOR_XML = ".sun-connector.xml";
    public static final String SUN_CMP_MAPPINGS_XML = ".sun-cmp-mappings.xml";
    private File tempFile;
    private PrintWriter log;
    private Hashtable htReplacementProps = new Hashtable();
    private Hashtable htReplacerTable = new Hashtable();
    private String sTempDir = "";
    private StringReplacer replacer;
    private File jteFile = new File(System.getProperty("TS_HOME") + File.separator + "bin" + File.separator + "ts.jte");
    private String mailFrom = "";
    private String mailHost = "";
    private String webHost = "";
    private String webHost2 = "";
    private String webPort = "";
    private String webPort2 = "";
    private String securedWebPort = "";
    private String securedWebPort2 = "";
    private String wsdlRepository1 = "";
    private String wsdlRepository2 = "";
    private String tsHome = "";
    private String user1 = "cts1";
    private String user2 = "cts2";
    private String user3 = "cts3";
    private String password1 = "cts1";
    private String password2 = "cts2";
    private String password3 = "cts3";
    private String rauser1 = "cts1";
    private String rauser2 = "cts2";
    private String rapassword1 = "cts1";
    private String rapassword2 = "cts2";
    private String namingServiceHost1 = "";
    private String namingServicePort1 = "";
    private String namingServiceHost2 = "";
    private String namingServicePort2 = "";
    private int iPort = 0;
    private PropertyManagerInterface propMgr;

    public TSRuntimeConfiguration(PrintWriter out) throws PropertyNotSetException {
        try {
            this.propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log = out;
        this.replacer = new StringReplacer();
        this.tsHome = this.propMgr.getProperty("ts_home", this.tsHome);
        this.webHost = this.propMgr.getProperty("webServerHost", this.webHost);
        this.webPort = this.propMgr.getProperty("webServerPort", this.webPort);
        this.webHost2 = this.propMgr.getProperty("webServerHost.2", this.webHost2);
        this.webPort2 = this.propMgr.getProperty("webServerPort.2", this.webPort2);
        this.securedWebPort = this.propMgr.getProperty("securedWebServicePort", this.securedWebPort);
        this.securedWebPort2 = this.propMgr.getProperty("securedWebServicePort.2", this.securedWebPort2);
        this.mailFrom = this.propMgr.getProperty("mailFrom", this.mailFrom);
        this.mailHost = this.propMgr.getProperty("mailHost", this.mailHost);
        this.user1 = this.propMgr.getProperty("user1", this.user1);
        this.user2 = this.propMgr.getProperty("user2", this.user2);
        this.user3 = this.propMgr.getProperty("user3", this.user3);
        this.password1 = this.propMgr.getProperty("password1", this.password1);
        this.password2 = this.propMgr.getProperty("password2", this.password2);
        this.password3 = this.propMgr.getProperty("password3", this.password3);
        this.rauser1 = this.propMgr.getProperty("rauser1", this.rauser1);
        this.rauser2 = this.propMgr.getProperty("rauser2", this.rauser2);
        this.rapassword1 = this.propMgr.getProperty("rapassword1", this.rapassword1);
        this.rapassword2 = this.propMgr.getProperty("rapassword2", this.rapassword2);
        this.namingServiceHost1 = this.propMgr.getProperty("namingServiceHost1", this.namingServiceHost1);
        this.namingServiceHost2 = this.propMgr.getProperty("namingServiceHost2", this.namingServiceHost2);
        this.namingServicePort1 = this.propMgr.getProperty("namingServicePort1", this.namingServicePort1);
        this.namingServicePort2 = this.propMgr.getProperty("namingServicePort2", this.namingServicePort2);
        this.wsdlRepository1 = this.propMgr.getProperty("wsdlRepository1", this.wsdlRepository1);
        this.wsdlRepository2 = this.propMgr.getProperty("wsdlRepository2", this.wsdlRepository2);
        if (TestUtil.harnessDebug) {
            String msg = "TSRuntimeConfig: user1=" + this.user1 + ", rauser1=" + this.rauser1 + ", password1=" + this.password1 + ", user2=" + this.user2 + ", password2=" + this.password2 + ", user3=" + this.user3 + ", password3=" + this.password3 + ", rapassword1=" + this.rapassword1 + ", rauser2=" + this.rauser2 + ", rapassword2=" + this.rapassword2 + ", webPort = " + this.webPort + ", webHost = " + this.webHost + ", mailFrom = " + this.mailFrom + ", mailHost = " + this.mailHost + ", namingServiceHost1 = " + this.namingServiceHost1 + ", namingServicePort1 = " + this.namingServicePort1 + ", namingServiceHost2 = " + this.namingServiceHost2 + ", namingServicePort2 = " + this.namingServicePort2 + ", securedWebServicePort = " + this.securedWebPort + ", securedWebServicePort.2 = " + this.securedWebPort2 + ", wsdlRepository1 = " + this.wsdlRepository1 + ", wsdlRepository2 = " + this.wsdlRepository2;
            TestUtil.logHarnessDebug(msg);
        }
        this.htReplacementProps.put("webServerHost", this.webHost);
        this.htReplacementProps.put("webServerPort", this.webPort);
        this.htReplacementProps.put("webServerHost.1", this.webHost);
        this.htReplacementProps.put("webServerPort.1", this.webPort);
        this.htReplacementProps.put("webServerHost.2", this.webHost2);
        this.htReplacementProps.put("webServerPort.2", this.webPort2);
        this.htReplacementProps.put("securedWebServicePort", this.securedWebPort);
        this.htReplacementProps.put("securedWebServicePort.1", this.securedWebPort);
        this.htReplacementProps.put("securedWebServicePort.2", this.securedWebPort2);
        this.htReplacementProps.put("ts_home", this.tsHome);
        this.htReplacementProps.put("mailFrom", this.mailFrom);
        this.htReplacementProps.put("mailHost", this.mailHost);
        this.htReplacementProps.put("namingServiceHost1", this.namingServiceHost1);
        this.htReplacementProps.put("namingServicePort1", this.namingServicePort1);
        this.htReplacementProps.put("namingServiceHost2", this.namingServiceHost2);
        this.htReplacementProps.put("namingServicePort2", this.namingServicePort2);
        this.htReplacementProps.put("user1", this.user1);
        this.htReplacementProps.put("user2", this.user2);
        this.htReplacementProps.put("user3", this.user3);
        this.htReplacementProps.put("password1", this.password1);
        this.htReplacementProps.put("password2", this.password2);
        this.htReplacementProps.put("password3", this.password3);
        this.htReplacementProps.put("rauser1", this.rauser1);
        this.htReplacementProps.put("rauser2", this.rauser2);
        this.htReplacementProps.put("rapassword1", this.rapassword1);
        this.htReplacementProps.put("rapassword2", this.rapassword2);
        this.htReplacementProps.put("wsdlRepository1", this.wsdlRepository1);
        this.htReplacementProps.put("wsdlRepository2", this.wsdlRepository2);
        this.sTempDir = this.propMgr.getProperty("harness.temp.directory");
        this.htReplacementProps.put("harness.temp.directory", this.sTempDir);
    }

    public void setTable(Hashtable table) {
        this.htReplacerTable = table;
    }

    public String sweepRuntimeFile(File file) throws FileNotFoundException, IOException {
        File xml = new File(this.sTempDir + File.separator + file.getName());
        if (this.htReplacerTable != null && !this.htReplacerTable.isEmpty()) {
            this.htReplacerTable = this.replaceOnRuntimeInfoStrings(this.htReplacerTable);
        }
        return this.replacer.replace(file, this.htReplacementProps, this.htReplacerTable, this.sTempDir);
    }

    private Hashtable replaceOnRuntimeInfoStrings(Hashtable extras) {
        boolean changeIt = false;
        Hashtable<String, String> resultTable = new Hashtable<String, String>(extras);
        String[] searchFor = new String[]{"namingServiceHost1", "namingServicePort1", "namingServiceHost2", "namingServicePort2", "webServerHost.1", "webServerPort.1", "webServerHost.2", "webServerPort.2", "securedWebServicePort.1", "securedWebServicePort.2", "wsdlRepository1", "wsdlRepository2", "harness.temp.directory", "webServerHost", "webServerPort, securedWebServicePort"};
        Enumeration e = extras.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            Object val = (String)extras.get(sKey);
            TestUtil.logHarnessDebug("extra Key = " + sKey);
            TestUtil.logHarnessDebug("extra Val = " + (String)val);
            String oldJndi = val;
            changeIt = false;
            String buff = null;
            int startPos = 0;
            for (int i = 0; i < searchFor.length; ++i) {
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarness("\n###Searching for=" + searchFor[i]);
                }
                if ((startPos = ((String)val).lastIndexOf(searchFor[i])) == -1) continue;
                changeIt = true;
                String startBuff = ((String)val).substring(0, startPos);
                buff = (String)this.htReplacementProps.get(searchFor[i]);
                val = startBuff + buff + ((String)val).substring(startPos + searchFor[i].length());
            }
            if (!changeIt) continue;
            resultTable.put(sKey, (String)val);
            if (!TestUtil.harnessDebug) continue;
            TestUtil.logHarness("\n###\nold RuntimeInfo Val=" + oldJndi + "\nNew RuntimeInfo Val = " + (String)val);
        }
        return resultTable;
    }

    final class StringReplacer {
        public String sFindString;
        public String sReplaceString;
        public String sDirString;
        public String sFileNameStringToReplace;
        public String sNewFileNameString;
        public int iHowMany = -1;
        public String[] sFileList;
        public boolean bNewFile = false;
        private Hashtable htFindAndReplace = null;
        private Hashtable htCustomTable = null;
        private Vector vInfoObjects = new Vector();
        private Vector vMatchingInfoObjects = new Vector();
        private Vector vNonMatchingInfoObjects = new Vector();
        private boolean bSomethingWasReplaced = false;

        StringReplacer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String replace(File file, Hashtable htStrings, Hashtable htReplacerTable, String sTempDir) {
            Object sFileList = null;
            this.htFindAndReplace = htStrings;
            this.htCustomTable = htReplacerTable;
            String sTemp = "";
            ReplacementInfo ri = null;
            Object sNewFileName = "";
            StringBuffer sFoundBuffer = new StringBuffer();
            this.bSomethingWasReplaced = false;
            BufferedReader fReader = null;
            BufferedWriter fNewWriter = null;
            try {
                this.vInfoObjects = new Vector();
                String sKey = "";
                Enumeration e = this.htFindAndReplace.keys();
                while (e.hasMoreElements()) {
                    sKey = (String)e.nextElement();
                    this.vInfoObjects.addElement(new ReplacementInfo(sKey, (String)this.htFindAndReplace.get(sKey)));
                }
                if (this.htCustomTable != null) {
                    e = this.htCustomTable.keys();
                    while (e.hasMoreElements()) {
                        sKey = (String)e.nextElement();
                        this.vInfoObjects.addElement(new ReplacementInfo(sKey, (String)this.htCustomTable.get(sKey)));
                    }
                }
                fReader = new BufferedReader(new FileReader(file));
                StringWriter sWriter = new StringWriter();
                boolean bCheckForDot = false;
                String sHold = "";
                this.vMatchingInfoObjects.addAll(this.vInfoObjects);
                while (true) {
                    Enumeration e2;
                    int iCharRead;
                    if ((iCharRead = fReader.read()) != -1) {
                        block30: {
                            char c = (char)iCharRead;
                            if (bCheckForDot) {
                                if (c != '.') {
                                    sHold = new String(new Character(c).toString());
                                    TestUtil.logHarnessDebug("sHold = " + sHold);
                                    break block30;
                                } else {
                                    sFoundBuffer.append(c);
                                    bCheckForDot = false;
                                    continue;
                                }
                            }
                            if (sHold != null) {
                                sWriter.write(sHold);
                                sHold = null;
                            }
                            sFoundBuffer.append(c);
                        }
                        sTemp = new String(sFoundBuffer);
                        e2 = this.vMatchingInfoObjects.elements();
                    } else {
                        File fTmpRuntimeFile;
                        fReader.close();
                        sNewFileName = sTempDir + File.separator + file.getName();
                        if (TestUtil.harnessDebug) {
                            TestUtil.logHarnessDebug("New filename:" + (String)sNewFileName);
                        }
                        if ((fTmpRuntimeFile = new File((String)sNewFileName)).exists()) {
                            TestUtil.logHarnessDebug("Old runtime file exists:" + (String)sNewFileName);
                            fTmpRuntimeFile.delete();
                            TestUtil.logHarnessDebug("Deleted old runtime file:" + (String)sNewFileName);
                        }
                        fNewWriter = new BufferedWriter(new FileWriter(new File((String)sNewFileName)));
                        fNewWriter.write(sWriter.toString());
                        fNewWriter.flush();
                        return sNewFileName;
                    }
                    while (e2.hasMoreElements()) {
                        ri = (ReplacementInfo)e2.nextElement();
                        if (ri.sFind.startsWith(sTemp)) {
                            if (!ri.sFind.equals(sTemp)) continue;
                            if (!bCheckForDot) {
                                if (sTemp.equals("webServerHost") || sTemp.equals("webServerPort") || sTemp.equals("securedWebServicePort")) {
                                    bCheckForDot = true;
                                    break;
                                }
                            } else {
                                bCheckForDot = false;
                            }
                            if (TestUtil.harnessDebug) {
                                TestUtil.logHarnessDebug("REPLACER:MATCH found:  " + ri.sFind + " matches " + sTemp);
                            }
                            ri.foundOccurance();
                            this.bSomethingWasReplaced = true;
                            sWriter.write(ri.sReplace);
                            sFoundBuffer = new StringBuffer();
                            this.vMatchingInfoObjects.removeAllElements();
                            this.vMatchingInfoObjects.addAll(this.vInfoObjects);
                            break;
                        }
                        this.vNonMatchingInfoObjects.addElement(ri);
                    }
                    this.vMatchingInfoObjects.removeAll(this.vNonMatchingInfoObjects);
                    this.vNonMatchingInfoObjects.removeAllElements();
                    if (!this.vMatchingInfoObjects.isEmpty()) continue;
                    sWriter.write(sTemp);
                    sFoundBuffer = new StringBuffer();
                    this.vMatchingInfoObjects.removeAllElements();
                    this.vMatchingInfoObjects.addAll(this.vInfoObjects);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return sNewFileName;
            }
            finally {
                if (fNewWriter != null) {
                    try {
                        fNewWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        class ReplacementInfo {
            private int iFoundOccurances = 0;
            private String sFind = null;
            private String sReplace = null;

            ReplacementInfo(String sFindString, String sReplaceString) {
                this.sFind = sFindString;
                this.sReplace = sReplaceString;
                this.iFoundOccurances = 0;
            }

            public void foundOccurance() {
                ++this.iFoundOccurances;
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarnessDebug("we found an occurance #" + this.iFoundOccurances + " of '" + this.sFind + "'");
                }
            }
        }
    }
}

