/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.multipart;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.eclipse.rap.http.servlet.internal.multipart.MultipartSupport;
import org.eclipse.rap.http.servlet.internal.multipart.MultipartSupportPart;
import org.eclipse.rap.service.servlet.internal.runtime.dto.ServletDTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MultipartSupportImpl
implements MultipartSupport {
    private final ServletDTO servletDTO;
    private final JakartaServletFileUpload upload;

    public MultipartSupportImpl(ServletDTO servletDTO, ServletContext servletContext) {
        this.servletDTO = servletDTO;
        File baseStorage = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
        if (servletDTO.multipartLocation.length() > 0) {
            File storage = new File(servletDTO.multipartLocation);
            if (!storage.isAbsolute()) {
                storage = new File(baseStorage, storage.getPath());
            }
            baseStorage = storage;
        }
        this.checkPermission(baseStorage, servletContext);
        baseStorage.mkdirs();
        DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setPath(baseStorage.toPath())).setBufferSize(servletDTO.multipartFileSizeThreshold).get();
        this.upload = new JakartaServletFileUpload((FileItemFactory)factory);
        if (servletDTO.multipartMaxFileSize > -1L) {
            this.upload.setMaxFileSize(servletDTO.multipartMaxFileSize);
        }
        if (servletDTO.multipartMaxRequestSize > -1L) {
            this.upload.setMaxSize(servletDTO.multipartMaxRequestSize);
        }
    }

    private void checkPermission(File baseStorage, ServletContext servletContext) {
        BundleContext bundleContext = (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
        Bundle bundle = bundleContext.getBundle();
        AccessControlContext accessControlContext = (AccessControlContext)bundle.adapt(AccessControlContext.class);
        if (accessControlContext == null) {
            return;
        }
        accessControlContext.checkPermission(new FilePermission(baseStorage.getAbsolutePath(), "read,write"));
    }

    @Override
    public List<Part> parseRequest(HttpServletRequest request) throws IOException, ServletException {
        if (this.upload == null) {
            throw new IllegalStateException("Servlet was not configured for multipart!");
        }
        if (!this.servletDTO.multipartEnabled) {
            throw new IllegalStateException("No multipart config on " + String.valueOf((Object)this.servletDTO));
        }
        if (!JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new ServletException("Not a multipart request!");
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        try {
            for (Object item : this.upload.parseRequest(request)) {
                DiskFileItem diskFileItem = (DiskFileItem)item;
                parts.add(new MultipartSupportPart(diskFileItem));
            }
        }
        catch (FileUploadException fnfe) {
            throw new IOException(fnfe);
        }
        return parts;
    }
}

