/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.BindingAssignerOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.BindingSetAssignmentInlinerOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ConjunctiveConstraintSplitterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.FilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.IterativeEvaluationOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.OrderLimitOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ParentReferenceChecker;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ParentReferenceCleaner;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ProjectionRemovalOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.QueryJoinOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.QueryModelNormalizerOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.RegexAsStringFunctionOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.SameTermFilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.UnionScopeChangeOptimizer;

public class StandardQueryOptimizerPipeline
implements QueryOptimizerPipeline {
    private static boolean assertsEnabled = false;
    public static final BindingAssignerOptimizer BINDING_ASSIGNER;
    public static final BindingSetAssignmentInlinerOptimizer BINDING_SET_ASSIGNMENT_INLINER;
    public static final CompareOptimizer COMPARE_OPTIMIZER;
    public static final ConjunctiveConstraintSplitterOptimizer CONJUNCTIVE_CONSTRAINT_SPLITTER;
    public static final DisjunctiveConstraintOptimizer DISJUNCTIVE_CONSTRAINT_OPTIMIZER;
    public static final SameTermFilterOptimizer SAME_TERM_FILTER_OPTIMIZER;
    public static final UnionScopeChangeOptimizer UNION_SCOPE_CHANGE_OPTIMIZER;
    public static final QueryModelNormalizerOptimizer QUERY_MODEL_NORMALIZER;
    public static final ProjectionRemovalOptimizer PROJECTION_REMOVAL_OPTIMIZER;
    public static final IterativeEvaluationOptimizer ITERATIVE_EVALUATION_OPTIMIZER;
    public static final FilterOptimizer FILTER_OPTIMIZER;
    public static final OrderLimitOptimizer ORDER_LIMIT_OPTIMIZER;
    public static final ParentReferenceCleaner PARENT_REFERENCE_CLEANER;
    private final EvaluationStatistics evaluationStatistics;
    private final TripleSource tripleSource;
    private final EvaluationStrategy strategy;

    public StandardQueryOptimizerPipeline(EvaluationStrategy strategy, TripleSource tripleSource, EvaluationStatistics evaluationStatistics) {
        this.strategy = strategy;
        this.tripleSource = tripleSource;
        this.evaluationStatistics = evaluationStatistics;
    }

    @Override
    public Iterable<QueryOptimizer> getOptimizers() {
        List<QueryOptimizer> optimizers = List.of(BINDING_ASSIGNER, BINDING_SET_ASSIGNMENT_INLINER, new ConstantOptimizer(this.strategy), new RegexAsStringFunctionOptimizer(this.tripleSource.getValueFactory()), COMPARE_OPTIMIZER, CONJUNCTIVE_CONSTRAINT_SPLITTER, DISJUNCTIVE_CONSTRAINT_OPTIMIZER, SAME_TERM_FILTER_OPTIMIZER, UNION_SCOPE_CHANGE_OPTIMIZER, QUERY_MODEL_NORMALIZER, PROJECTION_REMOVAL_OPTIMIZER, new QueryJoinOptimizer(this.evaluationStatistics, this.strategy.isTrackResultSize(), this.tripleSource), ITERATIVE_EVALUATION_OPTIMIZER, FILTER_OPTIMIZER, ORDER_LIMIT_OPTIMIZER);
        if (assertsEnabled) {
            ArrayList<QueryOptimizer> optimizersWithReferenceCleaner = new ArrayList<QueryOptimizer>();
            optimizersWithReferenceCleaner.add(new ParentReferenceChecker(null));
            for (QueryOptimizer optimizer : optimizers) {
                optimizersWithReferenceCleaner.add(optimizer);
                optimizersWithReferenceCleaner.add(new ParentReferenceChecker(optimizer));
            }
            optimizers = optimizersWithReferenceCleaner;
        }
        return optimizers;
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        BINDING_ASSIGNER = new BindingAssignerOptimizer();
        BINDING_SET_ASSIGNMENT_INLINER = new BindingSetAssignmentInlinerOptimizer();
        COMPARE_OPTIMIZER = new CompareOptimizer();
        CONJUNCTIVE_CONSTRAINT_SPLITTER = new ConjunctiveConstraintSplitterOptimizer();
        DISJUNCTIVE_CONSTRAINT_OPTIMIZER = new DisjunctiveConstraintOptimizer();
        SAME_TERM_FILTER_OPTIMIZER = new SameTermFilterOptimizer();
        UNION_SCOPE_CHANGE_OPTIMIZER = new UnionScopeChangeOptimizer();
        QUERY_MODEL_NORMALIZER = new QueryModelNormalizerOptimizer();
        PROJECTION_REMOVAL_OPTIMIZER = new ProjectionRemovalOptimizer();
        ITERATIVE_EVALUATION_OPTIMIZER = new IterativeEvaluationOptimizer();
        FILTER_OPTIMIZER = new FilterOptimizer();
        ORDER_LIMIT_OPTIMIZER = new OrderLimitOptimizer();
        PARENT_REFERENCE_CLEANER = new ParentReferenceCleaner();
    }
}

