/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsFactory;
import org.eclipse.rcptt.core.tags.TagsRegistry;

public class TagsWatcher
implements IElementChangedListener {
    public static final String HIERARCHY_SEP = "[/]";
    private final TagsRegistry tags;
    private Map<IQ7NamedElement, List<String>> TagsRefsMap;

    public TagsWatcher(TagsRegistry tags) {
        this.tags = tags;
        this.TagsRefsMap = Q7SearchCore.findAllTagReferences();
        for (Map.Entry<IQ7NamedElement, List<String>> entry : this.TagsRefsMap.entrySet()) {
            for (String tag : entry.getValue()) {
                this.addTagRef(tag, entry.getKey());
            }
        }
    }

    public void elementChanged(Q7ElementChangedEvent event) {
        IQ7ElementDelta[] addedChildren;
        IQ7NamedElement[] namedElements;
        IQ7ElementDelta delta = event.getDelta();
        if (this.hasContainerChanges(delta)) {
            this.reloadTags();
            return;
        }
        IQ7NamedElement[] iQ7NamedElementArray = namedElements = delta.getNamedElements();
        int n = namedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement changedElement = iQ7NamedElementArray[n2];
            IQ7ElementDelta childDelta = delta.getChildBy(changedElement);
            switch (childDelta.getKind()) {
                case 2: {
                    this.processElementRemoved(changedElement);
                    break;
                }
                case 1: {
                    this.processElementChanged(changedElement);
                    break;
                }
                case 4: {
                    if ((childDelta.getFlags() & 1) == 0) break;
                    this.processElementChanged(changedElement);
                }
            }
            ++n2;
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = addedChildren = delta.getAffectedChildren();
        int n3 = addedChildren.length;
        n = 0;
        while (n < n3) {
            IQ7ElementDelta iq7ElementDelta = iQ7ElementDeltaArray[n];
            if (iq7ElementDelta.getElement() instanceof IQ7Project && ((iq7ElementDelta.getFlags() & 0x200) != 0 || (iq7ElementDelta.getFlags() & 0x400) != 0)) {
                this.reloadTags();
                break;
            }
            ++n;
        }
    }

    private boolean hasContainerChanges(IQ7ElementDelta delta) {
        IQ7ElementDelta[] deltas;
        IQ7Element element = delta.getElement();
        if ((element instanceof IQ7Project || element instanceof IQ7Folder) && (delta.getKind() == 2 || delta.getKind() == 1)) {
            return true;
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
        if (deltas.length != 0) {
            IQ7ElementDelta childDelta = iQ7ElementDeltaArray[0];
            return this.hasContainerChanges(childDelta);
        }
        return false;
    }

    private void processElementRemoved(IQ7NamedElement element) {
        List<String> tagsToRemove = this.TagsRefsMap.get(element);
        if (tagsToRemove != null) {
            for (String tag : tagsToRemove) {
                this.removeTagRef(tag, element);
            }
        }
        this.TagsRefsMap.remove(element);
    }

    private void processElementChanged(IQ7NamedElement element) {
        List<String> oldTags = this.TagsRefsMap.get(element);
        if (oldTags == null) {
            oldTags = new ArrayList<String>();
        }
        ArrayList<String> newTags = new ArrayList<String>();
        String[] stringArray = Q7SearchCore.findTagsByDocument((IQ7Element)element);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String newTag = stringArray[n2];
            if (!oldTags.contains(newTag)) {
                this.addTagRef(newTag, element);
            }
            newTags.add(newTag);
            ++n2;
        }
        for (String oldTag : oldTags) {
            if (newTags.contains(oldTag)) continue;
            this.removeTagRef(oldTag, element);
        }
        this.TagsRefsMap.put(element, newTags);
    }

    private void reloadTags() {
        Map ActualTagsRefsMap = Q7SearchCore.findAllTagReferences();
        for (Map.Entry entry : ActualTagsRefsMap.entrySet()) {
            if (this.TagsRefsMap.get(entry.getKey()) == null) {
                for (String tag : (List)entry.getValue()) {
                    this.addTagRef(tag, (IQ7NamedElement)entry.getKey());
                }
                continue;
            }
            this.processElementChanged((IQ7NamedElement)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : this.TagsRefsMap.entrySet()) {
            if (ActualTagsRefsMap.get(entry.getKey()) != null) continue;
            for (String tag : (List)entry.getValue()) {
                this.removeTagRef(tag, (IQ7NamedElement)entry.getKey());
            }
        }
        this.TagsRefsMap = ActualTagsRefsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTagRef(String tagString, IQ7NamedElement ref) {
        TagsRegistry container = this.tags;
        Tag tag = null;
        String[] stringArray = tagString.split(HIERARCHY_SEP);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            TagsRegistry tagsRegistry = container;
            synchronized (tagsRegistry) {
                tag = this.findTag(this.getTags(container), name);
            }
            if (tag == null) {
                tag = TagsFactory.eINSTANCE.createTag();
                tag.setValue(name);
                tagsRegistry = container;
                synchronized (tagsRegistry) {
                    this.getTags(container).add(tag);
                }
            }
            container = tag;
            ++n2;
        }
        Tag tag2 = tag;
        synchronized (tag2) {
            tag.getRefs().add((Object)ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTagRef(String tagString, IQ7NamedElement ref) {
        TagsRegistry container = this.tags;
        Tag tag = null;
        String[] stringArray = tagString.split(HIERARCHY_SEP);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            TagsRegistry tagsRegistry = container;
            synchronized (tagsRegistry) {
                tag = this.findTag(this.getTags(container), name);
            }
            if (tag == null) {
                return;
            }
            container = tag;
            ++n2;
        }
        Tag tag2 = tag;
        synchronized (tag2) {
            tag.getRefs().remove((Object)ref);
        }
        while (true) {
            tag2 = tag;
            synchronized (tag2) {
                if (!tag.getRefs().isEmpty() || !tag.getTags().isEmpty()) {
                    return;
                }
            }
            container = tag.eContainer();
            tag2 = container;
            synchronized (tag2) {
                this.getTags(container).remove(tag);
            }
            if (!(container instanceof Tag)) break;
            tag = (Tag)container;
        }
    }

    public Tag findTag(List<Tag> tags, String tagString) {
        for (Tag test : tags) {
            if (!test.getValue().equals(tagString)) continue;
            return test;
        }
        return null;
    }

    private List<Tag> getTags(Object container) {
        EList tags = null;
        tags = container instanceof TagsRegistry ? ((TagsRegistry)container).getTags() : ((Tag)container).getTags();
        return tags;
    }
}

